/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PacketReader {
    private Thread readerThread;
    private Thread listenerThread;
    private XMPPConnection connection;
    private XmlPullParser parser;
    private boolean done = false;
    protected List collectors = new ArrayList();
    private List listeners = new ArrayList();
    protected List connectionListeners = new ArrayList();
    private String connectionID = null;
    private Object connectionIDLock = new Object();

    protected PacketReader(XMPPConnection connection) {
        this.connection = connection;
        this.readerThread = new Thread(){

            public void run() {
                PacketReader.this.parsePackets();
            }
        };
        this.readerThread.setName("Smack Packet Reader");
        this.readerThread.setDaemon(true);
        this.listenerThread = new Thread(){

            public void run() {
                try {
                    PacketReader.this.processListeners();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.listenerThread.setName("Smack Listener Processor");
        this.listenerThread.setDaemon(true);
        this.resetParser();
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        return new PacketCollector(this, packetFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        ListenerWrapper wrapper = new ListenerWrapper(this, packetListener, packetFilter);
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketListener packetListener) {
        List list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(i);
                if (wrapper == null || !wrapper.packetListener.equals(packetListener)) continue;
                this.listeners.set(i, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws XMPPException {
        this.readerThread.start();
        this.listenerThread.start();
        try {
            Object object = this.connectionIDLock;
            synchronized (object) {
                if (this.connectionID == null) {
                    long now;
                    long start = System.currentTimeMillis();
                    for (long waitTime = (long)SmackConfiguration.getPacketReplyTimeout(); this.connectionID == null && !this.done && waitTime > 0L; waitTime -= now - start) {
                        this.connectionIDLock.wait(waitTime * 3L);
                        now = System.currentTimeMillis();
                        start = now;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connectionID == null) {
            throw new XMPPException("Connection failed. No response from server.");
        }
        this.connection.connectionID = this.connectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.done) {
            List list = this.connectionListeners;
            synchronized (list) {
                ArrayList listenersCopy = new ArrayList(this.connectionListeners);
                Iterator i = listenersCopy.iterator();
                while (i.hasNext()) {
                    ConnectionListener listener = (ConnectionListener)i.next();
                    listener.connectionClosed();
                }
            }
        }
        this.done = true;
        Thread thread = this.listenerThread;
        synchronized (thread) {
            this.listenerThread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyConnectionError(Exception e) {
        this.done = true;
        this.connection.close();
        e.printStackTrace();
        Object object = this.connectionListeners;
        synchronized (object) {
            ArrayList listenersCopy = new ArrayList(this.connectionListeners);
            Iterator i = listenersCopy.iterator();
            while (i.hasNext()) {
                ConnectionListener listener = (ConnectionListener)i.next();
                listener.connectionClosedOnError(e);
            }
        }
        object = this.listenerThread;
        synchronized (object) {
            this.listenerThread.notify();
        }
    }

    private void resetParser() {
        try {
            this.parser = new MXParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.connection.reader);
        }
        catch (XmlPullParserException xppe) {
            xppe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processListeners() {
        while (!this.done) {
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.size() > 0) {
                    for (int i = this.listeners.size() - 1; i >= 0; --i) {
                        if (this.listeners.get(i) != null) continue;
                        this.listeners.remove(i);
                    }
                }
            }
            boolean processedPacket = false;
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(i);
                if (wrapper == null) continue;
                processedPacket = processedPacket || wrapper.notifyListener();
            }
            if (processedPacket) continue;
            try {
                Thread i = this.listenerThread;
                synchronized (i) {
                    this.listenerThread.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void parsePackets() {
        block32: {
            try {
                int eventType = this.parser.getEventType();
                do {
                    if (eventType == 2) {
                        if (this.parser.getName().equals("message")) {
                            this.processPacket(PacketParserUtils.parseMessage(this.parser));
                        } else if (this.parser.getName().equals("iq")) {
                            this.processPacket(this.parseIQ(this.parser));
                        } else if (this.parser.getName().equals("presence")) {
                            this.processPacket(PacketParserUtils.parsePresence(this.parser));
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                    if (this.parser.getAttributeName(i).equals("id")) {
                                        this.connectionID = this.parser.getAttributeValue(i);
                                        if ("1.0".equals(this.parser.getAttributeValue("", "version"))) continue;
                                        this.releaseConnectionIDLock();
                                        continue;
                                    }
                                    if (!this.parser.getAttributeName(i).equals("from")) continue;
                                    this.connection.serviceName = this.parser.getAttributeValue(i);
                                }
                            }
                        } else {
                            if (this.parser.getName().equals("error")) {
                                throw new XMPPException(this.parseStreamError(this.parser));
                            }
                            if (this.parser.getName().equals("features")) {
                                this.parseFeatures(this.parser);
                            } else if (this.parser.getName().equals("proceed")) {
                                this.connection.proceedTLSReceived();
                                this.resetParser();
                            } else if (this.parser.getName().equals("failure")) {
                                String namespace = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(namespace)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if ("http://jabber.org/protocol/compress".equals(namespace)) {
                                    this.connection.streamCompressionDenied();
                                } else {
                                    this.connection.getSASLAuthentication().authenticationFailed();
                                }
                            } else if (this.parser.getName().equals("challenge")) {
                                this.connection.getSASLAuthentication().challengeReceived(this.parser.nextText());
                            } else if (this.parser.getName().equals("success")) {
                                this.connection.packetWriter.openStream();
                                this.resetParser();
                                this.connection.getSASLAuthentication().authenticated();
                            } else if (this.parser.getName().equals("compressed")) {
                                this.connection.startStreamCompression();
                                this.resetParser();
                            }
                        }
                    } else if (eventType == 3 && this.parser.getName().equals("stream")) {
                        this.connection.close();
                    }
                    eventType = this.parser.next();
                } while (!this.done && eventType != 1);
            }
            catch (Exception e) {
                if (this.done) break block32;
                this.notifyConnectionError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnectionIDLock() {
        Object object = this.connectionIDLock;
        synchronized (object) {
            this.connectionIDLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(Packet packet) {
        int i;
        if (packet == null) {
            return;
        }
        List list = this.collectors;
        synchronized (list) {
            for (i = this.collectors.size() - 1; i >= 0; --i) {
                if (this.collectors.get(i) != null) continue;
                this.collectors.remove(i);
            }
        }
        int size = this.collectors.size();
        for (i = 0; i < size; ++i) {
            PacketCollector collector = (PacketCollector)this.collectors.get(i);
            if (collector == null) continue;
            collector.processPacket(packet);
        }
        Thread thread = this.listenerThread;
        synchronized (thread) {
            this.listenerThread.notifyAll();
        }
    }

    private StreamError parseStreamError(XmlPullParser parser) throws IOException, XmlPullParserException {
        StreamError streamError = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                streamError = new StreamError(parser.getName());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("error")) continue;
            done = true;
        }
        return streamError;
    }

    private void parseFeatures(XmlPullParser parser) throws Exception {
        boolean startTLSReceived = false;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("starttls")) {
                    startTLSReceived = true;
                    this.connection.startTLSReceived();
                    continue;
                }
                if (parser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(this.parseMechanisms(parser));
                    continue;
                }
                if (parser.getName().equals("bind")) {
                    this.connection.getSASLAuthentication().bindingRequired();
                    continue;
                }
                if (parser.getName().equals("session")) {
                    this.connection.getSASLAuthentication().sessionsSupported();
                    continue;
                }
                if (!parser.getName().equals("compression")) continue;
                this.connection.setAvailableCompressionMethods(this.parseCompressionMethods(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("features")) continue;
            done = true;
        }
        if (!startTLSReceived) {
            this.releaseConnectionIDLock();
        }
    }

    private Collection parseMechanisms(XmlPullParser parser) throws Exception {
        ArrayList<String> mechanisms = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                if (!elementName.equals("mechanism")) continue;
                mechanisms.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("mechanisms")) continue;
            done = true;
        }
        return mechanisms;
    }

    private Collection parseCompressionMethods(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<String> methods = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                if (!elementName.equals("method")) continue;
                methods.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("compression")) continue;
            done = true;
        }
        return methods;
    }

    private IQ parseIQ(XmlPullParser parser) throws Exception {
        Packet iqPacket = null;
        String id = parser.getAttributeValue("", "id");
        String to = parser.getAttributeValue("", "to");
        String from = parser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(parser.getAttributeValue("", "type"));
        XMPPError error = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("error")) {
                    error = PacketParserUtils.parseError(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:auth")) {
                    iqPacket = this.parseAuthentication(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:roster")) {
                    iqPacket = this.parseRoster(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:register")) {
                    iqPacket = this.parseRegistration(parser);
                    continue;
                }
                if (elementName.equals("bind") && namespace.equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                    iqPacket = this.parseResourceBinding(parser);
                    continue;
                }
                Object provider = ProviderManager.getIQProvider(elementName, namespace);
                if (provider == null) continue;
                if (provider instanceof IQProvider) {
                    iqPacket = ((IQProvider)provider).parseIQ(parser);
                    continue;
                }
                if (!(provider instanceof Class)) continue;
                iqPacket = (IQ)PacketParserUtils.parseWithIntrospection(elementName, (Class)provider, parser);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("iq")) continue;
            done = true;
        }
        if (iqPacket == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                iqPacket = new IQ(){

                    public String getChildElementXML() {
                        return null;
                    }
                };
                iqPacket.setPacketID(id);
                iqPacket.setTo(from);
                iqPacket.setFrom(to);
                ((IQ)iqPacket).setType(IQ.Type.ERROR);
                iqPacket.setError(new XMPPError(501, "feature-not-implemented"));
                this.connection.sendPacket(iqPacket);
                return null;
            }
            iqPacket = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
        }
        iqPacket.setPacketID(id);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        ((IQ)iqPacket).setType(type);
        iqPacket.setError(error);
        return iqPacket;
    }

    private Authentication parseAuthentication(XmlPullParser parser) throws Exception {
        Authentication authentication = new Authentication();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("username")) {
                    authentication.setUsername(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("password")) {
                    authentication.setPassword(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("digest")) {
                    authentication.setDigest(parser.nextText());
                    continue;
                }
                if (!parser.getName().equals("resource")) continue;
                authentication.setResource(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return authentication;
    }

    private RosterPacket parseRoster(XmlPullParser parser) throws Exception {
        RosterPacket roster = new RosterPacket();
        boolean done = false;
        RosterPacket.Item item = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("item")) {
                    String jid = parser.getAttributeValue("", "jid");
                    String name = parser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(jid, name);
                    String ask = parser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus status = RosterPacket.ItemStatus.fromString(ask);
                    item.setItemStatus(status);
                    String subscription = parser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType type = RosterPacket.ItemType.fromString(subscription);
                    item.setItemType(type);
                }
                if (!parser.getName().equals("group") || item == null) continue;
                item.addGroupName(parser.nextText());
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("item")) {
                roster.addRosterItem(item);
            }
            if (!parser.getName().equals("query")) continue;
            done = true;
        }
        return roster;
    }

    private Registration parseRegistration(XmlPullParser parser) throws Exception {
        Registration registration = new Registration();
        HashMap<String, String> fields = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getNamespace().equals("jabber:iq:register")) {
                    String name = parser.getName();
                    String value = "";
                    if (fields == null) {
                        fields = new HashMap<String, String>();
                    }
                    if (parser.next() == 4) {
                        value = parser.getText();
                    }
                    if (!name.equals("instructions")) {
                        fields.put(name, value);
                        continue;
                    }
                    registration.setInstructions(value);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(parser.getName(), parser.getNamespace(), parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        registration.setAttributes(fields);
        return registration;
    }

    private Bind parseResourceBinding(XmlPullParser parser) throws IOException, XmlPullParserException {
        Bind bind = new Bind();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("resource")) {
                    bind.setResource(parser.nextText());
                    continue;
                }
                if (!parser.getName().equals("jid")) continue;
                bind.setJid(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("bind")) continue;
            done = true;
        }
        return bind;
    }

    private static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketCollector packetCollector;

        public ListenerWrapper(PacketReader packetReader, PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetCollector = new PacketCollector(packetReader, packetFilter);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof ListenerWrapper) {
                return ((ListenerWrapper)object).packetListener.equals(this.packetListener);
            }
            if (object instanceof PacketListener) {
                return object.equals(this.packetListener);
            }
            return false;
        }

        public boolean notifyListener() {
            Packet packet = this.packetCollector.pollResult();
            if (packet != null) {
                this.packetListener.processPacket(packet);
                return true;
            }
            return false;
        }

        public void cancel() {
            this.packetCollector.cancel();
            this.packetCollector = null;
            this.packetListener = null;
        }
    }
}

