/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.ReferenceMap;

public class SoftLimitMRUCache
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    private final int strongReferenceCount;
    private transient ReferenceMap softReferenceCache = new ReferenceMap(1, 1);
    private transient LRUMap strongReferenceCache;

    public SoftLimitMRUCache() {
        this(128);
    }

    public SoftLimitMRUCache(int strongRefCount) {
        this.strongReferenceCount = strongRefCount;
        this.init();
    }

    public synchronized Object get(Object key) {
        Object result = this.softReferenceCache.get(key);
        if (result != null) {
            this.strongReferenceCache.put(key, result);
        }
        return result;
    }

    public Object put(Object key, Object value) {
        this.softReferenceCache.put(key, value);
        return this.strongReferenceCache.put(key, value);
    }

    public int size() {
        return this.strongReferenceCache.size();
    }

    public int softSize() {
        return this.softReferenceCache.size();
    }

    public Iterator entries() {
        return this.strongReferenceCache.entrySet().iterator();
    }

    public Iterator softEntries() {
        return this.softReferenceCache.entrySet().iterator();
    }

    private void init() {
        this.strongReferenceCache = new LRUMap(this.strongReferenceCount);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

