/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;

public final class EntityEntry
implements Serializable {
    private LockMode lockMode;
    private Status status;
    private final Serializable id;
    private Object[] loadedState;
    private Object[] deletedState;
    private boolean existsInDatabase;
    private Object version;
    private transient EntityPersister persister;
    private final EntityMode entityMode;
    private final String entityName;
    private boolean isBeingReplicated;
    private boolean loadedWithLazyPropertiesUnfetched;
    private final transient Object rowId;

    EntityEntry(Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, EntityMode entityMode, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        this.status = status;
        this.loadedState = loadedState;
        this.id = id;
        this.rowId = rowId;
        this.existsInDatabase = existsInDatabase;
        this.version = version;
        this.lockMode = lockMode;
        this.isBeingReplicated = disableVersionIncrement;
        this.loadedWithLazyPropertiesUnfetched = lazyPropertiesAreUnfetched;
        this.persister = persister;
        this.entityMode = entityMode;
        this.entityName = persister == null ? null : persister.getEntityName();
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status == Status.READ_ONLY) {
            this.loadedState = null;
        }
        this.status = status;
    }

    public Serializable getId() {
        return this.id;
    }

    public Object[] getLoadedState() {
        return this.loadedState;
    }

    public Object[] getDeletedState() {
        return this.deletedState;
    }

    public void setDeletedState(Object[] deletedState) {
        this.deletedState = deletedState;
    }

    public boolean isExistsInDatabase() {
        return this.existsInDatabase;
    }

    public Object getVersion() {
        return this.version;
    }

    public EntityPersister getPersister() {
        return this.persister;
    }

    void afterDeserialize(SessionFactoryImplementor factory) {
        this.persister = factory.getEntityPersister(this.entityName);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean isBeingReplicated() {
        return this.isBeingReplicated;
    }

    public Object getRowId() {
        return this.rowId;
    }

    public void postUpdate(Object entity, Object[] updatedState, Object nextVersion) {
        this.loadedState = updatedState;
        this.setLockMode(LockMode.WRITE);
        if (this.getPersister().isVersioned()) {
            this.version = nextVersion;
            this.getPersister().setPropertyValue(entity, this.getPersister().getVersionProperty(), nextVersion, this.entityMode);
        }
        FieldInterceptor.clearDirty(entity);
    }

    public void postDelete() {
        this.status = Status.GONE;
        this.existsInDatabase = false;
    }

    public void postInsert() {
        this.existsInDatabase = true;
    }

    public boolean isNullifiable(boolean earlyInsert, SessionImplementor session) {
        return this.getStatus() == Status.SAVING || (earlyInsert ? !this.isExistsInDatabase() : session.getPersistenceContext().getNullifiableEntityKeys().contains(new EntityKey(this.getId(), this.getPersister(), this.entityMode)));
    }

    public Object getLoadedValue(String propertyName) {
        int propertyIndex = ((UniqueKeyLoadable)this.persister).getPropertyIndex(propertyName);
        return this.loadedState[propertyIndex];
    }

    public boolean requiresDirtyCheck(Object entity) {
        boolean isMutableInstance = this.status != Status.READ_ONLY && this.persister.isMutable();
        return isMutableInstance && (this.getPersister().hasMutableProperties() || !FieldInterceptor.hasInterceptor(entity) || FieldInterceptor.getFieldInterceptor(entity).isDirty());
    }

    public void setReadOnly(boolean readOnly, Object entity) {
        if (this.status != Status.MANAGED && this.status != Status.READ_ONLY) {
            throw new HibernateException("instance was not in a valid state");
        }
        if (readOnly) {
            this.setStatus(Status.READ_ONLY);
            this.loadedState = null;
        } else {
            this.setStatus(Status.MANAGED);
            this.loadedState = this.getPersister().getPropertyValues(entity, this.entityMode);
        }
    }

    public String toString() {
        return "EntityEntry" + MessageHelper.infoString(this.entityName, this.id) + '(' + this.status + ')';
    }

    public boolean isLoadedWithLazyPropertiesUnfetched() {
        return this.loadedWithLazyPropertiesUnfetched;
    }
}

