/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.ObjectTypeDeterminer;
import com.opensymphony.xwork.util.ObjectTypeDeterminerFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.XWorkBasicConverter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import ognl.DefaultTypeConverter;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XWorkConverter
extends DefaultTypeConverter {
    private static XWorkConverter instance;
    protected static final Log LOG;
    public static final String REPORT_CONVERSION_ERRORS = "report.conversion.errors";
    public static final String CONVERSION_PROPERTY_FULLNAME = "conversion.property.fullName";
    public static final String CONVERSION_ERROR_PROPERTY_PREFIX = "invalid.fieldvalue.";
    public static final String CONVERSION_COLLECTION_PREFIX = "Collection_";
    public static final String LAST_BEAN_CLASS_ACCESSED = "last.bean.accessed";
    public static final String LAST_BEAN_PROPERTY_ACCESSED = "last.property.accessed";
    HashMap defaultMappings = new HashMap();
    HashMap mappings = new HashMap();
    HashSet noMapping = new HashSet();
    HashSet unknownMappings = new HashSet();
    TypeConverter defaultTypeConverter = new XWorkBasicConverter();
    ObjectTypeDeterminer objectTypeDeterminer = ObjectTypeDeterminerFactory.getInstance();
    static /* synthetic */ Class class$com$opensymphony$xwork$util$XWorkConverter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$ognl$TypeConverter;
    static /* synthetic */ Class class$java$lang$Object;

    protected XWorkConverter() {
        try {
            this.loadConversionProperties("xwork-default-conversion.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadConversionProperties("xwork-conversion.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getConversionErrorMessage(String propertyName, OgnlValueStack stack) {
        String defaultMessage = LocalizedTextUtil.findDefaultText("xwork.default.invalid.fieldvalue", ActionContext.getContext().getLocale(), new Object[]{propertyName});
        String getTextExpression = "getText('invalid.fieldvalue." + propertyName + "','" + defaultMessage + "')";
        String message = (String)stack.findValue(getTextExpression);
        if (message == null) {
            message = defaultMessage;
        }
        return message;
    }

    public static XWorkConverter getInstance() {
        if (instance == null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.opensymphony.xwork.util.AnnotationXWorkConverter");
                instance = (XWorkConverter)((Object)clazz.newInstance());
                LOG.info((Object)"Detected AnnotationXWorkConverter, initializing it...");
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                LOG.error((Object)"Exception when trying to create new AnnotationXWorkConverter", (Throwable)e);
            }
            if (instance == null) {
                instance = new XWorkConverter();
            }
        }
        return instance;
    }

    public static String buildConverterFilename(Class clazz) {
        String className = clazz.getName();
        String resource = className.replace('.', '/') + "-conversion.properties";
        return resource;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void setDefaultConverter(TypeConverter defaultTypeConverter) {
        this.defaultTypeConverter = defaultTypeConverter;
    }

    public Object convertValue(Map map, Object o, Class aClass) {
        return this.convertValue(map, null, null, null, o, aClass);
    }

    public Object convertValue(Map context, Object target, Member member, String property, Object value, Class toClass) {
        TypeConverter tc = null;
        if (value != null && toClass == value.getClass()) {
            return value;
        }
        if (target != null) {
            Class clazz = target.getClass();
            Object[] classProp = null;
            if (target instanceof CompoundRoot && context != null) {
                classProp = this.getClassProperty(context);
            }
            if (classProp != null) {
                clazz = (Class)classProp[0];
                property = (String)classProp[1];
            }
            tc = (TypeConverter)this.getConverter(clazz, property);
        }
        if (tc == null) {
            tc = toClass.equals(class$java$lang$String == null ? (class$java$lang$String = XWorkConverter.class$("java.lang.String")) : class$java$lang$String) && value != null && !value.getClass().equals(class$java$lang$String == null ? (class$java$lang$String = XWorkConverter.class$("java.lang.String")) : class$java$lang$String) && !value.getClass().equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = XWorkConverter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) ? this.lookup(value.getClass()) : this.lookup(toClass);
        }
        if (tc != null) {
            try {
                return tc.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return OgnlRuntime.NoConversionPossible;
            }
        }
        if (this.defaultTypeConverter != null) {
            try {
                return this.defaultTypeConverter.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return OgnlRuntime.NoConversionPossible;
            }
        }
        try {
            return super.convertValue(context, target, member, property, value, toClass);
        }
        catch (Exception e) {
            this.handleConversionException(context, property, value, target);
            return OgnlRuntime.NoConversionPossible;
        }
    }

    public TypeConverter lookup(String className) {
        if (this.unknownMappings.contains(className)) {
            return null;
        }
        TypeConverter result = (TypeConverter)this.defaultMappings.get(className);
        if (result == null) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            result = this.lookupSuper(clazz);
            if (result != null) {
                this.registerConverter(className, result);
            } else {
                this.registerConverterNotFound(className);
            }
        }
        return result;
    }

    public TypeConverter lookup(Class clazz) {
        return this.lookup(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getConverter(Class clazz, String property) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Property: " + property));
            LOG.debug((Object)("Class: " + clazz.getName()));
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            if (property != null && !this.noMapping.contains(clazz)) {
                try {
                    Map mapping = (Map)this.mappings.get(clazz);
                    if (mapping == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Map is null.");
                        }
                        mapping = this.buildConverterMapping(clazz);
                    } else {
                        mapping = this.conditionalReload(clazz, mapping);
                    }
                    Object converter = mapping.get(property);
                    if (LOG.isDebugEnabled() && converter == null) {
                        LOG.debug((Object)("converter is null for property " + property + ". Mapping size: " + mapping.size()));
                        Iterator iter = mapping.keySet().iterator();
                        while (iter.hasNext()) {
                            Object next = iter.next();
                            LOG.debug((Object)(next + ":" + mapping.get(next)));
                        }
                    }
                    return converter;
                }
                catch (Throwable t) {
                    this.noMapping.add(clazz);
                }
            }
        }
        return null;
    }

    protected void handleConversionException(Map context, String property, Object value, Object object) {
        if (context.get(REPORT_CONVERSION_ERRORS) == Boolean.TRUE) {
            HashMap<String, Object> conversionErrors;
            String realProperty = property;
            String fullName = (String)context.get(CONVERSION_PROPERTY_FULLNAME);
            if (fullName != null) {
                realProperty = fullName;
            }
            if ((conversionErrors = (HashMap<String, Object>)context.get("com.opensymphony.xwork.ActionContext.conversionErrors")) == null) {
                conversionErrors = new HashMap<String, Object>();
                context.put("com.opensymphony.xwork.ActionContext.conversionErrors", conversionErrors);
            }
            conversionErrors.put(realProperty, value);
        }
    }

    protected synchronized void registerConverter(String className, TypeConverter converter) {
        this.defaultMappings.put(className, converter);
    }

    protected synchronized void registerConverterNotFound(String className) {
        this.unknownMappings.add(className);
    }

    private Object[] getClassProperty(Map context) {
        return (Object[])context.get("__link");
    }

    private Object acceptableErrorValue(Class toClass) {
        if (!toClass.isPrimitive()) {
            return null;
        }
        if (toClass == Integer.TYPE) {
            return new Integer(0);
        }
        if (toClass == Double.TYPE) {
            return new Double(0.0);
        }
        if (toClass == Long.TYPE) {
            return new Long(0L);
        }
        if (toClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toClass == Short.TYPE) {
            return new Short(0);
        }
        if (toClass == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toClass == Byte.TYPE) {
            return new Byte(0);
        }
        if (toClass == Character.TYPE) {
            return new Character('\u0000');
        }
        return null;
    }

    void addConverterMapping(Map mapping, Class clazz) {
        try {
            InputStream is = FileManager.loadFile((String)XWorkConverter.buildConverterFilename(clazz), (Class)clazz);
            if (is != null) {
                Map.Entry<Object, Object> entry;
                String key;
                Properties prop = new Properties();
                prop.load(is);
                Iterator<Map.Entry<Object, Object>> it = prop.entrySet().iterator();
                while (it.hasNext() && !mapping.containsKey(key = (String)(entry = it.next()).getKey())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(key + ":" + entry.getValue()));
                    }
                    if (key.startsWith("KeyProperty_") || key.startsWith("CreateIfNull_")) {
                        mapping.put(key, entry.getValue());
                        continue;
                    }
                    if (!(key.startsWith("Element_") || key.startsWith("Key_") || key.startsWith(CONVERSION_COLLECTION_PREFIX))) {
                        mapping.put(key, this.createTypeConverter((String)entry.getValue()));
                        continue;
                    }
                    if (key.startsWith("Key_")) {
                        Class<?> converterClass = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Converter class: " + converterClass));
                        }
                        if (converterClass.isAssignableFrom(class$ognl$TypeConverter == null ? XWorkConverter.class$("ognl.TypeConverter") : class$ognl$TypeConverter)) {
                            mapping.put(key, this.createTypeConverter((String)entry.getValue()));
                            continue;
                        }
                        mapping.put(key, converterClass);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Object placed in mapping for key " + key + " is " + mapping.get(key)));
                        continue;
                    }
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue()));
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Problem loading properties for " + clazz.getName()), (Throwable)ex);
        }
    }

    private Map buildConverterMapping(Class clazz) throws Exception {
        HashMap mapping = new HashMap();
        Class curClazz = clazz;
        while (!curClazz.equals(class$java$lang$Object == null ? XWorkConverter.class$("java.lang.Object") : class$java$lang$Object)) {
            this.addConverterMapping(mapping, curClazz);
            Class<?>[] interfaces = curClazz.getInterfaces();
            for (int x = 0; x < interfaces.length; ++x) {
                this.addConverterMapping(mapping, interfaces[x]);
            }
            curClazz = curClazz.getSuperclass();
        }
        if (mapping.size() > 0) {
            this.mappings.put(clazz, mapping);
        } else {
            this.noMapping.add(clazz);
        }
        return mapping;
    }

    private Map conditionalReload(Class clazz, Map oldValues) throws Exception {
        Map mapping = oldValues;
        if (FileManager.isReloadingConfigs() && FileManager.fileNeedsReloading((String)XWorkConverter.buildConverterFilename(clazz))) {
            mapping = this.buildConverterMapping(clazz);
        }
        return mapping;
    }

    TypeConverter createTypeConverter(String className) throws Exception {
        return (TypeConverter)ObjectFactory.getObjectFactory().buildBean(className, null);
    }

    public void loadConversionProperties(String propsName) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsName);
        Properties props = new Properties();
        props.load(is);
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            try {
                this.defaultMappings.put(key, this.createTypeConverter((String)entry.getValue()));
            }
            catch (Exception e) {
                LOG.error((Object)"Conversion registration error", (Throwable)e);
            }
        }
    }

    TypeConverter lookupSuper(Class clazz) {
        TypeConverter result = null;
        if (clazz != null && (result = (TypeConverter)this.defaultMappings.get(clazz.getName())) == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!this.defaultMappings.containsKey(interfaces[i].getName())) continue;
                result = (TypeConverter)this.defaultMappings.get(interfaces[i].getName());
                break;
            }
            if (result == null) {
                result = this.lookupSuper(clazz.getSuperclass());
            }
        }
        return result;
    }

    public ObjectTypeDeterminer getObjectTypeDeterminer() {
        return this.objectTypeDeterminer;
    }

    public void setObjectTypeDeterminer(ObjectTypeDeterminer determiner) {
        this.objectTypeDeterminer = determiner;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$util$XWorkConverter == null ? (class$com$opensymphony$xwork$util$XWorkConverter = XWorkConverter.class$("com.opensymphony.xwork.util.XWorkConverter")) : class$com$opensymphony$xwork$util$XWorkConverter));
    }
}

