/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.util.XWorkConverter;
import com.opensymphony.xwork.util.XWorkList;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import ognl.DefaultTypeConverter;
import ognl.Ognl;
import ognl.TypeConverter;

public class XWorkBasicConverter
extends DefaultTypeConverter {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public Object convertValue(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        if (value == null || toType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (toType == (class$java$lang$String == null ? (class$java$lang$String = XWorkBasicConverter.class$("java.lang.String")) : class$java$lang$String)) {
            result = this.doConvertToString(context, value);
        } else if (toType == Boolean.TYPE) {
            result = this.doConvertToBoolean(value);
        } else if (toType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XWorkBasicConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            result = this.doConvertToBoolean(value);
        } else if (toType.isArray()) {
            result = this.doConvertToArray(context, o, member, s, value, toType);
        } else if ((class$java$util$Date == null ? (class$java$util$Date = XWorkBasicConverter.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(toType)) {
            result = this.doConvertToDate(context, value, toType);
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = XWorkBasicConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(toType)) {
            result = this.doConvertToCollection(context, o, member, s, value, toType);
        } else if (toType == (class$java$lang$Character == null ? (class$java$lang$Character = XWorkBasicConverter.class$("java.lang.Character")) : class$java$lang$Character)) {
            result = this.doConvertToCharacter(value);
        } else if (toType == Character.TYPE) {
            result = this.doConvertToCharacter(value);
        } else if ((class$java$lang$Number == null ? (class$java$lang$Number = XWorkBasicConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(toType)) {
            result = this.doConvertToNumber(context, value, toType);
        } else if (toType == (class$java$lang$Class == null ? (class$java$lang$Class = XWorkBasicConverter.class$("java.lang.Class")) : class$java$lang$Class)) {
            result = this.doConvertToClass(value);
        }
        if (result == null) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length >= 1) {
                    value = array[0];
                }
                result = this.convertValue(context, o, member, s, value, toType);
            } else if (!"".equals(value)) {
                result = super.convertValue(context, value, toType);
            }
            if (result == null && value != null && !"".equals(value)) {
                throw new XworkException("Cannot create type " + toType + " from value " + value);
            }
        }
        return result;
    }

    private Locale getLocale(Map context) {
        if (context == null) {
            return Locale.getDefault();
        }
        Locale locale = (Locale)context.get("com.opensymphony.xwork.ActionContext.locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private Collection createCollection(Object fromObject, String propertyName, Class toType, Class memberType, int size) {
        AbstractCollection result = toType == (class$java$util$Set == null ? (class$java$util$Set = XWorkBasicConverter.class$("java.util.Set")) : class$java$util$Set) ? (size > 0 ? new HashSet(size) : new HashSet()) : (toType == (class$java$util$SortedSet == null ? (class$java$util$SortedSet = XWorkBasicConverter.class$("java.util.SortedSet")) : class$java$util$SortedSet) ? new TreeSet() : (size > 0 ? new XWorkList(memberType, size) : new XWorkList(memberType)));
        return result;
    }

    private Object doConvertToArray(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        Class<?> componentType = toType.getComponentType();
        if (componentType != null) {
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                result = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object valueItem = Array.get(value, i);
                    Array.set(result, i, converter.convertValue(context, o, member, s, valueItem, componentType));
                }
            } else {
                result = Array.newInstance(componentType, 1);
                Array.set(result, 0, converter.convertValue(context, o, member, s, value, componentType));
            }
        }
        return result;
    }

    private Object doConvertToCharacter(Object value) {
        if (value instanceof String) {
            String cStr = (String)value;
            return cStr.length() > 0 ? new Character(cStr.charAt(0)) : null;
        }
        return null;
    }

    private Object doConvertToBoolean(Object value) {
        if (value instanceof String) {
            String bStr = (String)value;
            return Boolean.valueOf(bStr);
        }
        return null;
    }

    private Class doConvertToClass(Object value) {
        Class<?> clazz = null;
        if (value instanceof String) {
            try {
                clazz = Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                throw new XworkException(e.getLocalizedMessage(), e);
            }
        }
        return clazz;
    }

    private Collection doConvertToCollection(Map context, Object o, Member member, String prop, Object value, Class toType) {
        Collection result;
        Class memberType;
        Class clazz = memberType = class$java$lang$String == null ? (class$java$lang$String = XWorkBasicConverter.class$("java.lang.String")) : class$java$lang$String;
        if (o != null && (memberType = XWorkConverter.getInstance().getObjectTypeDeterminer().getElementClass(o.getClass(), prop, null)) == null) {
            Class clazz2 = memberType = class$java$lang$String == null ? (class$java$lang$String = XWorkBasicConverter.class$("java.lang.String")) : class$java$lang$String;
        }
        if (toType.isAssignableFrom(value.getClass())) {
            result = (Collection)value;
        } else if (value.getClass().isArray()) {
            Object[] objArray = (Object[])value;
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            result = this.createCollection(o, prop, toType, memberType, objArray.length);
            for (int i = 0; i < objArray.length; ++i) {
                result.add(converter.convertValue(context, o, member, prop, objArray[i], memberType));
            }
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = XWorkBasicConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(value.getClass())) {
            Collection col = (Collection)value;
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            result = this.createCollection(o, prop, toType, memberType, col.size());
            Iterator it = col.iterator();
            while (it.hasNext()) {
                result.add(converter.convertValue(context, o, member, prop, it.next(), memberType));
            }
        } else {
            result = this.createCollection(o, prop, toType, memberType, -1);
            result.add(value);
        }
        return result;
    }

    private Object doConvertToDate(Map context, Object value, Class toType) {
        Date result;
        block7: {
            result = null;
            if (value instanceof String) {
                String sa = (String)value;
                Locale locale = this.getLocale(context);
                DateFormat df = (class$java$sql$Time == null ? (class$java$sql$Time = XWorkBasicConverter.class$("java.sql.Time")) : class$java$sql$Time) == toType ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateInstance(3, locale);
                try {
                    result = df.parse(sa);
                    if ((class$java$util$Date == null ? (class$java$util$Date = XWorkBasicConverter.class$("java.util.Date")) : class$java$util$Date) != toType) {
                        try {
                            Constructor constructor = toType.getConstructor(Long.TYPE);
                            return constructor.newInstance(new Long(result.getTime()));
                        }
                        catch (Exception e) {
                            throw new XworkException("Couldn't create class " + toType + " using default (long) constructor", e);
                        }
                    }
                    break block7;
                }
                catch (ParseException e) {
                    throw new XworkException("Could not parse date", e);
                }
            }
            if ((class$java$util$Date == null ? (class$java$util$Date = XWorkBasicConverter.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(value.getClass())) {
                result = (Date)value;
            }
        }
        return result;
    }

    private Object doConvertToNumber(Map context, Object value, Class toType) {
        Object[] objArray;
        if (value instanceof String) {
            if (toType == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XWorkBasicConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                return new BigDecimal((String)value);
            }
            if (toType == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = XWorkBasicConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                return new BigInteger((String)value);
            }
            String stringValue = (String)value;
            NumberFormat numFormat = NumberFormat.getInstance(this.getLocale(context));
            ParsePosition parsePos = new ParsePosition(0);
            Number number = numFormat.parse(stringValue, parsePos);
            if (parsePos.getIndex() != stringValue.length()) {
                throw new XworkException("Unparseable number: \"" + stringValue + "\" at position " + parsePos.getIndex());
            }
            value = super.convertValue(context, (Object)number, toType);
        } else if (value instanceof Object[] && (objArray = (Object[])value).length == 1) {
            return this.doConvertToNumber(context, objArray[0], toType);
        }
        return super.convertValue(context, value, toType);
    }

    private String doConvertToString(Map context, Object value) {
        String result = null;
        if (value instanceof int[]) {
            int[] x = (int[])value;
            ArrayList<Integer> intArray = new ArrayList<Integer>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Integer(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof long[]) {
            long[] x = (long[])value;
            ArrayList<Long> intArray = new ArrayList<Long>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Long(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof double[]) {
            double[] x = (double[])value;
            ArrayList<Double> intArray = new ArrayList<Double>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Double(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof boolean[]) {
            boolean[] x = (boolean[])value;
            ArrayList<Boolean> intArray = new ArrayList<Boolean>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Boolean(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof Date) {
            DateFormat df = value instanceof Time ? DateFormat.getTimeInstance(2, this.getLocale(context)) : DateFormat.getDateInstance(3, this.getLocale(context));
            result = df.format(value);
        } else if (value instanceof String[]) {
            result = TextUtils.join((String)", ", (String[])((String[])value));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

