/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork.interceptor.ExceptionHolder;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionMappingInterceptor
implements Interceptor {
    protected Log log = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$java$lang$Throwable;

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        String result;
        try {
            result = invocation.invoke();
        }
        catch (Exception e) {
            List exceptionMappings = invocation.getProxy().getConfig().getExceptionMappings();
            String mappedResult = this.findResultFromExceptions(exceptionMappings, e);
            if (mappedResult != null) {
                result = mappedResult;
                this.publishException(invocation, new ExceptionHolder(e));
            }
            throw e;
        }
        return result;
    }

    private String findResultFromExceptions(List exceptionMappings, Throwable t) {
        String result = null;
        if (exceptionMappings != null) {
            int deepest = Integer.MAX_VALUE;
            Iterator iter = exceptionMappings.iterator();
            while (iter.hasNext()) {
                ExceptionMappingConfig exceptionMappingConfig = (ExceptionMappingConfig)iter.next();
                int depth = this.getDepth(exceptionMappingConfig.getExceptionClassName(), t);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                result = exceptionMappingConfig.getResult();
            }
        }
        return result;
    }

    public int getDepth(String exceptionMapping, Throwable t) {
        return this.getDepth(exceptionMapping, t.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class exceptionClass, int depth) {
        if (exceptionClass.getName().indexOf(exceptionMapping) != -1) {
            return depth;
        }
        if (exceptionClass.equals(class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionMappingInterceptor.class$("java.lang.Throwable")) : class$java$lang$Throwable)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }

    protected void publishException(ActionInvocation invocation, ExceptionHolder exceptionHolder) {
        invocation.getStack().push(exceptionHolder);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

