/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Validateable;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.TextParseUtil;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWorkflowInterceptor
implements Interceptor {
    Log log = LogFactory.getLog(this.getClass());
    Set excludeMethods = Collections.EMPTY_SET;
    Set includeMethods = Collections.EMPTY_SET;

    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = TextParseUtil.commaDelimitedStringToSet(excludeMethods);
    }

    public void setIncludeMethods(String includeMethods) {
        this.includeMethods = TextParseUtil.commaDelimitedStringToSet(includeMethods);
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        String method = invocation.getProxy().getMethod();
        if (this.excludeMethods.contains(method) && !this.includeMethods.contains(method)) {
            this.log.debug((Object)("Skipping workflow. Method [" + method + "] found in exclude list."));
            return invocation.invoke();
        }
        if (this.includeMethods.size() == 0 || this.includeMethods.contains(method)) {
            ValidationAware validationAwareAction;
            Object action = invocation.getAction();
            if (action instanceof Validateable) {
                Validateable validateable = (Validateable)action;
                validateable.validate();
            }
            if (action instanceof ValidationAware && (validationAwareAction = (ValidationAware)action).hasErrors()) {
                return "input";
            }
        }
        return invocation.invoke();
    }

    public void destroy() {
    }

    public void init() {
    }
}

