/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.entities;

import com.opensymphony.xwork.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork.config.entities.ExternalReference;
import com.opensymphony.xwork.config.entities.InterceptorListHolder;
import com.opensymphony.xwork.config.entities.Parameterizable;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ActionConfig
implements InterceptorListHolder,
Parameterizable,
Serializable {
    protected List externalRefs;
    protected List interceptors;
    protected Map params;
    protected Map results;
    protected List exceptionMappings;
    protected String className;
    protected String methodName;
    protected String packageName;

    public ActionConfig() {
        this.params = new TreeMap();
        this.results = new TreeMap();
        this.interceptors = new ArrayList();
        this.externalRefs = new ArrayList();
        this.exceptionMappings = new ArrayList();
    }

    public ActionConfig(String methodName, Class clazz, Map parameters, Map results, List interceptors) {
        this(methodName, clazz.getName(), parameters, results, interceptors);
    }

    public ActionConfig(String methodName, Class clazz, Map parameters, Map results, List interceptors, List exceptionMappings) {
        this(methodName, clazz.getName(), parameters, results, interceptors, exceptionMappings);
    }

    public ActionConfig(String methodName, String className, Map parameters, Map results, List interceptors) {
        this(methodName, className, parameters, results, interceptors, Collections.EMPTY_LIST, new String());
    }

    public ActionConfig(String methodName, String className, Map parameters, Map results, List interceptors, List exceptionMappings) {
        this(methodName, className, parameters, results, interceptors, Collections.EMPTY_LIST, exceptionMappings, new String());
    }

    public ActionConfig(String methodName, String className, Map parameters, Map results, List interceptors, List externalRefs, String packageName) {
        this(methodName, className, parameters, results, interceptors, externalRefs, Collections.EMPTY_LIST, packageName);
    }

    public ActionConfig(String methodName, String className, Map parameters, Map results, List interceptors, List externalRefs, List exceptionMappings, String packageName) {
        this.methodName = methodName;
        this.interceptors = interceptors;
        this.params = parameters;
        this.results = results;
        this.className = className;
        this.externalRefs = externalRefs;
        this.exceptionMappings = exceptionMappings;
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public List getExternalRefs() {
        return this.externalRefs;
    }

    public List getExceptionMappings() {
        return this.exceptionMappings;
    }

    public List getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        return this.interceptors;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public Map getParams() {
        if (this.params == null) {
            this.params = new TreeMap();
        }
        return this.params;
    }

    public void setResults(Map results) {
        this.results = results;
    }

    public Map getResults() {
        if (this.results == null) {
            this.results = new TreeMap();
        }
        return this.results;
    }

    public void addExternalRef(ExternalReference reference) {
        this.getExternalRefs().add(reference);
    }

    public void addExternalRefs(List externalRefs) {
        this.getExternalRefs().addAll(externalRefs);
    }

    public void addExceptionMapping(ExceptionMappingConfig exceptionMapping) {
        this.getExceptionMappings().add(exceptionMapping);
    }

    public void addExceptionMappings(List exceptionMappings) {
        this.getExceptionMappings().addAll(exceptionMappings);
    }

    public void addInterceptor(Interceptor interceptor) {
        this.getInterceptors().add(interceptor);
    }

    public void addInterceptors(List interceptors) {
        this.getInterceptors().addAll(interceptors);
    }

    public void addParam(String name, Object value) {
        this.getParams().put(name, value);
    }

    public void addResultConfig(ResultConfig resultConfig) {
        this.getResults().put(resultConfig.getName(), resultConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionConfig)) {
            return false;
        }
        ActionConfig actionConfig = (ActionConfig)o;
        if (this.className != null ? !this.className.equals(actionConfig.className) : actionConfig.className != null) {
            return false;
        }
        if (this.interceptors != null ? !((Object)this.interceptors).equals(actionConfig.interceptors) : actionConfig.interceptors != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(actionConfig.methodName) : actionConfig.methodName != null) {
            return false;
        }
        if (this.params != null ? !((Object)this.params).equals(actionConfig.params) : actionConfig.params != null) {
            return false;
        }
        return !(this.results != null ? !((Object)this.results).equals(actionConfig.results) : actionConfig.results != null);
    }

    public int hashCode() {
        int result = this.interceptors != null ? ((Object)this.interceptors).hashCode() : 0;
        result = 29 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        result = 29 * result + (this.results != null ? ((Object)this.results).hashCode() : 0);
        result = 29 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{ActionConfig " + this.className + (this.methodName != null ? "." + this.methodName + "()" : "") + "}";
    }
}

