/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.impl.DefaultConfiguration;
import com.opensymphony.xwork.config.providers.XmlConfigurationProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManager {
    protected static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$config$ConfigurationManager == null ? (class$com$opensymphony$xwork$config$ConfigurationManager = ConfigurationManager.class$("com.opensymphony.xwork.config.ConfigurationManager")) : class$com$opensymphony$xwork$config$ConfigurationManager));
    protected static Configuration configurationInstance;
    private static List configurationProviders;
    static /* synthetic */ Class class$com$opensymphony$xwork$config$ConfigurationManager;

    private ConfigurationManager() {
    }

    public static synchronized void setConfiguration(Configuration configuration) {
        configurationInstance = configuration;
    }

    public static synchronized Configuration getConfiguration() {
        if (configurationInstance == null) {
            configurationInstance = new DefaultConfiguration();
            try {
                configurationInstance.reload();
            }
            catch (ConfigurationException e) {
                configurationInstance = null;
                throw e;
            }
        } else {
            ConfigurationManager.conditionalReload();
        }
        return configurationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getConfigurationProviders() {
        List list = configurationProviders;
        synchronized (list) {
            if (configurationProviders.size() == 0) {
                configurationProviders.add(new XmlConfigurationProvider());
            }
            return configurationProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigurationProvider(ConfigurationProvider provider) {
        List list = configurationProviders;
        synchronized (list) {
            if (!configurationProviders.contains(provider)) {
                configurationProviders.add(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearConfigurationProviders() {
        List list = configurationProviders;
        synchronized (list) {
            Iterator iterator = configurationProviders.iterator();
            while (iterator.hasNext()) {
                ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
                provider.destroy();
            }
            configurationProviders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void destroyConfiguration() {
        List list = configurationProviders;
        synchronized (list) {
            configurationProviders = new ArrayList();
            configurationInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void conditionalReload() {
        if (FileManager.isReloadingConfigs()) {
            boolean reload;
            List list = configurationProviders;
            synchronized (list) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Checking ConfigurationProviders for reload.");
                }
                reload = false;
                Iterator iterator = ConfigurationManager.getConfigurationProviders().iterator();
                while (iterator.hasNext()) {
                    ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
                    if (!provider.needsReload()) continue;
                    reload = true;
                    break;
                }
            }
            if (reload) {
                configurationInstance.reload();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        configurationProviders = new ArrayList();
        ConfigurationManager.destroyConfiguration();
    }
}

