/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DirtyFlagMap
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1433884852607126222L;
    private boolean dirty = false;
    private transient boolean locked = false;
    private Map map;

    public DirtyFlagMap(Map mapToWrap) {
        if (mapToWrap == null) {
            throw new IllegalArgumentException("mapToWrap cannot be null!");
        }
        this.map = mapToWrap;
    }

    public DirtyFlagMap() {
        this.map = new HashMap();
    }

    public DirtyFlagMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public DirtyFlagMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    public void setMutable(boolean mutable) {
        if (this.locked == !mutable) {
            return;
        }
        this.locked = !mutable;
        this.map = this.locked ? Collections.unmodifiableMap(this.map) : new HashMap(this.map);
    }

    public boolean isMutable() {
        return !this.locked;
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Map getWrappedMap() {
        return this.map;
    }

    public void clear() {
        this.dirty = true;
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DirtyFlagMap)) {
            return false;
        }
        return ((Object)this.map).equals(((DirtyFlagMap)obj).getWrappedMap());
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object val) {
        this.dirty = true;
        return this.map.put(key, val);
    }

    public void putAll(Map t) {
        if (!t.isEmpty()) {
            this.dirty = true;
        }
        this.map.putAll(t);
    }

    public Object remove(Object key) {
        Object obj = this.map.remove(key);
        if (obj != null) {
            this.dirty = true;
        }
        return obj;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public Object clone() {
        DirtyFlagMap copy;
        try {
            copy = (DirtyFlagMap)super.clone();
            if (this.map instanceof HashMap) {
                copy.map = (Map)((HashMap)this.map).clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }
}

