/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.hsqldb.util.RCData;
import org.hsqldb.util.SqlFile;
import org.hsqldb.util.SqlToolError;

public class SqlTool {
    private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
    private static Connection conn;
    private static boolean noexit;
    private static String revnum;
    private static String CMDLINE_ID;
    private static final String SYNTAX_MESSAGE;
    private static BadCmdline bcl;

    private static void exitMain(int retval) throws SqlToolException {
        SqlTool.exitMain(retval, null);
    }

    private static void exitMain(int retval, String msg) throws SqlToolException {
        if (noexit) {
            if (retval == 0) {
                return;
            }
            if (msg == null) {
                throw new SqlToolException();
            }
            throw new SqlToolException(msg);
        }
        if (msg != null) {
            (retval == 0 ? System.out : System.err).println(msg);
        }
        System.exit(retval);
    }

    private static String promptForPassword(String username) throws SqlToolException {
        String password = null;
        try {
            BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(username + "'s password: ");
            password = console.readLine();
            password = password == null ? "" : password.trim();
        }
        catch (IOException e) {
            SqlTool.exitMain(30, "Error while reading password from console: " + e.getMessage());
        }
        return password;
    }

    private static void varParser(String varString, Map varMap, boolean lowerCaseKeys) throws SqlToolException {
        if (varMap == null || varString == null) {
            return;
        }
        StringTokenizer allvars = new StringTokenizer(varString, ",");
        while (allvars.hasMoreTokens()) {
            String curSetting = allvars.nextToken().trim();
            int equals = curSetting.indexOf(61);
            if (equals < 1) {
                throw new SqlToolException("Var settings not of format NAME=var[,...]");
            }
            String var = curSetting.substring(0, equals).trim();
            String val = curSetting.substring(equals + 1).trim();
            if (var.length() < 1 || val.length() < 1) {
                throw new SqlToolException("Var settings not of format NAME=var[,...]");
            }
            if (lowerCaseKeys) {
                var = var.toLowerCase();
            }
            varMap.put(var, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws SqlToolException {
        int j;
        String rcFile = null;
        File tmpFile = null;
        String sqlText = null;
        String driver = null;
        String targetDb = null;
        String varSettings = null;
        boolean debug = false;
        File[] scriptFiles = null;
        int i = -1;
        boolean listMode = false;
        boolean interactive = false;
        boolean noinput = false;
        boolean noautoFile = false;
        boolean autoCommit = false;
        Boolean coeOverride = null;
        Boolean stdinputOverride = null;
        String rcParams = null;
        String rcUrl = null;
        String rcUsername = null;
        String rcPassword = null;
        String rcDriver = null;
        String rcCharset = null;
        String rcTruststore = null;
        HashMap rcFields = null;
        noexit = System.getProperty("sqltool.noexit") != null;
        try {
            while (i + 1 < arg.length && arg[i + 1].startsWith("--") && arg[++i].length() != 2) {
                String parameter = arg[i].substring(2).toLowerCase();
                if (parameter.equals("help")) {
                    SqlTool.exitMain(0, SYNTAX_MESSAGE);
                    return;
                }
                if (parameter.equals("abortonerr")) {
                    if (coeOverride != null) {
                        SqlTool.exitMain(0, "Switches '--abortOnErr' and '--continueOnErr' are mutually exclusive");
                        return;
                    }
                    coeOverride = Boolean.FALSE;
                    continue;
                }
                if (parameter.equals("continueonerr")) {
                    if (coeOverride != null) {
                        SqlTool.exitMain(0, "Switches '--abortOnErr' and '--continueOnErr' are mutually exclusive");
                        return;
                    }
                    coeOverride = Boolean.TRUE;
                    continue;
                }
                if (parameter.equals("list")) {
                    listMode = true;
                    continue;
                }
                if (parameter.equals("rcfile")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    rcFile = arg[i];
                    continue;
                }
                if (parameter.equals("setvar")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    varSettings = arg[i];
                    continue;
                }
                if (parameter.equals("sql")) {
                    noinput = true;
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    sqlText = arg[i];
                    if (sqlText.charAt(sqlText.length() - 1) == ';') continue;
                    sqlText = sqlText + ";";
                    continue;
                }
                if (parameter.equals("debug")) {
                    debug = true;
                    continue;
                }
                if (parameter.equals("noautofile")) {
                    noautoFile = true;
                    continue;
                }
                if (parameter.equals("autocommit")) {
                    autoCommit = true;
                    continue;
                }
                if (parameter.equals("stdinput")) {
                    noinput = false;
                    stdinputOverride = Boolean.TRUE;
                    continue;
                }
                if (parameter.equals("noinput")) {
                    noinput = true;
                    stdinputOverride = Boolean.FALSE;
                    continue;
                }
                if (parameter.equals("driver")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    driver = arg[i];
                    continue;
                }
                if (parameter.equals("inlinerc")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    rcParams = arg[i];
                    continue;
                }
                throw bcl;
            }
            if (!listMode && rcParams == null) {
                if (++i == arg.length) {
                    throw bcl;
                }
                targetDb = arg[i];
            }
            int scriptIndex = 0;
            if (sqlText != null) {
                try {
                    tmpFile = File.createTempFile("sqltool-", ".sql");
                    FileWriter fw = new FileWriter(tmpFile);
                    fw.write("/* " + new Date() + ".  " + SqlTool.class.getName() + " command-line SQL. */\n\n");
                    fw.write(sqlText + '\n');
                    fw.flush();
                    fw.close();
                }
                catch (IOException ioe) {
                    SqlTool.exitMain(4, "Failed to write given sql to temp file: " + ioe);
                    return;
                }
            }
            if (stdinputOverride != null) {
                noinput = stdinputOverride == false;
            }
            boolean bl = interactive = !noinput && arg.length <= i + 1;
            if (arg.length == i + 2 && arg[i + 1].equals("-")) {
                if (stdinputOverride == null) {
                    noinput = false;
                }
            } else if (arg.length > i + 1) {
                scriptFiles = new File[arg.length - i - 1 + (stdinputOverride == null || stdinputOverride == false ? 0 : 1)];
                if (debug) {
                    System.err.println("scriptFiles has " + scriptFiles.length + " elements");
                }
                while (i + 1 < arg.length) {
                    scriptFiles[scriptIndex++] = new File(arg[++i]);
                }
                if (stdinputOverride != null && stdinputOverride.booleanValue()) {
                    scriptFiles[scriptIndex++] = null;
                    noinput = true;
                }
            }
        }
        catch (BadCmdline bcl) {
            SqlTool.exitMain(2, SYNTAX_MESSAGE);
            return;
        }
        RCData conData = null;
        if (rcParams != null) {
            rcFields = new HashMap();
            try {
                SqlTool.varParser(rcParams, rcFields, true);
            }
            catch (SqlToolException e) {
                SqlTool.exitMain(24, e.getMessage());
            }
            try {
                rcUrl = (String)rcFields.get("url");
                rcUsername = (String)rcFields.get("user");
                rcDriver = (String)rcFields.get("driver");
                rcCharset = (String)rcFields.get("charset");
                rcTruststore = (String)rcFields.get("truststore");
                rcPassword = SqlTool.promptForPassword(rcUsername);
                conData = new RCData(CMDLINE_ID, rcUrl, rcUsername, rcPassword, rcDriver, rcCharset, rcTruststore);
            }
            catch (SqlToolException e) {
                throw e;
            }
            catch (Exception e) {
                SqlTool.exitMain(1, "Invalid inline RC file specified: " + e.getMessage());
                return;
            }
        }
        try {
            conData = new RCData(new File(rcFile == null ? DEFAULT_RCFILE : rcFile), targetDb);
        }
        catch (Exception e) {
            SqlTool.exitMain(1, "Failed to retrieve connection info for database '" + targetDb + "': " + e.getMessage());
            return;
        }
        if (listMode) {
            SqlTool.exitMain(0);
            return;
        }
        if (debug) {
            conData.report();
        }
        try {
            conn = conData.getConnection(driver, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
            conn.setAutoCommit(autoCommit);
            DatabaseMetaData md = null;
            if (interactive && (md = conn.getMetaData()) != null) {
                System.out.println("JDBC Connection established to a " + md.getDatabaseProductName() + " v. " + md.getDatabaseProductVersion() + " database as '" + md.getUserName() + "'.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SqlTool.exitMain(10, "Failed to get a connection to " + conData.url + " as " + conData.username + ".  " + e.getMessage());
            return;
        }
        File[] emptyFileArray = new File[]{};
        File[] singleNullFileArray = new File[]{null};
        File autoFile = null;
        if (!(!interactive || noautoFile || (autoFile = new File(System.getProperty("user.home") + "/auto.sql")).isFile() && autoFile.canRead())) {
            autoFile = null;
        }
        if (scriptFiles == null) {
            scriptFiles = noinput ? emptyFileArray : singleNullFileArray;
        }
        int numFiles = scriptFiles.length;
        if (tmpFile != null) {
            ++numFiles;
        }
        if (autoFile != null) {
            ++numFiles;
        }
        SqlFile[] sqlFiles = new SqlFile[numFiles];
        HashMap userVars = new HashMap();
        if (varSettings != null) {
            SqlTool.varParser(varSettings, userVars, false);
        }
        int interactiveFileIndex = -1;
        try {
            int fileIndex = 0;
            if (autoFile != null) {
                sqlFiles[fileIndex++] = new SqlFile(autoFile, false, userVars);
            }
            if (tmpFile != null) {
                sqlFiles[fileIndex++] = new SqlFile(tmpFile, false, userVars);
            }
            for (j = 0; j < scriptFiles.length; ++j) {
                if (interactiveFileIndex < 0 && interactive) {
                    interactiveFileIndex = fileIndex;
                }
                sqlFiles[fileIndex++] = new SqlFile(scriptFiles[j], interactive, userVars);
            }
        }
        catch (IOException ioe) {
            try {
                conn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            SqlTool.exitMain(2, ioe.getMessage());
            return;
        }
        int retval = 0;
        try {
            for (j = 0; j < sqlFiles.length; ++j) {
                if (j == interactiveFileIndex) {
                    System.out.print("SqlTool v. " + revnum + ".                        ");
                }
                sqlFiles[j].execute(conn, coeOverride);
            }
        }
        catch (IOException ioe) {
            System.err.println("Failed to execute SQL:  " + ioe.getMessage());
            retval = 3;
        }
        catch (SqlToolError ste) {
            retval = 2;
        }
        catch (SQLException se) {
            retval = 1;
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
        if (tmpFile != null && !tmpFile.delete()) {
            System.err.println("Error occurred while trying to remove temp file '" + tmpFile + "'");
        }
        SqlTool.exitMain(retval);
    }

    static {
        revnum = null;
        CMDLINE_ID = "cmdline";
        revnum = "$Revision: 1.55 $".substring("$Revision: ".length(), "$Revision: 1.55 $".length() - 2);
        SYNTAX_MESSAGE = "Usage: java [-Dsqlfile.X=Y...] org.hsqldb.util.SqlTool \\\n    [--optname [optval...]] urlid [file1.sql...]\nwhere arguments are:\n    --help                   Displays this message\n    --list                   List urlids in the rc file\n    --noInput                Do not read stdin (default if sql file given\n                             or --sql switch used).\n    --stdInput               Read stdin IN ADDITION to sql files/--sql input\n    --inlineRc URL=val1,USER=val2[,DRIVER=val3][,CHARSET=val4][,TRUST=val5]\n                             Inline RC file variables\n    --debug                  Print Debug info to stderr\n    --noAutoFile             Do not execute auto.sql from home dir\n    --autoCommit             Auto-commit JDBC DML commands\n    --sql \"SQL; Statements\"  Execute given SQL instead of stdin (before\n                             SQL files if any are specified) where \"SQL\"\n                             consists of SQL command(s).  See the Guide.\n    --rcFile /file/path.rc   Connect Info File [$HOME/sqltool.rc]\n    --abortOnErr             Abort on Error (overrides defaults)\n    --continueOnErr          Continue on Error (overrides defaults)\n    --setVar NAME1=val1[,NAME2=val2...]   PL variables\n    --driver a.b.c.Driver    JDBC driver class [org.hsqldb.jdbcDriver]\n    urlid                    ID of url/userame/password in rcfile\n    file1.sql...             SQL files to be executed [stdin]\n                             (Use '-' for non-interactively stdin).\nSee the SqlTool Manual for the supported sqltool.* System Properties.\nSqlTool v. " + revnum + ".";
        bcl = new BadCmdline();
    }

    public static class SqlToolException
    extends Exception {
        public SqlToolException() {
        }

        public SqlToolException(String s) {
            super(s);
        }
    }

    private static class BadCmdline
    extends Exception {
        private BadCmdline() {
        }
    }
}

