/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.math.BigDecimal;
import java.sql.Date;
import org.hsqldb.store.ValuePoolHashMap;

public class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static ValuePoolHashMap datePool;
    static final int DEFAULT_VALUE_POOL_SIZE = 10000;
    static final int[] defaultPoolLookupSize;
    static final int POOLS_COUNT;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] sizeArray = defaultPoolLookupSize;
        int sizeFactor = 2;
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[POOLS_COUNT];
            for (int i = 0; i < POOLS_COUNT; ++i) {
                int size = sizeArray[i];
                ValuePool.poolList[i] = new ValuePoolHashMap(size, size * sizeFactor, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            datePool = poolList[5];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool(int[] sizeArray, int sizeFactor) {
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].resetCapacity(sizeArray[i] * sizeFactor, 2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool() {
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            ValuePool.resetPool(defaultPoolLookupSize, 2);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool() {
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInt(int val) {
        ValuePoolHashMap valuePoolHashMap = intPool;
        synchronized (valuePoolHashMap) {
            return intPool.getOrAddInteger(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(long val) {
        ValuePoolHashMap valuePoolHashMap = longPool;
        synchronized (valuePoolHashMap) {
            return longPool.getOrAddLong(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(long val) {
        ValuePoolHashMap valuePoolHashMap = doublePool;
        synchronized (valuePoolHashMap) {
            return doublePool.getOrAddDouble(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String val) {
        if (val == null || val.length() > maxStringLength) {
            return val;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDate(long val) {
        ValuePoolHashMap valuePoolHashMap = datePool;
        synchronized (valuePoolHashMap) {
            return datePool.getOrAddDate(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimal(BigDecimal val) {
        if (val == null) {
            return val;
        }
        ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
        synchronized (valuePoolHashMap) {
            return (BigDecimal)bigdecimalPool.getOrAddObject(val);
        }
    }

    public static Boolean getBoolean(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        defaultPoolLookupSize = new int[]{10000, 10000, 10000, 10000, 10000, 10000};
        POOLS_COUNT = defaultPoolLookupSize.length;
        ValuePool.initPool();
    }
}

