/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.scriptio.ScriptWriterBase;

class ScriptWriterBinary
extends ScriptWriterBase {
    RowOutputBinary rowOut;

    ScriptWriterBinary(Database db, String file, boolean includeCached, boolean newFile) throws HsqlException {
        super(db, file, includeCached, newFile, false);
    }

    protected void initBuffers() {
        this.rowOut = new RowOutputBinary();
    }

    protected void writeSingleColumnResult(Result r) throws IOException, HsqlException {
        Result.write(r, this.rowOut, this.fileStreamOut);
    }

    protected void writeRow(Session session, Table t, Object[] data) throws IOException, HsqlException {
        this.rowOut.reset();
        this.rowOut.writeRow(data, t);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        ++this.tableRowCount;
    }

    protected void writeTableInit(Table t) throws HsqlException, IOException {
        this.tableRowCount = 0;
        this.rowOut.reset();
        this.rowOut.writeSize(0);
        this.rowOut.writeString(t.getName().name);
        this.rowOut.writeIntData(1);
        this.rowOut.writeString(t.getSchemaName());
        this.rowOut.writeIntData(this.rowOut.size(), 0);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    }

    protected void writeTableTerm(Table t) throws IOException {
        this.rowOut.reset();
        this.rowOut.writeSize(0);
        this.rowOut.writeIntData(this.tableRowCount);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    }

    protected void writeDataTerm() throws IOException {
        this.rowOut.reset();
        this.rowOut.writeSize(0);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    }

    public void writeLogStatement(Session session, String s) throws IOException, HsqlException {
    }

    protected void addSessionId(Session session) throws IOException {
    }

    public void writeDeleteStatement(Session session, Table table, Object[] ddata) throws HsqlException, IOException {
    }

    public void writeSequenceStatement(Session session, NumberSequence seq) throws HsqlException, IOException {
    }

    public void writeInsertStatement(Session session, Table table, Object[] data) throws HsqlException, IOException {
    }

    public void writeCommitStatement(Session session) throws HsqlException, IOException {
    }
}

