/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public abstract class RowOutputBase
extends HsqlByteArrayOutputStream
implements RowOutputInterface {
    public static final int CACHED_ROW_160 = 0;
    public static final int CACHED_ROW_170 = 1;
    protected boolean skipSystemId = false;

    public RowOutputBase() {
    }

    public RowOutputBase(int initialSize) {
        super(initialSize);
    }

    public RowOutputBase(byte[] buffer) {
        super(buffer);
    }

    public abstract void writeEnd();

    public abstract void writeSize(int var1);

    public abstract void writeType(int var1);

    public abstract void writeShortData(short var1);

    public abstract void writeIntData(int var1);

    public abstract void writeIntData(int var1, int var2);

    public abstract void writeString(String var1);

    protected void writeFieldPrefix() {
    }

    protected abstract void writeFieldType(int var1);

    protected abstract void writeNull(int var1);

    protected abstract void writeChar(String var1, int var2);

    protected abstract void writeSmallint(Number var1);

    protected abstract void writeInteger(Number var1);

    protected abstract void writeBigint(Number var1);

    protected abstract void writeReal(Double var1, int var2);

    protected abstract void writeDecimal(BigDecimal var1);

    protected abstract void writeBit(Boolean var1);

    protected abstract void writeDate(Date var1);

    protected abstract void writeTime(Time var1);

    protected abstract void writeTimestamp(Timestamp var1);

    protected abstract void writeOther(JavaObject var1);

    protected abstract void writeBinary(Binary var1, int var2);

    public void writeRow(Object[] data, Table t) {
        this.writeSize(0);
        this.writeData(data, t);
        this.writeIntData(this.size(), 0);
    }

    public void writeData(Object[] data, Table t) {
        int[] types = t.getColumnTypes();
        int l = t.getColumnCount();
        this.writeData(l, types, data, null, null);
    }

    public void writeData(int l, int[] types, Object[] data, HashMappedList cols, int[] primaryKeys) {
        boolean hasPK = primaryKeys != null && primaryKeys.length != 0;
        int limit = hasPK ? primaryKeys.length : l;
        block14: for (int i = 0; i < limit; ++i) {
            int j = hasPK ? primaryKeys[i] : i;
            Object o = data[j];
            int t = types[j];
            if (cols != null) {
                Column col = (Column)cols.get(j);
                this.writeFieldPrefix();
                this.writeString(col.columnName.statementName);
            }
            if (o == null) {
                this.writeNull(t);
                continue;
            }
            this.writeFieldType(t);
            switch (t) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 100: {
                    this.writeChar((String)o, t);
                    continue block14;
                }
                case -6: 
                case 5: {
                    this.writeSmallint((Number)o);
                    continue block14;
                }
                case 4: {
                    this.writeInteger((Number)o);
                    continue block14;
                }
                case -5: {
                    this.writeBigint((Number)o);
                    continue block14;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.writeReal((Double)o, t);
                    continue block14;
                }
                case 2: 
                case 3: {
                    this.writeDecimal((BigDecimal)o);
                    continue block14;
                }
                case 16: {
                    this.writeBit((Boolean)o);
                    continue block14;
                }
                case 91: {
                    this.writeDate((Date)o);
                    continue block14;
                }
                case 92: {
                    this.writeTime((Time)o);
                    continue block14;
                }
                case 93: {
                    this.writeTimestamp((Timestamp)o);
                    continue block14;
                }
                case 1111: {
                    this.writeOther((JavaObject)o);
                    continue block14;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.writeBinary((Binary)o, t);
                    continue block14;
                }
                default: {
                    throw Trace.runtimeError(20, Types.getTypeString(t));
                }
            }
        }
    }

    public HsqlByteArrayOutputStream getOutputStream() {
        return this;
    }
}

