/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buf;
    protected int count;

    public HsqlByteArrayOutputStream() {
        this(128);
    }

    public HsqlByteArrayOutputStream(int size) {
        if (size < 128) {
            size = 128;
        }
        this.buf = new byte[size];
    }

    public HsqlByteArrayOutputStream(byte[] buffer) {
        this.buf = buffer;
    }

    public final void writeShort(int v) {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    public final void writeInt(int v) {
        if (this.count + 4 > this.buf.length) {
            this.ensureRoom(4);
        }
        this.buf[this.count++] = (byte)(v >>> 24);
        this.buf[this.count++] = (byte)(v >>> 16);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    public final void writeLong(long v) {
        this.writeInt((int)(v >>> 32));
        this.writeInt((int)v);
    }

    public final void writeBytes(String s) {
        int len = s.length();
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buf[this.count++] = (byte)s.charAt(i);
        }
    }

    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean v) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)v;
    }

    public void writeChar(int v) throws IOException {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.ensureRoom(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buf[this.count++] = (byte)(v >>> 8);
            this.buf[this.count++] = (byte)v;
        }
    }

    public void writeUTF(String str) throws IOException {
        int len = str.length();
        if (len > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(len * 3 + 2);
        int initpos = this.count;
        this.count += 2;
        StringConverter.writeUTF(str, this);
        int bytecount = this.count - initpos - 2;
        if (bytecount > 65535) {
            this.count = initpos;
            throw new UTFDataFormatException();
        }
        this.buf[initpos++] = (byte)(bytecount >>> 8);
        this.buf[initpos] = (byte)bytecount;
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void write(int b) {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        this.ensureRoom(len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    public void close() throws IOException {
    }

    public void fill(int b, int len) {
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buf[this.count++] = (byte)b;
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    protected void ensureRoom(int extra) {
        int newcount = this.count + extra;
        int newsize = this.buf.length;
        if (newcount > newsize) {
            while (newcount > newsize) {
                newsize *= 2;
            }
            byte[] newbuf = new byte[newsize];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }

    protected void reset(int newSize) {
        this.count = 0;
        if (newSize > this.buf.length) {
            this.buf = new byte[newSize];
        }
    }
}

