/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class HashMap
extends BaseHashMap {
    Set keySet;
    Collection values;

    public HashMap() {
        this(16, 0.75f);
    }

    public HashMap(int initialCapacity) throws IllegalArgumentException {
        this(initialCapacity, 0.75f);
    }

    public HashMap(int initialCapacity, float loadFactor) throws IllegalArgumentException {
        super(initialCapacity, loadFactor, 3, 3, false);
    }

    public Object get(Object key) {
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            return this.objectValueTable[lookup];
        }
        return null;
    }

    public Object put(Object key, Object value) {
        return super.addOrRemove(0L, 0L, key, value, false);
    }

    public Object remove(Object key) {
        return super.removeObject(key);
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public void putAll(HashMap t) {
        Iterator it = t.keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        public Iterator iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return new BaseHashMap.BaseHashIterator(hashMap, false);
        }

        public int size() {
            return HashMap.this.size();
        }

        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        public boolean add(Object value) {
            throw new RuntimeException();
        }

        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear() {
            HashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        public Iterator iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return new BaseHashMap.BaseHashIterator(hashMap, true);
        }

        public int size() {
            return HashMap.this.size();
        }

        public boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        public Object get(Object key) {
            int lookup = HashMap.this.getLookup(key, key.hashCode());
            if (lookup < 0) {
                return null;
            }
            return HashMap.this.objectKeyTable[lookup];
        }

        public boolean add(Object value) {
            throw new RuntimeException();
        }

        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        public boolean remove(Object o) {
            int oldSize = this.size();
            HashMap.this.remove(o);
            return this.size() != oldSize;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear() {
            HashMap.this.clear();
        }
    }
}

