/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil;
    public static final boolean fsIsIgnoreCase;
    public static final boolean fsNormalizesPosixSeparator;
    static final Random random;

    FileUtil() {
    }

    public static FileUtil getDefaultInstance() {
        if (fileUtil == null) {
            fileUtil = new FileUtil();
        }
        return fileUtil;
    }

    public boolean isStreamElement(String elementName) {
        return new File(elementName).exists();
    }

    public InputStream openInputStreamElement(String streamName) throws IOException {
        try {
            return new FileInputStream(new File(streamName));
        }
        catch (Throwable e) {
            throw FileUtil.toIOException(e);
        }
    }

    public void createParentDirs(String filename) {
        FileUtil.makeParentDirectories(new File(filename));
    }

    public void removeElement(String filename) {
        if (this.isStreamElement(filename)) {
            FileUtil.delete(filename);
        }
    }

    public void renameElement(String oldName, String newName) {
        FileUtil.renameOverwrite(oldName, newName);
    }

    public OutputStream openOutputStreamElement(String streamName) throws IOException {
        return new FileOutputStream(new File(streamName));
    }

    public static void delete(String filename) {
        new File(filename).delete();
    }

    public static void deleteOnExit(File f) {
        JavaSystem.deleteOnExit(f);
    }

    public static boolean exists(String filename) {
        return new File(filename).exists();
    }

    public static boolean exists(String fileName, boolean resource, Class cla) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return resource ? null != cla.getResource(fileName) : FileUtil.exists(fileName);
    }

    public static void renameOverwrite(String oldname, String newname) {
        FileUtil.delete(newname);
        if (FileUtil.exists(oldname)) {
            File file = new File(oldname);
            file.renameTo(new File(newname));
        }
    }

    public static IOException toIOException(Throwable e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e.toString());
    }

    public static String absolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    public static File canonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public static File canonicalFile(String path) throws IOException {
        return new File(new File(path).getCanonicalPath());
    }

    public static String canonicalPath(File f) throws IOException {
        return f.getCanonicalPath();
    }

    public static String canonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    public static String canonicalOrAbsolutePath(String path) {
        try {
            return FileUtil.canonicalPath(path);
        }
        catch (Exception e) {
            return FileUtil.absolutePath(path);
        }
    }

    public static void makeParentDirectories(File f) {
        String parent = f.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        } else {
            parent = f.getPath();
            int index = parent.lastIndexOf(47);
            if (index > 0) {
                parent = parent.substring(0, index);
                new File(parent).mkdirs();
            }
        }
    }

    public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
        return new FileSync((FileOutputStream)os);
    }

    static {
        fsIsIgnoreCase = new File("A").equals(new File("a"));
        fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
        random = new Random(System.currentTimeMillis());
    }

    public class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream os) throws IOException {
            this.outDescriptor = os.getFD();
        }

        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

