/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.WebServer;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

class WebServerConnection
implements Runnable {
    static final String ENCODING = "8859_1";
    private Socket socket;
    private WebServer server;
    private static final int REQUEST_TYPE_BAD = 0;
    private static final int REQUEST_TYPE_GET = 1;
    private static final int REQUEST_TYPE_HEAD = 2;
    private static final int REQUEST_TYPE_POST = 3;
    private static final String HEADER_OK = "HTTP/1.0 200 OK";
    private static final String HEADER_BAD_REQUEST = "HTTP/1.0 400 Bad Request";
    private static final String HEADER_NOT_FOUND = "HTTP/1.0 404 Not Found";
    private static final String HEADER_FORBIDDEN = "HTTP/1.0 403 Forbidden";
    static final int BUFFER_SIZE = 256;
    private RowOutputBinary rowOut = new RowOutputBinary(256);
    private RowInputBinary rowIn = new RowInputBinary(this.rowOut);
    static final byte[] BYTES_GET = "GET".getBytes();
    static final byte[] BYTES_HEAD = "HEAD".getBytes();
    static final byte[] BYTES_POST = "POST".getBytes();
    static final byte[] BYTES_CONTENT = "Content-Length: ".getBytes();
    static final byte[] BYTES_WHITESPACE = new byte[]{32, 9};
    private static final int hnd_content_types = BundleHandler.getBundleHandle("content-types", null);

    WebServerConnection(Socket socket, WebServer server) {
        this.server = server;
        this.socket = socket;
    }

    private String getMimeTypeString(String name) {
        if (name == null) {
            return "text/html";
        }
        int pos = name.lastIndexOf(46);
        String key = null;
        String mimeType = null;
        if (pos >= 0) {
            key = name.substring(pos).toLowerCase();
            mimeType = this.server.serverProperties.getProperty(key);
        }
        if (mimeType == null && key.length() > 1) {
            mimeType = BundleHandler.getString(hnd_content_types, key.substring(1));
        }
        return mimeType == null ? "text/html" : mimeType;
    }

    public void run() {
        try {
            int offset;
            int count;
            DataInputStream inStream = new DataInputStream(this.socket.getInputStream());
            String name = null;
            int method = 0;
            int len = -1;
            do {
                if ((count = InOutUtil.readLine(inStream, this.rowOut)) != 0) continue;
                throw new Exception();
            } while (count < 2);
            byte[] byteArray = this.rowOut.getBuffer();
            if (ArrayUtil.containsAt(byteArray, offset = this.rowOut.size() - count, BYTES_POST)) {
                method = 3;
                offset += BYTES_POST.length;
            } else if (ArrayUtil.containsAt(byteArray, offset, BYTES_GET)) {
                method = 1;
                offset += BYTES_GET.length;
            } else if (ArrayUtil.containsAt(byteArray, offset, BYTES_HEAD)) {
                method = 2;
                offset += BYTES_HEAD.length;
            } else {
                throw new Exception();
            }
            count = ArrayUtil.countStartElementsAt(byteArray, offset, BYTES_WHITESPACE);
            if (count == 0) {
                throw new Exception();
            }
            offset += count;
            count = ArrayUtil.countNonStartElementsAt(byteArray, offset, BYTES_WHITESPACE);
            name = new String(byteArray, offset, count, ENCODING);
            switch (method) {
                case 0: {
                    this.processError(0);
                    break;
                }
                case 1: {
                    this.processGet(name, true);
                    break;
                }
                case 2: {
                    this.processGet(name, false);
                    break;
                }
                case 3: {
                    this.processPost(inStream, name);
                }
            }
            inStream.close();
            this.socket.close();
        }
        catch (Exception e) {
            this.server.printStackTrace(e);
        }
    }

    private void processPost(InputStream inStream, String name) throws HsqlException, IOException {
        try {
            InOutUtil.readLine(inStream, this.rowOut);
            int count = InOutUtil.readLine(inStream, this.rowOut);
            int offset = this.rowOut.size() - count;
            byte[] byteArray = this.rowOut.getBuffer();
            if (!ArrayUtil.containsAt(byteArray, offset, BYTES_CONTENT)) {
                throw new Exception();
            }
            String lenStr = new String(byteArray, offset += BYTES_CONTENT.length, (count -= BYTES_CONTENT.length) - 2);
            int length = Integer.parseInt(lenStr);
            InOutUtil.readLine(inStream, this.rowOut);
        }
        catch (Exception e) {
            this.processError(400);
            return;
        }
        this.processQuery(inStream);
    }

    void processQuery(InputStream inStream) {
        try {
            Result resultOut;
            Session session;
            Result resultIn = Result.read(this.rowIn, new DataInputStream(inStream));
            if (resultIn.mode == 65543) {
                try {
                    int dbID = this.server.getDBID(resultIn.subSubString);
                    session = DatabaseManager.newSession(dbID, resultIn.getMainString(), resultIn.getSubString());
                    resultOut = new Result(1);
                    resultOut.databaseID = dbID;
                    resultOut.sessionID = session.getId();
                }
                catch (HsqlException e) {
                    resultOut = new Result(e, null);
                }
                catch (RuntimeException e) {
                    resultOut = new Result(e, null);
                }
            } else {
                int dbID = resultIn.databaseID;
                session = DatabaseManager.getSession(dbID, resultIn.sessionID);
                resultOut = session == null ? new Result(Trace.error(94), null) : session.execute(resultIn);
            }
            this.rowOut.reset();
            resultOut.write(this.rowOut);
            OutputStream outStream = this.socket.getOutputStream();
            String header = this.getHead(HEADER_OK, false, "application/octet-stream", this.rowOut.size());
            outStream.write(header.getBytes(ENCODING));
            outStream.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            this.server.printStackTrace(e);
        }
    }

    private void processGet(String name, boolean send) {
        try {
            String hdr;
            if (name.endsWith("/")) {
                name = name + this.server.getDefaultWebPage();
            }
            if (name.indexOf("..") != -1) {
                this.processError(403);
                return;
            }
            name = this.server.getWebRoot() + name;
            if (File.separatorChar != '/') {
                name = name.replace('/', File.separatorChar);
            }
            InputStream is = null;
            this.server.printWithThread("GET " + name);
            try {
                File file = new File(name);
                is = new DataInputStream(new FileInputStream(file));
                hdr = this.getHead(HEADER_OK, true, this.getMimeTypeString(name), (int)file.length());
            }
            catch (IOException e) {
                this.processError(404);
                if (is != null) {
                    is.close();
                }
                return;
            }
            BufferedOutputStream os = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)os).write(hdr.getBytes(ENCODING));
            if (send) {
                int b;
                while ((b = is.read()) != -1) {
                    ((OutputStream)os).write(b);
                }
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception e) {
            this.server.printError("processGet: " + e.toString());
            this.server.printStackTrace(e);
        }
    }

    String getHead(String responseCodeString, boolean addInfo, String mimeType, int length) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(responseCodeString).append("\r\n");
        if (addInfo) {
            sb.append("Allow: GET, HEAD, POST\nMIME-Version: 1.0\r\n");
            sb.append("Server: ").append("HSQL Database Engine").append("\r\n");
        }
        if (mimeType != null) {
            sb.append("Content-Type: ").append(mimeType).append("\r\n");
            sb.append("Content-Length: ").append(length).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private void processError(int code) {
        String msg;
        this.server.printWithThread("processError " + code);
        switch (code) {
            case 400: {
                msg = this.getHead(HEADER_BAD_REQUEST, false, null, 0);
                msg = msg + BundleHandler.getString(WebServer.webBundleHandle, "BAD_REQUEST");
                break;
            }
            case 403: {
                msg = this.getHead(HEADER_FORBIDDEN, false, null, 0);
                msg = msg + BundleHandler.getString(WebServer.webBundleHandle, "FORBIDDEN");
                break;
            }
            default: {
                msg = this.getHead(HEADER_NOT_FOUND, false, null, 0);
                msg = msg + BundleHandler.getString(WebServer.webBundleHandle, "NOT_FOUND");
            }
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)os).write(msg.getBytes(ENCODING));
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            this.server.printError("processError: " + e.toString());
            this.server.printStackTrace(e);
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB HTTP Connection @" + Integer.toString(this.hashCode(), 16);
    }
}

