/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class View
extends Table {
    Select viewSelect;
    SubQuery viewSubQuery;
    private String statement;
    private HsqlNameManager.HsqlName[] colList;
    HsqlNameManager.HsqlName compileTimeSchema;
    SubQuery[] viewSubqueries;

    View(Session session, Database db, HsqlNameManager.HsqlName name, String definition, HsqlNameManager.HsqlName[] columns) throws HsqlException {
        super(db, name, 7);
        this.isReadOnly = true;
        this.colList = columns;
        this.statement = View.trimStatement(definition);
        this.compileTimeSchema = session.getSchemaHsqlName(null);
        this.compile(session);
        HsqlNameManager.HsqlName[] schemas = this.getSchemas();
        for (int i = 0; i < schemas.length; ++i) {
            if (db.schemaManager.isSystemSchema(schemas[i]) || schemas[i].equals(name.schema)) continue;
            throw Trace.error(227);
        }
    }

    static String trimStatement(String s) throws HsqlException {
        int position;
        String str;
        Tokenizer tokenizer = new Tokenizer(s);
        do {
            position = tokenizer.getPosition();
        } while ((str = tokenizer.getString()).length() != 0 || tokenizer.wasValue());
        return s.substring(0, position).trim();
    }

    void compile(Session session) throws HsqlException {
        Parser p = new Parser(session, this.database, new Tokenizer(this.statement));
        int brackets = p.parseOpenBracketsSelect();
        this.viewSubQuery = p.parseSubquery(brackets, this.colList, true, 115);
        p.setAsView(this);
        this.viewSubqueries = p.getSortedSubqueries();
        this.viewSelect = this.viewSubQuery.select;
        this.viewSelect.prepareResult(session);
        Result.ResultMetaData metadata = this.viewSelect.resultMetaData;
        int columns = this.viewSelect.iResultLen;
        if (this.columnCount == 0) {
            super.addColumns(metadata, columns);
        }
    }

    String getStatement() {
        return this.statement;
    }

    void setDataReadOnly(boolean value) throws HsqlException {
        throw Trace.error(55);
    }

    HsqlNameManager.HsqlName[] getSchemas() {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            Select select = this.viewSubqueries[i].select;
            while (select != null) {
                TableFilter[] tfilter = select.tFilter;
                for (int j = 0; j < tfilter.length; ++j) {
                    list.add(tfilter[j].filterTable.tableName.schema);
                }
                select = select.unionSelect;
            }
        }
        return (HsqlNameManager.HsqlName[])list.toArray(new HsqlNameManager.HsqlName[list.size()]);
    }

    boolean hasView(View view) {
        if (view == this) {
            return false;
        }
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            if (this.viewSubqueries[i].view != view) continue;
            return true;
        }
        return false;
    }

    boolean hasTable(Table table) {
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            Select select = this.viewSubqueries[i].select;
            while (select != null) {
                TableFilter[] tfilter = select.tFilter;
                for (int j = 0; j < tfilter.length; ++j) {
                    if (!table.equals(tfilter[j].filterTable.tableName)) continue;
                    return true;
                }
                select = select.unionSelect;
            }
        }
        return false;
    }

    boolean hasColumn(Table table, String colname) {
        if (this.hasTable(table)) {
            Expression.Collector coll = new Expression.Collector();
            coll.addAll(this.viewSubqueries[this.viewSubqueries.length - 1].select, 2);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                if (!colname.equals(e.getBaseColumnName()) || !table.equals(e.getTableHsqlName())) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasSequence(NumberSequence sequence) {
        Expression.Collector coll = new Expression.Collector();
        coll.addAll(this.viewSubqueries[this.viewSubqueries.length - 1].select, 71);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            if (e.valueData != sequence) continue;
            return true;
        }
        return false;
    }
}

