/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.View;
import org.hsqldb.lib.ObjectComparator;

class SubQuery
implements ObjectComparator {
    int level;
    boolean hasParams;
    boolean isResolved;
    boolean isExistsPredicate;
    boolean uniqueRows;
    Select select;
    Table table;
    View view;
    boolean isMaterialised;

    SubQuery() {
    }

    void populateTable(Session session) throws HsqlException {
        Result r = this.select.getResult(session, this.isExistsPredicate ? 1 : 0);
        if (this.uniqueRows) {
            r.removeDuplicates(session, this.select.iResultLen);
        }
        this.table.insertResult(session, r);
    }

    public int compare(Object a, Object b) {
        SubQuery sqa = (SubQuery)a;
        SubQuery sqb = (SubQuery)b;
        if (sqa.view == null && sqb.view == null) {
            return sqb.level - sqa.level;
        }
        if (sqa.view != null && sqb.view != null) {
            int diff;
            Database db = sqa.view.database;
            int ia = db.schemaManager.getTableIndex(sqa.view);
            int ib = db.schemaManager.getTableIndex(sqb.view);
            if (ia == -1) {
                ia = db.schemaManager.getTables(sqa.view.getSchemaName()).size();
            }
            if (ib == -1) {
                ib = db.schemaManager.getTables(sqb.view.getSchemaName()).size();
            }
            return (diff = ia - ib) == 0 ? sqb.level - sqa.level : diff;
        }
        return sqa.view == null ? 1 : -1;
    }
}

