/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.User;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

public class SessionManager {
    int sessionIdCount = 1;
    private IntKeyHashMap sessionMap = new IntKeyHashMap();
    private Session sysSession;

    public SessionManager(Database db) {
        User sysUser = db.getUserManager().getSysUser();
        this.sysSession = new Session(db, sysUser, false, false, 0);
    }

    public synchronized Session newSession(Database db, User user, boolean readonly, boolean forlog) {
        Session s = new Session(db, user, true, readonly, this.sessionIdCount);
        s.isProcessingLog = forlog;
        this.sessionMap.put(this.sessionIdCount, s);
        ++this.sessionIdCount;
        return s;
    }

    public Session getSysSession(String schema, boolean forScript) throws HsqlException {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getSchemaHsqlName(schema);
        this.sysSession.isProcessingScript = forScript;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.defaultSchemaHsqlName;
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public Session getSysSession(String schema, User user) throws HsqlException {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getSchemaHsqlName(schema);
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(user);
        return this.sysSession;
    }

    public synchronized void closeAllSessions() {
        Session[] sessions = this.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].close();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void clearAll() {
        this.sessionMap.clear();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(int id) {
        return (Session)this.sessionMap.get(id);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessions = new Session[this.sessionMap.size()];
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            sessions[i] = (Session)it.next();
            ++i;
        }
        return sessions;
    }

    public synchronized boolean isUserActive(String userName) {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            if (userName.equals(session.getUser().getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void removeSchemaReference(SchemaManager.Schema schema) {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            if (session.currentSchema == schema.name) {
                session.resetSchema();
            }
            ++i;
        }
    }
}

