/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.persist.Logger;

public class SequenceManager {
    HashMappedList sequenceMap = new HashMappedList();

    SequenceManager() {
    }

    void dropSequence(String name) throws HsqlException {
        boolean found = this.sequenceMap.containsKey(name);
        Trace.check(found, 191, name);
        this.sequenceMap.remove(name);
    }

    public NumberSequence getSequence(String name) {
        return (NumberSequence)this.sequenceMap.get(name);
    }

    NumberSequence createSequence(HsqlNameManager.HsqlName hsqlname, long start, long increment, int type) throws HsqlException {
        Trace.check(!this.sequenceMap.containsKey(hsqlname.name), 192);
        NumberSequence sequence = new NumberSequence(hsqlname, start, increment, type);
        this.sequenceMap.put(hsqlname.name, sequence);
        return sequence;
    }

    String logSequences(Session c, Logger logger) throws HsqlException {
        for (int i = 0; i < this.sequenceMap.size(); ++i) {
            NumberSequence seq = (NumberSequence)this.sequenceMap.get(i);
            if (!seq.wasUsed()) continue;
            logger.writeSequenceStatement(c, seq);
            seq.resetWasUsed();
        }
        return null;
    }
}

