/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingLen;
    int iOrderLen;
    int[] sortOrder;
    int[] sortDirection;
    boolean sortUnion;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType;
    Select[] unionArray;
    int unionMaxDepth;
    Select unionSelect;
    int unionType;
    int unionDepth;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private boolean simpleLimit;
    Result.ResultMetaData resultMetaData;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap aliasMap = new HashMap();
        for (int i = 0; i < this.iResultLen; ++i) {
            String alias = this.exprColumns[i].getAlias();
            if (alias == null) continue;
            aliasMap.put(alias, this.exprColumns[i]);
        }
        return aliasMap;
    }

    void resolve(Session session) throws HsqlException {
        this.resolveTables();
        this.resolveTypes(session);
        this.setFilterConditions(session);
    }

    private void resolveTables() throws HsqlException {
        for (int i = this.iResultLen; i < this.exprColumns.length; ++i) {
            if (this.exprColumns[i].getType() == 2) {
                if (this.exprColumns[i].joinedTableColumnIndex != -1) continue;
                boolean descending = this.exprColumns[i].isDescending();
                this.exprColumns[i] = this.exprColumns[i].getExpressionForAlias(this.exprColumns, this.iResultLen);
                if (!descending) continue;
                this.exprColumns[i].setDescending();
                continue;
            }
            this.exprColumns[i].replaceAliases(this.exprColumns, this.iResultLen);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceAliases(this.exprColumns, this.iResultLen);
        }
        int len = this.tFilter.length;
        for (int i = 0; i < len; ++i) {
            this.resolveTables(this.tFilter[i]);
        }
    }

    void resolveUnionColumnTypes() throws HsqlException {
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            for (int i = 0; i < this.iResultLen; ++i) {
                Expression e = this.exprColumns[i];
                if (e.isTypeEqual(this.unionSelect.exprColumns[i])) continue;
                this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], e.getDataType(), e.getColumnSize(), e.getColumnScale());
            }
        }
    }

    void resolveTypes(Session session) throws HsqlException {
        int len = this.exprColumns.length;
        for (int i = 0; i < len; ++i) {
            this.exprColumns[i].resolveTypes(session);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session);
        }
    }

    void resolveTablesUnion(TableFilter f) throws HsqlException {
        if (this.unionArray == null) {
            this.resolveTables(f);
        } else {
            for (int i = 0; i < this.unionArray.length; ++i) {
                this.unionArray[i].resolveTables(f);
            }
        }
    }

    void resolveTables(TableFilter f) throws HsqlException {
        int len = this.exprColumns.length;
        for (int i = 0; i < len; ++i) {
            this.exprColumns[i].resolveTables(f);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(f);
        }
    }

    private void setFilterConditions(Session session) throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        for (int i = 0; i < this.tFilter.length; ++i) {
            this.tFilter[i].setConditions(session, this.queryCondition);
        }
    }

    boolean checkResolved(boolean check) throws HsqlException {
        int i;
        boolean result = true;
        int len = this.exprColumns.length;
        for (i = 0; i < len; ++i) {
            result = result && this.exprColumns[i].checkResolved(check);
        }
        if (this.queryCondition != null) {
            boolean bl = result = result && this.queryCondition.checkResolved(check);
        }
        if (this.havingCondition != null) {
            result = result && this.havingCondition.checkResolved(check);
        }
        for (i = 0; i < this.tFilter.length; ++i) {
            if (this.tFilter[i].filterIndex != null) continue;
            this.tFilter[i].filterIndex = this.tFilter[i].filterTable.getPrimaryIndex();
        }
        return result;
    }

    Object getValue(Session session, int type) throws HsqlException {
        this.resolve(session);
        Result r = this.getResult(session, 2);
        int size = r.getSize();
        int len = r.getColumnCount();
        if (len == 1) {
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                Object o = r.rRoot.data[0];
                return r.metaData.colTypes[0] == type ? o : Column.convertObject(o, type);
            }
            throw Trace.error(17);
        }
        HsqlException e = Trace.error(17);
        throw new HsqlInternalException(e);
    }

    void prepareResult(Session session) throws HsqlException {
        this.resolveAll(session, true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            for (int i = this.iResultLen; i < this.iResultLen + this.iGroupLen; ++i) {
                this.exprColumns[i].collectAllColumnNames(this.groupColumnNames);
            }
        }
        int len = this.exprColumns.length;
        Result.ResultMetaData rmd = this.resultMetaData = new Result.ResultMetaData(len);
        int groupByStart = this.iResultLen;
        int groupByEnd = groupByStart + this.iGroupLen;
        int orderByStart = groupByEnd + this.iHavingLen;
        int orderByEnd = orderByStart + this.iOrderLen;
        for (int i = 0; i < len; ++i) {
            Expression e = this.exprColumns[i];
            rmd.colTypes[i] = e.getDataType();
            rmd.colSizes[i] = e.getColumnSize();
            rmd.colScales[i] = e.getColumnScale();
            if (e.isAggregate()) {
                this.isAggregated = true;
            }
            if (i >= groupByStart && i < groupByEnd && !this.exprColumns[i].canBeInGroupBy()) {
                Trace.error(68, this.exprColumns[i]);
            }
            if (i >= groupByEnd && i < groupByEnd + this.iHavingLen && !this.exprColumns[i].isConditional()) {
                Trace.error(69, this.exprColumns[i]);
            }
            if (i >= orderByStart && i < orderByEnd && !this.exprColumns[i].canBeInOrderBy()) {
                Trace.error(70, this.exprColumns[i]);
            }
            if (i >= this.iResultLen) continue;
            rmd.colLabels[i] = e.getAlias();
            rmd.isLabelQuoted[i] = e.isAliasQuoted();
            rmd.schemaNames[i] = e.getTableSchemaName();
            rmd.tableNames[i] = e.getTableName();
            rmd.colNames[i] = e.getColumnName();
            if (rmd.isTableColumn(i)) {
                rmd.colNullable[i] = e.nullability;
                rmd.isIdentity[i] = e.isIdentity;
                rmd.isWritable[i] = e.isWritable;
            }
            rmd.classNames[i] = e.getValueClassName();
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        this.checkAggregateOrGroupByColumns(groupByEnd, orderByStart);
        this.checkAggregateOrGroupByOrderColumns(orderByStart, orderByEnd);
        this.prepareSort();
        this.simpleLimit = !this.isDistinctSelect && !this.isGrouped && this.unionSelect == null && this.iOrderLen == 0;
    }

    void prepareUnions() throws HsqlException {
        int count = 0;
        Select current = this;
        while (current != null) {
            current = current.unionSelect;
            ++count;
        }
        if (count == 1) {
            if (this.unionDepth != 0) {
                throw Trace.error(121);
            }
            return;
        }
        this.unionArray = new Select[count];
        count = 0;
        current = this;
        while (current != null) {
            this.unionArray[count] = current;
            this.unionMaxDepth = current.unionDepth > this.unionMaxDepth ? current.unionDepth : this.unionMaxDepth;
            current = current.unionSelect;
            ++count;
        }
        if (this.unionArray[this.unionArray.length - 1].unionDepth != 0) {
            throw Trace.error(121);
        }
    }

    Result getResult(Session session, int maxrows) throws HsqlException {
        Result r;
        if (this.unionArray == null) {
            r = this.getSingleResult(session, maxrows);
        } else {
            r = this.getResultMain(session);
            if (this.sortUnion) {
                this.sortResult(session, r);
                r.trimResult(this.getLimitStart(session), this.getLimitCount(session, maxrows));
            }
        }
        r.setColumnCount(this.iResultLen);
        return r;
    }

    private Result getResultMain(Session session) throws HsqlException {
        Result[] unionResults = new Result[this.unionArray.length];
        for (int i = 0; i < this.unionArray.length; ++i) {
            unionResults[i] = this.unionArray[i].getSingleResult(session, Integer.MAX_VALUE);
        }
        for (int depth = this.unionMaxDepth; depth >= 0; --depth) {
            block2: for (int pass = 0; pass < 2; ++pass) {
                for (int i = 0; i < this.unionArray.length - 1; ++i) {
                    int nextIndex;
                    if (unionResults[i] == null || this.unionArray[i].unionDepth < depth || pass == 0 && this.unionArray[i].unionType != 3 || pass == 1 && this.unionArray[i].unionType == 3) continue;
                    for (nextIndex = i + 1; nextIndex < this.unionArray.length && unionResults[nextIndex] == null; ++nextIndex) {
                    }
                    if (nextIndex == this.unionArray.length) continue block2;
                    this.unionArray[i].mergeResults(session, unionResults[i], unionResults[nextIndex]);
                    unionResults[nextIndex] = unionResults[i];
                    unionResults[i] = null;
                }
            }
        }
        return unionResults[unionResults.length - 1];
    }

    private void mergeResults(Session session, Result first, Result second) throws HsqlException {
        switch (this.unionType) {
            case 1: {
                first.append(second);
                first.removeDuplicates(session, this.iResultLen);
                break;
            }
            case 2: {
                first.append(second);
                break;
            }
            case 3: {
                first.removeDifferent(session, second, this.iResultLen);
                break;
            }
            case 4: {
                first.removeSecond(session, second, this.iResultLen);
            }
        }
    }

    int getLimitStart(Session session) throws HsqlException {
        Integer limit;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getArg().getValue(session)) != null) {
            return limit;
        }
        return 0;
    }

    int getLimitCount(Session session, int rowCount) throws HsqlException {
        Integer limit;
        int limitCount = 0;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getArg2().getValue(session)) != null) {
            limitCount = limit;
        }
        if (rowCount != 0 && (limitCount == 0 || rowCount < limitCount)) {
            limitCount = rowCount;
        }
        return limitCount;
    }

    int getMaxRowCount(Session session, int rowCount) throws HsqlException {
        int limitStart = this.getLimitStart(session);
        int limitCount = this.getLimitCount(session, rowCount);
        if (!this.simpleLimit) {
            rowCount = Integer.MAX_VALUE;
        } else {
            if (rowCount == 0) {
                rowCount = limitCount;
            }
            rowCount = rowCount == 0 || rowCount > Integer.MAX_VALUE - limitStart ? Integer.MAX_VALUE : (rowCount += limitStart);
        }
        return rowCount;
    }

    private Result getSingleResult(Session session, int rowCount) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult(session);
        }
        Result r = this.buildResult(session, this.getMaxRowCount(session, rowCount));
        if (this.isDistinctSelect) {
            r.removeDuplicates(session, this.iResultLen);
        }
        if (!this.sortUnion) {
            this.sortResult(session, r);
            r.trimResult(this.getLimitStart(session), this.getLimitCount(session, rowCount));
        }
        return r;
    }

    private void prepareSort() {
        int startCol;
        if (this.iOrderLen == 0) {
            return;
        }
        this.sortOrder = new int[this.iOrderLen];
        this.sortDirection = new int[this.iOrderLen];
        int i = startCol = this.iResultLen + this.iGroupLen + this.iHavingLen;
        for (int j = 0; j < this.iOrderLen; ++j) {
            int colindex = i;
            if (this.exprColumns[i].joinedTableColumnIndex != -1) {
                colindex = this.exprColumns[i].joinedTableColumnIndex;
            }
            this.sortOrder[j] = colindex;
            this.sortDirection[j] = this.exprColumns[i].isDescending() ? -1 : 1;
            ++i;
        }
    }

    private void sortResult(Session session, Result r) throws HsqlException {
        if (this.iOrderLen == 0) {
            return;
        }
        r.sortResult(session, this.sortOrder, this.sortDirection);
    }

    private void checkAggregateOrGroupByColumns(int start, int end) throws HsqlException {
        if (start < end) {
            int i;
            HsqlArrayList colExps = new HsqlArrayList();
            for (i = start; i < end; ++i) {
                this.exprColumns[i].collectInGroupByExpressions(colExps);
            }
            int size = colExps.size();
            for (i = 0; i < size; ++i) {
                Expression exp = (Expression)colExps.get(i);
                if (this.inAggregateOrGroupByClause(exp)) continue;
                throw Trace.error(67, exp);
            }
        }
    }

    private void checkAggregateOrGroupByOrderColumns(int start, int end) throws HsqlException {
        this.checkAggregateOrGroupByColumns(start, end);
        if (start < end && this.isDistinctSelect) {
            int i;
            HsqlArrayList colExps = new HsqlArrayList();
            for (i = start; i < end; ++i) {
                this.exprColumns[i].collectInGroupByExpressions(colExps);
            }
            int size = colExps.size();
            for (i = 0; i < size; ++i) {
                Expression exp = (Expression)colExps.get(i);
                if (this.isSimilarIn(exp, 0, this.iResultLen)) continue;
                throw Trace.error(71, exp);
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression exp) {
        if (this.isGrouped) {
            return this.isSimilarIn(exp, this.iResultLen, this.iResultLen + this.iGroupLen) || Select.allColumnsAreDefinedIn(exp, this.groupColumnNames);
        }
        if (this.isAggregated) {
            return exp.canBeInAggregate();
        }
        return true;
    }

    private boolean isSimilarIn(Expression exp, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!exp.similarTo(this.exprColumns[i])) continue;
            return true;
        }
        return false;
    }

    static boolean allColumnsAreDefinedIn(Expression exp, HashSet definedColumns) {
        HashSet colNames = new HashSet();
        exp.collectAllColumnNames(colNames);
        if (colNames.size() > 0 && definedColumns == null) {
            return false;
        }
        Iterator i = colNames.iterator();
        while (i.hasNext()) {
            if (definedColumns.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    private Result buildResult(Session session, int limitcount) throws HsqlException {
        boolean notempty;
        GroupedResult gResult = new GroupedResult(this, this.resultMetaData);
        int len = this.exprColumns.length;
        int filter = this.tFilter.length;
        boolean[] first = new boolean[filter];
        boolean[] outerused = new boolean[filter];
        int level = 0;
        boolean bl = notempty = this.queryCondition == null || !this.queryCondition.isFixedConditional() || this.queryCondition.testCondition(session);
        while (notempty && level >= 0) {
            boolean outerfound;
            boolean found;
            TableFilter t = this.tFilter[level];
            if (!first[level]) {
                found = t.findFirst(session);
                outerfound = t.isOuterJoin && !found && !outerused[level] && !t.nonJoinIsNull && t.nextOuter(session);
                outerused[level] = outerfound;
                first[level] = found;
            } else {
                found = t.next(session);
                outerfound = t.isOuterJoin && !found && !first[level] && !outerused[level] && !t.nonJoinIsNull && t.nextOuter(session);
                outerused[level] = outerfound;
                first[level] = found;
            }
            if (!found && !outerfound) {
                --level;
                continue;
            }
            if (level < filter - 1) {
                ++level;
                continue;
            }
            while (outerused[level]) {
                outerused[level--] = false;
            }
            if (this.queryCondition != null && !this.queryCondition.testCondition(session)) continue;
            try {
                int i;
                Object[] row = new Object[len];
                for (i = gResult.groupBegin; i < gResult.groupEnd; ++i) {
                    row[i] = this.exprColumns[i].getValue(session);
                }
                row = gResult.getRow(row);
                for (i = 0; i < gResult.groupBegin; ++i) {
                    row[i] = this.isAggregated && this.exprColumns[i].isAggregate() ? this.exprColumns[i].updateAggregatingValue(session, row[i]) : this.exprColumns[i].getValue(session);
                }
                for (i = gResult.groupEnd; i < len; ++i) {
                    row[i] = this.isAggregated && this.exprColumns[i].isAggregate() ? this.exprColumns[i].updateAggregatingValue(session, row[i]) : this.exprColumns[i].getValue(session);
                }
                gResult.addRow(row);
                if (gResult.size() < limitcount) continue;
                break;
            }
            catch (HsqlInternalException e) {
            }
        }
        if (this.isAggregated && !this.isGrouped && gResult.size() == 0) {
            Object[] row = new Object[len];
            for (int i = 0; i < len; ++i) {
                row[i] = this.exprColumns[i].isAggregate() ? null : this.exprColumns[i].getValue(session);
            }
            gResult.addRow(row);
        }
        Iterator it = gResult.iterator();
        while (it.hasNext()) {
            Object[] row = (Object[])it.next();
            if (this.isAggregated) {
                for (int i = 0; i < len; ++i) {
                    if (!this.exprColumns[i].isAggregate()) continue;
                    row[i] = this.exprColumns[i].getAggregatedValue(session, row[i]);
                }
            }
            if (this.iHavingLen <= 0 || Boolean.TRUE.equals(row[this.iResultLen + this.iGroupLen])) continue;
            it.remove();
        }
        return gResult.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        TableFilter filter;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(' ');
        for (i = 0; i < this.iResultLen; ++i) {
            sb.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen - 1) continue;
            sb.append(',');
        }
        sb.append("FROM");
        for (i = 0; i < this.tFilter.length; ++i) {
            filter = this.tFilter[i];
            if (i != 0 && filter.isOuterJoin) {
                sb.append("FROM").append(' ');
                sb.append("JOIN").append(' ');
            }
            sb.append(',');
        }
        sb.append(' ').append("WHERE").append(' ');
        for (i = 0; i < this.tFilter.length; ++i) {
            filter = this.tFilter[i];
        }
        sb.append(' ').append("GROUP").append(' ');
        for (i = this.iResultLen; i < this.iResultLen + this.iGroupLen; ++i) {
            sb.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen + this.iGroupLen - 1) continue;
            sb.append(',');
        }
        sb.append(' ').append("HAVING").append(' ');
        for (i = this.iResultLen + this.iGroupLen; i < this.iResultLen + this.iGroupLen + this.iHavingLen; ++i) {
            sb.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen + this.iGroupLen - 1) continue;
            sb.append(',');
        }
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    sb.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    sb.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    sb.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    sb.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        int groupByEnd = this.iResultLen + this.iGroupLen;
        int orderByStart = groupByEnd + this.iHavingLen;
        int orderByEnd = orderByStart + this.iOrderLen;
        sb.append(' ').append("ORDER").append("BY").append(' ');
        for (int i2 = orderByStart; i2 < orderByEnd; ++i2) {
            sb.append(this.exprColumns[i2].getDDL());
            if (i2 >= this.iResultLen + this.iGroupLen - 1) continue;
            sb.append(',');
        }
        return sb;
    }

    boolean resolveAll(Session session, boolean check) throws HsqlException {
        if (this.isResolved) {
            return true;
        }
        this.resolve(session);
        this.isResolved = this.checkResolved(check);
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            for (int i = 0; i < this.iResultLen; ++i) {
                Expression e = this.exprColumns[i];
                if (e.isTypeEqual(this.unionSelect.exprColumns[i])) continue;
                this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], e.getDataType(), e.getColumnSize(), e.getColumnScale());
            }
            this.isResolved &= this.unionSelect.resolveAll(session, check);
        }
        return this.isResolved;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String describe(Session session) {
        int i;
        try {
            this.getResult(session, 1);
        }
        catch (HsqlException e) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            sb.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            sb.append("offset=[").append(this.limitCondition.getArg().describe(session)).append("]\n");
            sb.append("limit=[").append(this.limitCondition.getArg2().describe(session)).append("]\n");
        }
        sb.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        sb.append("isGrouped=[").append(this.isGrouped).append("]\n");
        sb.append("isAggregated=[").append(this.isAggregated).append("]\n");
        sb.append("columns=[");
        int columns = this.exprColumns.length - this.iOrderLen;
        for (i = 0; i < columns; ++i) {
            sb.append(this.exprColumns[i].describe(session));
        }
        sb.append("\n]\n");
        sb.append("tableFilters=[\n");
        for (i = 0; i < this.tFilter.length; ++i) {
            sb.append("[\n");
            sb.append(this.tFilter[i].describe(session));
            sb.append("\n]");
        }
        sb.append("]\n");
        String temp = this.queryCondition == null ? "null" : this.queryCondition.describe(session);
        sb.append("eCondition=[").append(temp).append("]\n");
        temp = this.havingCondition == null ? "null" : this.havingCondition.describe(session);
        sb.append("havingCondition=[").append(temp).append("]\n");
        sb.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    sb.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    sb.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    sb.append(" UNION ");
                    break;
                }
                case 2: {
                    sb.append(" UNION ALL ");
                    break;
                }
                default: {
                    sb.append(" UNKNOWN SET OPERATION ");
                }
            }
            sb.append("[\n").append(this.unionSelect.describe(session)).append("]\n");
        }
        return sb.toString();
    }

    Result describeResult() {
        Result r = new Result(3, this.iResultLen);
        Result.ResultMetaData rmd = r.metaData;
        for (int i = 0; i < this.iResultLen; ++i) {
            Expression e = this.exprColumns[i];
            rmd.colTypes[i] = e.getDataType();
            rmd.colSizes[i] = e.getColumnSize();
            rmd.colScales[i] = e.getColumnScale();
            rmd.colLabels[i] = e.getAlias();
            rmd.isLabelQuoted[i] = e.isAliasQuoted();
            rmd.tableNames[i] = e.getTableName();
            rmd.colNames[i] = e.getColumnName();
            if (!rmd.isTableColumn(i)) continue;
            rmd.colNullable[i] = e.nullability;
            rmd.isIdentity[i] = e.isIdentity;
            rmd.isWritable[i] = e.isWritable;
        }
        return r;
    }
}

