/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.SchemaManager;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.ValuePool;

class Parser {
    private Database database;
    private Tokenizer tokenizer;
    private Session session;
    private String sSchema;
    private String sTable;
    private String sToken;
    private boolean wasQuoted;
    private Object oData;
    private int iType;
    private int iToken;
    private int subQueryLevel;
    private HsqlArrayList subQueryList = new HsqlArrayList();
    static HashMap simpleFunctions = new HashMap();
    private static IntValueHashMap tokenSet;
    HsqlArrayList parameters = new HsqlArrayList();
    private static final Expression[] noParameters;
    private static final SubQuery[] noSubqueries;

    Parser(Session session, Database db, Tokenizer t) {
        this.database = db;
        this.tokenizer = t;
        this.session = session;
    }

    void reset(String sql) {
        this.sTable = null;
        this.sToken = null;
        this.oData = null;
        this.tokenizer.reset(sql);
        this.subQueryList.clear();
        this.subQueryLevel = 0;
        this.parameters.clear();
    }

    void checkTableWriteAccess(Table table, int userRight) throws HsqlException {
        this.session.checkReadWrite();
        this.session.check(table.getName(), userRight);
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    static HsqlArrayList getColumnNames(Database db, Table table, Tokenizer t, boolean full) throws HsqlException {
        HsqlArrayList columns = new HsqlArrayList();
        while (true) {
            String token;
            if (full) {
                token = t.getSimpleName();
                boolean quoted = t.wasQuotedIdentifier();
                HsqlNameManager.HsqlName name = db.nameManager.newHsqlName(token, quoted);
                columns.add(name);
            } else {
                columns.add(t.getName());
                if (t.wasLongName() && !t.getLongNameFirst().equals(table.getName().name)) {
                    throw Trace.error(22, t.getLongNameFirst());
                }
            }
            if ((token = t.getSimpleToken()).equals(",")) continue;
            if (token.equals(")")) break;
            t.throwUnexpected();
        }
        return columns;
    }

    SubQuery parseSubquery(int brackets, HsqlNameManager.HsqlName[] colNames, boolean resolveAll, int predicateType) throws HsqlException {
        int i;
        SubQuery sq = new SubQuery();
        ++this.subQueryLevel;
        boolean canHaveOrder = predicateType == 115;
        boolean limitWithOrder = predicateType == 115 || predicateType == 3 || predicateType == 30 || predicateType == 32 || predicateType == 33 || predicateType == 103;
        Select s = this.parseSelect(brackets, canHaveOrder, false, limitWithOrder, true);
        sq.level = this.subQueryLevel--;
        boolean isResolved = s.resolveAll(this.session, resolveAll);
        sq.select = s;
        sq.isResolved = isResolved;
        HsqlNameManager.HsqlName sqtablename = this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false);
        SchemaManager cfr_ignored_0 = this.database.schemaManager;
        sqtablename.schema = SchemaManager.SYSTEM_SCHEMA_HSQLNAME;
        Table table = new Table(this.database, sqtablename, 1);
        if (colNames != null) {
            if (colNames.length != s.iResultLen) {
                throw Trace.error(5);
            }
            for (i = 0; i < s.iResultLen; ++i) {
                HsqlNameManager.HsqlName name = colNames[i];
                s.exprColumns[i].setAlias(name.name, name.isNameQuoted);
            }
        } else {
            for (i = 0; i < s.iResultLen; ++i) {
                String colname = s.exprColumns[i].getAlias();
                if (colname != null && colname.length() != 0) continue;
                colname = "COL_" + String.valueOf(i + 1);
                s.exprColumns[i].setAlias(colname, false);
            }
        }
        table.addColumns(s);
        boolean uniqueValues = predicateType == 31 || predicateType == 30 || predicateType == 32 || predicateType == 33;
        int[] pcol = null;
        if (uniqueValues) {
            pcol = new int[s.iResultLen];
            ArrayUtil.fillSequence(pcol);
        }
        table.createPrimaryKey(pcol);
        sq.table = table;
        sq.uniqueRows = uniqueValues;
        this.subQueryList.add(sq);
        return sq;
    }

    SubQuery getViewSubquery(View v) {
        SubQuery sq = v.viewSubQuery;
        for (int i = 0; i < v.viewSubqueries.length; ++i) {
            this.subQueryList.add(v.viewSubqueries[i]);
        }
        return sq;
    }

    Select parseSelect(int brackets, boolean canHaveOrder, boolean canHaveLimit, boolean limitWithOrder, boolean isMain) throws HsqlException {
        int unionType;
        boolean hasLimit;
        Select select = new Select();
        String token = this.tokenizer.getString();
        if ((canHaveLimit || limitWithOrder) && (this.tokenizer.wasThis("LIMIT") || this.tokenizer.wasThis("TOP"))) {
            this.parseLimit(token, select, false);
            token = this.tokenizer.getString();
        }
        if (this.tokenizer.wasThis("DISTINCT")) {
            select.isDistinctSelect = true;
        } else if (!this.tokenizer.wasThis("ALL")) {
            this.tokenizer.back();
        }
        HsqlArrayList vcolumn = new HsqlArrayList();
        do {
            Expression e = this.parseExpression();
            token = this.tokenizer.getString();
            if (this.tokenizer.wasThis("AS")) {
                e.setAlias(this.tokenizer.getSimpleName(), this.tokenizer.wasQuotedIdentifier());
                token = this.tokenizer.getString();
            } else if (this.tokenizer.wasSimpleName()) {
                e.setAlias(token, this.tokenizer.wasQuotedIdentifier());
                token = this.tokenizer.getString();
            }
            vcolumn.add(e);
        } while (this.tokenizer.wasThis(","));
        if (token.equals("INTO")) {
            boolean getname = true;
            token = this.tokenizer.getString();
            if (this.tokenizer.wasSimpleToken()) {
                switch (Token.get(token)) {
                    case 302: {
                        select.intoType = 4;
                        break;
                    }
                    case 327: {
                        select.intoType = 2;
                        break;
                    }
                    case 328: {
                        select.intoType = 6;
                        break;
                    }
                    case 310: {
                        select.intoType = 3;
                        break;
                    }
                    default: {
                        select.intoType = this.database.getDefaultTableType();
                        getname = false;
                    }
                }
                if (getname) {
                    token = this.tokenizer.getName();
                } else if (!this.tokenizer.wasName()) {
                    this.tokenizer.throwUnexpected();
                }
            }
            select.sIntoTable = this.database.nameManager.newHsqlName(token, this.tokenizer.wasQuotedIdentifier());
            select.sIntoTable.schema = this.session.getSchemaHsqlName(this.tokenizer.getLongNameFirst());
            token = this.tokenizer.getString();
        }
        this.tokenizer.matchThis("FROM");
        Expression condition = null;
        HsqlArrayList vfilter = new HsqlArrayList();
        vfilter.add(this.parseTableFilter(false));
        while (true) {
            TableFilter tf;
            token = this.tokenizer.getString();
            boolean cross = false;
            if (this.tokenizer.wasThis("INNER")) {
                this.tokenizer.getThis("JOIN");
                token = "JOIN";
            } else if (this.tokenizer.wasThis("CROSS")) {
                this.tokenizer.getThis("JOIN");
                token = "JOIN";
                cross = true;
            }
            if (token.equals("LEFT") && !this.tokenizer.wasQuotedIdentifier()) {
                this.tokenizer.isGetThis("OUTER");
                this.tokenizer.getThis("JOIN");
                tf = this.parseTableFilter(true);
                vfilter.add(tf);
                this.tokenizer.getThis("ON");
                Expression newcondition = this.parseExpression();
                newcondition.checkTables(vfilter);
                condition = Parser.addJoinCondition(condition, newcondition, tf, true);
                continue;
            }
            if (token.equals("RIGHT") && !this.tokenizer.wasQuotedIdentifier()) {
                this.tokenizer.isGetThis("OUTER");
                this.tokenizer.getThis("JOIN");
                tf = this.parseTableFilter(false);
                HsqlArrayList nvfilter = new HsqlArrayList();
                nvfilter.add(tf);
                nvfilter.addAll(vfilter);
                vfilter = nvfilter;
                ((TableFilter)vfilter.get((int)1)).isOuterJoin = true;
                this.tokenizer.getThis("ON");
                Expression newcondition = this.parseExpression();
                newcondition.checkTables(vfilter);
                condition = Parser.addJoinCondition(condition, newcondition, (TableFilter)vfilter.get(1), true);
                continue;
            }
            if (this.tokenizer.wasThis("JOIN")) {
                vfilter.add(this.parseTableFilter(false));
                if (cross) continue;
                this.tokenizer.getThis("ON");
                Expression newcondition = this.parseExpression();
                newcondition.checkTables(vfilter);
                condition = Parser.addJoinCondition(condition, newcondition, null, false);
                continue;
            }
            if (!this.tokenizer.wasThis(",")) break;
            vfilter.add(this.parseTableFilter(false));
        }
        this.tokenizer.back();
        this.resolveSelectTableFilter(select, vcolumn, vfilter);
        token = this.tokenizer.getString();
        if (this.tokenizer.wasThis("WHERE")) {
            Expression newcondition = this.parseExpression();
            condition = Parser.addCondition(condition, newcondition);
            token = this.tokenizer.getString();
        }
        select.queryCondition = condition;
        if (this.tokenizer.wasThis("GROUP")) {
            this.tokenizer.getThis("BY");
            int len = 0;
            do {
                Expression e = this.parseExpression();
                vcolumn.add(e);
                token = this.tokenizer.getString();
                ++len;
            } while (this.tokenizer.wasThis(","));
            select.iGroupLen = len;
        }
        if (this.tokenizer.wasThis("HAVING")) {
            select.iHavingLen = 1;
            select.havingCondition = this.parseExpression();
            token = this.tokenizer.getString();
            vcolumn.add(select.havingCondition);
        }
        if (isMain || limitWithOrder) {
            if (this.tokenizer.wasThis("ORDER")) {
                this.tokenizer.getThis("BY");
                this.parseOrderBy(select, vcolumn);
                token = this.tokenizer.getString();
            }
            if (this.tokenizer.wasThis("LIMIT")) {
                this.parseLimit(token, select, true);
                token = this.tokenizer.getString();
            }
        }
        boolean closebrackets = false;
        if (brackets > 0 && token.equals(")")) {
            closebrackets = true;
            brackets -= this.parseCloseBrackets(brackets - 1) + 1;
            token = this.tokenizer.getString();
        }
        select.unionDepth = brackets;
        if (!isMain && !closebrackets) {
            limitWithOrder = false;
        }
        boolean hasOrder = select.iOrderLen != 0;
        boolean bl = hasLimit = select.limitCondition != null;
        if (limitWithOrder) {
            if (hasLimit && !hasOrder) {
                throw Trace.error(163);
            }
        } else {
            if (hasOrder && !canHaveOrder) {
                throw Trace.error(70);
            }
            if (hasLimit && !canHaveLimit) {
                throw Trace.error(153);
            }
        }
        if ((unionType = this.parseUnion(token)) != 0) {
            boolean openbracket = false;
            select.unionType = unionType;
            if (this.tokenizer.isGetThis("(")) {
                openbracket = true;
                brackets += this.parseOpenBrackets() + 1;
            }
            this.tokenizer.getThis("SELECT");
            select.unionSelect = this.parseSelect(brackets, false, false, openbracket, false);
            token = this.tokenizer.getString();
        }
        if (isMain && (canHaveOrder || limitWithOrder) && select.iOrderLen == 0) {
            if (this.tokenizer.wasThis("ORDER")) {
                this.tokenizer.getThis("BY");
                this.parseOrderBy(select, vcolumn);
                token = this.tokenizer.getString();
                select.sortUnion = true;
            }
            if (this.tokenizer.wasThis("LIMIT")) {
                this.parseLimit(token, select, true);
                token = this.tokenizer.getString();
            }
        }
        this.tokenizer.back();
        if (isMain) {
            select.prepareUnions();
        }
        int len = vcolumn.size();
        select.exprColumns = new Expression[len];
        vcolumn.toArray(select.exprColumns);
        return select;
    }

    int parseUnion(String token) throws HsqlException {
        int unionType = 0;
        if (this.tokenizer.wasSimpleToken()) {
            switch (Token.get(token)) {
                case 227: {
                    token = this.tokenizer.getSimpleToken();
                    if (token.equals("ALL")) {
                        unionType = 2;
                        break;
                    }
                    if (token.equals("DISTINCT")) {
                        unionType = 1;
                        break;
                    }
                    unionType = 1;
                    this.tokenizer.back();
                    break;
                }
                case 115: {
                    this.tokenizer.isGetThis("DISTINCT");
                    unionType = 3;
                    break;
                }
                case 78: 
                case 311: {
                    this.tokenizer.isGetThis("DISTINCT");
                    unionType = 4;
                    break;
                }
            }
        }
        return unionType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseLimit(String token, Select select, boolean isEnd) throws HsqlException {
        Expression e2;
        if (select.limitCondition != null) {
            return;
        }
        Expression e1 = null;
        boolean islimit = false;
        if (isEnd) {
            if (!token.equals("LIMIT")) return;
            islimit = true;
            this.read();
            e2 = this.readTerm();
            if (this.sToken.equals("OFFSET")) {
                this.read();
                e1 = this.readTerm();
            }
            this.tokenizer.back();
        } else if (token.equals("LIMIT")) {
            this.read();
            e1 = this.readTerm();
            e2 = this.readTerm();
            islimit = true;
            this.tokenizer.back();
        } else {
            if (!token.equals("TOP")) return;
            this.read();
            e2 = this.readTerm();
            this.tokenizer.back();
        }
        if (e1 == null) {
            e1 = new Expression(4, ValuePool.getInt(0));
        }
        if ((e1.isParam() || e1.getType() == 1 && e1.getDataType() == 4 && e1.getValue(null) != null && (Integer)e1.getValue(null) >= 0) && (e2.isParam() || e2.getType() == 1 && e2.getDataType() == 4 && e2.getValue(null) != null && (Integer)e2.getValue(null) >= 0)) {
            e1.setDataType(4);
            e2.setDataType(4);
            select.limitCondition = new Expression(8, e1, e2);
            return;
        }
        int messageid = islimit ? 168 : 169;
        throw Trace.error(16, messageid);
    }

    private void parseOrderBy(Select select, HsqlArrayList vcolumn) throws HsqlException {
        String token;
        int len = 0;
        do {
            Expression e = this.parseExpression();
            e = Parser.resolveOrderByExpression(e, select, vcolumn);
            token = this.tokenizer.getString();
            if (token.equals("DESC")) {
                e.setDescending();
                token = this.tokenizer.getString();
            } else if (token.equals("ASC")) {
                token = this.tokenizer.getString();
            }
            vcolumn.add(e);
            ++len;
        } while (token.equals(","));
        this.tokenizer.back();
        select.iOrderLen = len;
    }

    private void resolveSelectTableFilter(Select select, HsqlArrayList vcolumn, HsqlArrayList vfilter) throws HsqlException {
        Expression e;
        TableFilter[] filters = new TableFilter[vfilter.size()];
        vfilter.toArray(filters);
        select.tFilter = filters;
        int colcount = vcolumn.size();
        int pos = 0;
        while (pos < colcount) {
            e = (Expression)vcolumn.get(pos);
            if (e.getType() == 6) {
                vcolumn.remove(pos);
                colcount = vcolumn.size();
                String tablename = e.getTableName();
                if (tablename == null) {
                    for (int i = 0; i < filters.length; ++i) {
                        pos = Parser.addFilterColumns(filters[i], vcolumn, pos);
                        colcount = vcolumn.size();
                    }
                    continue;
                }
                TableFilter f = e.findTableFilter(filters);
                if (f == null) {
                    throw Trace.error(22, tablename);
                }
                pos = Parser.addFilterColumns(f, vcolumn, pos);
                colcount = vcolumn.size();
                continue;
            }
            if (e.getFilter() == null) {
                for (int i = 0; i < filters.length; ++i) {
                    e.resolveTables(filters[i]);
                }
            }
            ++pos;
        }
        for (int i = 0; i < colcount; ++i) {
            e = (Expression)vcolumn.get(i);
            e.resolveTypes(this.session);
        }
        select.iResultLen = colcount;
    }

    static int addFilterColumns(TableFilter filter, HsqlArrayList columnList, int position) {
        Table table = filter.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Expression e = new Expression(filter, table.getColumn(i));
            columnList.add(position++, e);
        }
        return position;
    }

    private static Expression resolveOrderByExpression(Expression e, Select select, HsqlArrayList vcolumn) throws HsqlException {
        boolean union;
        int visiblecols = select.iResultLen;
        boolean bl = union = select.unionSelect != null;
        if (e.getType() == 1) {
            return Parser.resolveOrderByColumnIndex(e, vcolumn, visiblecols);
        }
        if (e.getType() != 2) {
            if (union) {
                throw Trace.error(70);
            }
            return e;
        }
        String ecolname = e.getColumnName();
        String etablename = e.getTableName();
        int size = visiblecols;
        for (int i = 0; i < size; ++i) {
            Expression colexpr = (Expression)vcolumn.get(i);
            String colalias = colexpr.getDefinedAlias();
            String colname = colexpr.getColumnName();
            String tablename = colexpr.getTableName();
            String filtername = colexpr.getFilterTableName();
            if (!ecolname.equals(colalias) && !ecolname.equals(colname) || etablename != null && !etablename.equals(tablename) && !etablename.equals(filtername)) continue;
            colexpr.joinedTableColumnIndex = i;
            return colexpr;
        }
        if (union) {
            throw Trace.error(70, ecolname);
        }
        return e;
    }

    private static Expression resolveOrderByColumnIndex(Expression e, HsqlArrayList vcolumn, int visiblecols) throws HsqlException {
        int i;
        if (e.getDataType() == 4 && 0 < (i = ((Integer)e.getValue(null)).intValue()) && i <= visiblecols) {
            Expression colexpr = (Expression)vcolumn.get(i - 1);
            colexpr.joinedTableColumnIndex = i - 1;
            return colexpr;
        }
        throw Trace.error(70);
    }

    private TableFilter parseSimpleTableFilter(int type) throws HsqlException {
        String alias = null;
        String token = this.tokenizer.getName();
        String schema = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
        Table table = this.database.schemaManager.getTable(this.session, token, schema);
        this.checkTableWriteAccess(table, type);
        token = this.tokenizer.getString();
        if (token.equals("AS")) {
            alias = this.tokenizer.getSimpleName();
        } else if (this.tokenizer.wasSimpleName()) {
            alias = token;
        } else {
            this.tokenizer.back();
        }
        return new TableFilter(table, alias, null, false);
    }

    private TableFilter parseTableFilter(boolean outerjoin) throws HsqlException {
        Table t = null;
        SubQuery sq = null;
        String sAlias = null;
        BaseHashMap columnList = null;
        if (this.tokenizer.isGetThis("(")) {
            int brackets = this.parseOpenBrackets();
            this.tokenizer.getThis("SELECT");
            sq = this.parseSubquery(brackets, null, true, 3);
            this.tokenizer.getThis(")");
            t = sq.table;
        } else {
            String token = this.tokenizer.getName();
            String schema = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
            t = this.database.schemaManager.getTable(this.session, token, schema);
            this.session.check(t.getName(), 1);
            if (t.isView()) {
                sq = this.getViewSubquery((View)t);
                sq.select = ((View)t).viewSelect;
                t = sq.table;
                sAlias = token;
            }
        }
        String token = this.tokenizer.getString();
        if (this.tokenizer.wasLongName()) {
            this.tokenizer.throwUnexpected();
        }
        if ((token.equals("LEFT") || token.equals("RIGHT")) && !this.tokenizer.wasQuotedIdentifier()) {
            this.tokenizer.back();
        } else if (token.equals("AS") && !this.tokenizer.wasQuotedIdentifier()) {
            sAlias = this.tokenizer.getSimpleName();
            if (this.tokenizer.isGetThis("(")) {
                this.tokenizer.back();
                columnList = this.parseColumnList();
            }
        } else if (this.tokenizer.wasSimpleName()) {
            sAlias = token;
            if (this.tokenizer.isGetThis("(")) {
                this.tokenizer.back();
                columnList = this.parseColumnList();
            }
        } else {
            this.tokenizer.back();
        }
        if (columnList != null && t.getColumnCount() != columnList.size()) {
            throw Trace.error(5);
        }
        return new TableFilter(t, sAlias, (HashMappedList)columnList, outerjoin);
    }

    private static Expression addCondition(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return new Expression(28, e1, e2);
    }

    private static Expression addJoinCondition(Expression e1, Expression e2, TableFilter tf, boolean outer) throws HsqlException {
        if (!e2.setForJoin(tf, outer)) {
            throw Trace.error(64);
        }
        return Parser.addCondition(e1, e2);
    }

    Expression parseExpression() throws HsqlException {
        this.read();
        Expression r = this.readOr();
        this.tokenizer.back();
        return r;
    }

    private Expression readAggregate() throws HsqlException {
        boolean distinct = false;
        boolean all = false;
        int type = this.iToken;
        this.read();
        String token = this.tokenizer.getString();
        if (token.equals("DISTINCT")) {
            distinct = true;
        } else if (token.equals("ALL")) {
            all = true;
        } else {
            this.tokenizer.back();
        }
        this.readThis(101);
        Expression s = this.readOr();
        this.readThis(102);
        if ((all || distinct) && (type == 47 || type == 48 || type == 49 || type == 50)) {
            throw Trace.error(200);
        }
        Expression aggregateExp = new Expression(type, s, null);
        aggregateExp.setDistinctAggregate(distinct);
        return aggregateExp;
    }

    private Expression readOr() throws HsqlException {
        Expression r = this.readAnd();
        while (this.iToken == 29) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() throws HsqlException {
        Expression r = this.readCondition();
        while (this.iToken == 28) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() throws HsqlException {
        switch (this.iToken) {
            case 20: {
                int type = this.iToken;
                this.read();
                return new Expression(type, this.readCondition(), null);
            }
            case 31: {
                int type = this.iToken;
                this.read();
                this.readThis(101);
                int brackets = 0;
                if (this.iToken == 101) {
                    brackets += this.parseOpenBrackets() + 1;
                    this.read();
                }
                Trace.check(this.iToken == 103, 11);
                SubQuery sq = this.parseSubquery(brackets, null, false, 31);
                Expression s = new Expression(sq);
                this.read();
                this.readThis(102);
                return new Expression(type, s, null);
            }
        }
        Expression a = this.readConcat();
        if (this.iToken == 109) {
            boolean not;
            this.read();
            if (this.iToken == 20) {
                not = true;
                this.read();
            } else {
                not = false;
            }
            Trace.check(this.iToken == 1 && this.oData == null, 11);
            this.read();
            a = new Expression(34, a, new Expression(0, null));
            if (not) {
                a = new Expression(20, a, null);
            }
            return a;
        }
        boolean not = false;
        if (this.iToken == 20) {
            not = true;
            this.read();
        }
        switch (this.iToken) {
            case 27: {
                a = this.parseLikePredicate(a);
                break;
            }
            case 106: {
                a = this.parseBetweenPredicate(a);
                break;
            }
            case 30: {
                a = this.parseInPredicate(a);
                break;
            }
            default: {
                Trace.check(!not, 11);
                if (Expression.isCompare(this.iToken)) {
                    int type = this.iToken;
                    this.read();
                    return new Expression(type, a, this.readConcat());
                }
                return a;
            }
        }
        if (not) {
            a = new Expression(20, a, null);
        }
        return a;
    }

    private Expression parseLikePredicate(Expression a) throws HsqlException {
        this.read();
        Expression b = this.readConcat();
        Character escape = null;
        if (this.sToken.equals("ESCAPE")) {
            this.read();
            Expression c = this.readTerm();
            Trace.check(c.getType() == 1, 7);
            String s = (String)c.getValue(this.session, 12);
            if (s == null || s.length() < 1) {
                throw Trace.error(7, s);
            }
            escape = new Character(s.charAt(0));
        }
        boolean hasCollation = this.database.collation.name != null;
        a = new Expression(a, b, escape, hasCollation);
        return a;
    }

    private Expression parseBetweenPredicate(Expression a) throws HsqlException {
        this.read();
        Expression l = new Expression(22, a, this.readConcat());
        this.readThis(28);
        Expression h = new Expression(25, a, this.readConcat());
        if (l.getArg().isParam() && l.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        if (h.getArg().isParam() && h.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        return new Expression(28, l, h);
    }

    private Expression parseInPredicate(Expression a) throws HsqlException {
        int type = this.iToken;
        this.read();
        this.readThis(101);
        Expression b = null;
        int brackets = 0;
        if (this.iToken == 101) {
            brackets += this.parseOpenBrackets() + 1;
            this.read();
        }
        if (this.iToken == 103) {
            SubQuery sq = this.parseSubquery(brackets, null, false, 30);
            Trace.check(sq.select.iResultLen == 1, 159);
            b = new Expression(sq);
            this.read();
        } else {
            this.tokenizer.back();
            HsqlArrayList v = new HsqlArrayList();
            do {
                Expression value = this.parseExpression();
                if (value.exprType == 1 && value.valueData == null && !value.isParam()) {
                    throw Trace.error(79);
                }
                v.add(value);
                this.read();
            } while (this.iToken == 104);
            Expression[] valueList = (Expression[])v.toArray(new Expression[v.size()]);
            b = new Expression(valueList);
        }
        this.readThis(102);
        return new Expression(type, a, b);
    }

    private Expression parseAllAnyPredicate() throws HsqlException {
        int type = this.iToken;
        this.read();
        this.readThis(101);
        Expression b = null;
        int brackets = 0;
        if (this.iToken == 101) {
            brackets += this.parseOpenBrackets() + 1;
            this.read();
        }
        if (this.iToken != 103) {
            throw Trace.error(74);
        }
        SubQuery sq = this.parseSubquery(brackets, null, false, type);
        Select select = sq.select;
        Trace.check(sq.select.iResultLen == 1, 159);
        b = new Expression(sq);
        this.read();
        this.readThis(102);
        return new Expression(type, b, null);
    }

    private void readThis(int type) throws HsqlException {
        Trace.check(this.iToken == type, 11);
        this.read();
    }

    private Expression readConcat() throws HsqlException {
        Expression r = this.readSum();
        while (this.iToken == 15) {
            int type = 15;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readSum());
        }
        return r;
    }

    private Expression readSum() throws HsqlException {
        Expression r = this.readFactor();
        while (true) {
            int type;
            if (this.iToken == 100) {
                type = 11;
            } else {
                if (this.iToken != 10) break;
                type = 12;
            }
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() throws HsqlException {
        Expression r = this.readTerm();
        while (this.iToken == 13 || this.iToken == 14) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readTerm());
        }
        return r;
    }

    private Expression readTerm() throws HsqlException {
        Expression r = null;
        switch (this.iToken) {
            case 2: {
                r = this.readColumnExpression();
                break;
            }
            case 10: {
                int type = this.iToken;
                this.read();
                r = new Expression(type, this.readTerm(), null);
                Trace.check(!r.getArg().isParam(), 212);
                break;
            }
            case 100: {
                this.read();
                r = this.readTerm();
                Trace.check(!r.isParam(), 216, Trace.getMessage(212));
                break;
            }
            case 101: {
                this.read();
                r = this.readOr();
                if (this.iToken != 102) {
                    throw Trace.error(11, this.sToken);
                }
                this.read();
                break;
            }
            case 1: {
                r = new Expression(this.iType, this.oData);
                this.read();
                break;
            }
            case 9: {
                r = new Expression(0, null, true);
                this.parameters.add(r);
                this.read();
                break;
            }
            case 103: {
                SubQuery sq = this.parseSubquery(0, null, false, 103);
                r = new Expression(sq);
                this.read();
                break;
            }
            case 32: 
            case 33: {
                r = this.parseAllAnyPredicate();
                break;
            }
            case 13: {
                r = new Expression(this.sSchema, this.sTable, (String)null);
                this.read();
                break;
            }
            case 62: {
                return this.readCaseWhenExpression();
            }
            case 68: {
                return this.readCaseExpression();
            }
            case 67: {
                return this.readNullIfExpression();
            }
            case 60: 
            case 69: {
                return this.readCoalesceExpression();
            }
            case 71: {
                return this.readSequenceExpression();
            }
            case 61: 
            case 107: {
                return this.readCastExpression();
            }
            case 63: {
                return this.readExtractExpression();
            }
            case 65: {
                return this.readTrimExpression();
            }
            case 64: {
                return this.readPositionExpression();
            }
            case 66: {
                return this.readSubstringExpression();
            }
            default: {
                if (Expression.isAggregate(this.iToken)) {
                    return this.readAggregate();
                }
                throw Trace.error(11, this.sToken);
            }
        }
        return r;
    }

    Expression readCaseExpression() throws HsqlException {
        int type = 62;
        Expression r = null;
        Expression predicand = null;
        this.read();
        if (this.iToken != 110) {
            predicand = this.readOr();
        }
        Expression leaf = null;
        do {
            Expression casewhen = this.parseCaseWhen(predicand);
            if (r == null) {
                r = casewhen;
            } else {
                leaf.setRightExpression(casewhen);
            }
            leaf = casewhen.getRightExpression();
        } while (this.iToken == 110);
        if (this.iToken == 112) {
            this.readThis(112);
            Expression elsexpr = this.readOr();
            leaf.setRightExpression(elsexpr);
        }
        this.readThis(113);
        return r;
    }

    private Expression parseCaseWhen(Expression r) throws HsqlException {
        this.readThis(110);
        Expression condition = r == null ? this.readOr() : new Expression(21, r, this.readOr());
        this.readThis(111);
        Expression current = this.readOr();
        Expression alternatives = new Expression(70, current, new Expression(0, null));
        Expression casewhen = new Expression(62, condition, alternatives);
        return casewhen;
    }

    private Expression readCaseWhenExpression() throws HsqlException {
        int type = this.iToken;
        Expression r = null;
        this.read();
        this.readThis(101);
        r = this.readOr();
        this.readThis(104);
        Expression thenelse = this.readOr();
        this.readThis(104);
        thenelse = new Expression(70, thenelse, this.readOr());
        r = new Expression(type, r, thenelse);
        this.readThis(102);
        return r;
    }

    private Expression readCastExpression() throws HsqlException {
        boolean isConvert = this.iToken == 61;
        this.read();
        this.readThis(101);
        Expression r = this.readOr();
        if (isConvert) {
            this.readThis(104);
        } else {
            this.readThis(122);
        }
        int typeNr = Types.getTypeNr(this.sToken);
        int length = 0;
        int scale = 0;
        boolean hasLength = false;
        if (Types.acceptsPrecisionCreateParam(typeNr) && this.tokenizer.isGetThis("(")) {
            length = this.tokenizer.getInt();
            hasLength = true;
            if (Types.acceptsScaleCreateParam(typeNr) && this.tokenizer.isGetThis(",")) {
                scale = this.tokenizer.getInt();
            }
            this.tokenizer.getThis(")");
        }
        if (typeNr == 6 && length > 53) {
            throw Trace.error(65);
        }
        if (typeNr == 93) {
            if (!hasLength) {
                length = 6;
            } else if (length != 0 && length != 6) {
                throw Trace.error(65);
            }
        }
        if (r.isParam()) {
            r.setDataType(typeNr);
        }
        r = new Expression(r, typeNr, length, scale);
        this.read();
        this.readThis(102);
        return r;
    }

    private Expression readColumnExpression() throws HsqlException {
        String name = this.sToken;
        Expression r = new Expression(this.sTable, name, this.wasQuoted);
        this.read();
        if (this.iToken == 101) {
            String javaName = this.database.getJavaName(name);
            Function f = new Function(name, javaName, false);
            this.session.check(javaName);
            int len = f.getArgCount();
            int i = 0;
            this.read();
            if (this.iToken != 102) {
                while (true) {
                    f.setArgument(i++, this.readOr());
                    if (this.iToken != 104) break;
                    this.read();
                }
            }
            this.readThis(102);
            r = new Expression(f);
        } else {
            String javaName = (String)simpleFunctions.get(name);
            if (javaName != null) {
                Function f = new Function(name, javaName, true);
                r = new Expression(f);
            }
        }
        return r;
    }

    private Expression readConcatExpression() throws HsqlException {
        int type = this.iToken;
        this.read();
        this.readThis(101);
        Expression r = this.readOr();
        this.readThis(104);
        r = new Expression(type, r, this.readOr());
        this.readThis(102);
        return r;
    }

    private Expression readNullIfExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        Expression r = this.readOr();
        this.readThis(104);
        Expression thenelse = new Expression(70, new Expression(0, null), r);
        r = new Expression(21, r, this.readOr());
        r = new Expression(62, r, thenelse);
        this.readThis(102);
        return r;
    }

    private Expression readCoalesceExpression() throws HsqlException {
        Expression current;
        Expression r = null;
        this.read();
        this.readThis(101);
        Expression leaf = null;
        while (true) {
            current = this.readOr();
            if (leaf != null && this.iToken == 102) break;
            Expression condition = new Expression(34, current, null);
            Expression alternatives = new Expression(70, new Expression(0, null), current);
            Expression casewhen = new Expression(62, condition, alternatives);
            if (r == null) {
                r = casewhen;
            } else {
                leaf.setLeftExpression(casewhen);
            }
            leaf = alternatives;
            this.readThis(104);
        }
        this.readThis(102);
        leaf.setLeftExpression(current);
        return r;
    }

    private Expression readExtractExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        String name = this.sToken;
        if (!Expression.SQL_EXTRACT_FIELD_NAMES.contains(name)) {
            throw Trace.error(11, this.sToken);
        }
        this.readToken();
        this.readThis(124);
        Function f = new Function(name, this.database.getJavaName(name), false);
        f.setArgument(0, this.readOr());
        this.readThis(102);
        return new Expression(f);
    }

    private Expression readPositionExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        Function f = new Function("POSITION", "org.hsqldb.Library.position", false);
        f.setArgument(0, this.readTerm());
        this.readThis(30);
        f.setArgument(1, this.readOr());
        this.readThis(102);
        return new Expression(f);
    }

    private Expression readSubstringExpression() throws HsqlException {
        boolean commas = false;
        this.read();
        this.readThis(101);
        Function f = new Function("SUBSTRING", "org.hsqldb.Library.substring", false);
        f.setArgument(0, this.readTerm());
        if (this.iToken == 124) {
            this.readThis(124);
        } else {
            this.readThis(104);
            commas = true;
        }
        f.setArgument(1, this.readOr());
        Expression count = null;
        if (!commas && this.iToken == 123) {
            this.readThis(123);
            count = this.readTerm();
        } else if (commas && this.iToken == 104) {
            this.readThis(104);
            count = this.readTerm();
        }
        f.setArgument(2, count);
        this.readThis(102);
        return new Expression(f);
    }

    private Expression readSequenceExpression() throws HsqlException {
        this.tokenizer.getThis("VALUE");
        this.tokenizer.getThis("FOR");
        String name = this.tokenizer.getName();
        String schemaname = this.tokenizer.getLongNameFirst();
        schemaname = this.session.getSchemaName(schemaname);
        this.tokenizer.getString();
        NumberSequence sequence = this.database.schemaManager.getSequence(name, schemaname);
        return new Expression(sequence);
    }

    private Expression readTrimExpression() throws HsqlException {
        Expression trailing;
        Expression leading;
        String trimstr;
        this.read();
        this.readThis(101);
        String type = this.sToken;
        if (Expression.SQL_TRIM_SPECIFICATION.contains(type)) {
            this.read();
        } else {
            type = "BOTH";
        }
        if (this.sToken.length() == 1) {
            trimstr = this.sToken;
            this.read();
        } else {
            trimstr = " ";
        }
        this.readThis(124);
        Expression trim = new Expression(1, trimstr);
        if (type.equals("LEADING")) {
            leading = new Expression(true);
            trailing = new Expression(false);
        } else if (type.equals("TRAILING")) {
            leading = new Expression(false);
            trailing = new Expression(true);
        } else {
            leading = trailing = new Expression(true);
        }
        Function f = new Function("TRIM", "org.hsqldb.Library.trim", false);
        f.setArgument(0, this.readOr());
        f.setArgument(1, trim);
        f.setArgument(2, leading);
        f.setArgument(3, trailing);
        this.readThis(102);
        return new Expression(f);
    }

    Expression readDefaultClause(int dataType) throws HsqlException {
        Object r = null;
        this.read();
        switch (this.iToken) {
            case 2: {
                String name = this.sToken;
                String javaName = (String)simpleFunctions.get(name);
                if (javaName == null) break;
                Function f = new Function(name, javaName, true);
                return new Expression(f);
            }
            case 10: {
                int exprType = this.iToken;
                this.read();
                if (this.iToken != 1) break;
                this.oData = Column.convertObject(this.oData, dataType);
                return new Expression(exprType, new Expression(dataType, this.oData), null);
            }
            case 1: {
                String name = this.sToken.toUpperCase(Locale.ENGLISH);
                String javaName = (String)simpleFunctions.get(name);
                if (Types.isDatetimeType(dataType) && javaName != null) {
                    Function f = new Function(name, javaName, true);
                    return new Expression(f);
                }
                this.oData = Column.convertObject(this.oData, dataType);
                return new Expression(dataType, this.oData);
            }
        }
        throw Trace.error(46, this.sToken);
    }

    private void read() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.wasQuoted = this.tokenizer.wasQuotedIdentifier();
        if (this.tokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tokenizer.getAsValue();
            this.iType = this.tokenizer.getType();
        } else if (this.tokenizer.wasSimpleName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tokenizer.wasLongName()) {
            this.sSchema = this.tokenizer.getLongNamePre();
            this.sTable = this.tokenizer.getLongNameFirst();
            this.iToken = this.sToken.equals("*") ? 13 : 2;
        } else if (this.tokenizer.wasParameter()) {
            this.iToken = 9;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else {
            this.iToken = tokenSet.get((Object)this.sToken, -1);
            if (this.iToken == -1) {
                this.iToken = 108;
            }
            switch (this.iToken) {
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case 13: {
                    this.sTable = null;
                    break;
                }
                default: {
                    this.iToken = 108;
                }
            }
        }
    }

    private void readToken() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.iToken = tokenSet.get((Object)this.sToken, -1);
    }

    Expression[] getParameters() {
        Expression[] result = this.parameters.size() == 0 ? noParameters : (Expression[])this.parameters.toArray(new Expression[this.parameters.size()]);
        this.parameters.clear();
        return result;
    }

    void clearParameters() {
        this.parameters.clear();
    }

    void setAsView(View view) {
        for (int i = 0; i < this.subQueryList.size(); ++i) {
            SubQuery sq = (SubQuery)this.subQueryList.get(i);
            if (sq.view != null) continue;
            sq.view = view;
        }
    }

    SubQuery[] getSortedSubqueries() {
        if (this.subQueryList.size() == 0) {
            return noSubqueries;
        }
        this.subQueryList.sort((SubQuery)this.subQueryList.get(0));
        SubQuery[] subqueries = new SubQuery[this.subQueryList.size()];
        this.subQueryList.toArray(subqueries);
        this.subQueryList.clear();
        return subqueries;
    }

    CompiledStatement compileCallStatement() throws HsqlException {
        this.clearParameters();
        Expression expression = this.parseExpression();
        CompiledStatement cs = new CompiledStatement(this.session, this.database, this.session.currentSchema, expression, this.getSortedSubqueries(), this.getParameters());
        return cs;
    }

    CompiledStatement compileDeleteStatement() throws HsqlException {
        Expression condition = null;
        this.clearParameters();
        this.tokenizer.getThis("FROM");
        TableFilter tableFilter = this.parseSimpleTableFilter(2);
        String token = this.tokenizer.getString();
        if (token.equals("WHERE")) {
            condition = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        CompiledStatement cs = new CompiledStatement(this.session, this.database, this.session.currentSchema, tableFilter, condition, this.getSortedSubqueries(), this.getParameters());
        return cs;
    }

    private void getInsertColumnValueExpressions(Table t, Expression[] acve, int len) throws HsqlException {
        this.tokenizer.getThis("(");
        for (int i = 0; i < len; ++i) {
            Expression columnValExpression = this.parseExpression();
            columnValExpression.resolveTables(null);
            columnValExpression.resolveTypes(this.session);
            acve[i] = columnValExpression;
            String token = this.tokenizer.getSimpleToken();
            if (token.equals(",")) continue;
            if (token.equals(")")) {
                if (i != len - 1) break;
                return;
            }
            this.tokenizer.throwUnexpected();
        }
        throw Trace.error(5);
    }

    CompiledStatement compileInsertStatement() throws HsqlException {
        this.clearParameters();
        this.tokenizer.getThis("INTO");
        String token = this.tokenizer.getName();
        String schema = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
        Table table = this.database.schemaManager.getTable(this.session, token, schema);
        this.checkTableWriteAccess(table, 4);
        HsqlArrayList columnNames = null;
        boolean[] columnCheckList = null;
        int[] columnMap = table.getColumnMap();
        int len = table.getColumnCount();
        int brackets = this.parseOpenBrackets();
        token = this.tokenizer.getString();
        if (brackets == 1 && !this.tokenizer.wasThis("SELECT")) {
            brackets = 0;
            this.tokenizer.back();
            columnNames = Parser.getColumnNames(this.database, table, this.tokenizer, false);
            if (columnNames.size() > len) {
                throw Trace.error(5);
            }
            len = columnNames.size();
            columnCheckList = table.getNewColumnCheckList();
            columnMap = new int[len];
            for (int i = 0; i < len; ++i) {
                int ci;
                columnMap[i] = ci = table.getColumnNr((String)columnNames.get(i));
                columnCheckList[ci] = true;
            }
            token = this.tokenizer.getSimpleToken();
        } else if (!this.tokenizer.wasSimpleToken()) {
            this.tokenizer.throwUnexpected();
        }
        int command = Token.get(token);
        switch (command) {
            case 226: {
                Expression[] acve = new Expression[len];
                this.getInsertColumnValueExpressions(table, acve, len);
                CompiledStatement cs = new CompiledStatement(this.session.currentSchema, table, columnMap, acve, columnCheckList, this.getSortedSubqueries(), this.getParameters());
                return cs;
            }
            case 313: {
                brackets = this.parseOpenBrackets() + 1;
                this.tokenizer.getThis("SELECT");
            }
            case 193: {
                Select select = this.parseSelect(brackets, true, false, true, true);
                if (len != select.iResultLen) {
                    throw Trace.error(5);
                }
                CompiledStatement cs = new CompiledStatement(this.session, this.database, this.session.currentSchema, table, columnMap, columnCheckList, select, this.getSortedSubqueries(), this.getParameters());
                return cs;
            }
        }
        throw Trace.error(11, token);
    }

    CompiledStatement compileSelectStatement(int brackets) throws HsqlException {
        String schema;
        String name;
        this.clearParameters();
        Select select = this.parseSelect(brackets, true, true, false, true);
        if (select.sIntoTable != null && this.database.schemaManager.findUserTable(this.session, name = select.sIntoTable.name, schema = select.sIntoTable.schema.name) != null) {
            throw Trace.error(21, name);
        }
        CompiledStatement cs = new CompiledStatement(this.session, this.database, this.session.currentSchema, select, this.getSortedSubqueries(), this.getParameters());
        return cs;
    }

    CompiledStatement compileUpdateStatement() throws HsqlException {
        this.clearParameters();
        TableFilter tableFilter = this.parseSimpleTableFilter(8);
        Table table = tableFilter.filterTable;
        this.tokenizer.getThis("SET");
        int[] colList = table.getNewColumnMap();
        Expression[] exprList = new Expression[colList.length];
        int len = 0;
        String token = null;
        do {
            int ci = table.getColumnNr(this.tokenizer.getName());
            String tablename = this.tokenizer.getLongNameFirst();
            if (tablename != null && !tableFilter.getName().equals(tablename)) {
                throw Trace.error(22);
            }
            this.tokenizer.getThis("=");
            Expression cve = this.parseExpression();
            if (len == colList.length) {
                throw Trace.error(5);
            }
            colList[len] = ci;
            exprList[len] = cve;
            token = this.tokenizer.getSimpleToken();
            ++len;
        } while (token.equals(","));
        Expression condition = null;
        if (token.equals("WHERE")) {
            condition = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        colList = (int[])ArrayUtil.resizeArray(colList, len);
        exprList = (Expression[])ArrayUtil.resizeArray(exprList, len);
        CompiledStatement cs = new CompiledStatement(this.session, this.database, this.session.currentSchema, tableFilter, colList, exprList, condition, this.getSortedSubqueries(), this.getParameters());
        return cs;
    }

    int parseOpenBracketsSelect() throws HsqlException {
        int count = this.parseOpenBrackets();
        this.tokenizer.getThis("SELECT");
        return count;
    }

    int parseOpenBrackets() throws HsqlException {
        int count = 0;
        while (this.tokenizer.isGetThis("(")) {
            ++count;
        }
        return count;
    }

    int parseCloseBrackets(int limit) throws HsqlException {
        int count;
        for (count = 0; count < limit && this.tokenizer.isGetThis(")"); ++count) {
        }
        return count;
    }

    HashMappedList parseColumnList() throws HsqlException {
        return Parser.processColumnList(this.tokenizer, false);
    }

    static HashMappedList processColumnList(Tokenizer tokenizer, boolean acceptAscDesc) throws HsqlException {
        String token;
        HashMappedList list = new HashMappedList();
        tokenizer.getThis("(");
        do {
            boolean result;
            if (!(result = list.add(token = tokenizer.getSimpleName(), null))) {
                throw Trace.error(27, token);
            }
            token = tokenizer.getSimpleToken();
            if (!acceptAscDesc || !token.equals("DESC") && !token.equals("ASC")) continue;
            token = tokenizer.getSimpleToken();
        } while (token.equals(","));
        if (!token.equals(")")) {
            throw Trace.error(11, token);
        }
        return list;
    }

    static {
        simpleFunctions.put("CURRENT_DATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("CURRENT_TIME", "org.hsqldb.Library.curtime");
        simpleFunctions.put("CURRENT_TIMESTAMP", "org.hsqldb.Library.now");
        simpleFunctions.put("CURRENT_USER", "org.hsqldb.Library.user");
        simpleFunctions.put("SYSDATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("NOW", "org.hsqldb.Library.now");
        simpleFunctions.put("TODAY", "org.hsqldb.Library.curdate");
        tokenSet = new IntValueHashMap(37);
        tokenSet.put(",", 104);
        tokenSet.put("=", 21);
        tokenSet.put("!=", 26);
        tokenSet.put("<>", 26);
        tokenSet.put("<", 24);
        tokenSet.put(">", 23);
        tokenSet.put("<=", 25);
        tokenSet.put(">=", 22);
        tokenSet.put("AND", 28);
        tokenSet.put("NOT", 20);
        tokenSet.put("OR", 29);
        tokenSet.put("ALL", 32);
        tokenSet.put("ANY", 33);
        tokenSet.put("IN", 30);
        tokenSet.put("EXISTS", 31);
        tokenSet.put("BETWEEN", 106);
        tokenSet.put("+", 100);
        tokenSet.put("-", 10);
        tokenSet.put("*", 13);
        tokenSet.put("/", 14);
        tokenSet.put("||", 15);
        tokenSet.put("(", 101);
        tokenSet.put(")", 102);
        tokenSet.put("SELECT", 103);
        tokenSet.put("LIKE", 27);
        tokenSet.put("COUNT", 40);
        tokenSet.put("SUM", 41);
        tokenSet.put("MIN", 42);
        tokenSet.put("MAX", 43);
        tokenSet.put("AVG", 44);
        tokenSet.put("EVERY", 45);
        tokenSet.put("SOME", 46);
        tokenSet.put("STDDEV_POP", 47);
        tokenSet.put("STDDEV_SAMP", 48);
        tokenSet.put("VAR_POP", 49);
        tokenSet.put("VAR_SAMP", 50);
        tokenSet.put("IFNULL", 60);
        tokenSet.put("NVL", 60);
        tokenSet.put("NULLIF", 67);
        tokenSet.put("CONVERT", 61);
        tokenSet.put("CAST", 107);
        tokenSet.put("NEXT", 71);
        tokenSet.put("CASE", 68);
        tokenSet.put("WHEN", 110);
        tokenSet.put("THEN", 111);
        tokenSet.put("ELSE", 112);
        tokenSet.put("END", 113);
        tokenSet.put("CASEWHEN", 62);
        tokenSet.put("COALESCE", 69);
        tokenSet.put("EXTRACT", 63);
        tokenSet.put("POSITION", 64);
        tokenSet.put("FROM", 124);
        tokenSet.put("TRIM", 65);
        tokenSet.put("SUBSTRING", 66);
        tokenSet.put("FOR", 123);
        tokenSet.put("AS", 122);
        tokenSet.put("IS", 109);
        tokenSet.put("?", 9);
        noParameters = new Expression[0];
        noSubqueries = new SubQuery[0];
    }
}

