/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.store.ValuePool;

public class HSQLClientConnection
implements SessionInterface {
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    private boolean isClosed;
    private Socket socket;
    protected OutputStream dataOutput;
    protected DataInputStream dataInput;
    protected RowOutputBinary rowOut;
    protected RowInputBinary rowIn;
    private Result resultOut;
    private int sessionID;
    private boolean isReadOnly = false;
    private boolean isAutoCommit = true;
    String host;
    int port;
    String path;
    String database;
    boolean isTLS;
    int databaseID;

    public HSQLClientConnection(String host, int port, String path, String database, boolean isTLS, String user, String password) throws HsqlException {
        this.host = host;
        this.port = port;
        this.path = path;
        this.database = database;
        this.isTLS = isTLS;
        this.initStructures();
        Result login = new Result(65543);
        login.mainString = user;
        login.subString = password;
        login.subSubString = database;
        this.initConnection(host, port, isTLS);
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            throw Trace.error(resultIn);
        }
        this.sessionID = resultIn.sessionID;
        this.databaseID = resultIn.databaseID;
    }

    private void initStructures() {
        this.rowOut = new RowOutputBinary(this.mainBuffer);
        this.rowIn = new RowInputBinary(this.rowOut);
        this.resultOut = Result.newSessionAttributesResult();
        this.resultOut.add(new Object[7]);
    }

    protected void initConnection(String host, int port, boolean isTLS) throws HsqlException {
        this.openConnection(host, port, isTLS);
    }

    protected void openConnection(String host, int port, boolean isTLS) throws HsqlException {
        try {
            this.socket = HsqlSocketFactory.getInstance(isTLS).createSocket(host, port);
            this.dataOutput = new BufferedOutputStream(this.socket.getOutputStream());
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception e) {
            throw Trace.error(80);
        }
    }

    protected void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    public synchronized Result execute(Result r) throws HsqlException {
        try {
            r.sessionID = this.sessionID;
            r.databaseID = this.databaseID;
            this.write(r);
            return this.read();
        }
        catch (Throwable e) {
            throw Trace.error(3, e.toString());
        }
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.resultOut.setResultType(65545);
            this.execute(this.resultOut);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object getAttribute(int id) throws HsqlException {
        this.resultOut.setResultType(7);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Trace.error(in);
        }
        return in.rRoot.data[id];
    }

    private void setAttribute(Object property, int id) throws HsqlException {
        this.resultOut.setResultType(6);
        ArrayUtil.fillArray(this.resultOut.rRoot.data, null);
        this.resultOut.rRoot.data[id] = property;
        Result resultIn = this.execute(this.resultOut);
        if (resultIn.isError()) {
            throw Trace.error(resultIn);
        }
    }

    public boolean isReadOnly() throws HsqlException {
        Object info = this.getAttribute(6);
        this.isReadOnly = (Boolean)info;
        return this.isReadOnly;
    }

    public void setReadOnly(boolean mode) throws HsqlException {
        if (mode != this.isReadOnly) {
            this.setAttribute(mode ? Boolean.TRUE : Boolean.FALSE, 6);
            this.isReadOnly = mode;
        }
    }

    public boolean isAutoCommit() throws HsqlException {
        Object info = this.getAttribute(4);
        this.isAutoCommit = (Boolean)info;
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean mode) throws HsqlException {
        if (mode != this.isAutoCommit) {
            this.setAttribute(mode ? Boolean.TRUE : Boolean.FALSE, 4);
            this.isAutoCommit = mode;
        }
    }

    public void setIsolation(int level) throws HsqlException {
        this.setAttribute(ValuePool.getInt(level), 3);
    }

    public int getIsolation() throws HsqlException {
        Object info = this.getAttribute(3);
        return (Integer)info;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Session getSession() {
        return null;
    }

    public void startPhasedTransaction() throws HsqlException {
    }

    public void prepareCommit() throws HsqlException {
        this.resultOut.setResultType(66541);
        this.resultOut.updateCount = 11;
        this.resultOut.setMainString("");
        this.execute(this.resultOut);
    }

    public void commit() throws HsqlException {
        this.resultOut.setResultType(66541);
        this.resultOut.updateCount = 0;
        this.resultOut.setMainString("");
        this.execute(this.resultOut);
    }

    public void rollback() throws HsqlException {
        this.resultOut.setResultType(66541);
        this.resultOut.updateCount = 1;
        this.resultOut.setMainString("");
        this.execute(this.resultOut);
    }

    public int getId() {
        return this.sessionID;
    }

    public void resetSession() throws HsqlException {
        Result login = new Result(10);
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            this.isClosed = true;
            this.closeConnection();
            throw Trace.error(resultIn);
        }
        this.sessionID = resultIn.sessionID;
        this.databaseID = resultIn.databaseID;
    }

    protected void write(Result r) throws IOException, HsqlException {
        Result.write(r, this.rowOut, this.dataOutput);
    }

    protected Result read() throws IOException, HsqlException {
        Result r = Result.read(this.rowIn, this.dataInput);
        this.rowOut.setBuffer(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        return r;
    }
}

