/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Library;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

class Function {
    private String sFunction;
    private Method mMethod;
    private String returnClassName;
    private Class[] aArgClasses;
    private int iReturnType;
    private int iArgCount;
    private int iSqlArgCount;
    private int iSqlArgStart;
    private int[] iArgType;
    private boolean[] bArgNullable;
    Expression[] eArg;
    private boolean bConnection;
    private static HashMap methodCache = new HashMap();
    private int fID;
    String name;
    boolean isSimple;
    boolean hasAggregate;

    Function(String name, String fqn, boolean isSimple) throws HsqlException {
        Class<?> returnClass;
        this.name = name;
        this.isSimple = isSimple;
        this.sFunction = fqn;
        this.fID = Library.functionID(fqn);
        int i = fqn.lastIndexOf(46);
        Trace.check(i != -1, 11, fqn);
        String classname = fqn.substring(0, i);
        this.mMethod = (Method)methodCache.get(fqn);
        if (this.mMethod == null) {
            String methodname = fqn.substring(i + 1);
            Class<?> classinstance = null;
            try {
                classinstance = Class.forName(classname);
            }
            catch (Exception e) {
                throw Trace.error(42, 115, new Object[]{classname, e});
            }
            Method[] methods = classinstance.getMethods();
            for (i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodname) || !Modifier.isStatic(m.getModifiers())) continue;
                this.mMethod = m;
                break;
            }
            Trace.check(this.mMethod != null, 13, methodname);
            methodCache.put(fqn, this.mMethod);
        }
        this.iReturnType = (returnClass = this.mMethod.getReturnType()).equals(Result.class) ? 1111 : Types.getParameterTypeNr(returnClass);
        this.returnClassName = Types.getFunctionReturnClassName(returnClass.getName());
        this.aArgClasses = this.mMethod.getParameterTypes();
        this.iArgCount = this.aArgClasses.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        for (i = 0; i < this.aArgClasses.length; ++i) {
            Class a = this.aArgClasses[i];
            String type = a.getName();
            if (i == 0 && a.equals(Connection.class)) {
                this.bConnection = true;
                continue;
            }
            this.iArgType[i] = Types.getParameterTypeNr(a);
            this.bArgNullable[i] = !a.isPrimitive();
        }
        this.iSqlArgCount = this.iArgCount;
        if (this.bConnection) {
            --this.iSqlArgCount;
            this.iSqlArgStart = 1;
        } else {
            this.iSqlArgStart = 0;
        }
        this.eArg = new Expression[this.iArgCount];
    }

    Object getValue(Session session) throws HsqlException {
        switch (this.fID) {
            case 10: {
                return session.getCurrentTime();
            }
            case 9: {
                return session.getCurrentDate();
            }
            case 11: {
                return session.getDatabase().getPath();
            }
            case 19: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                return session.getLastIdentity();
            }
            case 30: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                return session.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 31: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                return session.getCurrentTimestamp();
            }
            case 64: {
                return session.getUsername();
            }
        }
        Object[] oArg = this.getArguments(session);
        if (oArg == null) {
            return null;
        }
        return this.getValue(session, oArg);
    }

    Object getValue(Session session, Object[] arguments) throws HsqlException {
        if (this.bConnection) {
            arguments[0] = session.getInternalConnection();
        }
        try {
            Object ret = this.fID >= 0 ? Library.invoke(this.fID, arguments) : this.mMethod.invoke(null, arguments);
            return Column.convertObject(ret, this.iReturnType);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String s = this.sFunction + " : " + t.toString();
            throw Trace.error(198, s);
        }
        catch (IllegalAccessException e) {
            throw Trace.error(198);
        }
    }

    private Object[] getArguments(Session session) throws HsqlException {
        Object[] oArg = new Object[this.iArgCount];
        for (int i = this.bConnection ? 1 : 0; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            Object o = null;
            if (e != null) {
                o = e.getValue(session, this.iArgType[i]);
            }
            if (o == null && !this.bArgNullable[i]) {
                return null;
            }
            if (o instanceof JavaObject) {
                o = ((JavaObject)o).getObject();
            } else if (o instanceof Binary) {
                o = ((Binary)o).getBytes();
            }
            oArg[i] = o;
        }
        return oArg;
    }

    private Object[] getNotNull(Object[] values) throws HsqlException {
        int i;
        int n = i = this.bConnection ? 1 : 0;
        while (i < this.iArgCount) {
            Object o = values[i];
            if (o == null && !this.bArgNullable[i]) {
                return null;
            }
            ++i;
        }
        return values;
    }

    void collectInGroupByExpressions(HsqlArrayList colExps) {
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            e.collectInGroupByExpressions(colExps);
        }
    }

    Object getAggregatedValue(Session session, Object currValue) throws HsqlException {
        Object[] valueArray = (Object[])currValue;
        if (valueArray == null) {
            valueArray = new Object[this.iArgCount];
        }
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (this.eArg[i] == null) continue;
            valueArray[i] = this.eArg[i].isAggregate() ? Column.convertObject(e.getAggregatedValue(session, valueArray[i]), this.iArgType[i]) : e.getValue(session, this.iArgType[i]);
        }
        if ((valueArray = this.getNotNull(valueArray)) == null) {
            return null;
        }
        return this.getValue(session, valueArray);
    }

    Object updateAggregatingValue(Session session, Object currValue) throws HsqlException {
        Object[] valueArray = (Object[])currValue;
        if (valueArray == null) {
            valueArray = new Object[this.iArgCount];
        }
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (this.eArg[i] == null) continue;
            valueArray[i] = e.updateAggregatingValue(session, valueArray[i]);
        }
        return valueArray;
    }

    int getArgCount() {
        return this.iSqlArgCount;
    }

    void replaceAliases(Expression[] columns, int length) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            if (e.exprType == 2) {
                this.eArg[i] = e.getExpressionForAlias(columns, length);
                continue;
            }
            e.replaceAliases(columns, length);
        }
    }

    void checkTables(HsqlArrayList fa) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            e.checkTables(fa);
        }
    }

    void resolveTables(TableFilter f) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            e.resolveTables(f);
        }
    }

    void resolveType(Session session) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            if (e.isParam()) {
                e.setDataType(this.iArgType[i]);
                e.nullability = this.getArgNullability(i);
                e.valueClassName = this.getArgClass(i).getName();
                continue;
            }
            e.resolveTypes(session);
        }
    }

    boolean checkResolved(boolean check) throws HsqlException {
        boolean result = true;
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            if (this.eArg[i] == null) continue;
            result = result && this.eArg[i].checkResolved(check);
        }
        return result;
    }

    int getArgType(int i) {
        return this.iArgType[i];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    void setArgument(int i, Expression e) {
        if (this.bConnection) {
            ++i;
        }
        this.eArg[i] = e;
        this.hasAggregate = this.hasAggregate || e != null && e.isAggregate();
    }

    String getDLL() throws HsqlException {
        StringBuffer sb = new StringBuffer();
        String ddlName = this.name;
        if (this.isSimple) {
            return this.name;
        }
        if ("TRIM".equals(this.name)) {
            sb.append(this.name).append('(');
            boolean leading = this.eArg[2].testCondition(null);
            boolean trailing = this.eArg[3].testCondition(null);
            if (leading && trailing) {
                sb.append("BOTH");
            } else {
                sb.append(leading ? "LEADING" : "TRAILING");
            }
            sb.append(' ');
            String charval = (String)this.eArg[1].getValue(null);
            sb.append(Column.createSQLString(charval)).append(' ');
            sb.append("FROM").append(' ');
            sb.append(this.eArg[0].getDDL()).append(')');
            return sb.toString();
        }
        if (this.sFunction.equals(this.name)) {
            ddlName = StringConverter.toQuotedString(this.name, '\"', true);
        }
        sb.append(ddlName).append('(');
        for (int i = this.iSqlArgStart; i < this.eArg.length; ++i) {
            sb.append(this.eArg[i].getDDL());
            if (i >= this.eArg.length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public String describe(Session session) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("=[\n");
        sb.append(this.sFunction).append("(");
        for (int i = this.iSqlArgStart; i < this.eArg.length; ++i) {
            sb.append("[").append(this.eArg[i].describe(session)).append("]");
        }
        sb.append(") returns ").append(Types.getTypeString(this.getReturnType()));
        sb.append("]\n");
        return sb.toString();
    }

    String getReturnClassName() {
        return this.returnClassName;
    }

    Class getArgClass(int i) {
        return this.aArgClasses[i];
    }

    int getArgNullability(int i) {
        return this.bArgNullable[i] ? 1 : 0;
    }

    Method getMethod() {
        return this.mMethod;
    }
}

