/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseURL {
    static final String S_DOT = ".";
    public static final String S_MEM = "mem:";
    public static final String S_FILE = "file:";
    public static final String S_RES = "res:";
    public static final String S_ALIAS = "alias:";
    public static final String S_HSQL = "hsql://";
    public static final String S_HSQLS = "hsqls://";
    public static final String S_HTTP = "http://";
    public static final String S_HTTPS = "https://";
    public static final String S_URL_PREFIX = "jdbc:hsqldb:";

    public static boolean isFileBasedDatabaseType(String url) {
        return url == S_FILE || url == S_RES;
    }

    public static boolean isInProcessDatabaseType(String url) {
        return url == S_FILE || url == S_RES || url == S_MEM;
    }

    public static HsqlProperties parseURL(String url, boolean hasPrefix) {
        String database;
        String urlImage = url.toLowerCase(Locale.ENGLISH);
        HsqlProperties props = new HsqlProperties();
        HsqlProperties extraProps = null;
        String arguments = null;
        int pos = 0;
        if (hasPrefix) {
            if (urlImage.startsWith(S_URL_PREFIX)) {
                pos = S_URL_PREFIX.length();
            } else {
                return props;
            }
        }
        String type = null;
        int port = 0;
        boolean isNetwork = false;
        props.setProperty("url", url);
        int semicolpos = url.indexOf(59, pos);
        if (semicolpos < 0) {
            semicolpos = url.length();
        } else {
            arguments = urlImage.substring(semicolpos + 1, urlImage.length());
            extraProps = HsqlProperties.delimitedArgPairsToProps(arguments, "=", ";", null);
            props.addProperties(extraProps);
        }
        if (semicolpos == pos + 1 && urlImage.startsWith(S_DOT, pos)) {
            type = S_DOT;
        } else if (urlImage.startsWith(S_MEM, pos)) {
            type = S_MEM;
        } else if (urlImage.startsWith(S_FILE, pos)) {
            type = S_FILE;
        } else if (urlImage.startsWith(S_RES, pos)) {
            type = S_RES;
        } else if (urlImage.startsWith(S_ALIAS, pos)) {
            type = S_ALIAS;
        } else if (urlImage.startsWith(S_HSQL, pos)) {
            type = S_HSQL;
            port = 9001;
            isNetwork = true;
        } else if (urlImage.startsWith(S_HSQLS, pos)) {
            type = S_HSQLS;
            port = 554;
            isNetwork = true;
        } else if (urlImage.startsWith(S_HTTP, pos)) {
            type = S_HTTP;
            port = 80;
            isNetwork = true;
        } else if (urlImage.startsWith(S_HTTPS, pos)) {
            type = S_HTTPS;
            port = 443;
            isNetwork = true;
        }
        if (type == null) {
            type = S_FILE;
        } else if (type == S_DOT) {
            type = S_MEM;
        } else {
            pos += type.length();
        }
        props.setProperty("connection_type", type);
        if (isNetwork) {
            String filePath;
            String path;
            int colonpos;
            int slashpos = url.indexOf(47, pos);
            if (slashpos < pos || slashpos > semicolpos) {
                slashpos = semicolpos;
            }
            if ((colonpos = url.indexOf(58, pos)) < pos || colonpos > slashpos) {
                colonpos = slashpos;
            } else {
                try {
                    port = Integer.parseInt(url.substring(colonpos + 1, slashpos));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            String host = urlImage.substring(pos, colonpos);
            int secondslashpos = url.lastIndexOf(47, semicolpos);
            if (secondslashpos < pos) {
                path = "/";
                database = "";
            } else if (secondslashpos == slashpos) {
                path = "/";
                database = urlImage.substring(secondslashpos + 1, semicolpos);
            } else {
                path = url.substring(slashpos, secondslashpos);
                database = urlImage.substring(secondslashpos + 1, semicolpos);
            }
            props.setProperty("port", port);
            props.setProperty("host", host);
            props.setProperty("path", path);
            if (extraProps != null && (filePath = extraProps.getProperty("filepath")) != null && database.length() != 0) {
                database = database + ";" + filePath;
            }
        } else {
            if (type == S_MEM || type == S_RES) {
                database = urlImage.substring(pos, semicolpos).toLowerCase();
                if (type == S_RES && database.indexOf(47) != 0) {
                    database = '/' + database;
                }
            } else {
                database = url.substring(pos, semicolpos);
            }
            if (database.length() == 0) {
                return null;
            }
        }
        props.setProperty("database", database);
        return props;
    }
}

