/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.java.JavaSystem;

final class CompiledStatementExecutor {
    private Session session;
    private Result updateResult;
    private static Result emptyZeroResult = new Result(1);
    private static Result updateOneResult = new Result(1);

    CompiledStatementExecutor(Session session) {
        this.session = session;
        this.updateResult = new Result(1);
    }

    Result execute(CompiledStatement cs, Object[] paramValues) {
        Result result = null;
        JavaSystem.gc();
        for (int i = 0; i < cs.parameters.length; ++i) {
            cs.parameters[i].bind(paramValues[i]);
        }
        try {
            cs.materializeSubQueries(this.session);
            result = this.executeImpl(cs);
        }
        catch (Throwable t) {
            result = new Result(t, cs.sql);
        }
        cs.dematerializeSubQueries(this.session);
        if (result == null) {
            result = emptyZeroResult;
        }
        return result;
    }

    private Result executeImpl(CompiledStatement cs) throws HsqlException {
        switch (cs.type) {
            case 5: {
                return this.executeSelectStatement(cs);
            }
            case 2: {
                return this.executeInsertSelectStatement(cs);
            }
            case 1: {
                return this.executeInsertValuesStatement(cs);
            }
            case 3: {
                return this.executeUpdateStatement(cs);
            }
            case 4: {
                return this.executeDeleteStatement(cs);
            }
            case 7: {
                return this.executeCallStatement(cs);
            }
            case 9: {
                return this.executeDDLStatement(cs);
            }
        }
        throw Trace.runtimeError(201, "CompiledStatementExecutor.executeImpl()");
    }

    private Result executeCallStatement(CompiledStatement cs) throws HsqlException {
        Expression e = cs.expression;
        Object o = e.getValue(this.session);
        if (o instanceof Result) {
            return (Result)o;
        }
        if (o instanceof jdbcResultSet) {
            return ((jdbcResultSet)o).rResult;
        }
        Result r = Result.newSingleColumnResult("@p0", e.getDataType());
        Object[] row = new Object[]{o};
        r.metaData.classNames[0] = e.getValueClassName();
        r.add(row);
        return r;
    }

    private Result executeDeleteStatement(CompiledStatement cs) throws HsqlException {
        Table table = cs.targetTable;
        TableFilter filter = cs.targetFilter;
        int count = 0;
        if (filter.findFirst(this.session)) {
            Expression c = cs.condition;
            HsqlArrayList del = new HsqlArrayList();
            do {
                if (c != null && !c.testCondition(this.session)) continue;
                del.add(filter.currentRow);
            } while (filter.next(this.session));
            count = table.delete(this.session, del);
        }
        this.updateResult.updateCount = count;
        return this.updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeInsertSelectStatement(CompiledStatement cs) throws HsqlException {
        int count;
        Table t = cs.targetTable;
        Select s = cs.select;
        int[] ct = t.getColumnTypes();
        Result r = s.getResult(this.session, Integer.MAX_VALUE);
        Record rc = r.rRoot;
        int[] cm = cs.columnMap;
        boolean[] ccl = cs.checkColumns;
        int len = cm.length;
        boolean success = false;
        this.session.beginNestedTransaction();
        try {
            while (rc != null) {
                Object[] row = t.getNewRowData(this.session, ccl);
                for (int i = 0; i < len; ++i) {
                    int j = cm[i];
                    row[j] = ct[j] != r.metaData.colTypes[i] ? Column.convertObject(rc.data[i], ct[j]) : rc.data[i];
                }
                rc.data = row;
                rc = rc.next;
            }
            count = t.insert(this.session, r);
            success = true;
            this.session.endNestedTransaction(!success);
        }
        catch (Throwable throwable) {
            this.session.endNestedTransaction(!success);
            throw throwable;
        }
        this.updateResult.updateCount = count;
        return this.updateResult;
    }

    private Result executeInsertValuesStatement(CompiledStatement cs) throws HsqlException {
        Table t = cs.targetTable;
        Object[] row = t.getNewRowData(this.session, cs.checkColumns);
        int[] cm = cs.columnMap;
        Expression[] acve = cs.columnValues;
        int[] ct = t.getColumnTypes();
        int len = acve.length;
        for (int i = 0; i < len; ++i) {
            Expression cve = acve[i];
            int ci = cm[i];
            row[ci] = cve.getValue(this.session, ct[ci]);
        }
        t.insert(this.session, row);
        return updateOneResult;
    }

    private Result executeSelectStatement(CompiledStatement cs) throws HsqlException {
        Result result;
        Select select = cs.select;
        if (select.sIntoTable != null) {
            boolean exists;
            this.session.checkDDLWrite();
            boolean bl = exists = this.session.database.schemaManager.findUserTable(this.session, select.sIntoTable.name, select.sIntoTable.schema.name) != null;
            if (exists) {
                throw Trace.error(21, select.sIntoTable.name);
            }
            result = select.getResult(this.session, Integer.MAX_VALUE);
            result = this.session.dbCommandInterpreter.processSelectInto(result, select.sIntoTable, select.intoType);
            this.session.getDatabase().setMetaDirty(false);
        } else {
            result = select.getResult(this.session, this.session.getMaxRows());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeUpdateStatement(CompiledStatement cs) throws HsqlException {
        Table table = cs.targetTable;
        TableFilter filter = cs.targetFilter;
        int count = 0;
        if (filter.findFirst(this.session)) {
            int[] colmap = cs.columnMap;
            Expression[] colvalues = cs.columnValues;
            Expression condition = cs.condition;
            int len = colvalues.length;
            HashMappedList rowset = new HashMappedList();
            int size = table.getColumnCount();
            int[] coltypes = table.getColumnTypes();
            boolean success = false;
            do {
                if (condition != null && !condition.testCondition(this.session)) continue;
                try {
                    Row row = filter.currentRow;
                    Object[] ni = table.getEmptyRowData();
                    System.arraycopy(row.getData(), 0, ni, 0, size);
                    for (int i = 0; i < len; ++i) {
                        int ci = colmap[i];
                        ni[ci] = colvalues[i].getValue(this.session, coltypes[ci]);
                    }
                    rowset.add(row, ni);
                }
                catch (HsqlInternalException e) {
                    // empty catch block
                }
            } while (filter.next(this.session));
            this.session.beginNestedTransaction();
            try {
                count = table.update(this.session, rowset, colmap);
                success = true;
                this.session.endNestedTransaction(!success);
            }
            catch (Throwable throwable) {
                this.session.endNestedTransaction(!success);
                throw throwable;
            }
        }
        this.updateResult.updateCount = count;
        return this.updateResult;
    }

    private Result executeDDLStatement(CompiledStatement cs) throws HsqlException {
        return this.session.sqlExecuteDirectNoPreChecks(cs.sql);
    }

    static {
        CompiledStatementExecutor.updateOneResult.updateCount = 1;
    }
}

