/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.displaytag.model.Cell;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.TableModel;
import org.displaytag.util.ShortToStringStyle;

public class Row {
    private Object rowObject;
    private List staticCells;
    private int rowNumber;
    private TableModel tableModel;

    public Row(Object object, int number) {
        this.rowObject = object;
        this.rowNumber = number;
        this.staticCells = new ArrayList();
    }

    public void setRowNumber(int number) {
        this.rowNumber = number;
    }

    public boolean isOddRow() {
        return this.rowNumber % 2 == 0;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void addCell(Cell cell) {
        this.staticCells.add(cell);
    }

    public List getCellList() {
        return this.staticCells;
    }

    public Object getObject() {
        return this.rowObject;
    }

    public ColumnIterator getColumnIterator(List columns) {
        return new ColumnIterator(columns, this);
    }

    protected void setParentTable(TableModel table) {
        this.tableModel = table;
    }

    protected TableModel getParentTable() {
        return this.tableModel;
    }

    public String getOpenTag() {
        String css = this.tableModel.getProperties().getCssRow(this.rowNumber);
        if (StringUtils.isNotBlank((String)css)) {
            return "\n<tr class=\"" + css + "\"" + ">";
        }
        return "\n<tr>";
    }

    public String getCloseTag() {
        return "</tr>";
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ShortToStringStyle.SHORT_STYLE).append("rowNumber", this.rowNumber).append("rowObject", this.rowObject).toString();
    }
}

