/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.BooleanUtils;

abstract class Decorator {
    private static final char CLASS_PROPERTY_SEPARATOR = '#';
    private static Map propertyMap = new HashMap();
    private PageContext pageContext;
    private Object decoratedObject;

    Decorator() {
    }

    public void init(PageContext context, Object decorated) {
        this.pageContext = context;
        this.decoratedObject = decorated;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public Object getDecoratedObject() {
        return this.decoratedObject;
    }

    public void finish() {
        this.pageContext = null;
        this.decoratedObject = null;
    }

    public boolean hasGetterFor(String propertyName) {
        Boolean cachedResult;
        String simpleProperty = propertyName;
        int indexOfDot = simpleProperty.indexOf(46);
        if (indexOfDot > 0) {
            simpleProperty = simpleProperty.substring(0, indexOfDot);
        }
        if ((cachedResult = (Boolean)propertyMap.get(this.getClass().getName() + '#' + simpleProperty)) != null) {
            return cachedResult;
        }
        boolean hasGetter = this.searchGetterFor(propertyName);
        propertyMap.put(this.getClass().getName() + '#' + simpleProperty, BooleanUtils.toBooleanObject((boolean)hasGetter));
        return hasGetter;
    }

    public boolean searchGetterFor(String propertyName) {
        Class type = null;
        try {
            type = PropertyUtils.getPropertyType((Object)this, (String)propertyName);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return type != null;
    }
}

