# Change Log
All notable changes to this project will be documented in this file.
This project uses the changelog in accordance with [keepchangelog](http://keepachangelog.com/). Please use this to write notable changes, which is not the same as git commit log...

## [unreleased][unreleased]

## [Frostbit] [2022-01-11]
 - Changed Wiegand format lookup - now case-insensitive (@iceman1001)
 - Added new standalone mode `hf_15SNIFF` - Same as `hf_14ASNIFF` standalone mode for RDV4 - flashmem (@startrk1995)
 - Added support for MIFARE DESFire application creation without authentication (@joswr1ght)
 - Changed drastically Hitag S ARM code to remove state machines and ease way to build new commands (@doegox)
 - Fixed Hitag S crypto mode with key or NrAr, fixed `lf hitag cc`, fixed pwd dump in hitagS dump with LKP (@doegox)
 - Changed `trace list -h` - textual change (@iceman1001)
 - Fixed `hf iclass config` - not get stuck when trying to make a keyroll config card (@iceman1001)
 - Changed textual output for iclass (@iceman1001)
 - Changed `hf iclass reader` to use NG (@iceman1001)
 - Changed various notes to have ToC and top links (@iceman1001)
 - Added option `lf gprox demod --raw` - now supports decoding of raw bytes (@iceman1001)
 - Added option `hf mf gview --pwd` - now supports user supplied password (@iceman1001)
 - Added option `--force` to `hf mfu rdb/wrbl` to force operation even if address is out of range (@doegox)
 - Added documentation for detailed usage of the Ultimate Magic Card (@doegox)
 - Changed HitagS trace record and parsing to deal with partial bytes and to check CRC8 (@doegox)
 - Added support for KS X 6924 (South Korea's T-money card) (@toucan12)
 - Fixed `hf 15 dump` - now correctly dumps 256 blocks w/o crashing the client (@iceman1001)
 - Changed `hf 14a sim -t 3` - anticollision for DESFire simulation now uses different RATS (@mosci)
 - Fixed `hf mfdes` - works with dynamic apdu and encode/decode buffers (@merlokk)
 - Added luascript `hf_ntag_bruteforce.lua` - ntag password bruteforce with the option to do NFC Tools MD5 versions of passwords (@keldnorman)
 - Added option `--crc-ht` to `lf cmdread` to compute and add CRC-8/HITAG (@doegox)
 - Added option `-k` to `lf cmdread` to keep field on (@doegox)
 - Added `hf mf acl` - decode and print MIFARE access rights (@iceman1001)
 - Added for readline, <tab> autocomplete work inside pm3 client (@iceman1001)
 - Fixed `hf iclass dump` - now uses the right key when suppling credit key (@iceman1001)
 - Changed crc16_legic to be supported in lua (@iceman1001)
 - Changed `trace list -t 14a` - now annotate magsafe wupa (@iceman1001)
 - Added magsafe polling (thanks to @tcprst !) (@iceman1001)
 - Changed `trace list -t 14a` - now annotate ECP (@iceman1001)
 - Added enhanced contactless polling (thanks to @relays user at gitlab) (@iceman1001)
 - Added iCS key (@FlUxIuS)
 - Changed `trace list -t 14a` - now annotate ULC when known key is used in auth (@doegox)
 - Fixed `hf mfu cauth` - option -k collision, used both for key and keep (@doegox)
 - Changed Dockerfiles, instructions, tests and CI to cover Python script within client (@doegox, @gator96100)
 - Changed `hw version` - now works offline too and provides client info (@doegox)
 - Added trace of VISA Apple transactions (thanks @a66at)
 - Added trace of reading a MIFARE UL-C with 3DES authentication (thanks @rad1game)
 - Added ATR fingerprinting (@iceman1001, @doegox)
 - Fixed DesFIRE decoding when not using wrapped cmds (@colinoflynn)
 - Added script to build all firmware variants (@doegox, @sbrun)
 - Fixed `hw tune` voltage values when no antenna is connected (@mwalker33)
 - Fixed `hf mf dump/auto/csave` MFC JSON dumps - save real ATQA/SAK (@doegox)
 - Fixed dynamic-stack-buffer-overflow in ndefDecodePayload (@AxisRay)
 - Added option to load raw NDEF to `nfc decode` command (@doegox)
 - Added option to save raw NDEF to all `hf * ndefread` commands (@doegox)
 - Changed `hf 14a info` - different FUDAN clone detection (@iceman1001)
 - Added `CROSS_CC` and similar args for maintainers, see Maintainers.md (@doegox)
 - Fixed crack5opencl - fix deadlock in wu_queue_destroy() + minor changes on threads.c (@matrix)
 - Fixed 14a incorrect BCC when multiple tags (@AxisRay)
 - Added additional support for macOS users utilizing MacPorts (@linuxgemini)
 - Fixed Windows USB prioritization (@gator96100)
 - Fixed `hf mfdes` - fix buffer overflow (@AxisRay)
 - Changed `hf mfdes` - detect LRP mode and info updates (@merlokk)
 - Fixed `hf mfdes` - increase response buffer length (@merlokk)
 - Fixed `SimulateTagLowFrequencyEx` ignoring the `ledcontrol` argument (@zabszk)
 - Added ledcontrol argument to LF operations (@zabszk)
 - Added new standalone mode `dankarmulti` -  select and run multiple standalone modes (@dankar)

## [crimson.4.14434][2021-09-18]
 - Fixed `hf mf staticnested` - flashmem / non loop now works (@horrordash)
 - Fixed `hf 15 restore` write command and `trace list -t 15` write command (@doegox)
 - Changed default standalone mode to LF_SAMYRUN (@iceman1001)
 - Added MIFARE Plus SL3 mode traces (@iceman1001)
 - Fixed PAC/Stanley checksum calculation (@rknoll)
 - Added option --mem to `hf mf nested`, from icopyx source (@doegox)
 - Added fpga-xc3s100e and icopyx source code specificities to this repo (@doegox)
 - Changed `hf mfdes` - Transactions. commit, abort, commit reader id. (@merlokk)
 - Changed `hf mfdes` - LRP secure channel for Desfire Light. (@merlokk)
 - Changed `hf mfdes` - commands refactoring. now fully works: des,2tdea,3tdea,aes keys with d40,ev1,ev2 channels and native/nativeiso/iso command sets(@merlokk)
 - Changed `lf em 410x *` - now better text (@clach04)
 - Fixed `hf mfu dump` - now sets keytype correct #1426 (@axisray)
 - Added new standalone mode `hf_mfcsim` which can load dump from flash and simulate Mifare Classic 1K card (@axisray)
 - Added support to demodulate Electra tags and column parity check for EM410x (@doegox)
 - Fixed demod plot for various demodulations (@doegox)
 - Fixed `lf t55xx detect/rdbl/dump` - to override if user set `lf config` and use default values during operation (@iceman1001)
 - Added `hf iclass encode --wiegand/--fc/--cn` - direct fmt/fc/cn support (@bettse)
 - Fixed `lf t55xx detect` - to unset lf config decimation if value is not one (@iceman1001)
 - Fixed `hf 15 sample` - data collection works again (@iceman1001)
 - Changed `data plot -h` - removed line (@doegox)
 - Fixed `lf_tharexde` - double define of global variable (@axisray)
 - Added new standalone mode `lf_hidfcbrute` - bruteforce facility code (@ss23)
 - Changed `hf felica info` - got more ic chip definitions (@ah01)
 - Changed `lf pyramid demod` - relaxed the size check (@iceman1001)
 - Changed `hf emrtd info` to view DG5 picture (@iceman1001)
 - Added `-4041x` option to lf indala clone for the Indala 4041X format (@chunkystew)
 - Added a new client preference,  delay of execution,  a delay in ms before a cmd is sent. Good for implants (@iceman1001)
 - Fixed `lf t55xx brute` - now correctly prints last key if it was correct (@scott4290)
 - Added support python scripts (@salmg)
 - Added new standalone mode `hf_reblay` -  relay 14a over bt (@salmg)
 - Added one new key from gun cloner found in wild (@scott4290)
 - Fixed `hf_msdsal` standalone in simulation flow (@salmg)
 - Added a picture viewer in QT. To be used with `hf emrtd info` (@iceman1001)
 - Fixed - move des functions to libcrypto (@merlokk)
 - Added `CLIGetOptionList` to cliparser that makes it easier to implement text options in the cli (@merlokk)
 - Added experimental support for macOS users utilizing MacPorts instead of Homebrew (@linuxgemini)
 - Added `pm3_online_check.py` - a script to verify and initialize a Proxmark3 RDV4 device (@iceman1001)

## [midsummer.4.13441][2021-06-25]
 - Fixed `hf iclass` - a crash when AA1 limit was larger than AA2 (@pcunning)
 - Added bruteforce function for the magic byte in `cmdlfnexwatch.c` and ability to clone with psk2 modulation (@Guilhem7, @MaximeBosca)
 - Changed `hw setmux` - improve user feedback for special case (@iceman1001)
 - Changed 'filename' - unified file name param across client (@iceman1001)
 - Fixed `lf em 4x05 brute/chk` - fixed input params crash (@iceman1001)
 - Fixed `lf hitag reader --23` - now accepts 6bytes key (@iceman1001)
 - Fixed coverity scans findigs (@merlokk, @iceman1001)
 - Fixed `hf iclass config` - now fallback to default config card configuration (@iceman1001)
 - Changed `nfc parser` - now also identify xvcard types (@iceman1001)
 - Added `hf mf gview` - view contents of a magic Gen3 GTU (@iceman1001)
 - Added Standalone mode for nexwatch ID credentials (@Guilhem7, @MaximeBosca)
 - Fixed `lf em 4x50/4x70 *`  reverted a misunderstanding in byte order macros (@iceman1001)
 - Added more keys (@equipter)
 - Changed `hf nfc ndefread` - ndef parser now handles more types (@iceman1001)
 - Fixed `hf desfire` changekey, GetUID, 3DES session key tweak. (@mwalker33)
 - Fixed `hf fido` commands now works correctly (@merlokk)
 - Moved / renamed  `client/resource/fido2_defparams.json` ->  `client/resource/hf_fido2_defparams.json` (@merlokk)
 - Added `hf cipurse` commands to work with cipurse transport cards (@merlokk)
 - Added `--gap` option to lf em 410x sim for more control over sim data (@mwalker)
 - Changed `hf fido` - refactored load/save json objects (@iceman1001)
 - Moved / renamed  `fido2.json` ->  `client/resource/fido2_defparams.json` (@iceman1001)
 - Added openocd shikra support based on @ninjastyle82 patch to deprecated iceman fork (@iceman1001)
 - Changed `hf lto info` - now decode more of LTO CM info (@iceman1001)
 - Added `HF_TMUDFORD` standalone mode that reads and emulates ISO15693 UID (@tmudford)
 - Changed `hf mf wipe` - now supports enforcing sector 0 / block 0 writes (@iceman1001)
 - Added `data asn1` - a command to decode ASN1 byte arrays  (@iceman1001)
 - Added `hf 15 disableprivacy` - from @g3gg0 fork *WIP* (@iceman1001)
 - Added `lf_ident_json.lua` - script to identify t55xx json dump files (@iceman1001)
 - Fixed `hf iclass chk` -  multithread concurrency issues solved (@iceman1001)
 - Fixed hf_iceclass standalone - correct null terminator filename (@metalauricle)
 - Changed `trace list -t mfdes - added annotations for EV2, EV3 (@iceman1001)`
 - Changed `hf iclass lookup` - fixed swapped args (@iceman1001)
 - Changed `hf iclass decrypt` - added the possibility to decode the data as block6 if you have a cardhelper (@iceman1001)
 - Changed `weigand decode` - removed -p param since we wanna see all encodings anyway (@iceman1001)
 - Changed `wiegand decode` - when bin string is supplied, use that exact length instead (@iceman1001)
 - Added a bunch more wiegand formats (@iceman1001)
 - Added `lf idteck clone` - now supports creating using raw values (@iceman1001)
 - Changed calypso scripts to work with NG (@iceman1001)
 - Changed HF 14b - fixed timings on device side (@iceman1001)
 - Changed `hf 14b raw` - now uses NG (@iceman1001)
 - Changed `hf 14a/14b/15 list etc alias commands now unified helptext (@doegox)
 - Changed `trace list` - now colors whole reader line (@iceman1001)
 - Changed `lf search` - add option `-c` to continue searching after first hit (@doegox)
 - Fixed DESFire mis-annotation (@VortixDev)
 - Changed `lf pac demod` - now also search for inverted bitstreams (@iceman1001)
 - Changed `hf 14b reader` - now supports continuous mode (@iceman1001)
 - Fixed `hf search` - now doesn't false identify ISO15693 (@iceman1001)
 - Changed emv commands now works with tokenized cards (@merlokk)
 - Changed `hf 15 restore` - now also support EML/JSON (@iceman1001)
 - Changed - all commands now use cliparser (@iceman1001)
 - Changed `lf t55xx restore` - now also support JSON (@iceman1001)
 - Changed `hf mf csetuid` - adapted to accept 7byte uids ~untested~  (@iceman1001)
 - Added `hf mf view/eload/cload` - now accepts bin/eml/json  (@iceman1001)
 - Added `hf mf eload/cload' - now accepts bin/eml/json  (@iceman1001)
 - Fixed RESTORE mis-annotation (@VortixDev)
 - Changed `smart raw` - now uses NG (@iceman1001)
 - Added `hf iclass configcard` - now can download / generate config card dumps with a cardhelper [WIP] (@iceman1001)
 - Fixed swapped DESELECT and WTX annotations (@VortixDev)
 - Fixed `hf 15 findafi` - cliparser bug, and loop is user interruptible (@iceman1001)
 - Added `hf mf wipe` - takes a keyfile and wipes a MFC to default values (@iceman1001)
 - Changed `pm3 shell` - now prioritize USB connections in WSL1 (@gator96100)
 - Added `hf mf restore -w` - now supports usage of specified keyfile to authenticate with instead of default FFFFFF key (@iceman1001)
 - Added `mem info --pem`- now supports loading of private key in PEM format (@iceman1001)
 - Changed `hf mfp auth` - more verbose message (@vortixdev)
 - Fixed `hf mfdes rd` - AES chained mode fixes (@anon)
 - Added `weigand decode -b` - now supports binary wiegand string as input (@iceman1001)
 - Updated `README.md` - new link to a GUI project,  and textual update (@iceman1001)
 - Changed `hf search` - reenabled FeliCa search (@iceman1001)
 - Changed `auto -a` - now allows for keep on searching, useful when detecting unknown multi tech cards (@iceman1001)
 - Added more aid (@anon)
 - Changed `hw version` - now also looks for FPGA chip id match (@iceman1001)
 - Added WSL checks for outdated bootloader (@gator96100)
 - Changed many, many more commands uses cliparser (@iceman1001)
 - Changed many many cppchecker fixes (@iceman1001)
 - Changed some coverity scan fixes (@iceman1001)
 - Added `hw break` - to break device side loops from client (@iceman1001)
 - Changed `hf mf sim` - removed field detection on device side (@iceman1001)
 - Changed `mf_nonce_brute` - to recover key for nested authentications from traces (@iceman1001)
 - Changed `trace list -t mf` - now prints needed data for mf_nonce_brute (@iceman1001)
 - Fixed `trace list -t mf` crc overwrote first hex char (@iceman1001)
 - Fixed `trace list -t mf` to print correct parity "!" (@doegox)
 - Fixed `lf em 4x05 unlock` not to break when tear off happens (@doegox)
 - Fixed `mem spiffs view` to not print when file doesn't exist on flash mem (@iceman1001)
 - Changed `hf mf rdsc, egetsc, cgetsc` to have unified output (@iceman1001)
 - Changed `hf mf rdsc` output to be more clear (@iceman1001)
 - Changed `mem dump -c` now supports optional column breaks of output (@iceman1001)
 - Changed unified client menu's to use curly brackets to indicate a sub category (@iceman1001)
 - Added `mem spiffs view` to view external flash memory (@iceman1001)
 - Fixed 'lf t55xx config, chk, bruteforce' some logic to got mixed up in cliparser conversion (@mwalker33)
 - Moved countones / bitcount fcts to utils.c (@doegox)
 - Changed tunings in `hf mfu opttear` (@doegox)
 - Updated the text in T5577_Guide.md to match new output (@iceman1001)
 - Added a new t55xx configblock found in the wild (@iceman1001)
 - Added `mem info -d` to support manual input of data (@iceman1001)
 - Fixed 'lf t55xx detect' some logic to got mixed up in cliparser conversion (@mwalker33)
 - Added `HF_CRAFTBYTE` standalone mode that reads and emulates 14a UID (@craftbyte)
 - Added cryptoRF trace (@iceman1001)
 - Changed default tcp port to 18888  (@iceman1001)
 - Added more default keys to MFC dictionary (@iceman1001)
 - Added one more icode slix2 signature to recover_pk.py (@iceman1001)
 - Changed C15001 format to use OEM = 900 by default (@iceman1001)
 - Added a script to dump originality signatures from MFU EV1s and NTAGs (@aveao)
 - Fixed `hf emrtd` segfaults (@aveao)
 - Fixed `lf em 4150` timings on device side (@tharexde)
 - Changed dependencies fixes in build scripts (@doegox, @iceman1001, @gator96100)
 - Changed `recover_pk.py` to support colors (@iceman1001)
 - Changed flashing feedback text to include needed steps (@iceman1001)
 - Changed `lf_em4100_bulk.lua` in order to handle Proxspace odd 32b limit (@iceman1001)
 - Added `script run lf_em4100_bulk.lua` a EM4100 bulk enrolling script (@iceman1001)
 - Changed amiitool now linked, compiles in cmake,  and outlined code usage in cmdhfmfu.c (@iceman1001)
 - Changed `hf mfu info` - to have a fingerprint fct (@iceman1001)
 - Added parsing of EF_CardAccess to display PACE algorithm, version and parameter in `hf emrtd info` (@aveao)
 - Changed numerous commands more uses cliparser (@tcprst, @iceman1001)
 - Added more originality public keys (@anon)
 - Added `hf 14a info` - now also verify MFC Ev1 signatures (@iceman1001)
 - Added `LF_THAREXDE` standalone mode which simulates and reads EM4x50 cards (@tharexde)
 - Added `hf jooki` commands (@iceman1001)
 - Changed `lf hid clone` - also accepts binary wiegand (@iceman1001)
 - Changed `wiegand encode` - format param is now optional, w/o it will try encode all formats (@iceman1001)
 - Fixed cppchecker warnings (@iceman1001)
 - Added `trace list -t mf` - now can use external dictionary keys file (@McEloff)
 - Fixed `lf gallagher read` - now correctly decodes card data
 - Added support to `lf gallagher clone` and `lf gallagher sim` for writing specific card region, facility, card & issue numbers (@DarkMatterMatt)
 - Added support for older vid/pid detection (@Gator96100)
 - Added `hf mfdes bruteaid` - proper bruteforce of DESFire AID when no reading of files is possible (@craftbyte)
 - Added support for bidirectional communication for `lf em 4x50 sim` (@tharexde)
 - Changed `PLATFORM=PM3OTHER` to `PLATFORM=PM3GENERIC` (@iceman1001)
 - Added `tools/hitag2crack/crack5opencl`, an optimized version of `crack5gpu` (@matrix)
 - Fixed Makefile to account for changes when running on Apple Silicon (@tcprst)
 - Added support for debugging ARM with JTAG & VSCode (@Gator96100)
 - Added MFUL "Gen1b" support to `hf_mfu_setuid.lua` (@iceman1001)
 - Added possibility to get bargraph in `lf tune` and `hf tune` (@iceman1001, @doegox)
 - Added `hf emrtd` ePassport dumping and parsing (@aveao)
 - Added `aidsearch` to `hf 14b info` (@iceman1001)
 - Added `ICE_STATE_DUMP_SIM` - standalone mode for dumping/simming one iClass tag (@iconicsec)
 - Added  `lf em 4x50 eview` - show uploaded EM4x50 data in emul memory (@tharexde)
 - Fixed `data rawdemod` parsing for psk2 and user defined clock (@cyberpunk-re)
 - Added `hf iclass encode` - encode a wiegand binary to a encrypted credential (@iceman1001)
 - Changed `recoverpk.py` - now tests more ECDSA curves (@doegox)
 - Added `hf 14a apdufuzz`- a naive apdu cla/ins/p1p2/len fuzzer (@iceman1001)
 - Improved `hf 14a apdufuzz/apdufind` to find hidden APDUs (@ikarus23)
 - Fixed mixed up INC/DEC in MIFARE protocol defs (@vortixdev)
 - Added `lf em 4x70 info` - new support for ID48 transponders (@cmolson)
 - Fixed multiple coverity scan issues (@iceman1001)
 - Added a SIO item (@iceman1001)
 - Fixed `lf hid brute` - param (@iceman1001)
 - Changed `lf em` layouts (@iceman1001)
 - Changed many commands to cliparser (@iceman1001, @tcprst, ...)
 - Fixed issue #844 - `lf t55xx config` => recompute block0 (@cyberpunk-re)
 - Changed `lf em 4x50` - changed cli parameter from w (word) to d (data) (@tharexde)
 - Added `lf em 4x50 login` - authenticate against tag (@tharexde)
 - Added `lf em 4x50 brute` - guess password within a given password range (@tharexde)
 - Added `lf em 4x50 chk` - try passwords from dictionary (without option -> T55xx default dictionary or -f user dictionary) (@tharexde)
 - Added `lf em 4x50 reader` - read data from tag (configured data -> standard read mode), incl. option -@  (@tharexde)
 - Added `lf em 4x50 sim` - simulate dump from file or emulator/flash (@tharexde)
 - Added `lf em 4x50 restore` - restore dump file (bin, eml, json) onto tag  (@tharexde)
 - Added `lf em 4x50 esave` - dump em4x50 content in emulator memory to file (bin + eml + json) (@tharexde)
 - Added `lf em 4x50 eload` - upload em4x50 file content (bin, eml, json) to emulator memory  (@tharexde)
 - Changed EM4x50 - added LED signals (@tharexde)
 - Changed `lf em 4x50 dump` - now support json format (@tharexde)
 - Changed `lf em 4x50 wipe` - relocated write requests from device to client (@tharexde)
 - Renamed `lf em 4x50 write_passwordd` -> `writepwd` (@tharexde)
 - Changed `lf em 4x50` - all hex input parameters now have to be given in lsb format (output is still msb + lsb) (@tharexde)
 - Changed `lf em 4x50` - changed cli parameter from a (address) to b (block) (@tharexde)
 - Changed `lf em 4x50` - now supports cliparser (@tharexde)
 - Changed EM4x50 - stabilized and accelerated tag detection (@tharexde)
 - Changed EM4x50 - removed global tag structure on device side (@tharexde)
 - Fixed `hf 15 sim` - Added basic response to GET_SYSTEM_INFO and READBLOCK requests in order to fix iso15693 tag sim (@cyberpunk-re)
 - Added `mf mfu sim t 7 n <numreads>` - MFU emulation now supports automatic exit after <num> blocks read. (@cyberpunk-re)
 - Added T55xx Guide to assist in learning how to use the T55xx chip (@mwalker33)
 - Fixed `hf iclass wrbl` - dealing with tags in unsecured vs secured pagemode now is correct (@iceman1001)
 - Changed many commands to cliparser (@iceman1001, @tcprst, @mwalker33,...)
 - ...
 - Changed `hf iclass chk/lookup/loclass` speedups (@iceman1001)
 - Changed - ongoing conversion to cliparser (@tcprst, @iceman1001)
 - Added compilation options for 256k Proxmark versions, see doc (@doegox)
 - Added support for 10b UID in `hf 14a sim` (@doegox)
 - Added `HF_TCPRST` standalone mode which read and emulate IKEA Rothult cards (@tcprst)
 - Added Gallagher key checking/KDF on MIFARE Desfire (@NZSmartie)
 - Added dictionaries with common words of proper size (@will-caruana)
 - Added `hf mf supercard` (@iceman1001)
 - Added initial support for MIFARE Key Diversification, cf AN10922 (@NZSmartie)
 - Changed MIFARE detection improved (@VortixDev)
 - Changed `hf 14b sriread` to `hf 14b rdbl` and `hf 14b dump` (@iceman1001)
 - Added continuous mode to `hf 14a reader` (@doegox and @iceman1001)
 - Added `lf em 4x05_sniff` to allow extracting commands and passwords used be cloners. (@mwalker33)
 - Removed 'hf iclass replay' -  use the 'hf iclass dump' or 'hf iclass rdbl' with option "n"  instead (@iceman1001).  Concept taken from official repo (@pwpiwi)
 - Added Destron FDX-A support (@doegox and @iceman1001)
 - Added `lf em 4x05_chk` (@iceman1001)
 - Added `lf em 4x05_unlock` tear-off (@doegox and @iceman1001)
 - Added customizable 3DES key to hf mfu cauth (@socram8888)
 - Added generic `hw tearoff` and hooks in various write commands (@doegox and @iceman1001)
 - Added protect support for EM4x05 and fix various EM4x69/EM4x05 aspects (@doegox and @iceman1001)
 - Added incognito option to client to avoid mangling history & logs (@doegox)
 - Added option to hide/show plot sliders (@mwalker33)
 - Added "</>" key bindings to realign demod plot on samples (@doegox)
 - Added "T" key binding to trim plot (@doegox)
 - Added units options to `data timescale` (@doegox)
 - Added mouse scrolling to pan & zoom to plot (@doegox)
 - Added hf_14b_mobib Lua script (@iceman1001)
 - Added ASK CTx detection to hf 14b reader (@iceman1001 and @doegox)
 - Added low level support for 14b' aka Innovatron (@doegox)
 - Added doc/cliparser.md (@mwalker33)
 - Added `hf 14b apdu` - send APDU over ISO14443B (@iceman1001)
 - Added `lf t55xx chk e <EM4100> option` - Checks calculated password based on the EM4100 id from some white cloners formula by paleopterix (@mwalker33)
 - Added `lf t55xx sniff` to allow extracting commands and passwords used be cloners. (@mwalker33)
 - Added options to `lf read`, `lf cmdread`, `lf sniff` for repeated acquisitions (@doegox)
 - Changed options of `lf read` to match `lf cmdread`, this affects historical `d` and `s` options (@doegox)
 - Added `hf waveshare` to upload picture to Waveshare NFC-Powered e-Paper (@doegox)
 - Added `hf 14a config` to deal with badly configured cards: invalid ATQA/BCC/SAK (@doegox)
 - Added Mikron JSC Russia Ultralight EV1 41 pages tag type support (@McEloff)
 - Added test for Ultralight gen2 magic 'hf search' (@McEloff)
 - Added test for Ultralight EV1 gen2 magic 'hf search' (@McEloff)
 - Added `hf mf gen3*`magic gen 3 card operations (@McEloff)
 - Re-added verichip command which seems missing (@iceman1001)
 - Fixed missing t55x7 config block detection (@iceman1001)
 - Fixed missing define on proxspace (@mwalker33)
 - Added `lf em 4x50_dump` (@iceman1001)
 - Added `lf em 4x50_read` (@tharexde)
 - Added `lf em 4x50_info` (@tharexde)
 - Added `4x50_write` (@tharexde)
 - Added `4x50_write_password` (@tharexde)
 - Fixed em4x50 demodulation error (@tharexde)
 - Fixed `hf mfdes` authentication issues, DES working (@bkerler)
 - Added Android cross-compilation to client cmake (@dxl, @doegox)
 - Fixed `emv scan` - now saves in current folder and uses unique names (@iceman1001)
 - Fixed pm3.sh - parse COM ports larger than one digit (@doegox)
 - Fixed stack size and automatically use available space for BigBuf. Stack is now 5K (@slurdge)
 - Added Mifare MAD Card Holder Information decoding (@lukaskuzmiak)
 - Changed Better precision for HF and LF voltage measurements and Add theremin.py script (@rosco)
 - Added Mifare MAD Info Byte decoding. Easier to identify Card Publisher (@lukaskuzmiak)
 - Changed use system Bzip2 library instead of Zlib for hardnested tables, tables are now 7x smaller (@doegox)
 - Changed pushed some ARM source to compile with THUMB.  Saves a lot of space of ARM flash memory (@slurdge)
 - Changed from using ZLIB compression of FPGA images in ARM to LZ4.  15%+ speedups when swapping between HF & LF now (@slurdge)
 - Fixed `emv scan -w` - hash mismatch, solution similar to below (@iceman1001)
 - Fixed 'emv roca' - hash mismatch, merged from official repo (@pwpiwi)
 - Fixed 'lf ti demod' - now calculates correct crc (@iceman1001)
 - Added Python3 as possible script engine (@iceman1001, @doegox)
 - Added doc/mfu_binary_format_notes.md (@iceman1001)
 - Fixed `hf mfu dump` - now reads Ulev1 3counter vs NTAG 1 counters (@iceman1001)
 - Fixed `hf mfu info` - now print correct cfg1 - nfc protection (@iceman1001)
 - Fixed `hf mfu eload` - now detects and converts between plain/old/new mfu binary format (@iceman1001)
 - Changed hitag2crack now integrated into main Makefile, tests added (@doegox)
 - Added `make check` mechanics (@doegox)
 - Changed log files moved to subfolders (@doegox)
 - Changed use system Lua library if available (@doegox)
 - Changed use system Jansson library if available (@doegox)
 - Changed use system Whereami library if available (@doegox)
 - Changed use system Zlib library if available (@doegox)
 - Fixed release version information (@doegox)

## [ice coffee.4.9237][2020-05-21]
 - Updated documentation (@doegox, @iceman1001)
 - Changed `pm3test.sh` - more regression tests to  (@doegox, @iceman1001)
 - Changed `hf 15 dump` - now supports basic json format (@iceman1001)
 - Changed Test and fix many `-Wxxxxxx` warnings [compiler trials] (@doegox)
 - Fixed COVERITY warnings [compiler trials] (@doegox, @iceman1001)
 - Fixed CPPCHECKER warnings [compiler trials] (@doegox, @iceman1001)
 - Fixed CLANG warnings [compiler trials] (@doegox)
 - Changed stricter warnings [compiler trials] (@doegox)
 - Changed remove section version_information for client (@doegox)
 - Changed Add RELEASE_NAME (@doegox)
 - Changed version info also for client (@doegox)
 - Added `make release` (@doegox)
 - Changed `trace load` - err if offline mode (@doegox)
 - Fixed `standalone mode matty_run` eloadcard (@iceman1001)
 - Added, HF 15 traces (@FlUxIUS)
 - Fixed follow naming conventions [android] (@dxl)
 - Changed work directory supported [android] (@dxl)
 - Added `lf fdx demod` - decoding of Bio-Thermo lf tag. Thanks to Rosco! (@iceman1001)
 - Fixed  32-bit time_t compilation error on [WIN64] (@grspy)
 - Changed LogTrace error msg (@doegox)
 - Changed remove inline [compiler trials] (@iceman1001)
 - Changed adding execute/home/current working directory functions to lua (<@iceman1001)
 - Changed fix max duration in LogTrace (@doegox)
 - Changed first attempt for trace log header (@iceman1001)
 - Changed pm3.sh, attempt to detect BT dongle when udevadm is not available (@doegox)
 - Changed pm3.sh, test access to /dev/ttyXXX files as prerequisite for [linux] (@doegox)
 - iclass bf: avoid slowdown (@doegox)
 - Changed pm3tests.sh, shellcheck (@doegox)
 - Changed pm3.sh, shellcheck (@doegox)
 - Changed pm3.sh, err msgs on stderr (@doegox)
 - Changed pm3.sh, textual and --list with no device, exit 1 (@doegox)
 - Changed pm3.sh, without udev: change detection routine (@doegox)
 - Changed pm3.sh, alternative if udevadm is not available [termux] (@doegox)
 - Changed `makefiles` - allow to skip pthread [termux] (@doegox)
 - Changed `script run test_t55x7` - enabled param to swap modulation to test (@iceman1001)
 - Added mf_nonce_brute from https://github.com/@iceman1001/mf_nonce_brute and merge to pm3 Makefile (@doegox)
 - Changed `lf indala demod` - more lenient size check (@iceman1001)
 - Changed clarify BUTTON macro usages (@doegox)
 - Changed fix REV macros & hitagS (@doegox)
 - Changed `hf iclass loclass` -removed printvar function (@iceman1001)
 - Changed clock can be negative  (@iceman1001)
 - Changed `data tune` (@doegox)
 - fancy timers (@doegox)
 - Changed copied from pm3 repo (@iceman1001)
 - Changed psk demodualtion, keep starting samples to easily find the zero init bit (@iceman1001)
 - Changed use machine/endian.h with osx (Jamie Fiedler)
 - Fixed 2 issues in proxendian.h (@doegox)
 - Fixed issue #729. Avoid stalling on non-rdv4 when polling for FeliCa without card in proximity (@doegox)
 - Changed `lf nexwatch demod` - lenient demod sizes (@iceman1001)
 - Changed `lf nexwath sim/clone` - now supports 88bit format direct. (@iceman1001)
 - Rewritten `standalone mode lf_em4100rwc `, added card bruteforce mode. (Dmitriy Loginoov)
 - Changed `data load` - color (@iceman1001)
 - Changed appveyor verbose (@doegox)
 - Changed `lf nexwatch demod` - now detects type, and show parity /chksum (@iceman1001)
 - Changed `lfsampling` - interruptible only when logging not yet triggered (@doegox)
 - Changed `lf keri demod` - more leanient when it comes to bits (@iceman1001)
 - Fixed proper filtering of RL markers (@doegox)
 - Changed clean deps [compiler trials] (@doegox)
 - Changed remove c99 restrictions [compiler trials] (@doegox)
 - Added tracelog file for hf mfu sniff or a ntag (@iceman1001)
 - Changed `trace list` - different alloc (@iceman1001)
 - Changed convert OLD -> MIX  (@iceman1001)
 - Changed `trace list` - adjust messages (@iceman1001)
 - Fixed a mem corruption in `trace load/list` (@doegox)
 - Changed rework banners (@doegox)
 - Changed Let's see if the prompt suffixed spaces are still needed.(@doegox)
 - Fixed colored readline prompt bug (@doegox)
 - Changed simpler ul_print_type (@doegox)
 - Fixed cmake for reveng [compiler trials] (@doegox)
 - Changed hook reveng outputs to pm3 machinery, add regression test (@doegox)
 - Changed cmake android: add backslashes for host compatibility [compiler trials](@doegox)
 - Changed Translation some comments from Chinese to English. [android] (@dxl)
 - Changed cmake android: use common cmake files for deps [android] (@doegox)
 - Fixed proper way to fix reveng getopt bug(@doegox)
 - Changed cmake deps: add prefix pm3rrg_rdv4_  [compiler trials] (@doegox)
 - Changed cmake deps: add -fPIC so they can be integrated in a pm3 shared lib [compiler trials] (@doegox)
 - Changed platform adaptation [android] (@dxl)
 - Changed don't mix ifdef and defined [android] (@dxl)
 - Fixed `trace list`- too short array for explanation (@iceman1001)
 - Changed check for sim module fw file (@iceman1001)
 - Changed rpi aling warning [compiler trials] (@iceman1001)
 - Changed more LF demodulation tests (@iceman1001)
 - Changed update whereami and avoid compiling unnneded troublesome parts [compiler trials] (@doegox)
 - Changed rework C includes in C++ [compiler trials] (@doegox)
 - Changed leanient parsing of tcp:/bt:/socket: vars (@iceman1001)
 - Changed add bluetooth group to `make accessrights` (@iceman1001)
 - Changed `Makefile` - fix PKG_CONFIG_ENV (@uli)
 - Changed `f sim` - now only fills until bigbuffer is full (@iceman1001)
 - Changed `hf mf hardnested` - don't drop field when in test mode (@doegox)
 - Changed `lf sim` - better to return err on faulty offset, thanks @iceman (@doegox)
 - Changed `lf sim` - fix offset of last packet (@doegox)
 - Changed `client Makefile` - make sure to rebuild deps when needed [compiler trials](@doegox)
 - Changed silent err if dbus absent [linux] (@doegox)
 - Changed `pm3.sh` - for direct bt devices (@doegox)
 - Changed `pm3.sh` - moved WSL/PS3.x bt native to be tested first. Since call to Win32_serialport crashes it. (@iceman1001)
 - Changed `pm3.sh` - Bt dongle, bt direct listing of serial ports on WSL and PS3.x,  now using powershell.exe since wmic is deprecated (@iceman1001)
 - Changed remove libsndfile (@doegox)
 - Changed enforce PACKED structs [compiler trials] (@iceman1001)
 - Changed adjust number of threads according to cpu (@iceman1001)
 - Changed `hitag2crack` compile flags(@doegox)
 - Changed msdsal fix bug after var de-shadowing (@doegox)
 - Changed lighter msg for loading prefs, json will anyway always tell the filename (@doegox)
 - Changed make sure colors and emoji are disabled when not on TTY (@doegox)
 - Added `pref` command. PM3 client now support user preferences saved to a json file. (@mwalker33)
 - Added native support for Bluetooth in client [linux] (@doegox)
 - Added `LF_EM4100RSWB` (based on `LF_EM4100RWC`) standalone mode to read/sim/clone/brute EM4100 cards (@Monster1024)
 - Added `HF_MSDSAL` standalone mode which read and emulate Visa EMV cards (@Netxing)
 - Added `hf mfu tear` - Mifare Ultralight tear off experiment (@cintainfinitam, @fukmar)
 - Added Mifare Desfire Read/Write/Create files/records/values functionality and several fixes to `hf mfdes` (@bkerler)
 - Added CreateStdFile command to Mifare `hf mfdes` (@bkerler)
 - Rework des/3des/3k3des/aes auth. Port to mbedtls crypto library on device (@bkerler)
 - Port `hf mfdes` Auntentication to CommandNG structure, fix auth session key (@bkerler)
 - Updates `hf mfdes` functions, improved logging and added new commands (@bkerler)
 - Updated 'legic.lua' and 'legic_clone.lua' script - works with current command set (@Pizza_4u)
 - Rewrote `hf mfdes` functions and added apdu debugging (@bkerler)
 - Added Mifare Desfire GetDFNames and improve HF MFDES Enum output (@bkerler)
 - Fixed Mifare Desfire select appid handling (@bkerler)
 - Improved `hf 14a info` - card detection handling (@bkerler)
 - Updated helptext layout in all luascripts (@iceman1001)
 - Changed `hf mfdes info` - output and logging (@bkerler)
 - Updated texts in `hf legic` commands (@ikarus23)
 - Fixed timing bug inside 40x5 (@mwalker33)
 - Refactored all Hitag2 attacks (@doegox)
 - Added two new Hitag2 attacks (@doegox)
 - Changed `hf iclass decrypt` - limit amount of data to read if wrong app limit (@iceman1001)
 - Changed `hf search` - now continue to search in case of dual tech cards (@iceman1001) Thanks to @ikarus23 for the suggestion!
 - Added `hf topas info` - old reader command,  now also prints NDEF (@iceman1001)
 - Changed `hf topaz reader` - now only prints lighter info, like UID. (@iceman1001)
 - Changed `hf iclass readtagfile` - improved param handling (@iceman1001)
 - Changed `hf mfu ndef` - text record now correctly decode language code and test (@iceman1001) Thanks to @bettse!
 - Updated the helptexts for `hf iclass` commands (@iceman1001)
 - Fixed NDEF TLV lock / memory parsed correct (@merlokk)
 - Changed `mem spiffs` commands now parse h param correct (@iceman1001)
 - Added colour to `hf mf chk` and `hf mf fchk` (@dunderhay)
 - Changed - updated public keys info (@bkerler)
 - Changed - mfc default keys removed dublicates (@iceman1001)
 . Change - mfc default keys got new entries found on TagInfo app (@bkerler)
 - Added `hf mfu ndef` - read and decode NDEF Type2 messages (@iceman1001)
 - Added `data ndef` - decode NDEF messages (@iceman1001)
 - Changed - usb write's now waits for shiftregisters (@pwpiwi)
 - Changed - NDEF supports more signatures now (@iceman1001)
 - OSX Makefile now supports `make style` and `make checks` (@Pizza_4u)
 - Added `HF_LEGIC` standalone mode to read and simulate a Legic prime tag (@Pizza_4u)
 - Added keri MS decode/encode and update `lf keri clone` to support MS fc/cid cloning. (@mwalker33)
 - Fixed `hf mfdes enum` - now actually manages to enumerate files under all AID's. :smiley:  (@iceman1001)
 - Fixed `hf mfdes info` - now detects DESFire light and work properly Wrapped commands :+1: (@iceman1001)
 - :smiling_imp: support (@doegox)
 - Additional colour changes as recommended by @iceman (@dunderhay)
 - Changed type colour for `hf 14a` card types (@dunderhay)
 - Added colour to `hf mfdes` command (@dunderhay)
 - Added `HINTS` command.  Will turn off / on hint messages. Default mode is OFF.  (@iceman1001)
 - Added colour to `hf 14a` and `hf mfu` commands (@dunderhay)
 - Added colour to `lf hid` commands (@dunderhay)
 - Changed `script run hf_bruteforce -s start_id -e end_id -t timeout -x mifare_card_type` - The hf_bruteforce card script now requires Mifare type (mfc or mfu) (@dunderhay)
 - Updated `hf_bruteforce.lua` script - added support for brute forcing Mifare Ultralight EV1 cards (@dunderhay)
 - Added `hf mf personlize` - personalize the UID of a Mifare Classic EV1 card (@pwpiwi)
 - Changed - hint texts added to all lf clone commands (@iceman1001)
 - Changed `lf keri demod` - adjusted the internal id. (@mwalker33)
 - Added seamless integration with cryptohelper (@iceman1001)
 - Changed `lf hid brute` - new params for direction (UP/DOWN); textual and main loop actually exit. (@capnkrunchy and @iceman1001)
 - Fixed `lf hid brute` - made it work again (@capnkrunchy)
 - Fixed standalone mode HF_MATTYRUN - correct logic when all keys found in printing. partial fix  (@iceman1001)
 - Changed static nonce detection got tighter (@iceman1001)
 - Improved termux notes (@msoose)
 - Fixed `hf mf autopwn` - works on debian 10 *nix. Bad exit commands in hardnested (@iceman1001)
 - Fixed `hf mf hardnested` - bad mutex strategies (@msoose)
 - Changed `lf hitag` - now obeys `lf config` (@iceman1001)
 - Added all python 2 scripts to python 3 (@doegox and @sigwinch28)
 - Removed undefined exit behaviour from `analyzesize` tool: it now exits with code 2 when called with wrong args (@sigwinch28)
 - Replaced shebangs in scripts with more portable versions which use `/usr/bin/env` (@sigwinch28)
 - Added `hf lto restore` - restore LTO cartridge memory from dump file [.bin|.eml] (@Kevin-Nakamoto)
 - Added `LF_ICEHID` standalone mode which searches for lf HID credentials and store to RDV4 flashmem (@iceman1001)
 - Added `HF_14ASNIFF` standalone mode with storing trace to RDV4 flashmem (@micolous)
 - Added `hf lto dump` - dump 8160 bytes of data from LTO cartridge memory and save to file (@Kevin-Nakamoto)
 - Changed `data plot` - write serial port name in window title for plot / slider window (@iceman1001)
 - Added `hf lto wrbl` - write block support for LTO Cartridge memory (@Kevin-Nakamoto)
 - Fixed compilation under openSUSE (@hsanjuan)
 - Added `lf nexwatch sim` - use raw hex to simulate (@iceman1001)
 - Fixed `lf indala read` - long id 224bits preamble identification less strict (@iceman1001)
 - Added `hf mf staticnested` - useful when targeting the strange cards with a static nonce. (@iceman1001) Thanks to @xtigmh @uzlonewolf for their solutions.
 - Added `hf plot` (@pwpiwi)
 - Fixed `lf config` - when called with no params, it no longer mess up all device lf config settings. (@iceman1001)
 - Changed `lf indala clone` - new option `--Q5` writes to q5/T5555 tags. (@iceman1001)
 - Changed `lf indala clone` - new option `-c <card id>` allows cloning INDALA tag from Heden2L/Hedengren ID format (@iceman1001) - Thanks to @randomdude42 for solution
 - Changed `lf indala demod` - added decode Heden2L/Hedengren format (@iceman1001) - Thanks to @randomdude42 for solution
 - Added `commands.md` - document with all proxmark client commands. Generated with XX_internal_command_dump_markdown_XX. (@iceman1001)
 - Changed `lf pac clone` - new option `c <card id>` to allow cloning PAC/Stanley tag from card ID (@danshuk)
 - Changed `lf pac read` - decoded PAC/Stanley card ID (@danshuk)
 - Changed mifare classic keytable output refactored and uses colors (@iceman1001)
 - Fixed `hf mf nested` - now writes the correct blockno (@iceman1001)
 - Changed `lf t55xx dump` - now supports saving to JSON (@iceman1001)
 - Changed `hf mf chk | fchk`  faster authentication by lower timeout limit. (@pwpiwi)
 - Changed `hf mf hardnested` - now detects "static / fixed" nonce tags and exits (@iceman1001)
 - Changed `hf mf csave` - now uses UID in filename (@iceman1001)
 - Fixed `hf mf chk` - read block B logical error. #489 (@iceman1001)
 - Added `hf mf ekeyprn d` - new parameter to save keys to file (@iceman1001)
 - Added `mfu_magic.lua` - script to interact with your magic NTAG tag. (@iceman1001)
 - Added `hf_bruteforce.lua` - script bruteforces uid for 14a using hf 14a sim (@keld)
 - Added `tools\pm3_cs8.pl` - convert .pm3 files to wave format (@samyk)
 - Added `tools\pm3_amii_bin2eml.pl` - amiibo convering script (@samyk)
 - Changed `hf 14a info` - now detects "static / fixed" nonce tags (@iceman1001)
 - Changed `data save f <filename> w` - params reworked.  (@iceman1001)
 - Changed `hf search` - now should detect LTO-CM tags (@iceman1001)
 - Added `hf lto info` - skeleton support for LTO Cartridge memory (@iceman1001)
 - Added saving as wave format (@anon)
 - Added ISO15_WRITE annotation (@pwipiw)
 - Added `lto_dump.lua` @kevin
 - Added `hf mf cwipe` magic chinese card (gen1a) wipe to default state (@merlokk)
 - Added `pm3_mf7b_wipe.py` python script. Wipes magic S70 7B Gen2 card. (@vulnersCom)
 - Added `hf mfp chk` Mifare plus command for check keys from public keys list, from dictionary or 1 and 2-byte bruteforce (@merlokk)
 - Changed `hf 15` - some refactoring (@grspy)
 - Added `hf 15 writeafi` and `hf 15 writedsfid` (@grspy)
 - Added detailed info for SLIX2 tags in `hf 15 info` (@grspy)
 - Fixed `hf list felica` and `hf felica sniff` (@7homasSutter)
 - Added `hf felica wrunencrypted` (@7homasSutter)
 - Added `hf felica rdunencrypted` (@7homasSutter)
 - Added `hf felica rqresponse` (@7homasSutter)
 - Added `hf felica rqservice` (@7homasSutter)
 - Added polling for felica standard (@7homasSutter)
 - Added `lf t55xx dump save` and `lf t55xx restore` for .bin and .eml files (@mwalker33)
 - Added `lf t55xx detected` to try without password first (@mwalker33)
 - Changed `lf indala read` - added indala 26bit decoding (@martinbeier)
 - Changed `lf t55xx detect` to try without password first (@mwalker33)
 - Display high bit for detected Kastle HIDs to allow `lf hid clone [id]` to work properly (@swg0101)
 - Added option `-n` to scripts pm3* (@doegox)
 - Added `wiegand list/encode/decode` - wiegand format manipulation. Adapted to fit here. (@grauerfuchs)
 - Added support for color text on windows 10 (@mwalker33)
 - Added `s` <samples to skip> to `lf config` / `lf sniff` to skip samples when sniffing based on same option in Proxmark/proxmark3 by @marshmellow42. (@mwalker33)
 - Added save to .eml and .bin for `em 4x05_dump` (@mwalker33)
 - Added option `-n` to scripts pm3* (@doegox)
 - Fixed `em 4x05_dump` to print all blocks read (@mwalker33)
 - Fixed T55xx config getting displayed when using password when no password needed on read. (@mwalker33)
 - Added T55x7 downlink mode auto usage via mode detected (lf t55 detect) (@mwalker33)
 - Added `lf t55xx protect` - sets password and enables password protection on t55x7 tag (@iceman1001)
 - Changed `lf t55xx wipe` - now accepts user provided configuration block (@iceman1001)
 - Added T55x7 downlink mode support r <mode> 0 Default, 1 Long Leading 0, 2 Leading 0, 3 1 of 4 and 4 (in some commands) try all. (@mwalker33)
 - Changed proxmark3-flasher is now merged into proxmark3 client. Add pm3-flash (@doegox)
 - Changed `hf iclass clone\dump\rdbl\wrbl` - now uses NG (@iceman1001)
 - Fixed `hf iclass clone` - last block always fails (@iceman1001)
 - Changed `hf iclass clone` - retries ten times, less output (honor verbose)  (@iceman1001)
 - Changed `hf iclass dump` - retries ten times, less output (honor verbose)  (@iceman1001)
 - Rename `hf iclass writeblk` ->  `hf iclass wrbl` to match hf mf wrbl (@iceman1001)
 - Rename `hf iclass readblk` ->  `hf iclass rdbl`  to match hf mf rdbl (@iceman1001)
 - Added cmdscript example and show usage with shebang (@doegox)
 - Added instructions for Fedora (@doegox)
 - Changed reduce the list of requirements to the minimum and move to QT5 (@doegox)
 - Added `make install` and reorganize/rename stuffs accordingly (@doegox)
 - Added searchFile for several types of files (@doegox / @iceman1001)
 - Changed posix sh version of mkversion (@doegox)
 - Changed remove entirely ncurses, not needed nowadays (@doegox)
 - Changed remove deprecated termcap, use ncurses instead (@ZeroChaos-)
 - Changed `hf iclass encrypt` - now takes transport key as param. (@iceman1001)
 - Changed `hf iclass decrypt` - now takes transport key as param. (@iceman1001)
 - Changed `hf mf fchk m` - now secretly dumps card to emul, if all keys are found (@iceman1001)
 - Changed history and logfile are now saved into $HOME/.proxmark3/ (@doegox)
 - Changed optimization of iclass mac calculations on deviceside (@pwpiwi)
 - Added `hf mf autopwn` - Autopwn function for Mifare Classic, extract all keys and dump card memory (@matthiaskonrath)
 - Added Lua paths: look for scripts also in ~/.proxmark/lua{scripts,libs} and /usr/local/share/proxmark3/lua{scripts,libs} (@doegox)
 - Changed Lua directory scripts/ to luascript/ (@doegox)
 - Changed non-rdv4 PLATFORM must now use the generic PM3OTHER, simpler (@doegox)
 - Fixed reveng integration for all platforms else than WIN32 (@doegox)
 - Added cheat sheet for easy operations of the Proxmark3 (scund00r)
 - Chg commands are now in green in the helptext list (@iceman1001)
 - Fixed `script run ndefdump` - better exit messages when failing (@iceman1001)
 - Fixed `hf iclass dump` - now also saves in EML format (@iceman1001)
 - Fixed `hf iclass sim 3` - now works on legacy readers and legacy SE readers (@iceman1001)
 - Rework hitag2 read/write help (@ViRb3)
 - Added `lf nedap` - encoding / decoding  (anon)
 - Added client option `-i` to stay in interactive mode after a script or command (@DidierStevens/@doegox)
 - Added VSCode tasks (@ViRb3)
 - Better warn user of hardcoded hitag info (@ViRb3)
 - Format and docs hitag (@ViRb3)
 - Fixed hitag password write offset by 1 (@ViRb3)
 - Fixed momentarily flash read/write of dicts (@doegox/@cjbrigato)
 - Added some more default keys (@anon)
 - Added `hf thinfilm sim` simulating Thinfilm NFC barcode tags (@doegox)
 - Added `hf thinfilm list` specific trace decoding (Thinfilm NFC barcode tags) (@doegox)
 - Fixed `hf topaz reader` - don't crash when trying to read a Thinfilm tag (@iceman1001)
 - Added `hf thinfilm info` - read / decode Kovio Thinfilm NFC barcode tags (@iceman1001)
 - Added FPGA LF adc path (@anon)
 - Added ECC support / check for NID_secp128r1 (@pwpiwi)
 - Added some more default keys (ollibolli)
 - Fixed T55x7 Downlink timings backward compatible (@mwalker33)
 - Added proper Makefile halting when using incompatible STANDALONE and PLATFORM vars (@doegox)
 - Added T55x7 Downlink mode support (@mwalker33)
 - Added SPIFFS Flash filesystem support (@cjbrigato)
 - Fixed support for flashing 512K units with old bootrom (@slurdge/@doegox)
 - Fixed `hf mf sim` - wrong access rights to write key B in trailer (@McEloff)
 - Added option -i to flasher to query Pm3 for its memory size (@doegox)
 - Added support for flashing 512K units (@slurdge)
 - Added a simple python tool to check the elf sizes (@slurdge)
 - Changed new keys for Vigik badges in default_keys.dict (@luminouw)
 - Added `hw standalone` to jump to standalone mode from command line or script (@doegox)
 - Added to `hf 14a apdu` print apdu and compose apdu (@merlokk)
 - Changed buggy `mem read` removed, `mem save` renamed `mem dump`, can now display too (@doegox)
 - Fixed timeout for mem wipe was too short, thanks @cjbrigato (@doegox)
 - Fixed `hf mf sim` - Mifare Classic simulation more flexible anti-collision check (@McEloff)
 - Changed `hf mf sim` - Mifare Classic simulation not respond NACK on invalid authentication request (@McEloff)
 - Changed `read_pwd_mem.lua` now handles Mifare Classic dictionaries large than 4096 bytes (@iceman1001)
 - Changed Do not clear trace log during `hf mf chk`, to save whole process history (@McEloff)
 - Added `msleep` command, for pauses in scripts (@doegox)
 - Added support for WSL in proxmark.sh (@doegox)
 - Added documentation for usage of Proxmark3 under WSL (@doegox)
 - Changed replace aes.c with mbedtls version (@slurdge)
 - Changed replace ukbhit by kbd_enter_pressed, not requiring tcgetattr (@xianglin1998/@doegox)
 - Added config for RaspberryPi in JTAG tools (@doegox)
 - Added config for FTDI C232HM-DDHSL-0 in JTAG tools (@doegox)
 - Fixed compilation under MacOSX with binutils (@matrix)
 - Added dynamic report of the chipID for flashing purposes (@slurdge)
 - Fixed Clang warnings (@matrix)
 - Fixed EMVGPO bug (@matrix)
 - Added hitag2 write password auth (@ViRb3)
 - Added check if bootloader segment is within bounds (@slurdge)
 - Added `hf 15 csetuid` - set UID on ISO-15693 Magic tags (@t0m4-null)
 - Changed Print help if unknown arg for hitag reader/writer (@ViRb3)
 - Fixed clock deadlock in hitag sniff (@ViRb3)
 - Added compiler info in client & ARM sections (@slurdge)
 - Added support for automatic COM detection on Windows (@slurdge)
 - Added support for compilation on RaspberryPiZero (armv6) (@doegox)
 - Changed updates to README (@iceman1001)
 - Changed `hf mf/mfu dbg` => `hw dbg` (@doegox)
 - Changed replace usb_poll_validate_length() by data_available() that supports USART too (@doegox)
 - Make sure standalone modes can be launched when connected on USB without client (@doegox)
 - Changed cleaner makefile execution, use `make V=1` if you want to see full lines (@doegox)
 - Changed automate make clean when platform definitions are changed (@doegox)
 - Added STANDALONE option to Makefile.hal (@Fl0-0)
 - Changed mem info - production public key to verify rdv4.0 flash  signature (@iceman1001)
 - Fixed specify that we need TCP and not UDP connection (@phcoder)
 - Changed lf cotag demod - adjusted error trigger (@iceman1001)
 - Added documentation on BT add-on (@iceman1001/@doegox)
 - Changed new button behaviour in bootloader mode, no need to keep it pressed, press again to interrupt (@doegox)
 - Changed new keys in dicts, new mem layout to accommodate them (@iceman1001/various)
 - Fixed lf sim -  if called with empty graphbuffer all strange things happen, like turning on HF field (@iceman1001)
 - Changed hf 14a sim / hf mf sim - check buttonpress/usb frame fewer times in order not to disrupt simulation (@McEloff)
 - Changed data convertbitstream - converts bit to max/min in order to facilitate demodulation of simulation data (@iceman1001)
 - Changed lf em 410x_demod - now can demod the simulation data (@iceman1001)
 - Added HC-06 scripts for BT add-on (@doegox)
 - Fixed lf nedap sim - error when adding parity (@iceman1001)
 - Added documentation on UART and baudrates (@doegox/@iceman1001)
 - Changed prompt now shows which channel is used (@iceman1001)
 - Changed USART baudrates computation, up to 6Mbps (@iceman1001/@doegox)
 - Changed hf mf nack - keep sync if started without card over antenna
 - Added usart btfactory - to reset a misconfigured BT add-on (@doegox)
 - Changed hw status - now prints number of dictionary keys loaded (@iceman1001)
 - Added home, end, pageup, and pagedown keybinds to the plot GUI. Also fix paged movement in GUI. (@mcd1992)
 - Changed legic.lua saves data in EML and BIN formats (@iceman1001)
 - Changed hf tune - is now synchronous (for BT add-on) and can be interrupted by kbd (@doegox)
 - Changed update macOS install instruction (@ Uli Heilmeier)
 - Added trace output in hexdump format for Wireshark import (@ Uli Heilmeier)
 - Added usart btpin - to change BT add-on PIN (@doegox)
 - Added reconnection support (@iceman1001/@doegox)
 - Added usart tx/rx/... - USART developer commands (@doegox)
 - Added PLATFORM_EXTRAS, WITH_FPC_USART_HOST, BTADDON Makefile configuration (@doegox)
 - Fixed slow reconfigure on mingw of serial port (@iceman1001)
 - Fixed cross thread communictions of timeout variable (@iceman1001)
 - Changed client is now "universal", adapting to Proxmark3 capabilities (@doegox)
 - Added disconnect support to Lua (@iceman1001)
 - Changed handles FPC/FLASH FW more gracefully on non-RDV4 pm3 (@doegox)
 - Added JTAG support for Shikra (@NinjaStyle82)
 - Changed smart color handling: only if linux and on real term (@doegox)
 - Changed reconfigure uart timeouts when compiled for FPC and connecting over USB (@iceman1001)
 - Changed fast push for many commands (@iceman1001/@doegox)
 - Added: fast push for Lua (@iceman1001)
 - Added NDEF parser in Lua (@iceman1001)
 - Changed improve NDEF parser (@iceman1001)
 - Changed all commands got migrated to MIX/NG packet format (@iceman1001/@doegox)
 - Fixed Mifare Ultralight read block missing bytes (@doegox)
 - Added support new frame format in all Lua scripts (@iceman1001)
 - Added CMD_CAPABILITIES for pm3 to inform dynamically the client (@doegox)
 - Changed baudrate handling, make it clear it is only indicative for USB-CDC & BT (@doegox)
 - Changed new progressive light scheme for `hw detectreader` (@doegox)
 - Added common error definitions system for retvals (@doegox)
 - Changed USART RX & TX code and fix delays handling to make it more robust, especially over BT (@doegox)
 - Added support for new frames format, speedup & huge changes, see doc/new_frame_format.txt (@doegox)
 - Changed loadFile* & saveFile* accept filenames with (or still without) extension (@doegox)
 - Fixed LoadEML to accept final "\n", e.g. from pm3_mfd2eml.py (@doegox)
 - Changed rework shell scripts for easy client or flasher (@doegox)
 - Fixed stop poking Internet when compiling (@doegox)
 - Added support for multiple commands to "-c", e.g. proxmark3 -c "hw ping;hw version" (@doegox)
 - Fixed external flash writing bitflips issues at 24MHz (@doegox)
 - Added color support to Dbprintf & alike and rework Dbprintf flags (@doegox)
 - Changed archive (and fix) hid-flasher (@doegox)
 - Added standalone placeholder to simplify new standalone integration (@doegox)
 - Changed refactor standalone mode info string (@iceman1001)
 - Added iceman skeleton standalone mode for ppl to use as base for their new modes (@iceman1001)
 - Changed move compilation options to Makefile.hal (@doegox)
 - Fixed compilation under OSX (@iceman1001)
 - Added openocd config files for JLink (@doegox)
 - Fixed compilation dependencies for recovery (@doegox)
 - Fixed segfault when loading a file (@doegox)
 - Change/Add new dump format for Ultralight/NTAG, counters support, simulation (@mceloff)
 - Added `hf mf sim` full-byte split anticollision support (@mceloff)
 - Fix/Add `hf mf sim` bugs fix, RATS support, etc (@mceloff)
 - Fixed serial of FPC. (@ryan)
 - Fixed `data shiftgraphzero` corrupting end of GraphBuffer (@doegox)
 - Fixed `hf legic info` - unsegmented card now uses card size to calc remaining length (@iceman1001)
 - Added 36bit HID format, extend calcWiegand() to include oem bits (@davidbeauchamp)
 - Fixed `hf mf hardnested` - not verify key when reading nonce file (@iceman1001)
 - Changed optimizations for ask/bi (@iceman1001)
 - Fixed `hf mf sim` - bugs fix, refactoring (@mceloff)
 - Added WRITE and COMPATIBLE_WRITE support to Mifare Ultralight/NTAG simulation (@mceloff)
 - Changed installation instructions and add video links (@5w0rdfish)
 - Changed `hf mf sim` to support more types (@vratiskol)
 - Changed better strong wave detection for biphase (@iceman1001)
 - Added `script run test_t55x7` (@iceman1001)
 - Added new lua scripting support for some t55xx commands (@iceman1001)
 - Added FPC USART for BT add-on with pm3 client. (@doegox)
 - Added `-b baudrate` option to the pm3 client. (@doegox)
 - Changed `lf t55xx info`: tell if known configuration block0. (@iceman1001)
 - Fix/Add FPC usart: fix TX, bring RX, full speed. (@doegox)
 - Changed `lf t55xx config` options: allow to toggle on/off i/q5/st
 - Changed `lf t55xx info`: support offline block0, Q5, fix extended, add warns. (@doegox)
 - Avoid race condition when flasher finds the not yet closed pm3 port. (@doegox)
 - Fixed `lf t55xx trace`: read the proper block. (@doegox)
 - Fixed Indala 64 on T55xx: use PSK1. (@doegox)
 - Force proper Linefeed (LF) handling in ProxSpace. (@vratiskol)
 - Fixed Makefiles race conditions to allow parallel compilation, e.g. `make -j8`. (@doegox)
 - Added - dictionary key file for MFU. (not in use at the moment) (@mazodude)
 - Changed `lf fdx demod` - better biphase maxerrors. (@MalteHillmann)
 - Changed `hf mf sim` - now works better against android (@mceloff)
 - Fixed `lf t55xx brute` - now works after aquiredata adaptations (@iceman1001)
 - Fixed `lf t55xx chk` - now works after aquiredata adaptations (@iceman1001)
 - Fixed `lf t55xx recoverpwd` - now works after aquiredata adaptations (@iceman1001)
 - Fixed `data detect p` - reverted bad clock detection (@iceman1001)
 - Changed `data detect a` - better clock detection (@iceman1001)
 - Added `hf 14a info` - now detects some magic card Gen2 (@iceman1001)
 - Removed `LCD` code in armsrc compilation (@iceman1001)
 - Changed - Generic fixes of codestyle (@doegox) (@iceman1001)
 - Changed `lf indala demod` - refactoring (@iceman1001)
 - Changed - handling fault bit markers (7) and partial nibbles in hex printing (@doegox)
 - Changed - printing of fault bit markers (7) using a dot (@doegox)
 - Changed `sc upgrade` - firmware file integrity check (@pwpiwi)
 - Fixed `data rawdemod am` - last bit was missing (@doegox)
 - Fixed `hf 15 dump f` - also selects tag first (@iceman1001)
 - Fixed `hf iclass clone` - missing fileclose (@iceman1001)
 - Added `trace list hitag` - old hitag annotations now use the new trace (@iceman1001)
 - Changed `lf hitag sim` - loads bin/eml/json (@iceman1001)
 - Changed `lf hitag reader 21` - saves in bin/eml/json (@iceman1001)
 - Changed `lf hitag` - refactoring (@iceman1001)
 - Changed `lf hitag` - refactoring (@pwpiwi)
 - Fixed `lf hitag` - generic fix for missing clock init (@pwpiwi)
 - Fixed fsk sim operations on deviceside - avoid division by zero (@doegox)
 - Fixed `hf mf fchk` - condition always false (@doegox)
 - Fixed `lf t55xx recoverpw` - shift as u32 (@doegox)
 - Fixed `lf ti demod` - shift as u32 (@doegox)
 - Fixed `lf ti read` - shift as u32 (@doegox)
 - Fixed `lf t55xx chk` - condition always false (@doegox)
 - Changed `lf sim` - ledcontrol refactoring (@doegox)
 - Fixed `hf mf nack` - signedness bug (@doegox)
 - Fixed `hf epa cnonce` - check return value (@doegox)
 - Fixed `lf hitag write` - condition always true (@doegox)
 - Fixed `mem write` - added extra check (@doegox)
 - Fixed `iso15693` - bad string cpy (@doegox)
 - Fixed `make style` - EOF LF support (@doegox)
 - Added `hf 14b raw` - added -t for timeout  (@iceman1001)
 - Rename `lf hitag snoop` - renamed to `lf hitag sniff` (@iceman1001)
 - Rename `lf snoop` - renamed to `lf sniff` (@iceman1001)
 - Rename `hf snoop` - renamed to `hf sniff` (@iceman1001)
 - Fixed `hf mfp wrbl` - more blocks available (@merlokk)
 - Added `make platform` - compile for non-rdv4 devices made simpler (@doegox)
 - Changed Makefiles optimizations when recompiling (@doegox)
 - Fixed `data load` - loads TITEST.txt again (@iceman1001)
 - Changed `lf search` - now detects TI (@iceman1001)
 - Changed fixing signal cleaning for LF (@doegox)
 - Fixed `lf paradox demod` - wrong check (@iceman1001)
 - Changed `lf t55xx` - aquiredata uses getsamples (@iceman1001)
 - Fixed `lf search` - chipset detection restore demod buffer again (@iceman1001)
 - Added `make style` (@doegox)
 - Fixed mixed tabs vs spaces. Now only use 4 space as tab. (@doegox)
 - Fixed `lf visa2000 read` - too few samples (@iceman1001)
 - Fixed `lf t55xx bruteforce` - infinity loop (@doegox)
 - Fixed `analyse nuid` - correct crc (@doegox)
 - Added command history not repeating logged commands (@doegox)
 - Fixed path for aidjson (@doegox)
 - Fixed missing init i2x (@doegox)
 - Fixed `14b select card` - (@doegox)
 - Added `hf mf ndef` - parsing of NDEF messages (@merlokk)
 - Added `hf mf mad` - parsing of Mifare Application Directory (@merlokk)
 - Rename `lf snoop` -> `lf sniff` (@iceman1001)
 - Rename `hf snoop` -> `hf sniff` (@iceman1001)
 - Changed generally added more colors (@iceman1001)
 - Changed `sc upgrade` updated firmware v3.11 (RDV40) (@sentiprox)
 - Changed `data autocorrelate` - better visual representation and added extra peak detection (@iceman1001)
 - Fixed `lf search` - false positive indala identification fixed (@iceman1001)
 - Added `lf keri` - basic support for Keri tags (@iceman1001)
 - Added `hf mf list` - re-added it again (@iceman1001)
 - Fixed - A lot of bugfixes, like memory leaks (@iceman1001)
 - Changed `hf 14a antifuzz` - original implementation (@asfabw),  reworked a bit
 - Fixed `hf mf fchk` (@iceman1001)
 - Fixed `usb slow on posix based systems` (@fl0-0)
 - Changed `lf pcf7931` - improved read code (@sguerrini97)
 - Changed `hf felica list` - started with some FeliCa annotations (@iceman1001)
 - Fixed `hf tune` - now works as expected (@iceman1001)
 - Added `option to use flash memory to upload dictionary files` (RDV40) (@iceman1001)
 - Fixed `printing percentage now standard compliant` (@fabled)
 - Added `emv roca` - command to test for ROCA vuln in public RSA modulus (@merlokk / @iceman1001)
 - Added TCP ports support (on linux) (@phcoder)
 - Added HF sniff standalone mode with optional storing of ULC/NTAG/ULEV1 authentication attempts (@bogiton)
 - Fixed `Lining up plot and control window` (@anticat)
 - Fixed `annoying focus behaviour` on OSX  (@Anticat)
 - Implemented AppNap API, fixing #283 and #627 OSX USB comm issues (@AntiCat)
 - Added `sc brute` - a naive SFI bruteforcer for contact smartcards (RDV40) (@iceman1001)
 - Changed `lf t55xx detectconfig` - now optional to persist settings to flashmem (RDV40) (@iceman1001)
 - Changed `hf mf csave` - now saves both EML/BIN formats (@iceman1001)
 - Changed `hf mf esave` - now saves both EML/BIN formats (@iceman1001)
 - Fixed `compiler warning on macos and gcc7.1 or higher`  (@TomHarkness)
 - Fixed `crash on Bionic libc if CloseProxmark is called twice` (@micolous)
 - Changed `lf hid` - got an  updated to Kastle format (@xilni)
 - Added `lf t55xx deviceconfig` - enables custom t55xx timing settings. (RDV40) (@iceman1001)
 - Chg adaptations for FPC communications (work in progress)  (@iceman1001)
 - Fixed `stand-alone Colin` - remake to benefit from flashmem for persistence. (@cjbrigato)
 - Fixed `LEGIC SIM` - remake of legic sim (@drandreas)
 - Changed `proxmark3 client threading`  - remake from official repo (@micolous)
 - Added `rem` - new command that adds a line to the log file (@didierStevens)
 - Fixed `EM410xdemod  empty tag id in lfops.c` (@Defensor7)
 - Fixed `usb device descriptor` - some android phones will enumerate better when iSerialnumber is not a multiple of 8 (@micolous, @megabug)
 - Fixed `StandaloneMode LF` -  when collecting signal, justNoise detection is needed (@didierStevens, @Megabug)
 - Fixed `StandAloneMode Colin` - mifare1ksim called with right params (@cjbrigato)
 - Improved `install.sh` to install dependencies for Ubuntu 18.04 and using max number of processors during compilation (@joanbono)
 - Modified `install.sh` script to work in macOS and Linux + added the `update.sh` and `proxmark3.sh` from joanbono (@TomHarkness)
 - Fixed `hf emv` - some cards need to have Le=0x00, some do not need to have (@merlokk)
 - Fixed `hf legic`  enhancement of rx / tx in legic commands (@drandreas)
 - Fixed `data buffclear` - now frees bigbuff also (@iceman1001)
 - Fixed GET_TICKS  and signess while shifting (@drandreas)
 - Added `hf 14b dump` - now dumps to file (bin & eml)  (@iceman1001)
 - Fixed fixed xcorrelation for strong signal (@drandreas)
 - Fixed `hf mf chk` - keytype was reversed (@TomHarkness)
 - Added strange vid/pid found in wild.  Could be pm3 easy clones. (@iceman1001)
 - Fixed `make udev`  -  udev filename could be in conflict,  renamed.  (@blshkv)
 - Fixed `lf t55xx config`  - wrong sized array disabled FSK1a/FSK2a as options (@grauerfuchs)
 - Added more default keys  (@j8048188) (@iceman1001)
 - Added `sc list/info/raw/reader/upgrade` - (RDV40) smart card module functionality  (@iceman1001)
 - Fixed `download eml buffer` (@drandreas)
 - Changed `exclusion of floatingpoint lib` (@pwpiwi)
 - Changed `lua scripts bit32 calls` (@iceman1001)
 - Changed `hw version`  (@pwpiwi),   adapted to iceman fork (@iceman1001)
 - Added `amiibo functionality`  (@jamchamb),   adapted to iceman fork (@iceman1001)
 - Fixed `hf legic`  (RDV40) adaptations to FPGA HF enhanched reading distance (@iceman1001)   Thanks to @drandreas!
 - Added `script run mifare_acces` - script to decode Mifare classic accessbits (@Neuromancer)
 - Added `mem load/save/wipe` - commands to upload / download to new RDV40 onboard flashmemory (@iceman1001)
 - Added `script run mifareplus` - script to communicate with a mifare plus tag (@dceliano)
 - Added FlashMemory functionality  (RDV40)  (@willok)
 - Fixed `hf mfu dump` - partial reads lead to corrupt data (Thanks @elafargue for pointing it out)
 - Changed `hf mfu dump / read`  - now retries five times. (@jamchamb)
 - Added `hf list mf` - deciphers crypto1 stream and works with first authentication and weak nested authentications (@Merlok)
 - Adjusted `lf cmdread` to respond to client when complete and the client will then automatically call `data samples` (@marshmellow42)
 - Added a bitbang mode to `lf cmdread` if delay is 0 the cmd bits turn off and on the antenna with 0 and 1 respectively (@marshmellow42)
 - dump / restore now uses custom filenames (@brianpow)
 - Removed `hf mf sniff` ,  (@iceman1001),  use HF 14A SNIFF instead
 - Added `hf iclass lookup` (@iceman1001)
 - Added `hf iclass chk` (@iceman1001)
 - Fixed ADC mux all closed push-pull state (@iceman1001)
 - Fixed `hf mf darkside` - speed fixes (@pwpiwi)
 - Fixed `hw tune`  -  now compensates for 3% error in output,  also measure full 140v using ADC channel 5 and 7.  (@iceman1001)
 - Updated loclass gpl license (@holiman)
 - Fixed Antenna on after changed FPGA Mode. (@iceman1001)
 - Added `hf mf nack` - Mifare NACK bug detection (@iceman1001) (@doegox)
 - Fixed `hf mf mifare` - zero parity works, no more double runs for normal darkside (@iceman1001)
 - Added `hf mf fchk` - the fastest check keys implementation tothisday (@iceman1001)
 - Fixed `hf iclass` - more stable demod (@iceman1001)
 - Added `hf iclass chk`  - check keys from default_iclass_keys.dic file (@iceman1001)
 - Fixed `hf 15 dump` - no more crc faults (@iceman1001)
 - Fixed `hf 15 read` - no more crc faults (@iceman1001)
 - Fixed `hf 15 readmulti` - no more crc faults (@iceman1001)
 - Changed proxmark command line parameter `flush` to `-f` or `-flush` (@merlokk)
 - Added to proxmark command line parameters `w` - wait 20s for serial port (@merlokk)
 - Added to proxmark command line parameters `c` and `l` - execute command and lua script from command line (@merlokk)
 - Added to proxmark ability to execute commands from stdin (pipe) (@merlokk)
 - Added new standalone mode "HF Mifare ultra fast sniff/sim/clone - aka VIGIKPWN"  (@cjbrigato)
 - Added to `hf 14a apdu` - exchange apdu via iso14443-4 (@merlokk)
 - Added to `hf 14a apdu` - apdu and tlv results parser (@merlokk)
 - Added `hf emv` commands  (@merlokk)
 - lots of bug fixes (many many)
 - Changed hf mfp security. Now it works in all the modes. (@drHatson)
 - Added `hf fido` commands that work with FIDO U2F authenticators (@merlokk)
 - Added mbedtls instead of old polarssl (@merlokk)
 - Added jansson (@merlokk)
 - Added `hf emv scan` - save card data to json file (@merlokk)
 - Added `hf emv` `gpo`, `readrec`, `genac`, `challenge`, `intauth` - separate commands from `hf emc exec` (@merlokk)
 - Added  `hf fido` `assert` and `make` commands from fido2 protocol (authenticatorMakeCredential and authenticatorGetAssertion) (@merlokk)
 - Added trailer block decoding to `hf mf rdbl` and `hf mf cgetbl` (@merlokk)
 - Added `hf mf mad` and `hf mfp mad` MAD decode, check and print commands (@merlokk)
 - Added `script run luxeodump` (@0xdrrb)
 - Fixed `lf hitag reader 02` - print all bytes (@bosb)
 - Fixed hitag S simulation (still not working), write, add example HITAG S 256  (@bosb)


### Fixed
 - Changed driver file proxmark3.inf to support both old and new Product/Vendor IDs (@pwpiwi)
 - Changed start sequence in Qt mode (fix: short commands hangs main Qt thread) (@merlokk)

## [ice.3.1.0][2017-09-26]
 - proxmark3 client can reconnect to device without restart (@iceman1001)
 - lots of bug fixes (many many)
 - trace/securakey-64169.pm3 - trace of a scecurakey (@atyppo)
 - `hf mf decrypt` - got some longer input and helptext parameter (@iceman1001)
 - Updated the Reveng 1.51 sourcecode to 1.52 from Reveng project homepage (@iceman1001)
 - `hf 14a read` - disconnects when failing to read tag (@iceman1001)
 - `hf mf csave` - renamed parameter `i` to `o` as in output (@iceman1001)

## [3.0.0][2017-08-29]
  Notes on this release
  this version includes a merge with the PM3 official v3.0.1 code, a.k.a the "Monster merge"
  There is a lot of changes,  command breaking changes, which is the cause for the JUMP in version number.
  It is set to v3.0.0 to show that it is on par with PM3 Official v3 release.

 - Updated `mkversion.pl` to write a date based on file when repo is downloaded as a zip file from github (@iceman1001)
 - Update `readme.md` to fit GitHubs markup(@joanbono)
 - Added `script run ul_uid`, try to change UID on a magic UL-card. (@iceman1001)
 - Fixed `hf snoop` bug,  of wrong bool value (@ikarus23)
 - Fixed fullimage.s19, wrong offsets (@doegox)
 - Updated `77-mm-usb-device-blacklist.rules` for the pid/vid (@iceman1001)
 - `hf 14a sim` now follows Mifare UL-EV1 protocol better (@iceman1001)
 - Updated `fpga_hf.bit` file (@pwpiwi)
 - Added more card detections to `hf mfu info` (@iceman1001)
 - Fixed `hf mfu restore/dump` to use the right struct values in special data in dumpfile. (@iceman1001)
 - Added `hf mfu restore r` new parameter to use the new pwd for all further auths needed when executing (@iceman1001)
 - Added `default_keys_dic2lua.awk` script to generate default_keys file in client/lualibs (@iceman1001)
 - Fixes to lots of lua scripts, among others
    - `mifare_autopwn`, now uses PRNG detection (@iceman1001)
    - `mfkeys`, fixed bug which only tested the first key (@iceman1001)
    - `dumptoemul`, removed last newline (@iceman1001)
    - ...
 - Added USB/SERIAL communication enhancements (@micolous)
 - Changed `hf 14a cuids`, to be interrupted with keyboard press (@iceman1001)
 - Changed debugstatements for LF to show which function more unified (@iceman1001)
 - Added `script run calc_di` , to calculate some Mifare keys (@iceman1001)
 - Fixed iclass commands never shut down antenna afterwards (@iceman1001)
 - Changed 512kb detection when flashing (@iceman1001)
 - Fixed compilation GCC4.9 or higher detection (@winguru)
 - Fixed compiler warnings in Ubuntu 17.04 (@iceman1001)
 - Ripped out `standalone` code into separate folder to be continued. (@iceman1001)
 - `hf mf nested`, added key validation to entered key (@merlokk)
 - `hf mf hardnested`, added key validation to enterd key (@iceman1001)
 - Changed a lot of help texts (@iceman1001)
 - Fixed `hf mf chk` - keyblock bug, limited keys to 256. (@iceman1001)
 - Changed `hf mf dump` retries three times now before giving up (@marshmellow42)
 - Fixed `mfu authentication`, with pack-len error (@iceman1001)
 - `Script list`, change sortorder to alphabetic order (@iceman1001)
 - Changed `hf mfu gen` to read taguid (@iceman1001)
 - Changed `hf mfu pwdgen` to read taguid (@iceman1001)
 - Added `hf mf setmod` sets Mifare Classic EV1 load modulation strength to card (@angelsl)
 - Added `hf 14a read`  Mifare PRNG detection based on @doegox LIBNFC impl (@iceman1001)
 - Added `hf mf nonces`, collects Mifare Classic nonces for analysing of PRNG (@iceman1001)
 - Added new CSNS in `hf iclass sim 2` attack (@iceman1001)
 - Added more default keys (@iceman1001)
 - Added analyse nuid, enable creation of Mifare NUID (@iceman1001)
 - Updated the Reveng 1.44 sourcecode to 1.51 from Reveng project homepage (@iceman1001)
 - script run formatMifare - got an option to execute the generate strings (@iceman1001)
 - Fixed `hf mf cgetsc` (@iceman1001)
 - Fixed `hf legic info` (@iceman1001)
 - Changed version output (@iceman1001)
 - Added PAC/Stanley detection to lf search (@marshmellow42)
 - Added lf pac demod and lf pac read - extracts the raw blocks from a PAC/Stanley tag (@marshmellow42)
 - Added hf mf csave commands compatibity for 4k (@Fl0-0)
 - Added data fsktonrz, a fsk cleaning/demodulating routine for weak fsk signal. Note: follow this up with a `data rawdemod nr` to finish demoding your signal. (@marshmellow42)
 - Added lf em 410xbrute, LF EM410x reader bruteforce attack by simulating UIDs from a file (@Fl0-0)
 - Compiles on OS X
 - Compiles with gcc 4.9
 - Compiles for non-Intel CPUs
 - Added lf hitag write 24, the command writes a block to hitag2 tags in crypto mode (@henjo)
 - Added the improved `hf mf hardnested`, an attack working for hardened Mifare cards (EV1, Mifare Plus SL1)
 - Added experimental testmode write option for t55xx (danger) (@marshmellow42)
 - Added t55xx p1detect to `lf search` chip detections (@marshmellow42)
 - Added lf t55xx p1detect, detect page 1 of a t55xx tag based on E015 mfg code (@marshmellow42)
 - Added lf noralsy demod, read, clone, sim commands (@iceman1001)
 - Added lf jablotron demod, read, clone, sim commands (@iceman1001)
 - Added lf nexwatch read   - reads a nexwatch tag from the antenna
 - Added lf paradox read    - reads a paradox tag from the antenna
 - Added lf fdx sim (@iceman1001)
 - Added lf fdx clone       - clones an fdx-b animal tag to t55x7 or q5 (@iceman1001)
 - Added lf fdx read        - reads a fdx-b tag from the antenna (@iceman1001)
 - Added lf gproxii read    - reads a gproxii tag from the antenna (@marshmellow42)
 - Added lf indala read     - reads an indala tag from the antenna (@marshmellow42)
 - Added lf visa2000 demod, read, clone, sim commands (@iceman1001)

## [1.7.0 iceman fork] [2017-03-07]
 - hf mf dump - added retry loops to try each read attempt up to 3 times.  makes getting a complete dump easier with many antennas. (@marshmellow42)
 - Added markers in the graph around found Sequence Terminator after askmandemod. (@marshmellow42)
 - Added data mtrim <start> <stop> command to trim out samples between start and stop. (@marshmellow42)
 - Added data setgraphmarkers <orange> <blue> command to set two extra markers on the graph (@marshmellow42)
 - added json support in lua (@vitorio)
 - added a buspirate settings file for at91sam7s512 (@adamlaurie)
 - `lf read` timeouts is now depended on what threshold level you set in `lf config`  (@marshmellow42)
 - `hf mf sim` fixed a bug which made sim fail auths. (@iceman1001)
 - `hf 14a read` added magic tag generation 1a and 1b detection  (@iceman1001)
 - correctly using stdtypes.h printf and scanf format string macros (PRIx64 et al) (@pwpiwi)
 - Fixed linker warning re missing entry point when linking fullimage.elf (@pwpiwi)
 - small changes to lf psk and fsk demods to improve results when the trace begins with noise or the chip is not broadcasting yet (@marshmellow42)
 - NOTE CHANGED ALL `lf em4x em*` cmds to simpler `lf em ` - example: `lf em4x em410xdemod` is now `lf em 410xdemod`
 - Renamed and rebuilt `lf em readword` && readwordpwd to `lf em 4x05read` - it now demods and outputs the read block (@marshmellow42/@iceman1001)
 - Renamed and rebuilt `lf em writeword` && writewordpwd to `lf em 4x05write` - it now also reads validation output from the tag (@marshmellow42/@iceman1001)
 - Fixed bug in lf sim and continuous demods not turning off antenna when finished
 - Added lua script path fixes (@pwpiwi)
 - `lf search` - Added EM4x05/EM4x69 chip detection (@marshmellow42)
 - Added lf em 4x05dump command to read and output all the blocks of the chip (@marshmellow42)
 - Added lf em 4x05info command to read and display information about the chip (@marshmellow42)
 - `lf em4x em4x50***` refactoring of em4x50 commands. (@iceman1001)

## [1.6.9 iceman fork] [2017-02-06]
 - Serial speedup,  if possible 408600baud otherwise default to 115200baud (@iceman1001)
 - `hf emv` - Added Peter Fillmore EMV branch now compiles on iceman fork.  See separate issue. (@iceman1001)
 - `hf 14a reader` - Aztek detection. (@iceman1001)
 - `standalone mode` - added more detection of tags and refactored (@iceman1001)
 - `script run ufodump` - dumps an Aztek tag. (@iceman1001)
 - `script run hard_autopwn` - runs hardnested attack against all sectors on tag (@iceman1001)
 - Added lf cotag read, and added it to lf search (@iceman1001)
 - Added hitag2 read UID only and added that to lf search (@marshmellow42)
 - `lf search` -  check for if signal is only noice (@marshmellow42)
 - `hf 14a reader` - fixed a bug when card has sak 0x00 but still is not UL/NTAG etc. (@iceman1001)
 - `hf mf sim` / `hf 14a sim` - use random nonce. (@micolous)
 - `hw tune` - only prints out if voltage is detected from antenna. (@iceman1001)
 - `hf iclass decrypt` - only decrypt Application1 (@iceman1001)
 - `lf t55xx detect` - when finding multiple possible config blocks, see if a known configblock exists and select. (@iceman1001)

## [1.6.7 iceman fork] [2017-01-05]
 - `lf animal` - FDX-B animal commands (@iceman1001)
 - Fixed bugs in `lf sim` and other lf continuous demods not turning off antenna when finished (@marshmellow42)
 - `hf iclass write` - fixed bugs, added crc. (?)
 - `hf iclass dump` - changed layout in dump (@iceman1001)
 - Changed - debug statements are more clear (@iceman1001)
 - `lf search` - fixed the silent option when acquire data. (@iceman1001)
 - `lf search` - added presco, visa2000, noralsy detection (@iceman1001)
 - `lf precso` - fixed some bitsgeneration in precso bits (@iceman1001)
 - Added `lf noralsy` -  adds demod/clone/sime of Noralsy LF tags. (@iceman1001)
 - Added `lf visa2000` - adds demod/clone/sim of Visa2000 lF tags. (@iceman1001)
 - Added `hf mf key_brute` - adds J-Runs 2nd phase bruteforce ref: https://github.com/J-Run/mf_key_brute   (@iceman1001)
 - Added `lf jablotron` - adds demod/clone/sim of Jablotron LF tags. (@iceman1001)
 - Added `lf t55xx recoverpw` - adds a new password recovery using bitflips and partial flips if password write went bad. (@alexgrin)
 - `hf legic` - added improved legic data mapping. (jason)
 - `hf mf mifare` - added possibility to target key A|B (@douniwan5788)
 - Added `analyse lcr` - added a new main command group,  to help analysing bytes & bits & nibbles. (@iceman1001)
 - Added `lf nedap` - added identification of a NEDAP tag. (@iceman1001)
 - `lf viking clone` - fixed a bug. (@iceman1001)
 - Added bitsliced bruteforce solver in `hf mf hardnested` (@Aczid)
 - `hf mf chk` speedup (@iceman1001)
 - `hf 14a/mf sim x` attack mode,  now uses also moebius version of mfkey32 to try finding the key. (@iceman1001)
 - `hf 14a sim` Added emulation of Mifare cards with 10byte UID length. (@iceman1001)
 - `hf mf sim` Added emulation of Mifare cards with 10byte UID length. (@iceman1001)
 - Added `lf guard clone/sim` (@iceman1001)
 - Added `lf pyramd clone/sim` (@iceman1001)
 - trying to fix `hf 14b` command to be able to read CALYPSO card. (@iceman1001)
 - `hf legic load`, it now loads faster and a casting bug is gone. (@iceman1001)
 - Added `hf legic calccrc8` added a method to calculate the legic crc-8 value (@iceman1001)
 - `hf legic decode` fixed the output overflow bugs, better printing (@iceman1001)
 - Coverity Scan fixes a lot of resource leaks, etc (@iceman1001)
 - Added `lf presco *` commands started (@iceman1001)
 - Added `lf hid wiegand` added a method to calculate WIEGAND in different formats, (@iceman1001)
 - `hf mf chkkeys` better printing, same table output as nested, faster execution and added Adam Lauries "try to read Key B if Key A is found" (@iceman1001)
 - `hf mf nested` better printing and added Adam Lauries "try to read Key B if Key A is found" (@iceman1001)
 - `hf mf mifare` fixing the zero parity path, which did not get called. (@iceman1001)
 - Updated the @blapost Crapto1 implementation to v3.3 (blapost)
 - `hf mf c*` updated the calling structure and refactored of the chinese magic commands (@iceman1001, @marshmellow42)
 - Started to add Peter Fillmore  EMV fork into Iceman fork. ref: https://github.com/peterfillmore/proxmark3  (@peterfillmore,  @iceman1001)
 - Added Travis-CI automatic build integration with GitHub fork. (@iceman1001)
 - Updated the Reveng 1.30 sourcecode to 1.31 from Reveng project homepage (@iceman1001)
 - Updated the Reveng 1.31 sourcecode to 1.40 from Reveng project homepage (@iceman1001)
 - Added possibility to write direct to a Legic Prime Tag (MIM256/1024) without using values from the `BigBuffer` -> `hf legic writeRaw <addr> <value>` (@icsom)
 - Added possibility to decrease DCF values at address 0x05 & 0x06 on a Legic Prime Tag
   DCF-value will be pulled from the BigBuffer (address 0x05 & 0x06) so you have to
   load the data into the BigBuffer before with `hf legic load <path/to/legic.dump>` & then
   write the DCF-Values (both at once) with `hf legic write 0x05 0x02`  (@icsom)
 - Added script `legic.lua` for display and edit Data of Legic-Prime Tags (@icsom)
 - Added the experimental HITAG_S support (@spenneb)
 - Added topaz detection to `hf search` (@iceman1001)
 - Fixed the silent mode for 14b to be used inside `hf search` (@iceman1001)

### Added
 - Added a LF ASK Sequence Terminator detection option to the standard ask demod - and applied it to `lf search u`, `lf t55xx detect`, and `data rawdemod am s` (@marshmellow42)
 - `lf awid bruteforce <facilitycode>` - Simple bruteforce attack against a AWID reader.
 - `lf t55xx bruteforce <start password> <end password> [i <*.dic>]` - Simple bruteforce attack to find password - (@iceman1001 and others)
 - `lf viking clone`- clone viking tag to t55x7 or Q5 from 4byte hex ID input
 - `lf viking sim`  - sim full viking tag from 4byte hex ID input
 - `lf viking read` - read viking tag and output ID
 - `lf t55xx wipe`  - sets t55xx back to factory defaults
 - Added viking demod to `lf search` (@marshmellow42)
 - `data askvikingdemod` demod viking id tag from graphbuffer (@marshmellow42)
 - `lf t55xx resetread` added reset then read command - should allow determining start of stream transmissions (@marshmellow42)
 - `lf t55xx wakeup` added wake with password (AOR) to allow lf search or standard lf read after (@iceman1001, @marshmellow42)
 - `hf mf eload u` added an ultralight/ntag option. (@marshmellow42)
 - `hf iclass managekeys` to save, load and manage iclass keys.  (adjusted most commands to accept a loaded key in memory) (@marshmellow42)
 - `hf iclass readblk` to select, authenticate, and read 1 block from an iclass card (@marshmellow42)
 - `hf iclass writeblk` to select, authenticate, and write 1 block to an iclass card (or picopass) (@marshmellow42 + others)
 - `hf iclass clone` to take a saved dump file and clone selected blocks to a new tag (@marshmellow42 + others)
 - `hf iclass calcnewkey` - to calculate the div_key change to change a key - (experimental) (@marshmellow42 + others)
 - `hf iclass encryptblk` - to encrypt a data block hex to prep for writing that block (@marshmellow42)
 - ISO14443a stand-alone operation with ARM CFLAG="WITH_ISO14443a_StandAlone". This code can read & emulate two banks of 14a tag UIDs and write to "magic" cards  (Craig Young)
 - AWID26 command context added as `lf awid` containing realtime demodulation as well as cloning/simulation based on tag numbers (Craig Young)
 - Added `hw status`. This command makes the ARM print out some runtime information. (@holiman)
 - Added `hw ping`. This command just sends a usb packets and checks if the pm3 is responsive. Can be used to abort certain operations which supports abort over usb. (@holiman)
 - Added `data hex2bin` and `data bin2hex` for command line conversion between binary and hexadecimal (@holiman)
 - Added `hf snoop`. This command take digitalized signal from FPGA and put in BigBuffer. (@pwpiwi + enio)
 - Added Topaz (NFC type 1) protocol support (`hf topaz reader`, `hf list topaz`, `hf 14a raw -T`, `hf topaz snoop`). (@pwpiwi)
 - Added option c to `hf list` (mark CRC bytes) (@pwpiwi)

### Changed
 - Added `[l] <length>` option to data printdemodbuffer
 - Adjusted lf awid clone to optionally clone to Q5 tags
 - Adjusted lf t55xx detect to find Q5 tags (t5555) instead of just t55x7
 - Adjusted all lf NRZ demods - works more accurately and consistently (as long as you have strong signal)
 - Adjusted lf pskindalademod to reduce false positive reads.
 - Small adjustments to psk, nrz, and ask clock detect routines - more reliable.
 - Adjusted lf em410x em410xsim to accept a clock argument
 - Adjusted lf t55xx dump to allow overriding the safety check and warning text (@marshmellow42)
 - Adjusted lf t55xx write input variables (@marshmellow42)
 - Adjusted lf t55xx read with password safety check and warning text and adjusted the input variables (@marshmellow42 & @iceman1001)
 - Adjusted LF FSK demod to account for cross threshold fluctuations (898 count waves will adjust the 9 to 8 now...) more accurate. (@marshmellow42)
 - Adjusted timings for t55xx commands.  more reliable now. (@marshmellow42 & @iceman1001)
 - `lf cmdread` adjusted input methods and added help text (@marshmellow42 & @iceman1001)
 - changed `lf config t <threshold>` to be 0 - 128 and will trigger on + or - threshold value (@marshmellow42)
 - `hf iclass dump` cli options - can now dump AA1 and AA2 with different keys in one run (does not go to multiple pages for the larger tags yet) (@marshmellow42)
 - Revised workflow for StandAloneMode14a (Craig Young)
 - EPA functions (`hf epa`) now support both ISO 14443-A and 14443-B cards (@frederikmoellers)
 - `hw version` only talks to ARM at startup, after that the info is cached. (@pwpiwi)
 - Added `r` option to iclass functions - allows key to be provided in raw block 3/4 format

## [2.2.0][2015-07-12]

### Changed
 - Added `hf 14b raw -s` option to auto select a 14b std tag before raw command
 - Changed `hf 14b write` to `hf 14b sriwrite` as it only applied to sri tags (@marshmellow42)
 - Added `hf 14b info` to `hf search` (@marshmellow42)
 - Added compression of fpga config and data, *BOOTROM REFLASH REQUIRED* (@pwpiwi)
 - Implemented better detection of mifare-tags that are not vulnerable to classic attacks (`hf mf mifare`, `hf mf nested`) (@pwpiwi)

### Added
 - Added `hf 14b reader` to find and print general info about known 14b tags (@marshmellow42)
 - Added `hf 14b info` to find and print info about std 14b tags and sri tags (using 14b raw commands in the client)  (@marshmellow42)
 - Added PACE replay functionality (@frederikmoellers)

### Fixed
 - t55xx write timing (@marshmellow42)


## [2.1.0][2015-06-23]

### Changed
 - Added ultralight/ntag tag type detection to `hf 14a read` (@marshmellow42)
 - Improved ultralight dump command to auto detect tag type, take authentication, and dump full memory (or subset specified) of known tag types (@iceman1001 / @marshmellow42)
 - Combined ultralight read/write commands and added authentication (@iceman1001)
 - Improved LF manchester and biphase demodulation and ask clock detection especially for reads with heavy clipping. (@marshmellow42)
 - Iclass read, `hf iclass read` now also reads tag config and prints configuration. (@holiman)
 - *bootrom* needs to be flashed, due to new address boundaries between os and fpga, after a size optimization (@pwpiwi)

### Fixed
 - Fixed EM4x50 read/demod of the tags broadcasted memory blocks. `lf em4x em4x50read` (not page read) (@marshmellow42)
 - Fixed issue #19, problems with LF T55xx commands (@iceman1001, @marshmellow42)
 - Fixed various problems with iso14443b, issue #103 (@pwpiwi, @marshmellow42)

### Added
 - Added `hf search` - currently tests for 14443a tags, iclass tags, and 15693 tags (@marshmellow42)
 - Added `hf mfu info` Ultralight/NTAG info command - reads tag configuration and info, allows authentication if needed (@iceman1001, @marshmellow42)
 - Added Mifare Ultralight C and Ultralight EV1/NTAG authentication. (@iceman1001)
 - Added changelog
 - Added `data fdxbdemod` - Demodulate a FDX-B ISO11784/85 Biphase tag from GraphBuffer aka ANIMAL TAG (@marshmellow42, @iceman1001)

## [2.0.0] - 2015-03-25
### Changed
 - LF sim operations now abort when new commands arrive over the USB - not required to push the device button anymore.

### Fixed
 - Mifare simulation, `hf mf sim` (was broken a long time) (@pwpiwi)
 - Major improvements in LF area and data operations. (@marshmellow42, @iceman1001)
 - Issues regarding LF simulation (@pwpiwi)

### Added
 - iClass functionality: full simulation of iclass tags, so tags can be simulated with data (not only CSN). Not yet support for write/update, but readers do not seem to enforce update. (@holiman).
 - iClass decryption. Proxmark can now decrypt data on an iclass tag, but requires you to have the HID decryption key locally on your computer, as this is not bundled with the sourcecode.
