/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.MatchedStringMatcher;
import proguard.util.OrMatcher;
import proguard.util.SettableMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.VariableStringMatcher;

public class ClassNameParser
implements StringParser {
    private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D'};
    private List variableStringMatchers;

    public ClassNameParser() {
        this(null);
    }

    public ClassNameParser(List list) {
        this.variableStringMatchers = list;
    }

    @Override
    public StringMatcher parse(String string) {
        int n;
        StringMatcher stringMatcher = new EmptyStringMatcher();
        for (n = 0; n < string.length(); ++n) {
            if (string.regionMatches(n, "L///;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                stringMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{')'}, 0, Integer.MAX_VALUE, settableMatcher));
                settableMatcher.setMatcher(this.parse(string.substring(n + 5)));
                break;
            }
            if (string.regionMatches(n, "L***;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                stringMatcher = this.rememberVariableStringMatcher(this.createAnyTypeMatcher(settableMatcher));
                settableMatcher.setMatcher(this.parse(string.substring(n + 5)));
                break;
            }
            if (string.regionMatches(n, "**", 0, 2)) {
                SettableMatcher settableMatcher = n + 2 == string.length() ? null : new SettableMatcher();
                stringMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, settableMatcher));
                if (settableMatcher == null) break;
                settableMatcher.setMatcher(this.parse(string.substring(n + 2)));
                break;
            }
            if (string.charAt(n) == '*') {
                SettableMatcher settableMatcher = new SettableMatcher();
                stringMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{';', '/'}, 0, Integer.MAX_VALUE, settableMatcher));
                settableMatcher.setMatcher(this.parse(string.substring(n + 1)));
                break;
            }
            if (string.charAt(n) == '?') {
                SettableMatcher settableMatcher = new SettableMatcher();
                stringMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{';', '/'}, 1, 1, settableMatcher));
                settableMatcher.setMatcher(this.parse(string.substring(n + 1)));
                break;
            }
            if (string.charAt(n) == '%') {
                SettableMatcher settableMatcher = new SettableMatcher();
                stringMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(PRIMITIVE_TYPES, null, 1, 1, settableMatcher));
                settableMatcher.setMatcher(this.parse(string.substring(n + 1)));
                break;
            }
            int n2 = this.wildCardIndex(string, n);
            if (n2 <= 0) continue;
            int n3 = string.indexOf(62, n + 1);
            stringMatcher = new MatchedStringMatcher(this.retrieveVariableStringMatcher(n2 - 1), this.parse(string.substring(n3 + 1)));
            break;
        }
        return n != 0 ? new FixedStringMatcher(string.substring(0, n), stringMatcher) : stringMatcher;
    }

    private VariableStringMatcher createAnyTypeMatcher(StringMatcher stringMatcher) {
        return new VariableStringMatcher(new char[]{'['}, null, 0, 255, new OrMatcher(new VariableStringMatcher(PRIMITIVE_TYPES, null, 1, 1, stringMatcher), new VariableStringMatcher(new char[]{'L'}, null, 1, 1, new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, new VariableStringMatcher(new char[]{';'}, null, 1, 1, stringMatcher)))));
    }

    private VariableStringMatcher rememberVariableStringMatcher(VariableStringMatcher variableStringMatcher) {
        if (this.variableStringMatchers != null) {
            this.variableStringMatchers.add(variableStringMatcher);
        }
        return variableStringMatcher;
    }

    private VariableStringMatcher retrieveVariableStringMatcher(int n) {
        return (VariableStringMatcher)this.variableStringMatchers.get(n);
    }

    private int wildCardIndex(String string, int n) throws IllegalArgumentException {
        if (string.charAt(n) != '<') {
            return 0;
        }
        int n2 = string.indexOf(62, n);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing closing angular bracket after opening bracket at index " + n + " in [" + string + "]");
        }
        if (this.variableStringMatchers == null) {
            throw new IllegalArgumentException("References to wildcards are not supported in this argument [" + string + "]");
        }
        String string2 = string.substring(n + 1, n2);
        try {
            int n3 = Integer.parseInt(string2);
            if (n3 < 1 || n3 > this.variableStringMatchers.size()) {
                throw new IllegalArgumentException("Invalid reference to wildcard (" + n3 + ", must lie between 1 and " + this.variableStringMatchers.size() + " in [" + string + "])");
            }
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Reference to wildcard must be a number [" + string2 + "] in [" + string + "]");
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Regular expression [" + stringArray[0] + "]");
            ClassNameParser classNameParser = new ClassNameParser();
            StringMatcher stringMatcher = classNameParser.parse(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + stringMatcher.matches(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

