/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.shrink.AnnotationUsageMarker;
import proguard.shrink.ClassShrinker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.LocalVariableTypeUsageMarker;
import proguard.shrink.NestUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFilter;
import proguard.util.PrintWriterUtil;

public class Shrinker {
    private final Configuration configuration;

    public Shrinker(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        Object object;
        Object object2;
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintWriter printWriter = new PrintWriter(System.out, true);
        classPool.classesAccept(new ClassCleaner());
        classPool2.classesAccept(new ClassCleaner());
        UsageMarker usageMarker = this.configuration.whyAreYouKeeping == null ? new UsageMarker() : new ShortestUsageMarker();
        MultiClassVisitor multiClassVisitor = new MultiClassVisitor(usageMarker, new NamedMethodVisitor("<init>", "()V", usageMarker));
        ClassPoolVisitor classPoolVisitor = new KeepClassSpecificationVisitorFactory(true, false, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)multiClassVisitor, (MemberVisitor)usageMarker, (MemberVisitor)usageMarker, (AttributeVisitor)usageMarker);
        classPool.accept(classPoolVisitor);
        classPool2.accept(classPoolVisitor);
        classPool2.classesAccept(usageMarker);
        classPool.classesAccept(new UsedClassFilter(usageMarker, new AllAttributeVisitor(true, new MultiAttributeVisitor(new InnerUsageMarker(usageMarker), new NestUsageMarker(usageMarker), new AnnotationUsageMarker(usageMarker), new LocalVariableTypeUsageMarker(usageMarker)))));
        classPool.classesAccept(new InterfaceUsageMarker(usageMarker));
        if (this.configuration.whyAreYouKeeping != null) {
            printWriter.println();
            object2 = new ShortestUsagePrinter((ShortestUsageMarker)usageMarker, this.configuration.verbose, printWriter);
            object = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.whyAreYouKeeping, (ClassVisitor)object2, (MemberVisitor)object2, (MemberVisitor)object2, null);
            classPool.accept((ClassPoolVisitor)object);
            classPool2.accept((ClassPoolVisitor)object);
        }
        if (this.configuration.printUsage != null) {
            object2 = PrintWriterUtil.createPrintWriterOut(this.configuration.printUsage);
            try {
                classPool.classesAcceptAlphabetically(new UsagePrinter(usageMarker, true, (PrintWriter)object2));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printUsage, (PrintWriter)object2);
            }
        }
        int n = classPool.size();
        object = new ClassPool();
        classPool.classesAccept(new UsedClassFilter(usageMarker, new MultiClassVisitor(new ClassShrinker(usageMarker), new ClassPoolFiller((ClassPool)object))));
        classPool.clear();
        classPool2.classesAccept(new ClassShrinker(usageMarker));
        int n2 = ((ClassPool)object).size();
        if (this.configuration.verbose) {
            printWriter.println("Removing unused program classes and class elements...");
            printWriter.println("  Original number of program classes: " + n);
            printWriter.println("  Final number of program classes:    " + n2);
        }
        if (!(n2 != 0 || this.configuration.warn != null && this.configuration.warn.isEmpty())) {
            if (this.configuration.ignoreWarnings) {
                System.err.println("Warning: the output jar is empty. Did you specify the proper '-keep' options?");
            } else {
                throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
            }
        }
        return object;
    }
}

