/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintWriter;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.ShortestUsageMarker;

public class ShortestUsagePrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final ShortestUsageMarker shortestUsageMarker;
    private final boolean verbose;
    private final PrintWriter pw;

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean bl, PrintWriter printWriter) {
        this.shortestUsageMarker = shortestUsageMarker;
        this.verbose = bl;
        this.pw = printWriter;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.pw.println(ClassUtil.externalClassName(programClass.getName()));
        this.printReason(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.pw.println(ClassUtil.externalClassName(libraryClass.getName()));
        this.pw.println("  is a library class.\n");
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string = programField.getName(programClass);
        String string2 = programField.getDescriptor(programClass);
        this.pw.println(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, string, string2) : "." + string));
        this.printReason(programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        String string2 = programMethod.getDescriptor(programClass);
        this.pw.print(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, string, string2) : "." + string));
        programMethod.attributesAccept(programClass, this);
        this.pw.println();
        this.printReason(programMethod);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String string = libraryField.getName(libraryClass);
        String string2 = libraryField.getDescriptor(libraryClass);
        this.pw.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, string, string2) : "." + string));
        this.pw.println("  is a library field.\n");
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String string = libraryMethod.getName(libraryClass);
        String string2 = libraryMethod.getDescriptor(libraryClass);
        this.pw.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), 0, string, string2) : "." + string));
        this.pw.println("  is a library method.\n");
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.pw.print(" (" + lineNumberTableAttribute.getLowestLineNumber() + ":" + lineNumberTableAttribute.getHighestLineNumber() + ")");
    }

    private void printReason(VisitorAccepter visitorAccepter) {
        if (this.shortestUsageMarker.isUsed(visitorAccepter)) {
            ShortestUsageMark shortestUsageMark = this.shortestUsageMarker.getShortestUsageMark(visitorAccepter);
            this.pw.print("  " + shortestUsageMark.getReason());
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
        } else {
            this.pw.println("  is not being kept.\n");
        }
    }
}

