/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExtendedLineNumberInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ExceptionInfoAdder;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.DynamicInvocationMarker;
import proguard.optimize.info.FinalFieldAssignmentMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.NonEmptyStackReturnMarker;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.SideEffectClassChecker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.info.SynchronizedBlockMethodMarker;

public class MethodInliner
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor,
ExceptionInfoVisitor,
LineNumberInfoVisitor {
    private static final int MAXIMUM_INLINED_CODE_LENGTH_JVM = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "8"));
    private static final int MAXIMUM_INLINED_CODE_LENGTH_android = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "32"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JSE = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "7000"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JME = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "2000"));
    static final int METHOD_DUMMY_START_LINE_NUMBER = 0;
    static final int INLINED_METHOD_END_LINE_NUMBER = -1;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DETAILS = false;
    private final boolean microEdition;
    private final boolean android;
    private final boolean allowAccessModification;
    private final boolean inlineSingleInvocations;
    private final InstructionVisitor extraInlinedInvocationVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private final MemberVisitor accessMethodMarker = new OptimizationInfoMemberFilter(new AllAttributeVisitor(new AllInstructionVisitor(new MultiInstructionVisitor(new SuperInvocationMarker(), new AccessMethodMarker()))));
    private final AttributeVisitor methodInvocationMarker = new AllInstructionVisitor(new MethodInvocationMarker());
    private final StackSizeComputer stackSizeComputer = new StackSizeComputer();
    private ProgramClass targetClass;
    private ProgramMethod targetMethod;
    private ConstantAdder constantAdder;
    private ExceptionInfoAdder exceptionInfoAdder;
    private int estimatedResultingCodeLength;
    private boolean inlining;
    private Stack inliningMethods = new Stack();
    private boolean emptyInvokingStack;
    private boolean coveredByCatchAllHandler;
    private int exceptionInfoCount;
    private int uninitializedObjectCount;
    private int variableOffset;
    private boolean inlined;
    private boolean inlinedAny;
    private boolean copiedLineNumbers;
    private String source;
    private int minimumLineNumberIndex;

    public MethodInliner(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(bl, bl2, bl3, bl4, null);
    }

    public MethodInliner(boolean bl, boolean bl2, boolean bl3, boolean bl4, InstructionVisitor instructionVisitor) {
        this.microEdition = bl;
        this.android = bl2;
        this.allowAccessModification = bl3;
        this.inlineSingleInvocations = bl4;
        this.extraInlinedInvocationVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while inlining method:");
            System.err.println("  Target class   = [" + this.targetClass.getName() + "]");
            System.err.println("  Target method  = [" + this.targetMethod.getName(this.targetClass) + this.targetMethod.getDescriptor(this.targetClass) + "]");
            if (this.inlining) {
                System.err.println("  Inlined class  = [" + clazz.getName() + "]");
                System.err.println("  Inlined method = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            }
            System.err.println("  Exception      = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            runtimeException.printStackTrace();
            System.err.println("Not inlining this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.inlining) {
            this.targetClass = (ProgramClass)clazz;
            this.targetMethod = (ProgramMethod)method;
            this.constantAdder = new ConstantAdder(this.targetClass);
            this.exceptionInfoAdder = new ExceptionInfoAdder(this.targetClass, this.codeAttributeComposer);
            this.estimatedResultingCodeLength = codeAttribute.u4codeLength;
            this.inliningMethods.clear();
            this.uninitializedObjectCount = method.getName(clazz).equals("<init>") ? 1 : 0;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.stackSizeComputer.visitCodeAttribute(clazz, method, codeAttribute);
            this.copyCode(clazz, method, codeAttribute);
            if (this.inlinedAny) {
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
                method.accept(clazz, this.accessMethodMarker);
            }
            this.targetClass = null;
            this.targetMethod = null;
            this.constantAdder = null;
        } else if ((this.inlineSingleInvocations ? MethodInvocationMarker.getInvocationCount(method) == 1 : codeAttribute.u4codeLength <= (this.android ? MAXIMUM_INLINED_CODE_LENGTH_android : MAXIMUM_INLINED_CODE_LENGTH_JVM)) && this.estimatedResultingCodeLength + codeAttribute.u4codeLength < (this.microEdition ? MAXIMUM_RESULTING_CODE_LENGTH_JME : MAXIMUM_RESULTING_CODE_LENGTH_JSE)) {
            this.estimatedResultingCodeLength += codeAttribute.u4codeLength;
            this.storeParameters(clazz, method);
            this.copyCode(clazz, method, codeAttribute);
            this.inlined = true;
            this.inlinedAny = true;
        }
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.source = this.inlining ? clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ':' + lineNumberTableAttribute.getLowestLineNumber() + ':' + lineNumberTableAttribute.getHighestLineNumber() : null;
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        this.copiedLineNumbers = true;
    }

    private void storeParameters(Clazz clazz, Method method) {
        String string;
        int n;
        String string2 = method.getDescriptor(clazz);
        boolean bl = (method.getAccessFlags() & 8) != 0;
        int n2 = ClassUtil.internalMethodParameterSize(string2);
        int n3 = bl ? 0 : 1;
        String[] stringArray = new String[n2];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string2);
        for (n = 0; n < n2; ++n) {
            stringArray[n] = string = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize(string) != 2) continue;
            ++n;
        }
        this.codeAttributeComposer.beginCodeFragment(n2 + 1);
        for (n = n2 - 1; n >= 0; --n) {
            byte by;
            string = stringArray[n];
            if (string == null) continue;
            switch (string.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    by = 54;
                    break;
                }
                case 'J': {
                    by = 55;
                    break;
                }
                case 'F': {
                    by = 56;
                    break;
                }
                case 'D': {
                    by = 57;
                    break;
                }
                default: {
                    by = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(n2 - n - 1, new VariableInstruction(by, this.variableOffset + n3 + n));
        }
        if (!bl) {
            this.codeAttributeComposer.appendInstruction(n2, new VariableInstruction(58, this.variableOffset));
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    private void copyCode(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        String string;
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        codeAttribute.exceptionsAccept(clazz, method, this.exceptionInfoAdder);
        this.copiedLineNumbers = false;
        this.minimumLineNumberIndex = 0;
        codeAttribute.attributesAccept(clazz, method, this);
        if (!this.copiedLineNumbers) {
            string = this.inlining ? clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ":0:0" : null;
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, new ExtendedLineNumberInfo(0, 0, string)) + 1;
        }
        if (this.inlining) {
            string = clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ":0:0";
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, new ExtendedLineNumberInfo(codeAttribute.u4codeLength, -1, string)) + 1;
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(n, instruction);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        if (this.inlining) {
            switch (simpleInstruction.opcode) {
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    if (n < codeAttribute.u4codeLength - 1) {
                        BranchInstruction branchInstruction = new BranchInstruction(-56, codeAttribute.u4codeLength - n);
                        this.codeAttributeComposer.appendInstruction(n, branchInstruction);
                    } else {
                        this.codeAttributeComposer.appendLabel(n);
                    }
                    return;
                }
            }
        }
        this.codeAttributeComposer.appendInstruction(n, simpleInstruction);
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        if (this.inlining) {
            variableInstruction.variableIndex += this.variableOffset;
        }
        this.codeAttributeComposer.appendInstruction(n, variableInstruction);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: {
                ++this.uninitializedObjectCount;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.inlined = false;
                this.codeAttributeComposer.appendLabel(n);
                this.emptyInvokingStack = !this.inlining && this.stackSizeComputer.isReachable(n) && this.stackSizeComputer.getStackSizeAfter(n) == 0;
                this.variableOffset += codeAttribute.u2maxLocals;
                this.coveredByCatchAllHandler = false;
                this.exceptionInfoCount = 0;
                codeAttribute.exceptionsAccept(clazz, method, n, this);
                this.coveredByCatchAllHandler = this.exceptionInfoCount > 0 ? this.coveredByCatchAllHandler : true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                this.variableOffset -= codeAttribute.u2maxLocals;
                if (!this.inlined) break;
                if (this.extraInlinedInvocationVisitor != null) {
                    this.extraInlinedInvocationVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
                }
                return;
            }
        }
        if (this.inlining) {
            constantInstruction.constantIndex = this.constantAdder.addConstant(clazz, constantInstruction.constantIndex);
        }
        this.codeAttributeComposer.appendInstruction(n, constantInstruction);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        refConstant.referencedMemberAccept(this);
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int n = programMethod.getAccessFlags();
        if (!(KeepMarker.isKept(programMethod) || !this.DEBUG("Access?") || (n & 0x1A) == 0 || !this.DEBUG("Synchronized?") || (n & 0x520) != 0 || !this.DEBUG("Init?") || programMethod.getName(programClass).equals("<init>") || !this.DEBUG("Self?") || programMethod.equals(this.targetMethod) && programClass.equals(this.targetClass) || !this.DEBUG("Recurse?") || this.inliningMethods.contains(programMethod) || !this.DEBUG("Version?") || this.targetClass.u4version < programClass.u4version || !this.DEBUG("Super?") || (SuperInvocationMarker.invokesSuperMethods(programMethod) || DynamicInvocationMarker.invokesDynamically(programMethod)) && !programClass.equals(this.targetClass) || !this.DEBUG("Branch?") || BackwardBranchMarker.branchesBackward(programMethod) && this.uninitializedObjectCount != 0 || !this.DEBUG("Access private?") || !this.allowAccessModification && (AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) || AccessMethodMarker.accessesPackageCode(programMethod) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName()))) || !this.DEBUG("Access private in subclass?") || AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) && this.targetClass.extendsOrImplements(programClass) || !this.DEBUG("Access protected?") || AccessMethodMarker.accessesProtectedCode(programMethod) && !programClass.equals(this.targetClass) || !this.DEBUG("Synchronization?") || SynchronizedBlockMethodMarker.hasSynchronizedBlock(programMethod) && !this.coveredByCatchAllHandler || !this.DEBUG("Final fields?") || FinalFieldAssignmentMarker.assignsFinalField(programMethod) || !this.DEBUG("Catch?") || CatchExceptionMarker.catchesExceptions(programMethod) && !this.emptyInvokingStack || !this.DEBUG("Stack?") || NonEmptyStackReturnMarker.returnsWithNonEmptyStack(programMethod) || !this.DEBUG("Side effects?") || SideEffectClassChecker.mayHaveSideEffects(this.targetClass, programClass, programMethod))) {
            boolean bl = this.inlining;
            this.inlining = true;
            this.inliningMethods.push(programMethod);
            programMethod.attributesAccept(programClass, this);
            if (!KeepMarker.isKept(this.targetMethod)) {
                ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(this.targetMethod).merge(MethodOptimizationInfo.getMethodOptimizationInfo(programMethod));
            }
            programMethod.attributesAccept(programClass, this.methodInvocationMarker);
            this.inlining = bl;
            this.inliningMethods.pop();
        } else if (programMethod.getName(programClass).equals("<init>")) {
            --this.uninitializedObjectCount;
        }
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        try {
            String string = lineNumberInfo.getSource() != null ? lineNumberInfo.getSource() : this.source;
            LineNumberInfo lineNumberInfo2 = string != null ? new ExtendedLineNumberInfo(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber, string) : new LineNumberInfo(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber);
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, lineNumberInfo2) + 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean DEBUG(String string) {
        return true;
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        ++this.exceptionInfoCount;
        this.coveredByCatchAllHandler |= exceptionInfo.u2catchType == 0;
    }
}

