/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.MutableBoolean;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.ReferenceEscapeChecker;
import proguard.optimize.info.SideEffectClassChecker;

public class ParameterEscapeMarker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ParameterVisitor {
    private static final boolean DEBUG = false;
    private final MutableBoolean repeatTrigger;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final ReferenceEscapeChecker referenceEscapeChecker;
    private final boolean runReferenceEscapeChecker;
    private final MemberVisitor parameterMarker = new AllParameterVisitor(true, this);
    private Method referencingMethod;
    private int referencingOffset;
    private int referencingPopCount;
    private boolean isReturnValueEscaping;
    private boolean isReturnValueModified;

    public ParameterEscapeMarker(MutableBoolean mutableBoolean) {
        this(mutableBoolean, new BasicValueFactory());
    }

    public ParameterEscapeMarker(MutableBoolean mutableBoolean, ValueFactory valueFactory) {
        this(mutableBoolean, valueFactory, new ReferenceTracingValueFactory(valueFactory));
    }

    public ParameterEscapeMarker(MutableBoolean mutableBoolean, ValueFactory valueFactory, ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(mutableBoolean, new PartialEvaluator(referenceTracingValueFactory, new ParameterTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    public ParameterEscapeMarker(MutableBoolean mutableBoolean, PartialEvaluator partialEvaluator, boolean bl) {
        this(mutableBoolean, partialEvaluator, bl, new ReferenceEscapeChecker(partialEvaluator, false), true);
    }

    public ParameterEscapeMarker(MutableBoolean mutableBoolean, PartialEvaluator partialEvaluator, boolean bl, ReferenceEscapeChecker referenceEscapeChecker, boolean bl2) {
        this.repeatTrigger = mutableBoolean;
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = bl;
        this.referenceEscapeChecker = referenceEscapeChecker;
        this.runReferenceEscapeChecker = bl2;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int n = programMethod.getAccessFlags();
        if ((n & 0x100) != 0) {
            this.markModifiedParameters((Method)programMethod, -1L);
            this.markEscapingParameters((Method)programMethod, -1L);
            this.markReturnedParameters((Method)programMethod, -1L);
            this.markAnythingModified(programMethod);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.runReferenceEscapeChecker) {
            this.referenceEscapeChecker.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 83: {
                this.markModifiedParameters(method, n, simpleInstruction.stackPopCount(clazz) - 1);
                this.markEscapingParameters(method, n, 0);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                this.markModifiedParameters(method, n, simpleInstruction.stackPopCount(clazz) - 1);
                break;
            }
            case -80: {
                this.markReturnedParameters(clazz, method, n, 0);
                break;
            }
            case -65: {
                this.markEscapingParameters(method, n, 0);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: 
            case -69: 
            case -67: 
            case -59: 
            case 18: 
            case 19: {
                this.referencingMethod = method;
                this.referencingOffset = n;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -77: {
                this.markAnythingModified(method);
                this.markEscapingParameters(method, n, 0);
                break;
            }
            case -76: {
                this.markEscapingParameters(method, n, 0);
                break;
            }
            case -75: {
                this.markModifiedParameters(method, n, constantInstruction.stackPopCount(clazz) - 1);
                this.markEscapingParameters(method, n, 0);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                this.referencingMethod = method;
                this.referencingOffset = n;
                this.referencingPopCount = constantInstruction.stackPopCount(clazz);
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Clazz clazz2 = stringConstant.referencedClass;
        if (clazz2 == null || SideEffectClassChecker.mayHaveSideEffects(clazz, clazz2)) {
            this.markAnythingModified(this.referencingMethod);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        Clazz clazz2 = classConstant.referencedClass;
        if (clazz2 == null || SideEffectClassChecker.mayHaveSideEffects(clazz, clazz2)) {
            this.markAnythingModified(this.referencingMethod);
        }
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.markAnythingModified(this.referencingMethod);
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        Method method = (Method)refConstant.referencedMember;
        if (method == null || ParameterEscapeMarker.modifiesAnything(method) || SideEffectClassChecker.mayHaveSideEffects(clazz, refConstant.referencedClass, method)) {
            this.markAnythingModified(this.referencingMethod);
        }
        if (method == null) {
            for (int i = 0; i < this.referencingPopCount; ++i) {
                int n = this.referencingPopCount - i - 1;
                this.markEscapingParameters(this.referencingMethod, this.referencingOffset, n);
                this.markModifiedParameters(this.referencingMethod, this.referencingOffset, n);
            }
        } else {
            this.isReturnValueEscaping = this.referenceEscapeChecker.isInstanceEscaping(this.referencingOffset);
            this.isReturnValueModified = this.referenceEscapeChecker.isInstanceModified(this.referencingOffset);
            refConstant.referencedMemberAccept(this.parameterMarker);
        }
    }

    @Override
    public void visitParameter(Clazz clazz, Member member, int n, int n2, int n3, int n4, String string, Clazz clazz2) {
        if (!ClassUtil.isInternalPrimitiveType(string.charAt(0))) {
            Method method = (Method)member;
            if (ParameterEscapeMarker.isParameterEscaping(method, n) || ParameterEscapeMarker.isParameterReturned(method, n) && this.isReturnValueEscaping) {
                this.markEscapingParameters(this.referencingMethod, this.referencingOffset, n4 - n3 - 1);
            }
            if (ParameterEscapeMarker.isParameterModified(method, n) || ParameterEscapeMarker.isParameterReturned(method, n) && this.isReturnValueModified) {
                this.markModifiedParameters(this.referencingMethod, this.referencingOffset, n4 - n3 - 1);
            }
        }
    }

    private void markEscapingParameters(Method method, int n, int n2) {
        ReferenceValue referenceValue;
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        Value value = tracedStack.getTop(n2);
        if (value.computationalType() == 5 && (referenceValue = value.referenceValue()).isNull() != 1) {
            this.markEscapingParameters(method, referenceValue);
        }
    }

    private void markEscapingParameters(Method method, ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            if (!instructionOffsetValue.isMethodParameter(i)) continue;
            this.markParameterEscaping(method, instructionOffsetValue.methodParameter(i));
        }
    }

    private void markParameterEscaping(Method method, int n) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.isParameterEscaping(n) && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setParameterEscaping(n);
            if (methodOptimizationInfo.isParameterEscaping(n)) {
                this.repeatTrigger.set();
            }
        }
    }

    private void markEscapingParameters(Method method, long l) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        long l2 = methodOptimizationInfo.getEscapingParameters();
        if (((l2 ^ 0xFFFFFFFFFFFFFFFFL) & l) != 0L && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).updateEscapingParameters(l);
            if (methodOptimizationInfo.getEscapingParameters() != l2) {
                this.repeatTrigger.set();
            }
        }
    }

    public static boolean isParameterEscaping(Method method, int n) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).isParameterEscaping(n);
    }

    public static long getEscapingParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getEscapingParameters();
    }

    private void markReturnedParameters(Clazz clazz, Method method, int n, int n2) {
        ReferenceValue referenceValue;
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        Value value = tracedStack.getTop(n2);
        if (value.computationalType() == 5 && (referenceValue = value.referenceValue()).isNull() != 1 && this.mayReturnType(clazz, method, referenceValue)) {
            this.markReturnedParameters(method, referenceValue);
        }
    }

    private void markReturnedParameters(Method method, ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            if (instructionOffsetValue.isMethodParameter(i)) {
                this.markParameterReturned(method, instructionOffsetValue.methodParameter(i));
                continue;
            }
            if (instructionOffsetValue.isFieldValue(i)) {
                this.markReturnsExternalValues(method);
                continue;
            }
            if (!instructionOffsetValue.isNewinstance(i) && !instructionOffsetValue.isExceptionHandler(i)) continue;
            this.markReturnsNewInstances(method);
        }
    }

    private void markParameterReturned(Method method, int n) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.returnsParameter(n) && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setParameterReturned(n);
            if (methodOptimizationInfo.returnsParameter(n)) {
                this.repeatTrigger.set();
            }
        }
    }

    private void markReturnedParameters(Method method, long l) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        long l2 = methodOptimizationInfo.getReturnedParameters();
        if (((l2 ^ 0xFFFFFFFFFFFFFFFFL) & l) != 0L && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).updateReturnedParameters(l);
            if (methodOptimizationInfo.getReturnedParameters() != l2) {
                this.repeatTrigger.set();
            }
        }
    }

    public static boolean isParameterReturned(Method method, int n) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).returnsParameter(n);
    }

    public static long getReturnedParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getReturnedParameters();
    }

    private void markReturnsNewInstances(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.returnsNewInstances() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setReturnsNewInstances();
            if (methodOptimizationInfo.returnsNewInstances()) {
                this.repeatTrigger.set();
            }
        }
    }

    public static boolean returnsNewInstances(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).returnsNewInstances();
    }

    private void markReturnsExternalValues(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.returnsExternalValues() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setReturnsExternalValues();
            if (methodOptimizationInfo.returnsExternalValues()) {
                this.repeatTrigger.set();
            }
        }
    }

    public static boolean returnsExternalValues(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).returnsExternalValues();
    }

    private boolean mayReturnType(Clazz clazz, Method method, ReferenceValue referenceValue) {
        String string = ClassUtil.internalMethodReturnType(method.getDescriptor(clazz));
        Clazz[] clazzArray = method instanceof ProgramMethod ? ((ProgramMethod)method).referencedClasses : ((LibraryMethod)method).referencedClasses;
        Clazz clazz2 = clazzArray == null || !ClassUtil.isInternalClassType(string) ? null : clazzArray[clazzArray.length - 1];
        return referenceValue.instanceOf(string, clazz2) != -1;
    }

    private void markModifiedParameters(Method method, int n, int n2) {
        ReferenceValue referenceValue;
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        Value value = tracedStack.getTop(n2);
        if (value.computationalType() == 5 && (referenceValue = value.referenceValue()).isNull() != 1) {
            this.markModifiedParameters(method, referenceValue);
        }
    }

    private void markModifiedParameters(Method method, ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            if (instructionOffsetValue.isMethodParameter(i)) {
                this.markParameterModified(method, instructionOffsetValue.methodParameter(i));
                continue;
            }
            if (instructionOffsetValue.isNewinstance(i) || instructionOffsetValue.isExceptionHandler(i)) continue;
            this.markModifiedParameters(method, ParameterEscapeMarker.getEscapingParameters(method));
            this.markAnythingModified(method);
        }
    }

    private void markParameterModified(Method method, int n) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.isParameterModified(n) && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setParameterModified(n);
            if (methodOptimizationInfo.isParameterModified(n)) {
                this.repeatTrigger.set();
            }
        }
    }

    private void markModifiedParameters(Method method, long l) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        long l2 = methodOptimizationInfo.getModifiedParameters();
        if (((l2 ^ 0xFFFFFFFFFFFFFFFFL) & l) != 0L && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).updateModifiedParameters(l);
            if (methodOptimizationInfo.getModifiedParameters() != l2) {
                this.repeatTrigger.set();
            }
        }
    }

    public static boolean isParameterModified(Method method, int n) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).isParameterModified(n);
    }

    public static long getModifiedParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getModifiedParameters();
    }

    private void markAnythingModified(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.modifiesAnything() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setModifiesAnything();
            if (methodOptimizationInfo.modifiesAnything()) {
                this.repeatTrigger.set();
            }
        }
    }

    public static boolean modifiesAnything(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).modifiesAnything();
    }
}

