/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;

public class OptimizedTypeAdapterInitializer
extends SimplifiedVisitor
implements ClassVisitor {
    private final String typeAdapterClassName;
    private final String objectClassName;
    private final ProgramClass objectProgramClass;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo serializationIndexMap;
    private final OptimizedJsonInfo deserializationIndexMap;
    private final ClassPool instanceCreatorClasses;
    private final ClassVisitor classVisitor;

    public OptimizedTypeAdapterInitializer(String string, ProgramClass programClass, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo optimizedJsonInfo, OptimizedJsonInfo optimizedJsonInfo2, ClassPool classPool, ClassVisitor classVisitor) {
        this.typeAdapterClassName = string;
        this.objectClassName = ClassUtil.internalClassName(programClass.getName());
        this.objectProgramClass = programClass;
        this.codeAttributeEditor = codeAttributeEditor;
        this.serializationIndexMap = optimizedJsonInfo;
        this.deserializationIndexMap = optimizedJsonInfo2;
        this.instanceCreatorClasses = classPool;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        SimplifiedVisitor simplifiedVisitor;
        boolean bl;
        programClass.thisClassConstantAccept(new TypeAdapterRenamer());
        programClass.methodsAccept(new AllAttributeVisitor(new AllAttributeVisitor(new LocalVariableTypeRenamer())));
        boolean bl2 = bl = (this.objectProgramClass.getAccessFlags() & 0x4000) != 0;
        if (bl) {
            this.objectProgramClass.u2accessFlags &= 0xFFFFFFFD;
            this.objectProgramClass.u2accessFlags |= 1;
        }
        SimplifiedVisitor simplifiedVisitor2 = bl ? new EnumReadImplementer() : new ReadImplementer();
        SimplifiedVisitor simplifiedVisitor3 = simplifiedVisitor = bl ? new EnumWriteImplementer() : new WriteImplementer();
        if (this.deserializationIndexMap.classIndices.get(this.objectClassName) != null) {
            programClass.methodsAccept(new MemberNameFilter("read", (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)((Object)simplifiedVisitor2))));
        }
        if (this.serializationIndexMap.classIndices.get(this.objectClassName) != null) {
            programClass.methodsAccept(new MemberNameFilter("write", (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)((Object)simplifiedVisitor))));
        }
        this.classVisitor.visitProgramClass(programClass);
    }

    private class WriteImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private WriteImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder((ProgramClass)clazz);
            Integer n = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).serializationIndexMap.classIndices.get(OptimizedTypeAdapterInitializer.this.objectClassName);
            String string = "toJson$" + n;
            CodeAttributeEditor.Label label = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label label2 = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            instructionSequenceBuilder.aload(2).ifnonnull(label.offset());
            instructionSequenceBuilder.aload(1).invokevirtual("com/google/gson/stream/JsonWriter", "nullValue", "()Lcom/google/gson/stream/JsonWriter;").pop().goto_(label2.offset());
            instructionSequenceBuilder.label(label).aload(2).checkcast(OptimizedTypeAdapterInitializer.this.objectClassName).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "gson", "Lcom/google/gson/Gson;").aload(1).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonWriter", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_WRITER).invokevirtual(OptimizedTypeAdapterInitializer.this.objectClassName, string, OptimizedClassConstants.METHOD_TYPE_TO_JSON).label(label2).return_();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, instructionSequenceBuilder.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private class EnumWriteImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private EnumWriteImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder((ProgramClass)clazz);
            CodeAttributeEditor.Label label = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label label2 = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label label3 = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            instructionSequenceBuilder.aload(2).ifnonnull(label.offset());
            instructionSequenceBuilder.aload(1).invokevirtual("com/google/gson/stream/JsonWriter", "nullValue", "()Lcom/google/gson/stream/JsonWriter;").pop().goto_(label2.offset());
            Map<String, String[]> map = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).serializationIndexMap.classJsonInfos.get((Object)((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).objectClassName).javaToJsonFieldNames;
            Map<String, Integer> map2 = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).serializationIndexMap.jsonFieldIndices;
            instructionSequenceBuilder.label(label).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonWriter", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_WRITER).aload(1).aload(2);
            for (String string : map.keySet()) {
                CodeAttributeEditor.Label label4 = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
                String string2 = map.get(string)[0];
                instructionSequenceBuilder.dup().getstatic(OptimizedTypeAdapterInitializer.this.objectClassName, string, ClassUtil.internalTypeFromClassName(OptimizedTypeAdapterInitializer.this.objectClassName)).ifacmpne(label4.offset()).pop().ldc(map2.get(string2)).goto_(label3.offset()).label(label4);
            }
            instructionSequenceBuilder.pop().iconst_m1();
            instructionSequenceBuilder.label(label3).invokevirtual("proguard/optimize/gson/_OptimizedJsonWriter", "c", "(Lcom/google/gson/stream/JsonWriter;I)V").label(label2).return_();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, instructionSequenceBuilder.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private class ReadImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private ReadImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder((ProgramClass)clazz);
            Integer n = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).deserializationIndexMap.classIndices.get(OptimizedTypeAdapterInitializer.this.objectClassName);
            String string = "fromJson$" + n;
            CodeAttributeEditor.Label label = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            instructionSequenceBuilder.aload(1).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;");
            instructionSequenceBuilder.getstatic("com/google/gson/stream/JsonToken", "NULL", "Lcom/google/gson/stream/JsonToken;").ifacmpne(label.offset());
            instructionSequenceBuilder.aload(1).invokevirtual("com/google/gson/stream/JsonReader", "skipValue", "()V");
            instructionSequenceBuilder.aconst_null().areturn();
            instructionSequenceBuilder.label(label);
            if (OptimizedTypeAdapterInitializer.this.instanceCreatorClasses.getClass(OptimizedTypeAdapterInitializer.this.objectClassName) == null) {
                instructionSequenceBuilder.new_(OptimizedTypeAdapterInitializer.this.objectClassName).dup().invokespecial(OptimizedTypeAdapterInitializer.this.objectClassName, "<init>", "()V").astore(2);
            } else {
                instructionSequenceBuilder.aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "gson", "Lcom/google/gson/Gson;").getfield("com/google/gson/Gson", "instanceCreators", "Ljava/util/Map;").ldc(OptimizedTypeAdapterInitializer.this.instanceCreatorClasses.getClass(OptimizedTypeAdapterInitializer.this.objectClassName)).invokevirtual("java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;").checkcast("com/google/gson/InstanceCreator").ldc(OptimizedTypeAdapterInitializer.this.instanceCreatorClasses.getClass(OptimizedTypeAdapterInitializer.this.objectClassName)).invokevirtual("com/google/gson/InstanceCreator", "createInstance", "(Ljava/lang/reflect/Type;)Ljava/lang/Object;").checkcast(OptimizedTypeAdapterInitializer.this.objectClassName).astore(2);
            }
            instructionSequenceBuilder.aload(2).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "gson", "Lcom/google/gson/Gson;").aload(1).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonReader", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_READER).invokevirtual(OptimizedTypeAdapterInitializer.this.objectClassName, string, OptimizedClassConstants.METHOD_TYPE_FROM_JSON);
            instructionSequenceBuilder.aload(2).areturn();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, instructionSequenceBuilder.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private static class SwitchCase
    implements Comparable<SwitchCase> {
        private String enumConstant;
        private CodeAttributeEditor.Label label;
        private int stringIndex;

        public SwitchCase(String string, CodeAttributeEditor.Label label, int n) {
            this.enumConstant = string;
            this.label = label;
            this.stringIndex = n;
        }

        @Override
        public int compareTo(SwitchCase switchCase) {
            return this.stringIndex - switchCase.stringIndex;
        }
    }

    private class EnumReadImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private EnumReadImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            int n;
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder((ProgramClass)clazz);
            Map<String, String[]> map = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).deserializationIndexMap.classJsonInfos.get((Object)((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).objectClassName).javaToJsonFieldNames;
            Map<String, Integer> map2 = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).deserializationIndexMap.jsonFieldIndices;
            ArrayList<SwitchCase> arrayList = new ArrayList<SwitchCase>();
            for (String object2 : map.keySet()) {
                String[] i = map.get(object2);
                n = i.length;
                for (int j = 0; j < n; ++j) {
                    String string = i[j];
                    arrayList.add(new SwitchCase(object2, OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label(), map2.get(string)));
                }
            }
            Collections.sort(arrayList);
            Object object3 = new int[arrayList.size()];
            int[] nArray = new int[arrayList.size()];
            for (int label = 0; label < arrayList.size(); ++label) {
                object3[label] = ((SwitchCase)arrayList.get(label)).stringIndex;
                nArray[label] = ((SwitchCase)arrayList.get(label)).label.offset();
            }
            CodeAttributeEditor.Label label = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            instructionSequenceBuilder.aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonReader", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_READER).aload(1).invokevirtual("proguard/optimize/gson/_OptimizedJsonReader", "c", "(Lcom/google/gson/stream/JsonReader;)I");
            instructionSequenceBuilder.lookupswitch(label.offset(), (int[])object3, nArray);
            for (n = 0; n < arrayList.size(); ++n) {
                instructionSequenceBuilder.label(((SwitchCase)arrayList.get(n)).label).getstatic(OptimizedTypeAdapterInitializer.this.objectClassName, ((SwitchCase)arrayList.get(n)).enumConstant, ClassUtil.internalTypeFromClassName(OptimizedTypeAdapterInitializer.this.objectClassName)).areturn();
            }
            instructionSequenceBuilder.label(label).aconst_null().areturn();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, instructionSequenceBuilder.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private class LocalVariableTypeRenamer
    extends SimplifiedVisitor
    implements AttributeVisitor,
    LocalVariableInfoVisitor {
        private LocalVariableTypeRenamer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
            localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        }

        @Override
        public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
            String string = localVariableInfo.getDescriptor(clazz);
            if (string.equals(OptimizedClassConstants.TYPE_OPTIMIZED_TYPE_ADAPTER_IMPL)) {
                localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(ClassUtil.internalTypeFromClassName(OptimizedTypeAdapterInitializer.this.typeAdapterClassName));
            }
        }
    }

    private class TypeAdapterRenamer
    extends SimplifiedVisitor
    implements ConstantVisitor {
        private TypeAdapterRenamer() {
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            classConstant.u2nameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(OptimizedTypeAdapterInitializer.this.typeAdapterClassName);
        }
    }
}

