/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.optimize.gson.GsonAnnotationCleaner;
import proguard.optimize.gson.GsonConstructorPatcher;
import proguard.optimize.gson.GsonContext;
import proguard.optimize.gson.GsonDeserializationOptimizer;
import proguard.optimize.gson.GsonSerializationOptimizer;
import proguard.optimize.gson.OptimizedJsonFieldCollector;
import proguard.optimize.gson.OptimizedJsonFieldVisitor;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.OptimizedJsonReaderImplInitializer;
import proguard.optimize.gson.OptimizedJsonWriterImplInitializer;
import proguard.optimize.gson.OptimizedTypeAdapterAdder;
import proguard.optimize.gson.OptimizedTypeAdapterFactoryInitializer;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.util.MultiValueMap;
import proguard.util.StringUtil;

public class GsonOptimizer {
    private static final boolean DEBUG = false;
    private static final String[] TEMPLATE_CLASSES = new String[]{"proguard/optimize/gson/_OptimizedTypeAdapter", "proguard/optimize/gson/_GsonUtil", "proguard/optimize/gson/_OptimizedJsonReader", "proguard/optimize/gson/_OptimizedJsonReaderImpl", "proguard/optimize/gson/_OptimizedJsonWriter", "proguard/optimize/gson/_OptimizedJsonWriterImpl", "proguard/optimize/gson/_OptimizedTypeAdapterFactory"};

    public void execute(ClassPool classPool, ClassPool classPool2, MultiValueMap<String, String> multiValueMap, Configuration configuration) throws IOException {
        classPool.classesAccept(new ClassNameFilter(StringUtil.join(",", "com/google/gson/Gson", "com/google/gson/internal/Excluder"), (ClassVisitor)new AllFieldVisitor(new MemberAccessSetter(1))));
        classPool.classesAccept(new ClassNameFilter("com/google/gson/Gson", (ClassVisitor)new MemberAccessFlagCleaner(16)));
        PrintWriter printWriter = new PrintWriter(System.out, true);
        WarningPrinter warningPrinter = new WarningPrinter(printWriter, configuration.note);
        GsonContext gsonContext = new GsonContext();
        gsonContext.setupFor(classPool, warningPrinter);
        if (gsonContext.gsonDomainClassPool.size() > 0) {
            boolean bl;
            OptimizedJsonInfo optimizedJsonInfo = new OptimizedJsonInfo();
            OptimizedJsonInfo optimizedJsonInfo2 = new OptimizedJsonInfo();
            OptimizedJsonFieldCollector optimizedJsonFieldCollector = new OptimizedJsonFieldCollector(optimizedJsonInfo, OptimizedJsonFieldCollector.Mode.serialize);
            OptimizedJsonFieldCollector optimizedJsonFieldCollector2 = new OptimizedJsonFieldCollector(optimizedJsonInfo2, OptimizedJsonFieldCollector.Mode.deserialize);
            gsonContext.gsonDomainClassPool.classesAccept(new MultiClassVisitor(new OptimizedJsonFieldVisitor(optimizedJsonFieldCollector, optimizedJsonFieldCollector), new OptimizedJsonFieldVisitor(optimizedJsonFieldCollector2, optimizedJsonFieldCollector2)));
            gsonContext.gsonDomainClassPool.classesAccept(new GsonAnnotationCleaner(gsonContext.gsonRuntimeSettings));
            optimizedJsonInfo.assignIndices();
            optimizedJsonInfo2.assignIndices();
            ClassReader classReader = new ClassReader(false, false, false, null, new MultiClassVisitor(new ClassPresenceFilter(classPool, null, new ClassPoolFiller(classPool)), new ClassReferenceInitializer(classPool, classPool2), new ClassSubHierarchyInitializer()));
            for (String string : TEMPLATE_CLASSES) {
                classReader.read(new ClassPathDataEntry(string + ".class"));
                multiValueMap.put("com/google/gson/Gson", string);
            }
            BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, false);
            classPool.classesAccept("proguard/optimize/gson/_OptimizedJsonWriterImpl", (ClassVisitor)new MultiClassVisitor(new AllMemberVisitor(new MemberNameFilter("a", (MemberVisitor)new MemberDescriptorFilter("()[Ljava/lang/String;", (MemberVisitor)new AllAttributeVisitor(new OptimizedJsonWriterImplInitializer(classPool, classPool2, codeAttributeEditor, optimizedJsonInfo)))))));
            classPool.classesAccept("proguard/optimize/gson/_OptimizedJsonReaderImpl", (ClassVisitor)new MultiClassVisitor(new AllMemberVisitor(new MemberNameFilter("a", (MemberVisitor)new MemberDescriptorFilter("()Ljava/util/Map;", (MemberVisitor)new AllAttributeVisitor(new OptimizedJsonReaderImplInitializer(classPool, classPool2, codeAttributeEditor, optimizedJsonInfo2)))))));
            gsonContext.gsonDomainClassPool.classesAccept(new ClassAccessFilter(0, 16384, new GsonSerializationOptimizer(classPool, classPool2, gsonContext.gsonRuntimeSettings, codeAttributeEditor, optimizedJsonInfo, multiValueMap)));
            gsonContext.gsonDomainClassPool.classesAccept(new ClassAccessFilter(0, 16384, new GsonDeserializationOptimizer(classPool, classPool2, gsonContext.gsonRuntimeSettings, codeAttributeEditor, optimizedJsonInfo2, multiValueMap)));
            gsonContext.gsonDomainClassPool.classesAccept(new ClassReferenceInitializer(classPool, classPool2));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            OptimizedTypeAdapterAdder optimizedTypeAdapterAdder = new OptimizedTypeAdapterAdder(classPool, classPool2, codeAttributeEditor, optimizedJsonInfo, optimizedJsonInfo2, multiValueMap, hashMap, gsonContext.instanceCreatorClassPool);
            gsonContext.gsonDomainClassPool.classesAccept(optimizedTypeAdapterAdder);
            classPool.classAccept("proguard/optimize/gson/_OptimizedTypeAdapterFactory", new MultiClassVisitor(new AllMemberVisitor(new AllAttributeVisitor(new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new OptimizedTypeAdapterFactoryInitializer(classPool, codeAttributeEditor, hashMap, gsonContext.gsonRuntimeSettings)))), new ClassReferenceInitializer(classPool, classPool2)));
            ProgramClass programClass = (ProgramClass)classPool.getClass("com/google/gson/Gson");
            MemberCounter memberCounter = new MemberCounter();
            programClass.accept(new NamedFieldVisitor("excluder", "Lcom/google/gson/internal/Excluder;", memberCounter));
            boolean bl2 = bl = memberCounter.getCount() == 0;
            if (bl) {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass, classPool, classPool2);
                int n = constantPoolEditor.addUtf8Constant("excluder");
                int n2 = constantPoolEditor.addUtf8Constant("Lcom/google/gson/internal/Excluder;");
                ProgramField programField = new ProgramField(1, n, n2, null);
                ClassEditor classEditor = new ClassEditor(programClass);
                classEditor.addField(programField);
                programClass.fieldsAccept(new ClassReferenceInitializer(classPool, classPool2));
                programClass.constantPoolEntriesAccept(new ClassReferenceInitializer(classPool, classPool2));
            }
            classPool.classAccept("com/google/gson/Gson", new MultiClassVisitor(new AllMemberVisitor(new MemberNameFilter("<init>", (MemberVisitor)new GsonConstructorPatcher(codeAttributeEditor, bl))), new ClassReferenceInitializer(classPool, classPool2)));
            if (configuration.verbose) {
                System.out.println("  Number of optimized serializable classes:      " + gsonContext.gsonDomainClassPool.size());
            }
        }
    }
}

