/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.optimize.gson.FieldSignatureCollector;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineDeserializer;
import proguard.optimize.gson.InlineDeserializers;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.TypeTokenClassBuilder;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;
import proguard.util.MultiValueMap;

public class GsonDeserializationOptimizer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final Map<String, InlineDeserializer> inlineDeserializers = new HashMap<String, InlineDeserializer>();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo deserializationInfo;
    private final boolean supportExposeAnnotation;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private InstructionSequenceBuilder ____;
    private OptimizedJsonInfo.ClassJsonInfo classDeserializationInfo;
    private Map<String, String[]> javaToJsonFieldNames;
    private Map<String, CodeAttributeEditor.Label> caseLabelByJavaFieldName;
    private CodeAttributeEditor.Label endSwitch;

    public GsonDeserializationOptimizer(ClassPool classPool, ClassPool classPool2, GsonRuntimeSettings gsonRuntimeSettings, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo optimizedJsonInfo, MultiValueMap<String, String> multiValueMap) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.codeAttributeEditor = codeAttributeEditor;
        this.deserializationInfo = optimizedJsonInfo;
        this.supportExposeAnnotation = gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation;
        this.injectedClassNameMap = multiValueMap;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= 0xFFFFFFFD;
        programClass.u2accessFlags |= 1;
        MemberCounter memberCounter = new MemberCounter();
        programClass.methodsAccept(new MemberNameFilter("<init>", (MemberVisitor)new MemberDescriptorFilter("()V", (MemberVisitor)new MultiMemberVisitor(new MemberAccessSetter(1), memberCounter))));
        SimplifiedClassEditor simplifiedClassEditor = new SimplifiedClassEditor(programClass);
        this.____ = new InstructionSequenceBuilder(programClass, this.programClassPool, this.libraryClassPool);
        if (memberCounter.getCount() == 0) {
            this.addDefaultConstructor(programClass, simplifiedClassEditor);
        }
        int n = this.deserializationInfo.classIndices.get(programClass.getName());
        this.addFromJsonMethod(programClass, simplifiedClassEditor, n);
        this.addFromJsonFieldMethod(programClass, simplifiedClassEditor, n);
        programClass.accept(new MethodLinker());
        simplifiedClassEditor.finishEditing(this.programClassPool, this.libraryClassPool);
    }

    private void addDefaultConstructor(ProgramClass programClass, SimplifiedClassEditor simplifiedClassEditor) {
        simplifiedClassEditor.addMethod(4097, "<init>", "()V", this.____.aload_0().invokespecial(programClass.getSuperName(), "<init>", "()V").return_().instructions()).accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
    }

    private void addFromJsonMethod(ProgramClass programClass, SimplifiedClassEditor simplifiedClassEditor, int n) {
        String string = "fromJson$" + n;
        ProgramMethod programMethod = simplifiedClassEditor.addMethod(4097, string, OptimizedClassConstants.METHOD_TYPE_FROM_JSON, this.____.return_().instructions());
        programMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        programMethod.attributesAccept(programClass, new FromJsonCodeAttributeVisitor());
    }

    private void addFromJsonFieldMethod(ProgramClass programClass, SimplifiedClassEditor simplifiedClassEditor, int n) {
        String string = "fromJsonField$" + n;
        ProgramMethod programMethod = simplifiedClassEditor.addMethod(4100, string, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V", this.____.return_().instructions());
        programMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        programMethod.attributesAccept(programClass, new FromJsonFieldCodeAttributeVisitor(this.supportExposeAnnotation));
    }

    static {
        inlineDeserializers.put("B", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Byte.TYPE));
        inlineDeserializers.put("S", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Short.TYPE));
        inlineDeserializers.put("I", new InlineDeserializers.InlinePrimitiveIntegerDeserializer());
        inlineDeserializers.put("Ljava/lang/String;", new InlineDeserializers.InlineStringDeserializer());
    }

    public static class FromJsonFieldCase
    implements Comparable<FromJsonFieldCase> {
        private String javaFieldName;
        private CodeAttributeEditor.Label label;
        private int fieldIndex;

        public FromJsonFieldCase(String string, CodeAttributeEditor.Label label, int n) {
            this.javaFieldName = string;
            this.label = label;
            this.fieldIndex = n;
        }

        @Override
        public int compareTo(FromJsonFieldCase fromJsonFieldCase) {
            return this.fieldIndex - fromJsonFieldCase.fieldIndex;
        }
    }

    private class FromJsonFieldCodeAttributeVisitor
    extends SimplifiedVisitor
    implements AttributeVisitor,
    MemberVisitor {
        private int isNullLocalIndex;
        private boolean supportExposeAnnotation;

        FromJsonFieldCodeAttributeVisitor(boolean bl) {
            this.supportExposeAnnotation = bl;
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            Object object;
            Object object2;
            GsonDeserializationOptimizer.this.codeAttributeEditor.reset(1);
            GsonDeserializationOptimizer.this.endSwitch = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            if (GsonDeserializationOptimizer.this.javaToJsonFieldNames.size() > 0) {
                object2 = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                object = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                this.isNullLocalIndex = codeAttribute.u2maxLocals;
                GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;").getstatic("com/google/gson/stream/JsonToken", "NULL", "Lcom/google/gson/stream/JsonToken;");
                GsonDeserializationOptimizer.this.____.ifacmpeq(((CodeAttributeEditor.Label)object2).offset()).iconst_1().goto_(((CodeAttributeEditor.Label)object).offset()).label((Instruction)object2).iconst_0().label((Instruction)object).istore(this.isNullLocalIndex);
                this.generateSwitchTables(clazz);
            }
            if (!clazz.getSuperClass().getName().equals("java/lang/Object")) {
                object2 = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classIndices.get(clazz.getSuperClass().getName());
                object = "fromJsonField$" + object2;
                GsonDeserializationOptimizer.this.____.aload(0).aload(1).aload(2).iload(3).invokevirtual(clazz.getSuperClass().getName(), (String)object, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
            } else {
                GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "skipValue", "()V");
            }
            GsonDeserializationOptimizer.this.____.label(GsonDeserializationOptimizer.this.endSwitch).return_();
            GsonDeserializationOptimizer.this.codeAttributeEditor.replaceInstruction(0, GsonDeserializationOptimizer.this.____.instructions());
            GsonDeserializationOptimizer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }

        private void generateSwitchTables(Clazz clazz) {
            Set<String> set = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).classDeserializationInfo.exposedJavaFieldNames;
            Set<String> set2 = this.supportExposeAnnotation ? set : GsonDeserializationOptimizer.this.javaToJsonFieldNames.keySet();
            this.generateSwitchTable(clazz, GsonDeserializationOptimizer.this.javaToJsonFieldNames, set2);
            if (this.supportExposeAnnotation) {
                CodeAttributeEditor.Label label = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                GsonDeserializationOptimizer.this.____.aload(1).getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "requireExpose", "Z").ifne(label.offset());
                HashSet<String> hashSet = new HashSet<String>();
                for (String string : GsonDeserializationOptimizer.this.javaToJsonFieldNames.keySet()) {
                    if (set.contains(string)) continue;
                    hashSet.add(string);
                }
                this.generateSwitchTable(clazz, GsonDeserializationOptimizer.this.javaToJsonFieldNames, hashSet);
                GsonDeserializationOptimizer.this.____.label(label);
            }
        }

        private void generateSwitchTable(Clazz clazz, Map<String, String[]> map, Set<String> set) {
            Object object;
            Map.Entry<String, String[]> entry2;
            ArrayList<FromJsonFieldCase> arrayList = new ArrayList<FromJsonFieldCase>();
            for (Map.Entry<String, String[]> entry2 : map.entrySet()) {
                if (!set.contains(entry2.getKey())) continue;
                String[] stringArray = entry2.getValue();
                object = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                for (String string : stringArray) {
                    arrayList.add(new FromJsonFieldCase((String)entry2.getKey(), (CodeAttributeEditor.Label)object, ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.jsonFieldIndices.get(string)));
                }
            }
            Collections.sort(arrayList);
            Object object2 = new int[arrayList.size()];
            entry2 = (Map.Entry<String, String[]>)new int[arrayList.size()];
            GsonDeserializationOptimizer.this.caseLabelByJavaFieldName = new HashMap();
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (FromJsonFieldCase)arrayList.get(i);
                object2[i] = ((FromJsonFieldCase)object).fieldIndex;
                entry2[i] = ((FromJsonFieldCase)object).label.offset();
                GsonDeserializationOptimizer.this.caseLabelByJavaFieldName.put(((FromJsonFieldCase)object).javaFieldName, ((FromJsonFieldCase)object).label);
            }
            CodeAttributeEditor.Label label = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            GsonDeserializationOptimizer.this.____.iload(3).lookupswitch(label.offset(), (int[])object2, (int[])entry2);
            clazz.fieldsAccept(new MemberAccessFilter(0, 4104, this));
            GsonDeserializationOptimizer.this.____.label(label);
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            CodeAttributeEditor.Label label = (CodeAttributeEditor.Label)GsonDeserializationOptimizer.this.caseLabelByJavaFieldName.get(programField.getName(programClass));
            if (label != null) {
                programField.accept(programClass, (MemberVisitor)new MemberAccessFlagCleaner(16));
                CodeAttributeEditor.Label label2 = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
                GsonDeserializationOptimizer.this.____.label(label).iload(this.isNullLocalIndex).ifeq(label2.offset());
                String string = programField.getDescriptor(programClass);
                FieldSignatureCollector fieldSignatureCollector = new FieldSignatureCollector();
                programField.attributesAccept(programClass, fieldSignatureCollector);
                InlineDeserializer inlineDeserializer = (InlineDeserializer)inlineDeserializers.get(string);
                if (inlineDeserializer != null && inlineDeserializer.canDeserialize(GsonDeserializationOptimizer.this.gsonRuntimeSettings)) {
                    inlineDeserializer.deserialize(programClass, programField, GsonDeserializationOptimizer.this.codeAttributeEditor, GsonDeserializationOptimizer.this.____, GsonDeserializationOptimizer.this.gsonRuntimeSettings);
                } else {
                    String string2;
                    String string3;
                    if (ClassUtil.isInternalPrimitiveType(string)) {
                        string2 = string3 = ClassUtil.internalNumericClassNameFromPrimitiveType(string.charAt(0));
                    } else {
                        string3 = ClassUtil.internalClassNameFromClassType(string);
                        string2 = string;
                    }
                    String string4 = null;
                    if (fieldSignatureCollector.getFieldSignature() != null) {
                        ProgramClass programClass2 = new TypeTokenClassBuilder(programClass, programField, fieldSignatureCollector.getFieldSignature()).build(GsonDeserializationOptimizer.this.programClassPool);
                        GsonDeserializationOptimizer.this.programClassPool.addClass(programClass2);
                        programClass2.accept(new ClassReferenceInitializer(GsonDeserializationOptimizer.this.programClassPool, GsonDeserializationOptimizer.this.libraryClassPool));
                        string4 = programClass2.getName();
                        GsonDeserializationOptimizer.this.injectedClassNameMap.put(programClass.getName(), string4);
                    }
                    if (string4 == null) {
                        GsonDeserializationOptimizer.this.____.aload(0).aload(1).ldc(string2, GsonDeserializationOptimizer.this.programClassPool.getClass(string3)).invokevirtual("com/google/gson/Gson", "getAdapter", "(Ljava/lang/Class;)Lcom/google/gson/TypeAdapter;");
                    } else {
                        GsonDeserializationOptimizer.this.____.aload(0).aload(1).new_(string4).dup().invokespecial(string4, "<init>", "()V").invokevirtual("com/google/gson/Gson", "getAdapter", "(Lcom/google/gson/reflect/TypeToken;)Lcom/google/gson/TypeAdapter;");
                    }
                    GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/TypeAdapter", "read", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;").checkcast(string2, GsonDeserializationOptimizer.this.programClassPool.getClass(string3));
                    switch (string.charAt(0)) {
                        case 'Z': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                            break;
                        }
                        case 'B': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Byte", "byteValue", "()B");
                            break;
                        }
                        case 'C': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Character", "charValue", "()C");
                            break;
                        }
                        case 'S': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Short", "shortValue", "()S");
                            break;
                        }
                        case 'I': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Integer", "intValue", "()I");
                            break;
                        }
                        case 'J': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Long", "longValue", "()J");
                            break;
                        }
                        case 'F': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Float", "floatValue", "()F");
                            break;
                        }
                        case 'D': {
                            GsonDeserializationOptimizer.this.____.invokevirtual("java/lang/Double", "doubleValue", "()D");
                        }
                    }
                    GsonDeserializationOptimizer.this.____.putfield(programClass, programField);
                }
                GsonDeserializationOptimizer.this.____.goto_(GsonDeserializationOptimizer.this.endSwitch.offset());
                GsonDeserializationOptimizer.this.____.label(label2);
                if (!ClassUtil.isInternalPrimitiveType(string)) {
                    GsonDeserializationOptimizer.this.____.aload(0).aconst_null().putfield(programClass, programField);
                }
                GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextNull", "()V").goto_(GsonDeserializationOptimizer.this.endSwitch.offset());
            }
        }
    }

    private class FromJsonCodeAttributeVisitor
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private FromJsonCodeAttributeVisitor() {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            GsonDeserializationOptimizer.this.codeAttributeEditor.reset(1);
            GsonDeserializationOptimizer.this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "beginObject", "()V");
            int n = codeAttribute.u2maxLocals;
            CodeAttributeEditor.Label label = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label label2 = GsonDeserializationOptimizer.this.codeAttributeEditor.label();
            GsonDeserializationOptimizer.this.____.label(label).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "hasNext", "()Z").ifeq(label2.offset());
            GsonDeserializationOptimizer.this.____.aload(3).aload(2).invokeinterface("proguard/optimize/gson/_OptimizedJsonReader", "b", "(Lcom/google/gson/stream/JsonReader;)I").istore(n);
            GsonDeserializationOptimizer.this.classDeserializationInfo = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classJsonInfos.get(clazz.getName());
            GsonDeserializationOptimizer.this.javaToJsonFieldNames = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).classDeserializationInfo.javaToJsonFieldNames;
            Integer n2 = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classIndices.get(clazz.getName());
            String string = "fromJsonField$" + n2;
            GsonDeserializationOptimizer.this.____.aload(0).aload(1).aload(2).iload(n).invokevirtual(clazz.getName(), string, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
            GsonDeserializationOptimizer.this.____.goto_(label.offset());
            GsonDeserializationOptimizer.this.____.label(label2).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "endObject", "()V").return_();
            GsonDeserializationOptimizer.this.codeAttributeEditor.replaceInstruction(0, GsonDeserializationOptimizer.this.____.instructions());
            GsonDeserializationOptimizer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }
}

