/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.SingleTimeAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.gson.TypeArgumentFinder;

public class GsonDeserializationInvocationFinder
extends SimplifiedVisitor
implements InstructionVisitor {
    private static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassVisitor domainClassVisitor;
    private final WarningPrinter notePrinter;
    private final FromJsonInvocationMatcher[] fromJsonInvocationMatchers;
    private final TypedReferenceValueFactory valueFactory = new TypedReferenceValueFactory();
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.valueFactory, new BasicInvocationUnit(new TypedReferenceValueFactory()), true);
    private final AttributeVisitor lazyPartialEvaluator = new AttributeNameFilter("Code", (AttributeVisitor)new SingleTimeAttributeVisitor(this.partialEvaluator));

    public GsonDeserializationInvocationFinder(ClassPool classPool, ClassVisitor classVisitor, WarningPrinter warningPrinter) {
        this.programClassPool = classPool;
        this.domainClassVisitor = classVisitor;
        this.notePrinter = warningPrinter;
        InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder();
        Instruction[] instructionArray = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;").instructions();
        Instruction[] instructionArray2 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Instruction[] instructionArray3 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/io/Reader;Ljava/lang/Class;)Ljava/lang/Object;").instructions();
        Instruction[] instructionArray4 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/io/Reader;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Instruction[] instructionArray5 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "fromJson", "(Lcom/google/gson/stream/JsonReader;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Constant[] constantArray = instructionSequenceBuilder.constants();
        this.fromJsonInvocationMatchers = new FromJsonInvocationMatcher[]{new FromJsonInvocationMatcher(constantArray, instructionArray, 0, -1), new FromJsonInvocationMatcher(constantArray, instructionArray2, -1, 0), new FromJsonInvocationMatcher(constantArray, instructionArray3, 0, -1), new FromJsonInvocationMatcher(constantArray, instructionArray4, -1, 0), new FromJsonInvocationMatcher(constantArray, instructionArray5, -1, 0)};
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        FromJsonInvocationMatcher fromJsonInvocationMatcher = null;
        for (FromJsonInvocationMatcher fromJsonInvocationMatcher2 : this.fromJsonInvocationMatchers) {
            instruction.accept(clazz, method, codeAttribute, n, fromJsonInvocationMatcher2);
            if (!fromJsonInvocationMatcher2.isMatching()) continue;
            fromJsonInvocationMatcher = fromJsonInvocationMatcher2;
            break;
        }
        if (fromJsonInvocationMatcher != null) {
            this.lazyPartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            int n2 = fromJsonInvocationMatcher.typeStackElementIndex == -1 ? fromJsonInvocationMatcher.classStackElementIndex : fromJsonInvocationMatcher.typeStackElementIndex;
            InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getStackBefore(n).getTopActualProducerValue(n2).instructionOffsetValue();
            TypeArgumentFinder typeArgumentFinder = new TypeArgumentFinder(this.programClassPool, this.partialEvaluator);
            for (int i = 0; i < instructionOffsetValue.instructionOffsetCount(); ++i) {
                codeAttribute.instructionAccept(clazz, method, instructionOffsetValue.instructionOffset(i), typeArgumentFinder);
            }
            String[] stringArray = typeArgumentFinder.typeArgumentClasses;
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.programClassPool.classAccept(string, this.domainClassVisitor);
                }
            } else if (this.notePrinter != null) {
                this.notePrinter.print(clazz.getName(), "Note: can't derive deserialized type from fromJson() invocation in " + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz));
            }
        }
    }

    private static class FromJsonInvocationMatcher
    extends InstructionSequenceMatcher {
        private int classStackElementIndex;
        private int typeStackElementIndex;

        private FromJsonInvocationMatcher(Constant[] constantArray, Instruction[] instructionArray, int n, int n2) {
            super(constantArray, instructionArray);
            this.classStackElementIndex = n;
            this.typeStackElementIndex = n2;
        }
    }
}

