/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.NoExternalSideEffectMethodMarker;
import proguard.optimize.info.ParameterEscapeMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectClassChecker;
import proguard.optimize.info.SideEffectInstructionChecker;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.util.ArrayUtil;

public class InstructionUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator(new TypedReferenceValueFactory());
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true, true);
    private final MyParameterUsageMarker parameterUsageMarker = new MyParameterUsageMarker();
    private final MyInitialUsageMarker initialUsageMarker = new MyInitialUsageMarker();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyVariableInitializationMarker variableInitializationMarker = new MyVariableInitializationMarker();
    private final MyStackConsistencyMarker stackConsistencyMarker = new MyStackConsistencyMarker();
    private final MyExtraPushPopInstructionMarker extraPushPopInstructionMarker = new MyExtraPushPopInstructionMarker();
    private InstructionOffsetValue[] reverseDependencies = new InstructionOffsetValue[8096];
    private boolean[][] stacksNecessaryAfter = new boolean[8096][16];
    private boolean[][] stacksUnwantedBefore = new boolean[8096][16];
    private boolean[] instructionsNecessary = new boolean[8096];
    private boolean[] extraPushPopInstructionsNecessary = new boolean[8096];
    private int maxMarkedOffset;

    public InstructionUsageMarker() {
        this(new PartialEvaluator(), true);
    }

    public InstructionUsageMarker(PartialEvaluator partialEvaluator, boolean bl) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = bl;
    }

    public boolean isTraced(int n) {
        return this.partialEvaluator.isTraced(n);
    }

    public InstructionVisitor tracedInstructionFilter(InstructionVisitor instructionVisitor) {
        return this.partialEvaluator.tracedInstructionFilter(instructionVisitor);
    }

    public InstructionVisitor tracedInstructionFilter(boolean bl, InstructionVisitor instructionVisitor) {
        return this.partialEvaluator.tracedInstructionFilter(bl, instructionVisitor);
    }

    public boolean isInstructionNecessary(int n) {
        return this.instructionsNecessary[n];
    }

    public boolean isExtraPushPopInstructionNecessary(int n) {
        return this.extraPushPopInstructionsNecessary[n];
    }

    public InstructionVisitor necessaryInstructionFilter(InstructionVisitor instructionVisitor) {
        return this.necessaryInstructionFilter(true, instructionVisitor);
    }

    public InstructionVisitor necessaryInstructionFilter(boolean bl, InstructionVisitor instructionVisitor) {
        return new MyNecessaryInstructionFilter(bl, instructionVisitor);
    }

    public TracedStack getStackBefore(int n) {
        return this.partialEvaluator.getStackBefore(n);
    }

    public TracedStack getStackAfter(int n) {
        return this.partialEvaluator.getStackAfter(n);
    }

    public boolean isStackEntryUnwantedBefore(int n, int n2) {
        return this.stacksUnwantedBefore[n][n2];
    }

    public boolean isStackEntriesPresentBefore(int n, int n2, int n3) {
        boolean bl = this.isStackEntryPresentBefore(n, n2);
        boolean bl2 = this.isStackEntryPresentBefore(n, n3);
        return bl || bl2;
    }

    public boolean isStackEntryPresentBefore(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        InstructionOffsetValue instructionOffsetValue = tracedStack.getBottomProducerValue(n2).instructionOffsetValue();
        return this.isAnyStackEntryNecessaryAfter(instructionOffsetValue, n2);
    }

    public boolean isStackEntriesNecessaryAfter(int n, int n2, int n3) {
        boolean bl = this.isStackEntryNecessaryAfter(n, n2);
        boolean bl2 = this.isStackEntryNecessaryAfter(n, n3);
        return bl || bl2;
    }

    public boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2 = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n2; ++i) {
            if (!instructionOffsetValue.isExceptionHandler(i) && !this.isStackEntryNecessaryAfter(instructionOffsetValue.instructionOffset(i), n)) continue;
            return true;
        }
        return false;
    }

    public boolean isStackEntryNecessaryAfter(int n, int n2) {
        return (n & 0x20000000) != 0 || this.stacksNecessaryAfter[n][n2];
    }

    public InstructionOffsetValue branchTargets(int n) {
        return this.partialEvaluator.branchTargets(n);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while marking instruction usage after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        int n;
        this.initializeNecessary(codeAttribute);
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n2 = codeAttribute.u4codeLength;
        this.maxMarkedOffset = -1;
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter(this.parameterUsageMarker));
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter(this.initialUsageMarker));
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            if (this.isInstructionNecessary(n)) {
                instruction = InstructionFactory.create(codeAttribute.code, n);
                instruction.accept(clazz, method, codeAttribute, n, this.producerMarker);
                this.markReverseDependencies(n);
            }
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        codeAttribute.instructionsAccept(clazz, method, this.necessaryInstructionFilter(this.variableInitializationMarker));
        this.maxMarkedOffset = n2 - 1;
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, n);
            instruction.accept(clazz, method, codeAttribute, n, this.stackConsistencyMarker);
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        this.maxMarkedOffset = n2 - 1;
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n) || this.isInstructionNecessary(n)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, n);
            instruction.accept(clazz, method, codeAttribute, n, this.extraPushPopInstructionMarker);
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
    }

    private void markVariableProducers(int n, int n2) {
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getVariablesBefore(n).getProducerValue(n2).instructionOffsetValue();
        if (instructionOffsetValue != null) {
            int n3 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n3; ++i) {
                if (instructionOffsetValue.isMethodParameter(i) || instructionOffsetValue.isExceptionHandler(i)) continue;
                int n4 = instructionOffsetValue.instructionOffset(i);
                this.markInstruction(n4);
            }
        }
    }

    private InstructionOffsetValue markVariableInitializersBefore(int n, int n2, InstructionOffsetValue instructionOffsetValue) {
        if (instructionOffsetValue == null || !instructionOffsetValue.contains(n)) {
            instructionOffsetValue = instructionOffsetValue == null ? new InstructionOffsetValue(n) : instructionOffsetValue.add(n);
            InstructionOffsetValue instructionOffsetValue2 = this.simplePartialEvaluator.getVariablesBefore(n).getProducerValue(n2).instructionOffsetValue();
            int n3 = instructionOffsetValue2.instructionOffsetCount();
            for (int i = 0; i < n3; ++i) {
                if (instructionOffsetValue2.isMethodParameter(i) || instructionOffsetValue2.isExceptionHandler(i)) continue;
                int n4 = instructionOffsetValue2.instructionOffset(i);
                instructionOffsetValue = this.markVariableInitializersAfter(n4, n2, instructionOffsetValue);
            }
        }
        return instructionOffsetValue;
    }

    private InstructionOffsetValue markVariableInitializersAfter(int n, int n2, InstructionOffsetValue instructionOffsetValue) {
        if (!this.isInstructionNecessary(n)) {
            if (this.isVariableInitialization(n, n2)) {
                this.markInstruction(n);
            } else {
                instructionOffsetValue = this.markVariableInitializersBefore(n, n2, instructionOffsetValue);
            }
        }
        return instructionOffsetValue;
    }

    private void markStackProducers(Clazz clazz, int n, Instruction instruction) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        int n2 = tracedStack.size();
        int n3 = instruction.stackPopCount(clazz);
        for (int i = n2 - n3; i < n2; ++i) {
            this.markStackEntryProducers(n, i, true);
        }
    }

    private void conditionallyMarkStackEntryProducers(int n, int n2, int n3) {
        int n4 = this.partialEvaluator.getStackAfter(n).size() - n2 - 1;
        if (this.isStackEntryNecessaryAfter(n, n4)) {
            int n5 = this.partialEvaluator.getStackBefore(n).size() - n3 - 1;
            this.markStackEntryProducers(n, n5, true);
        }
    }

    private void markStackEntryProducers(int n, int n2, boolean bl) {
        if (!this.isStackEntryUnwantedBefore(n, n2)) {
            this.markStackEntryProducers(this.partialEvaluator.getStackBefore(n).getBottomProducerValue(n2).instructionOffsetValue(), n2, bl);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue instructionOffsetValue, int n, boolean bl) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.isExceptionHandler(i)) continue;
                int n3 = instructionOffsetValue.instructionOffset(i);
                this.markStackEntryAfter(n3, n);
                if (bl) {
                    this.markInstruction(n3);
                    continue;
                }
                this.markExtraPushPopInstruction(n3);
            }
        }
    }

    private void markReverseDependencies(int n) {
        InstructionOffsetValue instructionOffsetValue = this.reverseDependencies[n];
        if (instructionOffsetValue != null) {
            this.markInstructions(instructionOffsetValue);
        }
    }

    private void markStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, boolean bl) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                if (bl) {
                    this.markStraddlingBranch(n, n3, n, n3);
                    continue;
                }
                this.markStraddlingBranch(n, n3, n3, n);
            }
        }
    }

    private void markStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isInstructionNecessary(n3) && this.isAnyInstructionNecessary(n, n2)) {
            this.markInstruction(n3);
        }
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int n;
        int n2 = codeAttribute.u4codeLength;
        int n3 = codeAttribute.u2maxLocals;
        int n4 = codeAttribute.u2maxStack;
        this.reverseDependencies = ArrayUtil.ensureArraySize(this.reverseDependencies, n2, null);
        if (this.stacksNecessaryAfter.length < n2 || this.stacksNecessaryAfter[0].length < n4) {
            this.stacksNecessaryAfter = new boolean[n2][n4];
        } else {
            for (n = 0; n < n2; ++n) {
                Arrays.fill(this.stacksNecessaryAfter[n], 0, n4, false);
            }
        }
        if (this.stacksUnwantedBefore.length < n2 || this.stacksUnwantedBefore[0].length < n4) {
            this.stacksUnwantedBefore = new boolean[n2][n4];
        } else {
            for (n = 0; n < n2; ++n) {
                Arrays.fill(this.stacksUnwantedBefore[n], 0, n4, false);
            }
        }
        this.instructionsNecessary = ArrayUtil.ensureArraySize(this.instructionsNecessary, n2, false);
        this.extraPushPopInstructionsNecessary = ArrayUtil.ensureArraySize(this.extraPushPopInstructionsNecessary, n2, false);
    }

    private boolean isVariableInitialization(int n, int n2) {
        Value value = this.simplePartialEvaluator.getVariablesBefore(n).getValue(n2);
        if (value == null) {
            return true;
        }
        Value value2 = this.simplePartialEvaluator.getVariablesAfter(n).getValue(n2);
        if (value2.computationalType() != value.computationalType()) {
            return true;
        }
        if (!(value2.computationalType() != 5 || value2.referenceValue().isNull() != 1 && value2.referenceValue().getType().equals(value.referenceValue().getType()))) {
            return true;
        }
        InstructionOffsetValue instructionOffsetValue = this.simplePartialEvaluator.getVariablesBefore(n).getProducerValue(n2).instructionOffsetValue();
        return instructionOffsetValue.instructionOffsetCount() == 1 && instructionOffsetValue.isMethodParameter(0);
    }

    private void markStackEntryAfter(int n, int n2) {
        if (!this.isStackEntryNecessaryAfter(n, n2)) {
            this.stacksNecessaryAfter[n][n2] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private void markStackEntryUnwantedBefore(int n, int n2) {
        this.stacksUnwantedBefore[n][n2] = true;
    }

    private void markInstructions(InstructionOffsetValue instructionOffsetValue) {
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            this.markInstruction(instructionOffsetValue.instructionOffset(i));
        }
    }

    private void markInstruction(int n) {
        if (!this.isInstructionNecessary(n)) {
            this.instructionsNecessary[n] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private void markExtraPushPopInstruction(int n) {
        if (!this.isInstructionNecessary(n) && !this.isExtraPushPopInstructionNecessary(n)) {
            this.extraPushPopInstructionsNecessary[n] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isInstructionNecessary(i) && !this.isExtraPushPopInstructionNecessary(i)) continue;
            return true;
        }
        return false;
    }

    private class MyNecessaryInstructionFilter
    implements InstructionVisitor {
        private final boolean necessary;
        private final InstructionVisitor instructionVisitor;

        public MyNecessaryInstructionFilter(boolean bl, InstructionVisitor instructionVisitor) {
            this.necessary = bl;
            this.instructionVisitor = instructionVisitor;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitSimpleInstruction(clazz, method, codeAttribute, n, simpleInstruction);
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, n, variableInstruction);
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, n, branchInstruction);
            }
        }

        @Override
        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitTableSwitchInstruction(clazz, method, codeAttribute, n, tableSwitchInstruction);
            }
        }

        @Override
        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitLookUpSwitchInstruction(clazz, method, codeAttribute, n, lookUpSwitchInstruction);
            }
        }

        private boolean shouldVisit(int n) {
            return InstructionUsageMarker.this.isInstructionNecessary(n) == this.necessary;
        }
    }

    private class MyExtraPushPopInstructionMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyExtraPushPopInstructionMarker() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            int n2;
            int n3 = InstructionUsageMarker.this.partialEvaluator.getStackBefore(n).size();
            for (int i = n2 = n3 - instruction.stackPopCount(clazz); i < n3; ++i) {
                if (InstructionUsageMarker.this.isStackEntryUnwantedBefore(n, i) || !InstructionUsageMarker.this.isStackEntryPresentBefore(n, i)) continue;
                InstructionUsageMarker.this.markExtraPushPopInstruction(n);
                InstructionUsageMarker.this.markStackEntryProducers(n, i, false);
            }
        }
    }

    private class MyStackConsistencyMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyMarker() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            int n2 = InstructionUsageMarker.this.partialEvaluator.getStackBefore(n).size();
            for (int i = 0; i < n2; ++i) {
                if (InstructionUsageMarker.this.isStackEntryUnwantedBefore(n, i) || !InstructionUsageMarker.this.isStackEntryPresentBefore(n, i)) continue;
                InstructionUsageMarker.this.markStackEntryProducers(n, i, false);
            }
        }
    }

    private class MyVariableInitializationMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyVariableInitializationMarker() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                InstructionUsageMarker.this.markVariableInitializersBefore(n, variableInstruction.variableIndex, null);
            }
        }
    }

    private class MyProducerMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            InstructionUsageMarker.this.markStackProducers(clazz, n, instruction);
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                case 90: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    break;
                }
                case 91: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    break;
                }
                case 92: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 3, 1);
                    break;
                }
                case 93: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 4, 1);
                    break;
                }
                case 94: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 3, 3);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 4, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 5, 1);
                    break;
                }
                case 95: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 0, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                default: {
                    InstructionUsageMarker.this.markStackProducers(clazz, n, simpleInstruction);
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                InstructionUsageMarker.this.markVariableProducers(n, variableInstruction.variableIndex);
            } else {
                InstructionUsageMarker.this.markStackProducers(clazz, n, variableInstruction);
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            InstructionUsageMarker.this.markStackProducers(clazz, n, constantInstruction);
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                InstructionUsageMarker.this.markStackEntryAfter(n, 0);
            } else {
                InstructionUsageMarker.this.markStackProducers(clazz, n, branchInstruction);
            }
        }
    }

    private class MyInitialUsageMarker
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    ParameterVisitor {
        private final MemberVisitor reverseDependencyCreator = new AllParameterVisitor(true, this);
        private int referencingOffset;
        private int referencingPopCount;

        private MyInitialUsageMarker() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            if (InstructionUsageMarker.this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, instruction)) {
                InstructionUsageMarker.this.markInstruction(n);
            }
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.createReverseDependencies(clazz, n, simpleInstruction);
                    this.visitAnyInstruction(clazz, method, codeAttribute, n, simpleInstruction);
                    break;
                }
                default: {
                    this.visitAnyInstruction(clazz, method, codeAttribute, n, simpleInstruction);
                }
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -67: 
                case -59: {
                    this.referencingOffset = n;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    this.visitAnyInstruction(clazz, method, codeAttribute, n, constantInstruction);
                    break;
                }
                case -78: 
                case -69: 
                case 18: 
                case 19: {
                    this.referencingOffset = n;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    break;
                }
                case -75: {
                    if (!InstructionUsageMarker.this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, constantInstruction)) break;
                    this.createReverseDependencies(clazz, n, constantInstruction);
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.referencingOffset = n;
                    this.referencingPopCount = constantInstruction.stackPopCount(clazz);
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    break;
                }
                default: {
                    this.visitAnyInstruction(clazz, method, codeAttribute, n, constantInstruction);
                }
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -89 && branchInstruction.branchOffset == 0) {
                InstructionUsageMarker.this.markInstruction(n);
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, n, branchInstruction);
            }
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            Clazz clazz2 = stringConstant.referencedClass;
            if (clazz2 != null && SideEffectClassChecker.mayHaveSideEffects(clazz, clazz2)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            }
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            Clazz clazz2 = classConstant.referencedClass;
            if (clazz2 == null || SideEffectClassChecker.mayHaveSideEffects(clazz, clazz2)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            }
        }

        @Override
        public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
            clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
        }

        @Override
        public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
            Method method = (Method)refConstant.referencedMember;
            if (SideEffectInstructionChecker.OPTIMIZE_CONSERVATIVELY && method != null && SideEffectMethodMarker.hasSideEffects(method) && !NoExternalSideEffectMethodMarker.hasNoExternalSideEffects(method)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            } else if (method == null || ParameterEscapeMarker.getEscapingParameters(method) != 0L || ParameterEscapeMarker.modifiesAnything(method) || SideEffectClassChecker.mayHaveSideEffects(clazz, refConstant.referencedClass, method)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            } else {
                refConstant.referencedMemberAccept(this.reverseDependencyCreator);
            }
        }

        @Override
        public void visitParameter(Clazz clazz, Member member, int n, int n2, int n3, int n4, String string, Clazz clazz2) {
            Method method = (Method)member;
            if (ParameterEscapeMarker.isParameterModified(method, n)) {
                this.createReverseDependencies(this.referencingOffset, n4 - n3 - 1);
            }
        }

        private void createReverseDependencies(Clazz clazz, int n, Instruction instruction) {
            this.createReverseDependencies(n, instruction.stackPopCount(clazz) - 1);
        }

        private void createReverseDependencies(int n, int n2) {
            ReferenceValue referenceValue;
            TracedStack tracedStack = InstructionUsageMarker.this.partialEvaluator.getStackBefore(n);
            Value value = tracedStack.getTop(n2);
            if (value.computationalType() == 5 && (referenceValue = value.referenceValue()).isNull() != 1) {
                if (referenceValue instanceof TracedReferenceValue) {
                    TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
                    this.createReverseDependencies(n, tracedReferenceValue.getTraceValue().instructionOffsetValue());
                } else {
                    InstructionUsageMarker.this.markInstruction(n);
                }
            }
        }

        private void createReverseDependencies(int n, InstructionOffsetValue instructionOffsetValue) {
            InstructionOffsetValue instructionOffsetValue2 = new InstructionOffsetValue(n);
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.isNewinstance(i)) {
                    int n3 = instructionOffsetValue.instructionOffset(i);
                    if (n3 == n) continue;
                    InstructionOffsetValue instructionOffsetValue3 = InstructionUsageMarker.this.reverseDependencies[n3];
                    ((InstructionUsageMarker)InstructionUsageMarker.this).reverseDependencies[n3] = instructionOffsetValue3 == null ? instructionOffsetValue2 : instructionOffsetValue3.generalize(instructionOffsetValue2);
                    continue;
                }
                InstructionUsageMarker.this.markInstruction(n);
            }
        }
    }

    private class MyParameterUsageMarker
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int parameterSize;
        private long usedParameters;

        private MyParameterUsageMarker() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.parameterSize = 0;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    for (int i = 0; i < this.parameterSize; ++i) {
                        if (i >= 64 || (this.usedParameters & 1L << i) != 0L) continue;
                        TracedStack tracedStack = InstructionUsageMarker.this.partialEvaluator.getStackBefore(n);
                        int n2 = tracedStack.size() - this.parameterSize + i;
                        InstructionUsageMarker.this.markStackEntryUnwantedBefore(n, n2);
                    }
                    break;
                }
            }
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept(this);
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            this.parameterSize = ParameterUsageMarker.getParameterSize(programMethod);
            this.usedParameters = ParameterUsageMarker.getUsedParameters(programMethod);
        }
    }
}

