/*
 * Decompiled with CFR 0.152.
 */
package proguard.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ConfigurationLogger
implements Runnable {
    public static final boolean LOG_ONCE = true;
    private static final String LOG_TAG = "ProGuard";
    public static final String CLASS_MAP_FILENAME = "classmap.txt";
    private static final String EMPTY_LINE = "\u00a0\n";
    private static final Set<String> missingClasses = new HashSet<String>();
    private static final Map<String, Set<MethodSignature>> missingConstructors = new HashMap<String, Set<MethodSignature>>();
    private static final Set<String> constructorListingClasses = new HashSet<String>();
    private static final Map<String, Set<MethodSignature>> missingMethods = new HashMap<String, Set<MethodSignature>>();
    private static final Set<String> methodListingClasses = new HashSet<String>();
    private static final Map<String, Set<String>> missingFields = new HashMap<String, Set<String>>();
    private static final Set<String> fieldListingCLasses = new HashSet<String>();
    private static Map<String, String> classNameMap;
    private static Set<String> classesWithObfuscatedMethods;
    private static Set<String> classesWithObfuscatedFields;
    private static Method logMethod;

    public static void logForName(String string, String string2) {
        ConfigurationLogger.logMissingClass(string, "Class", "forName", string2);
    }

    public static void logLoadClass(String string, String string2) {
        ConfigurationLogger.logMissingClass(string, "ClassLoader", "loadClass", string2);
    }

    public static void logMissingClass(String string, String string2, String string3, String string4) {
        if (!missingClasses.contains(string4)) {
            missingClasses.add(string4);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(string) + "' is calling " + string2 + "." + string3 + " to retrieve\nthe class '" + string4 + "', but the latter could not be found.\nIt may have been obfuscated or shrunk.\nYou should consider preserving the class with its original name,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepClassRule(string4) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredConstructor(String string, Class clazz, Class[] classArray) {
        ConfigurationLogger.logGetConstructor(string, "getDeclaredConstructor", clazz, classArray);
    }

    public static void logGetConstructor(String string, Class clazz, Class[] classArray) {
        ConfigurationLogger.logGetConstructor(string, "getConstructor", clazz, classArray);
    }

    public static void logGetConstructor(String string, String string2, Class clazz, Class[] classArray) {
        MethodSignature methodSignature = new MethodSignature("<init>", classArray);
        Set<MethodSignature> set = missingConstructors.get(clazz.getName());
        if (set == null) {
            set = new HashSet<MethodSignature>();
            missingConstructors.put(clazz.getName(), set);
        }
        if (!set.contains(methodSignature) && !ConfigurationLogger.isLibraryClass(clazz)) {
            set.add(methodSignature);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(string) + "' is calling Class." + string2 + "\non class '" + ConfigurationLogger.originalClassName(clazz) + "' to retrieve\nthe constructor with signature (" + ConfigurationLogger.originalSignature(methodSignature) + "), but the latter could not be found.\nIt may have been obfuscated or shrunk.\nYou should consider preserving the constructor, with a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepConstructorRule(clazz.getName(), methodSignature) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredConstructors(String string, Class clazz) {
        ConfigurationLogger.logGetConstructors(string, clazz, "getDeclaredConstructors");
    }

    public static void logGetConstructors(String string, Class clazz) {
        ConfigurationLogger.logGetConstructors(string, clazz, "getConstructors");
    }

    private static void logGetConstructors(String string, Class clazz, String string2) {
        ConfigurationLogger.initializeMappings();
        if (classesWithObfuscatedMethods.contains(clazz.getName()) && !constructorListingClasses.contains(clazz.getName()) && !ConfigurationLogger.isLibraryClass(clazz)) {
            constructorListingClasses.add(clazz.getName());
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(string) + "' is calling Class." + string2 + "\non class '" + ConfigurationLogger.originalClassName(clazz) + "' to retrieve its constructors.\nYou might consider preserving all constructors with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllConstructorsRule(clazz) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredMethod(String string, Class clazz, String string2, Class[] classArray) {
        ConfigurationLogger.logGetMethod(string, "getDeclaredMethod", clazz, string2, classArray);
    }

    public static void logGetMethod(String string, Class clazz, String string2, Class[] classArray) {
        ConfigurationLogger.logGetMethod(string, "getMethod", clazz, string2, classArray);
    }

    private static void logGetMethod(String string, String string2, Class clazz, String string3, Class[] classArray) {
        MethodSignature methodSignature;
        Set<MethodSignature> set = missingMethods.get(clazz.getName());
        if (set == null) {
            set = new HashSet<MethodSignature>();
            missingMethods.put(clazz.getName(), set);
        }
        if (!set.contains(methodSignature = new MethodSignature(string3, classArray)) && !ConfigurationLogger.isLibraryClass(clazz)) {
            set.add(methodSignature);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(string) + "' is calling Class." + string2 + "\non class '" + ConfigurationLogger.originalClassName(clazz) + "' to retrieve the method\n" + string3 + "(" + ConfigurationLogger.originalSignature(methodSignature) + "),\nbut the latter could not be found. It may have been obfuscated or shrunk.\nYou should consider preserving the method with its original name,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepMethodRule(clazz.getName(), string3, methodSignature) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredMethods(String string, Class clazz) {
        ConfigurationLogger.logGetMethods(string, "getDeclaredMethods", clazz);
    }

    public static void logGetMethods(String string, Class clazz) {
        ConfigurationLogger.logGetMethods(string, "getMethods", clazz);
    }

    private static void logGetMethods(String string, String string2, Class clazz) {
        ConfigurationLogger.initializeMappings();
        if (classesWithObfuscatedMethods.contains(clazz.getName()) && !methodListingClasses.contains(clazz.getName()) && !ConfigurationLogger.isLibraryClass(clazz)) {
            methodListingClasses.add(clazz.getName());
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(string) + "' is calling Class." + string2 + "\non class '" + ConfigurationLogger.originalClassName(clazz) + "' to retrieve its methods.\nYou might consider preserving all methods with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllMethodsRule(clazz) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetField(String string, Class clazz, String string2) {
        ConfigurationLogger.logGetField(string, "getField", clazz, string2);
    }

    public static void logGetDeclaredField(String string, Class clazz, String string2) {
        ConfigurationLogger.logGetField(string, "getDeclaredField", clazz, string2);
    }

    private static void logGetField(String string, String string2, Class clazz, String string3) {
        Set<String> set = missingFields.get(clazz.getName());
        if (set == null) {
            set = new HashSet<String>();
            missingFields.put(clazz.getName(), set);
        }
        if (!set.contains(string3) && !ConfigurationLogger.isLibraryClass(clazz)) {
            set.add(string3);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(string) + "' is calling Class." + string2 + "\non class '" + ConfigurationLogger.originalClassName(clazz) + "' to retrieve the field '" + string3 + "',\nbut the latter could not be found. It may have been obfuscated or shrunk.\nYou should consider preserving the field with its original name,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepFieldRule(clazz.getName(), string3) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredFields(String string, Class clazz) {
        ConfigurationLogger.logGetFields(string, "getDeclaredFields", clazz);
    }

    public static void logGetFields(String string, Class clazz) {
        ConfigurationLogger.logGetFields(string, "getFields", clazz);
    }

    private static void logGetFields(String string, String string2, Class clazz) {
        ConfigurationLogger.initializeMappings();
        if (classesWithObfuscatedFields.contains(clazz.getName()) && !fieldListingCLasses.contains(clazz.getName()) && !ConfigurationLogger.isLibraryClass(clazz)) {
            fieldListingCLasses.add(clazz.getName());
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(string) + "' is calling Class." + string2 + "\non class '" + ConfigurationLogger.originalClassName(clazz) + "' to retrieve its fields.\nYou might consider preserving all fields with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllFieldsRule(clazz) + "\n" + EMPTY_LINE);
        }
    }

    @Override
    public void run() {
        ConfigurationLogger.printConfiguration();
    }

    private static void printConfiguration() {
        ConfigurationLogger.log("The following settings may help solving issues related to\nmissing classes, methods and/or fields:\n");
        for (String string : missingClasses) {
            ConfigurationLogger.log(ConfigurationLogger.keepClassRule(string) + "\n");
        }
        for (String string : missingConstructors.keySet()) {
            for (MethodSignature object : missingConstructors.get(string)) {
                ConfigurationLogger.log(ConfigurationLogger.keepConstructorRule(string, object) + "\n");
            }
        }
        for (String string : missingMethods.keySet()) {
            for (MethodSignature methodSignature : missingMethods.get(string)) {
                ConfigurationLogger.log(ConfigurationLogger.keepMethodRule(string, methodSignature.name, methodSignature) + "\n");
            }
        }
        for (String string : missingFields.keySet()) {
            for (String string2 : missingFields.get(string)) {
                ConfigurationLogger.log(ConfigurationLogger.keepFieldRule(string, string2) + "\n");
            }
        }
    }

    private static String keepClassRule(String string) {
        return "-keep class " + string;
    }

    private static String keepConstructorRule(String string, MethodSignature methodSignature) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(string) + " {\n    public <init>(" + ConfigurationLogger.originalSignature(methodSignature) + ");\n}";
    }

    private static String keepMethodRule(String string, String string2, MethodSignature methodSignature) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(string) + " {\n    *** " + string2 + "(" + ConfigurationLogger.originalSignature(methodSignature) + ");\n}";
    }

    private static String keepFieldRule(String string, String string2) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(string) + " {\n    *** " + string2 + ";\n}";
    }

    private static String keepAllConstructorsRule(Class clazz) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(clazz) + " {\n    <init>(...);\n}";
    }

    private static String keepAllMethodsRule(Class clazz) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(clazz) + " {\n    <methods>;\n}";
    }

    private static String keepAllFieldsRule(Class clazz) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(clazz) + " {\n    <fields>;\n}";
    }

    private static String originalClassName(Class clazz) {
        return ConfigurationLogger.originalClassName(clazz.getName());
    }

    private static String originalClassName(String string) {
        ConfigurationLogger.initializeMappings();
        String string2 = classNameMap.get(string);
        return string2 != null ? string2 : string;
    }

    private static boolean isLibraryClass(Class clazz) {
        return clazz.getClassLoader() == String.class.getClassLoader();
    }

    private static void log(String string) {
        if (logMethod != null) {
            try {
                logMethod.invoke(null, LOG_TAG, string);
            }
            catch (Exception exception) {
                System.err.println(string);
            }
        } else {
            System.err.println(string);
        }
    }

    private static void initializeMappings() {
        if (classNameMap == null) {
            classNameMap = new HashMap<String, String>();
            classesWithObfuscatedMethods = new HashSet<String>();
            classesWithObfuscatedFields = new HashSet<String>();
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ConfigurationLogger.class.getClassLoader().getResourceAsStream(CLASS_MAP_FILENAME)));
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    boolean bl = stringTokenizer.nextToken().equals("1");
                    boolean bl2 = stringTokenizer.nextToken().equals("1");
                    classNameMap.put(string3, string2);
                    if (bl) {
                        classesWithObfuscatedMethods.add(string3);
                    }
                    if (!bl2) continue;
                    classesWithObfuscatedFields.add(string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static String originalSignature(MethodSignature methodSignature) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : methodSignature.parameters) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(ConfigurationLogger.originalClassName(string));
        }
        return stringBuilder.toString();
    }

    static {
        try {
            Class<?> clazz = Class.forName("android.util.Log");
            logMethod = clazz.getMethod("w", String.class, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class MethodSignature {
        private String name;
        private String[] parameters;

        public MethodSignature(String string, Class[] classArray) {
            this.name = string;
            this.parameters = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                this.parameters[i] = classArray[i].getName();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            if (!this.name.equals(methodSignature.name)) {
                return false;
            }
            return Arrays.equals(this.parameters, methodSignature.parameters);
        }

        public int hashCode() {
            int n = this.name.hashCode();
            n = 31 * n + Arrays.hashCode(this.parameters);
            return n;
        }
    }
}

