/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.HashSet;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MultiMemberVisitor;

public class FunctionalInterfaceFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public FunctionalInterfaceFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.isFunctionalInterface(programClass)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.isFunctionalInterface(libraryClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean isFunctionalInterface(Clazz clazz) {
        if ((clazz.getAccessFlags() & 0x200) == 0) {
            return false;
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        clazz.hierarchyAccept(true, false, true, false, new AllMethodVisitor(new MultiMemberVisitor(new MemberAccessFilter(1024, 0, new MemberCollector(false, true, true, hashSet)), new MemberAccessFilter(0, 1024, new MemberCollector(false, true, true, hashSet2)))));
        if (hashSet.size() == 0) {
            return false;
        }
        hashSet.removeAll(hashSet2);
        return hashSet.size() <= 1;
    }
}

