/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.module.ExportsInfo;
import proguard.classfile.attribute.module.ModuleAttribute;
import proguard.classfile.attribute.module.ModuleMainClassAttribute;
import proguard.classfile.attribute.module.ModulePackagesAttribute;
import proguard.classfile.attribute.module.OpensInfo;
import proguard.classfile.attribute.module.ProvidesInfo;
import proguard.classfile.attribute.module.RequiresInfo;
import proguard.classfile.attribute.module.visitor.ExportsInfoVisitor;
import proguard.classfile.attribute.module.visitor.OpensInfoVisitor;
import proguard.classfile.attribute.module.visitor.ProvidesInfoVisitor;
import proguard.classfile.attribute.module.visitor.RequiresInfoVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.ParameterInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ConstantPoolShrinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
ParameterInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
RequiresInfoVisitor,
ExportsInfoVisitor,
OpensInfoVisitor,
ProvidesInfoVisitor,
AnnotationVisitor,
ElementValueVisitor,
InstructionVisitor {
    private final Object USED = new Object();
    private int[] constantIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.markConstant(programClass, programClass.u2thisClass);
        programClass.superClassConstantAccept(this);
        programClass.interfaceConstantsAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        int n = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        if (n < programClass.u2constantPoolCount) {
            programClass.u2constantPoolCount = n;
            this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
            this.constantPoolRemapper.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        this.markConstant(programClass, programMember.u2nameIndex);
        this.markConstant(programClass, programMember.u2descriptorIndex);
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.markAsUsed(constant);
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.markAsUsed(stringConstant);
        this.markConstant(clazz, stringConstant.u2stringIndex);
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        this.markAsUsed(dynamicConstant);
        this.markConstant(clazz, dynamicConstant.u2nameAndTypeIndex);
        clazz.attributesAccept(this);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.markAsUsed(invokeDynamicConstant);
        this.markConstant(clazz, invokeDynamicConstant.u2nameAndTypeIndex);
        clazz.attributesAccept(this);
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.markAsUsed(methodHandleConstant);
        this.markConstant(clazz, methodHandleConstant.u2referenceIndex);
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.markAsUsed(refConstant);
        this.markConstant(clazz, refConstant.u2classIndex);
        this.markConstant(clazz, refConstant.u2nameAndTypeIndex);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.markAsUsed(classConstant);
        this.markConstant(clazz, classConstant.u2nameIndex);
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.markAsUsed(methodTypeConstant);
        this.markConstant(clazz, methodTypeConstant.u2descriptorIndex);
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.markAsUsed(nameAndTypeConstant);
        this.markConstant(clazz, nameAndTypeConstant.u2nameIndex);
        this.markConstant(clazz, nameAndTypeConstant.u2descriptorIndex);
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        this.markAsUsed(moduleConstant);
        this.markConstant(clazz, moduleConstant.u2nameIndex);
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        this.markAsUsed(packageConstant);
        this.markConstant(clazz, packageConstant.u2nameIndex);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.markConstant(clazz, attribute.u2attributeNameIndex);
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        this.markConstant(clazz, bootstrapMethodsAttribute.u2attributeNameIndex);
        bootstrapMethodsAttribute.bootstrapMethodEntriesAccept(clazz, this);
    }

    @Override
    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        this.markConstant(clazz, sourceFileAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceFileAttribute.u2sourceFileIndex);
    }

    @Override
    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        this.markConstant(clazz, sourceDirAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceDirAttribute.u2sourceDirIndex);
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.markConstant(clazz, innerClassesAttribute.u2attributeNameIndex);
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.markConstant(clazz, enclosingMethodAttribute.u2attributeNameIndex);
        this.markConstant(clazz, enclosingMethodAttribute.u2classIndex);
        this.markOptionalConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex);
    }

    @Override
    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
        this.markConstant(clazz, nestHostAttribute.u2attributeNameIndex);
        this.markConstant(clazz, nestHostAttribute.u2hostClassIndex);
    }

    @Override
    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        this.markConstant(clazz, nestMembersAttribute.u2attributeNameIndex);
        nestMembersAttribute.memberClassConstantsAccept(clazz, this);
    }

    @Override
    public void visitModuleAttribute(Clazz clazz, ModuleAttribute moduleAttribute) {
        this.markConstant(clazz, moduleAttribute.u2attributeNameIndex);
        this.markConstant(clazz, moduleAttribute.u2moduleNameIndex);
        this.markOptionalConstant(clazz, moduleAttribute.u2moduleVersionIndex);
        moduleAttribute.requiresAccept(clazz, this);
        moduleAttribute.exportsAccept(clazz, this);
        moduleAttribute.opensAccept(clazz, this);
        this.markConstants(clazz, moduleAttribute.u2uses, moduleAttribute.u2usesCount);
        moduleAttribute.providesAccept(clazz, this);
    }

    @Override
    public void visitModuleMainClassAttribute(Clazz clazz, ModuleMainClassAttribute moduleMainClassAttribute) {
        this.markConstant(clazz, moduleMainClassAttribute.u2attributeNameIndex);
        this.markConstant(clazz, moduleMainClassAttribute.u2mainClass);
    }

    @Override
    public void visitModulePackagesAttribute(Clazz clazz, ModulePackagesAttribute modulePackagesAttribute) {
        this.markConstant(clazz, modulePackagesAttribute.u2attributeNameIndex);
        modulePackagesAttribute.packagesAccept(clazz, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.markConstant(clazz, signatureAttribute.u2attributeNameIndex);
        this.markConstant(clazz, signatureAttribute.u2signatureIndex);
    }

    @Override
    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.markConstant(clazz, constantValueAttribute.u2attributeNameIndex);
        this.markConstant(clazz, constantValueAttribute.u2constantValueIndex);
    }

    @Override
    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        this.markConstant(clazz, methodParametersAttribute.u2attributeNameIndex);
        methodParametersAttribute.parametersAccept(clazz, method, this);
    }

    @Override
    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.markConstant(clazz, exceptionsAttribute.u2attributeNameIndex);
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, this);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.markConstant(clazz, codeAttribute.u2attributeNameIndex);
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.markConstant(clazz, stackMapAttribute.u2attributeNameIndex);
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.markConstant(clazz, stackMapTableAttribute.u2attributeNameIndex);
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.markConstant(clazz, localVariableTableAttribute.u2attributeNameIndex);
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.markConstant(clazz, localVariableTypeTableAttribute.u2attributeNameIndex);
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        this.markConstant(clazz, annotationsAttribute.u2attributeNameIndex);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        this.markConstant(clazz, parameterAnnotationsAttribute.u2attributeNameIndex);
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        this.markConstant(clazz, annotationDefaultAttribute.u2attributeNameIndex);
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        this.markConstant(clazz, bootstrapMethodInfo.u2methodHandleIndex);
        bootstrapMethodInfo.methodArgumentsAccept(clazz, this);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.innerClassConstantAccept(clazz, this);
        innerClassesInfo.outerClassConstantAccept(clazz, this);
        innerClassesInfo.innerNameConstantAccept(clazz, this);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.markOptionalConstant(clazz, exceptionInfo.u2catchType);
    }

    @Override
    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    @Override
    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ObjectType objectType) {
        this.markConstant(clazz, objectType.u2classIndex);
    }

    @Override
    public void visitParameterInfo(Clazz clazz, Method method, int n, ParameterInfo parameterInfo) {
        this.markOptionalConstant(clazz, parameterInfo.u2nameIndex);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        this.markConstant(clazz, localVariableInfo.u2nameIndex);
        this.markConstant(clazz, localVariableInfo.u2descriptorIndex);
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.markConstant(clazz, localVariableTypeInfo.u2nameIndex);
        this.markConstant(clazz, localVariableTypeInfo.u2signatureIndex);
    }

    @Override
    public void visitRequiresInfo(Clazz clazz, RequiresInfo requiresInfo) {
        this.markConstant(clazz, requiresInfo.u2requiresIndex);
        this.markOptionalConstant(clazz, requiresInfo.u2requiresVersionIndex);
    }

    @Override
    public void visitExportsInfo(Clazz clazz, ExportsInfo exportsInfo) {
        this.markConstant(clazz, exportsInfo.u2exportsIndex);
        this.markConstants(clazz, exportsInfo.u2exportsToIndex, exportsInfo.u2exportsToCount);
    }

    @Override
    public void visitOpensInfo(Clazz clazz, OpensInfo opensInfo) {
        this.markConstant(clazz, opensInfo.u2opensIndex);
        this.markConstants(clazz, opensInfo.u2opensToIndex, opensInfo.u2opensToCount);
    }

    @Override
    public void visitProvidesInfo(Clazz clazz, ProvidesInfo providesInfo) {
        this.markConstant(clazz, providesInfo.u2providesIndex);
        this.markConstants(clazz, providesInfo.u2providesWithIndex, providesInfo.u2providesWithCount);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.markConstant(clazz, annotation.u2typeIndex);
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.markOptionalConstant(clazz, constantElementValue.u2elementNameIndex);
        this.markConstant(clazz, constantElementValue.u2constantValueIndex);
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.markOptionalConstant(clazz, enumConstantElementValue.u2elementNameIndex);
        this.markConstant(clazz, enumConstantElementValue.u2typeNameIndex);
        this.markConstant(clazz, enumConstantElementValue.u2constantNameIndex);
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.markOptionalConstant(clazz, classElementValue.u2elementNameIndex);
        this.markConstant(clazz, classElementValue.u2classInfoIndex);
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.markOptionalConstant(clazz, annotationElementValue.u2elementNameIndex);
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.markOptionalConstant(clazz, arrayElementValue.u2elementNameIndex);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.markConstant(clazz, constantInstruction.constantIndex);
    }

    private void markConstants(Clazz clazz, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.markConstant(clazz, nArray[i]);
        }
    }

    private void markOptionalConstant(Clazz clazz, int n) {
        if (n != 0) {
            this.markConstant(clazz, n);
        }
    }

    private void markConstant(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this);
    }

    private void markAsUsed(Constant constant) {
        constant.setVisitorInfo(this.USED);
    }

    private boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == this.USED;
    }

    private int shrinkConstantPool(Constant[] constantArray, int n) {
        if (this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
        }
        int n2 = 1;
        boolean bl = false;
        for (int i = 1; i < n; ++i) {
            Constant constant = constantArray[i];
            if (constant != null) {
                bl = this.isUsed(constant);
            }
            if (bl) {
                this.constantIndexMap[i] = n2;
                constantArray[n2++] = constant;
                continue;
            }
            this.constantIndexMap[i] = -1;
        }
        Arrays.fill(constantArray, n2, n, null);
        return n2;
    }
}

