/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.module.ExportsInfo;
import proguard.classfile.attribute.module.ModuleAttribute;
import proguard.classfile.attribute.module.ModuleMainClassAttribute;
import proguard.classfile.attribute.module.ModulePackagesAttribute;
import proguard.classfile.attribute.module.OpensInfo;
import proguard.classfile.attribute.module.ProvidesInfo;
import proguard.classfile.attribute.module.RequiresInfo;
import proguard.classfile.attribute.module.visitor.ExportsInfoVisitor;
import proguard.classfile.attribute.module.visitor.OpensInfoVisitor;
import proguard.classfile.attribute.module.visitor.ProvidesInfoVisitor;
import proguard.classfile.attribute.module.visitor.RequiresInfoVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.ParameterInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ConstantPoolRemapper
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
InstructionVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
ParameterInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
RequiresInfoVisitor,
ExportsInfoVisitor,
OpensInfoVisitor,
ProvidesInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false, true);
    private int[] constantIndexMap;

    public void setConstantIndexMap(int[] nArray) {
        this.constantIndexMap = nArray;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2thisClass = this.remapConstantIndex(programClass.u2thisClass);
        programClass.u2superClass = this.remapConstantIndex(programClass.u2superClass);
        this.remapConstantIndexArray(programClass.u2interfaces, programClass.u2interfacesCount);
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.u2stringIndex = this.remapConstantIndex(stringConstant.u2stringIndex);
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        dynamicConstant.u2nameAndTypeIndex = this.remapConstantIndex(dynamicConstant.u2nameAndTypeIndex);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.u2nameAndTypeIndex = this.remapConstantIndex(invokeDynamicConstant.u2nameAndTypeIndex);
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        methodHandleConstant.u2referenceIndex = this.remapConstantIndex(methodHandleConstant.u2referenceIndex);
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        moduleConstant.u2nameIndex = this.remapConstantIndex(moduleConstant.u2nameIndex);
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        packageConstant.u2nameIndex = this.remapConstantIndex(packageConstant.u2nameIndex);
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        fieldrefConstant.u2classIndex = this.remapConstantIndex(fieldrefConstant.u2classIndex);
        fieldrefConstant.u2nameAndTypeIndex = this.remapConstantIndex(fieldrefConstant.u2nameAndTypeIndex);
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        interfaceMethodrefConstant.u2classIndex = this.remapConstantIndex(interfaceMethodrefConstant.u2classIndex);
        interfaceMethodrefConstant.u2nameAndTypeIndex = this.remapConstantIndex(interfaceMethodrefConstant.u2nameAndTypeIndex);
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        methodrefConstant.u2classIndex = this.remapConstantIndex(methodrefConstant.u2classIndex);
        methodrefConstant.u2nameAndTypeIndex = this.remapConstantIndex(methodrefConstant.u2nameAndTypeIndex);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.u2nameIndex = this.remapConstantIndex(classConstant.u2nameIndex);
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        methodTypeConstant.u2descriptorIndex = this.remapConstantIndex(methodTypeConstant.u2descriptorIndex);
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        nameAndTypeConstant.u2nameIndex = this.remapConstantIndex(nameAndTypeConstant.u2nameIndex);
        nameAndTypeConstant.u2descriptorIndex = this.remapConstantIndex(nameAndTypeConstant.u2descriptorIndex);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.visitMember(programClass, programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.visitMember(programClass, programMethod);
    }

    private void visitMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.u2nameIndex = this.remapConstantIndex(programMember.u2nameIndex);
        programMember.u2descriptorIndex = this.remapConstantIndex(programMember.u2descriptorIndex);
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    @Override
    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        unknownAttribute.u2attributeNameIndex = this.remapConstantIndex(unknownAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.u2attributeNameIndex = this.remapConstantIndex(bootstrapMethodsAttribute.u2attributeNameIndex);
        bootstrapMethodsAttribute.bootstrapMethodEntriesAccept(clazz, this);
    }

    @Override
    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        sourceFileAttribute.u2attributeNameIndex = this.remapConstantIndex(sourceFileAttribute.u2attributeNameIndex);
        sourceFileAttribute.u2sourceFileIndex = this.remapConstantIndex(sourceFileAttribute.u2sourceFileIndex);
    }

    @Override
    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        sourceDirAttribute.u2attributeNameIndex = this.remapConstantIndex(sourceDirAttribute.u2attributeNameIndex);
        sourceDirAttribute.u2sourceDirIndex = this.remapConstantIndex(sourceDirAttribute.u2sourceDirIndex);
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.u2attributeNameIndex = this.remapConstantIndex(innerClassesAttribute.u2attributeNameIndex);
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.u2attributeNameIndex = this.remapConstantIndex(enclosingMethodAttribute.u2attributeNameIndex);
        enclosingMethodAttribute.u2classIndex = this.remapConstantIndex(enclosingMethodAttribute.u2classIndex);
        enclosingMethodAttribute.u2nameAndTypeIndex = this.remapConstantIndex(enclosingMethodAttribute.u2nameAndTypeIndex);
    }

    @Override
    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
        nestHostAttribute.u2attributeNameIndex = this.remapConstantIndex(nestHostAttribute.u2attributeNameIndex);
        nestHostAttribute.u2hostClassIndex = this.remapConstantIndex(nestHostAttribute.u2hostClassIndex);
    }

    @Override
    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        nestMembersAttribute.u2attributeNameIndex = this.remapConstantIndex(nestMembersAttribute.u2attributeNameIndex);
        this.remapConstantIndexArray(nestMembersAttribute.u2classes, nestMembersAttribute.u2classesCount);
    }

    @Override
    public void visitModuleAttribute(Clazz clazz, ModuleAttribute moduleAttribute) {
        moduleAttribute.u2attributeNameIndex = this.remapConstantIndex(moduleAttribute.u2attributeNameIndex);
        moduleAttribute.u2moduleNameIndex = this.remapConstantIndex(moduleAttribute.u2moduleNameIndex);
        if (moduleAttribute.u2moduleVersionIndex != 0) {
            moduleAttribute.u2moduleVersionIndex = this.remapConstantIndex(moduleAttribute.u2moduleVersionIndex);
        }
        moduleAttribute.requiresAccept(clazz, this);
        moduleAttribute.exportsAccept(clazz, this);
        moduleAttribute.opensAccept(clazz, this);
        this.remapConstantIndexArray(moduleAttribute.u2uses, moduleAttribute.u2usesCount);
        moduleAttribute.providesAccept(clazz, this);
    }

    @Override
    public void visitModuleMainClassAttribute(Clazz clazz, ModuleMainClassAttribute moduleMainClassAttribute) {
        moduleMainClassAttribute.u2attributeNameIndex = this.remapConstantIndex(moduleMainClassAttribute.u2attributeNameIndex);
        moduleMainClassAttribute.u2mainClass = this.remapConstantIndex(moduleMainClassAttribute.u2mainClass);
    }

    @Override
    public void visitModulePackagesAttribute(Clazz clazz, ModulePackagesAttribute modulePackagesAttribute) {
        modulePackagesAttribute.u2attributeNameIndex = this.remapConstantIndex(modulePackagesAttribute.u2attributeNameIndex);
        this.remapConstantIndexArray(modulePackagesAttribute.u2packages, modulePackagesAttribute.u2packagesCount);
    }

    @Override
    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        deprecatedAttribute.u2attributeNameIndex = this.remapConstantIndex(deprecatedAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        syntheticAttribute.u2attributeNameIndex = this.remapConstantIndex(syntheticAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.u2attributeNameIndex = this.remapConstantIndex(signatureAttribute.u2attributeNameIndex);
        signatureAttribute.u2signatureIndex = this.remapConstantIndex(signatureAttribute.u2signatureIndex);
    }

    @Override
    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        constantValueAttribute.u2attributeNameIndex = this.remapConstantIndex(constantValueAttribute.u2attributeNameIndex);
        constantValueAttribute.u2constantValueIndex = this.remapConstantIndex(constantValueAttribute.u2constantValueIndex);
    }

    @Override
    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        methodParametersAttribute.u2attributeNameIndex = this.remapConstantIndex(methodParametersAttribute.u2attributeNameIndex);
        methodParametersAttribute.parametersAccept(clazz, method, this);
    }

    @Override
    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        exceptionsAttribute.u2attributeNameIndex = this.remapConstantIndex(exceptionsAttribute.u2attributeNameIndex);
        this.remapConstantIndexArray(exceptionsAttribute.u2exceptionIndexTable, exceptionsAttribute.u2exceptionIndexTableLength);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2attributeNameIndex = this.remapConstantIndex(codeAttribute.u2attributeNameIndex);
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        stackMapAttribute.u2attributeNameIndex = this.remapConstantIndex(stackMapAttribute.u2attributeNameIndex);
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        stackMapTableAttribute.u2attributeNameIndex = this.remapConstantIndex(stackMapTableAttribute.u2attributeNameIndex);
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.u2attributeNameIndex = this.remapConstantIndex(lineNumberTableAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2attributeNameIndex = this.remapConstantIndex(localVariableTableAttribute.u2attributeNameIndex);
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2attributeNameIndex = this.remapConstantIndex(localVariableTypeTableAttribute.u2attributeNameIndex);
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.u2attributeNameIndex = this.remapConstantIndex(annotationsAttribute.u2attributeNameIndex);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.u2attributeNameIndex = this.remapConstantIndex(parameterAnnotationsAttribute.u2attributeNameIndex);
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.u2attributeNameIndex = this.remapConstantIndex(annotationDefaultAttribute.u2attributeNameIndex);
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        bootstrapMethodInfo.u2methodHandleIndex = this.remapConstantIndex(bootstrapMethodInfo.u2methodHandleIndex);
        this.remapConstantIndexArray(bootstrapMethodInfo.u2methodArguments, bootstrapMethodInfo.u2methodArgumentCount);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerClassIndex != 0) {
            innerClassesInfo.u2innerClassIndex = this.remapConstantIndex(innerClassesInfo.u2innerClassIndex);
        }
        if (innerClassesInfo.u2outerClassIndex != 0) {
            innerClassesInfo.u2outerClassIndex = this.remapConstantIndex(innerClassesInfo.u2outerClassIndex);
        }
        if (innerClassesInfo.u2innerNameIndex != 0) {
            innerClassesInfo.u2innerNameIndex = this.remapConstantIndex(innerClassesInfo.u2innerNameIndex);
        }
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (exceptionInfo.u2catchType != 0) {
            exceptionInfo.u2catchType = this.remapConstantIndex(exceptionInfo.u2catchType);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        int n2 = this.remapConstantIndex(constantInstruction.constantIndex);
        if (n2 != constantInstruction.constantIndex) {
            ConstantInstruction constantInstruction2 = new ConstantInstruction(constantInstruction.opcode, n2, constantInstruction.constant);
            this.codeAttributeEditor.replaceInstruction(n, constantInstruction2);
        }
    }

    @Override
    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    @Override
    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ObjectType objectType) {
        objectType.u2classIndex = this.remapConstantIndex(objectType.u2classIndex);
    }

    @Override
    public void visitParameterInfo(Clazz clazz, Method method, int n, ParameterInfo parameterInfo) {
        parameterInfo.u2nameIndex = this.remapConstantIndex(parameterInfo.u2nameIndex);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2nameIndex = this.remapConstantIndex(localVariableInfo.u2nameIndex);
        localVariableInfo.u2descriptorIndex = this.remapConstantIndex(localVariableInfo.u2descriptorIndex);
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2nameIndex = this.remapConstantIndex(localVariableTypeInfo.u2nameIndex);
        localVariableTypeInfo.u2signatureIndex = this.remapConstantIndex(localVariableTypeInfo.u2signatureIndex);
    }

    @Override
    public void visitRequiresInfo(Clazz clazz, RequiresInfo requiresInfo) {
        requiresInfo.u2requiresIndex = this.remapConstantIndex(requiresInfo.u2requiresIndex);
        requiresInfo.u2requiresVersionIndex = this.remapConstantIndex(requiresInfo.u2requiresVersionIndex);
    }

    @Override
    public void visitExportsInfo(Clazz clazz, ExportsInfo exportsInfo) {
        exportsInfo.u2exportsIndex = this.remapConstantIndex(exportsInfo.u2exportsIndex);
        this.remapConstantIndexArray(exportsInfo.u2exportsToIndex, exportsInfo.u2exportsToCount);
    }

    @Override
    public void visitOpensInfo(Clazz clazz, OpensInfo opensInfo) {
        opensInfo.u2opensIndex = this.remapConstantIndex(opensInfo.u2opensIndex);
        this.remapConstantIndexArray(opensInfo.u2opensToIndex, opensInfo.u2opensToCount);
    }

    @Override
    public void visitProvidesInfo(Clazz clazz, ProvidesInfo providesInfo) {
        providesInfo.u2providesIndex = this.remapConstantIndex(providesInfo.u2providesIndex);
        this.remapConstantIndexArray(providesInfo.u2providesWithIndex, providesInfo.u2providesWithCount);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2typeIndex = this.remapConstantIndex(annotation.u2typeIndex);
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        constantElementValue.u2elementNameIndex = this.remapConstantIndex(constantElementValue.u2elementNameIndex);
        constantElementValue.u2constantValueIndex = this.remapConstantIndex(constantElementValue.u2constantValueIndex);
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        enumConstantElementValue.u2elementNameIndex = this.remapConstantIndex(enumConstantElementValue.u2elementNameIndex);
        enumConstantElementValue.u2typeNameIndex = this.remapConstantIndex(enumConstantElementValue.u2typeNameIndex);
        enumConstantElementValue.u2constantNameIndex = this.remapConstantIndex(enumConstantElementValue.u2constantNameIndex);
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        classElementValue.u2elementNameIndex = this.remapConstantIndex(classElementValue.u2elementNameIndex);
        classElementValue.u2classInfoIndex = this.remapConstantIndex(classElementValue.u2classInfoIndex);
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.u2elementNameIndex = this.remapConstantIndex(annotationElementValue.u2elementNameIndex);
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementNameIndex = this.remapConstantIndex(arrayElementValue.u2elementNameIndex);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void remapConstantIndexArray(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.remapConstantIndex(nArray[i]);
        }
    }

    private int remapConstantIndex(int n) {
        int n2 = this.constantIndexMap[n];
        if (n2 < 0) {
            throw new IllegalArgumentException("Can't remap constant index [" + n + "]");
        }
        return n2;
    }
}

