/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.util.ArrayUtil;

class ComparableConstant
extends SimplifiedVisitor
implements Comparable,
ConstantVisitor {
    private static final int[] PRIORITIES = new int[22];
    private final Clazz clazz;
    private final int thisIndex;
    private final Constant thisConstant;
    private Constant otherConstant;
    private int result;

    public ComparableConstant(Clazz clazz, int n, Constant constant) {
        this.clazz = clazz;
        this.thisIndex = n;
        this.thisConstant = constant;
    }

    public int getIndex() {
        return this.thisIndex;
    }

    public Constant getConstant() {
        return this.thisConstant;
    }

    public int compareTo(Object object) {
        int n;
        ComparableConstant comparableConstant = (ComparableConstant)object;
        this.otherConstant = comparableConstant.thisConstant;
        if (this.thisConstant == this.otherConstant) {
            int n2 = comparableConstant.thisIndex;
            return Integer.compare(this.thisIndex, n2);
        }
        int n3 = this.thisConstant.getTag();
        if (n3 != (n = this.otherConstant.getTag())) {
            return Integer.compare(PRIORITIES[n3], PRIORITIES[n]);
        }
        this.thisConstant.accept(this.clazz, this);
        return this.result;
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.result = Integer.compare(integerConstant.getValue(), ((IntegerConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.result = Long.compare(longConstant.getValue(), ((LongConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.result = Float.compare(floatConstant.getValue(), ((FloatConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.result = Double.compare(doubleConstant.getValue(), ((DoubleConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char c;
        PrimitiveArrayConstant primitiveArrayConstant2 = (PrimitiveArrayConstant)this.otherConstant;
        char c2 = primitiveArrayConstant.getPrimitiveType();
        if (c2 != (c = primitiveArrayConstant2.getPrimitiveType())) {
            this.result = Integer.compare(c2, c);
        } else {
            Object object = primitiveArrayConstant.getValues();
            Object object2 = primitiveArrayConstant2.getValues();
            this.result = object instanceof boolean[] ? ArrayUtil.compare((boolean[])object, ((boolean[])object).length, (boolean[])object2, ((boolean[])object2).length) : (object instanceof byte[] ? ArrayUtil.compare((byte[])object, ((byte[])object).length, (byte[])object2, ((byte[])object2).length) : (object instanceof char[] ? ArrayUtil.compare((char[])object, ((char[])object).length, (char[])object2, ((char[])object2).length) : (object instanceof short[] ? ArrayUtil.compare((short[])object, ((short[])object).length, (short[])object2, ((short[])object2).length) : (object instanceof int[] ? ArrayUtil.compare((int[])object, ((int[])object).length, (int[])object2, ((int[])object2).length) : (object instanceof float[] ? ArrayUtil.compare((float[])object, ((float[])object).length, (float[])object2, ((float[])object2).length) : (object instanceof long[] ? ArrayUtil.compare((long[])object, ((long[])object).length, (long[])object2, ((long[])object2).length) : ArrayUtil.compare((double[])object, ((double[])object).length, (double[])object2, ((double[])object2).length)))))));
        }
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.result = stringConstant.getString(clazz).compareTo(((StringConstant)this.otherConstant).getString(clazz));
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.result = utf8Constant.getString().compareTo(((Utf8Constant)this.otherConstant).getString());
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        int n;
        DynamicConstant dynamicConstant2 = (DynamicConstant)this.otherConstant;
        int n2 = dynamicConstant.getBootstrapMethodAttributeIndex();
        this.result = n2 < (n = dynamicConstant2.getBootstrapMethodAttributeIndex()) ? -1 : (n2 > n ? 1 : this.compare(dynamicConstant.getName(clazz), dynamicConstant.getType(clazz), dynamicConstant2.getName(clazz), dynamicConstant2.getType(clazz)));
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        int n;
        InvokeDynamicConstant invokeDynamicConstant2 = (InvokeDynamicConstant)this.otherConstant;
        int n2 = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
        this.result = n2 < (n = invokeDynamicConstant2.getBootstrapMethodAttributeIndex()) ? -1 : (n2 > n ? 1 : this.compare(invokeDynamicConstant.getName(clazz), invokeDynamicConstant.getType(clazz), invokeDynamicConstant2.getName(clazz), invokeDynamicConstant2.getType(clazz)));
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        int n;
        MethodHandleConstant methodHandleConstant2 = (MethodHandleConstant)this.otherConstant;
        int n2 = methodHandleConstant.getReferenceKind();
        this.result = n2 < (n = methodHandleConstant2.getReferenceKind()) ? -1 : (n2 > n ? 1 : this.compare(methodHandleConstant.getClassName(clazz), methodHandleConstant.getName(clazz), methodHandleConstant.getType(clazz), methodHandleConstant2.getClassName(clazz), methodHandleConstant2.getName(clazz), methodHandleConstant2.getType(clazz)));
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        RefConstant refConstant2 = (RefConstant)this.otherConstant;
        this.result = this.compare(refConstant.getClassName(clazz), refConstant.getName(clazz), refConstant.getType(clazz), refConstant2.getClassName(clazz), refConstant2.getName(clazz), refConstant2.getType(clazz));
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.result = classConstant.getName(clazz).compareTo(((ClassConstant)this.otherConstant).getName(clazz));
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        MethodTypeConstant methodTypeConstant2 = (MethodTypeConstant)this.otherConstant;
        this.result = methodTypeConstant.getType(clazz).compareTo(methodTypeConstant2.getType(clazz));
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        NameAndTypeConstant nameAndTypeConstant2 = (NameAndTypeConstant)this.otherConstant;
        this.result = this.compare(nameAndTypeConstant.getName(clazz), nameAndTypeConstant.getType(clazz), nameAndTypeConstant2.getName(clazz), nameAndTypeConstant2.getType(clazz));
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        this.result = moduleConstant.getName(clazz).compareTo(((ModuleConstant)this.otherConstant).getName(clazz));
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        this.result = packageConstant.getName(clazz).compareTo(((PackageConstant)this.otherConstant).getName(clazz));
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass()) && this.getConstant().getClass().equals(((ComparableConstant)object).getConstant().getClass()) && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private int compare(String string, String string2, String string3, String string4) {
        int n = string.compareTo(string3);
        return n != 0 ? n : string2.compareTo(string4);
    }

    private int compare(String string, String string2, String string3, String string4, String string5, String string6) {
        int n = string.compareTo(string4);
        return n != 0 ? n : ((n = string2.compareTo(string5)) != 0 ? n : string3.compareTo(string6));
    }

    static {
        ComparableConstant.PRIORITIES[3] = 0;
        ComparableConstant.PRIORITIES[4] = 1;
        ComparableConstant.PRIORITIES[8] = 2;
        ComparableConstant.PRIORITIES[7] = 3;
        ComparableConstant.PRIORITIES[5] = 4;
        ComparableConstant.PRIORITIES[6] = 5;
        ComparableConstant.PRIORITIES[9] = 6;
        ComparableConstant.PRIORITIES[10] = 7;
        ComparableConstant.PRIORITIES[11] = 8;
        ComparableConstant.PRIORITIES[17] = 9;
        ComparableConstant.PRIORITIES[18] = 10;
        ComparableConstant.PRIORITIES[15] = 11;
        ComparableConstant.PRIORITIES[12] = 12;
        ComparableConstant.PRIORITIES[16] = 13;
        ComparableConstant.PRIORITIES[19] = 14;
        ComparableConstant.PRIORITIES[20] = 15;
        ComparableConstant.PRIORITIES[1] = 16;
        ComparableConstant.PRIORITIES[21] = 17;
    }
}

