/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceFixer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final boolean ensureUniqueMemberNames;

    public ClassReferenceFixer(boolean bl) {
        this.ensureUniqueMemberNames = bl;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string;
        String string2 = programField.getDescriptor(programClass);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, programField.referencedClass))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programField.u2descriptorIndex = constantPoolEditor.addUtf8Constant(string);
            if (this.ensureUniqueMemberNames) {
                String string3 = programField.getName(programClass);
                String string4 = this.newUniqueMemberName(string3, string2);
                programField.u2nameIndex = constantPoolEditor.addUtf8Constant(string4);
            }
        }
        programField.attributesAccept(programClass, this);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string;
        String string2 = programMethod.getDescriptor(programClass);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, programMethod.referencedClasses))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(string);
            if (this.ensureUniqueMemberNames) {
                String string3 = programMethod.getName(programClass);
                String string4 = this.newUniqueMemberName(string3, string2);
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(string4);
            }
        }
        programMethod.attributesAccept(programClass, this);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String string;
        String string2 = libraryField.getDescriptor(libraryClass);
        libraryField.descriptor = string = ClassReferenceFixer.newDescriptor(string2, libraryField.referencedClass);
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String string;
        String string2 = libraryMethod.getDescriptor(libraryClass);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, libraryMethod.referencedClasses))) {
            libraryMethod.descriptor = string;
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String string;
        String string2;
        String string3;
        Clazz clazz2 = stringConstant.referencedClass;
        Member member = stringConstant.referencedMember;
        if (clazz2 != null && member == null && !(string3 = ClassReferenceFixer.newClassName(string2 = ClassUtil.internalClassName(string = stringConstant.getString(clazz)), clazz2)).equals(string2)) {
            String string4 = string.indexOf(46) >= 0 ? ClassUtil.externalClassName(string3) : string3;
            stringConstant.u2stringIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string4);
        }
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        String string;
        String string2 = dynamicConstant.getType(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, dynamicConstant.referencedClasses))) {
            String string3 = dynamicConstant.getName(clazz);
            dynamicConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(string3, string);
        }
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String string;
        String string2 = invokeDynamicConstant.getType(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, invokeDynamicConstant.referencedClasses))) {
            String string3 = invokeDynamicConstant.getName(clazz);
            invokeDynamicConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(string3, string);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String string;
        String string2;
        Clazz clazz2 = classConstant.referencedClass;
        if (clazz2 != null && !(string2 = classConstant.getName(clazz)).equals(string = ClassReferenceFixer.newClassName(string2, clazz2))) {
            classConstant.u2nameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        String string;
        String string2 = methodTypeConstant.getType(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, methodTypeConstant.referencedClasses))) {
            methodTypeConstant.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        String string;
        String string2 = signatureAttribute.getSignature(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, signatureAttribute.referencedClasses))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        String string;
        int n;
        int n2 = innerClassesInfo.u2innerClassIndex;
        int n3 = innerClassesInfo.u2innerNameIndex;
        if (n2 != 0 && n3 != 0 && (n = (string = clazz.getClassName(n2)).lastIndexOf(36)) >= 0) {
            innerClassesInfo.u2innerNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string.substring(n + 1));
        }
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        String string;
        String string2 = localVariableInfo.getDescriptor(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, localVariableInfo.referencedClass))) {
            localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        String string;
        String string2 = localVariableTypeInfo.getSignature(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, localVariableTypeInfo.referencedClasses))) {
            localVariableTypeInfo.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        String string;
        String string2 = annotation.getType(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, annotation.referencedClasses))) {
            annotation.u2typeIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        String string;
        String string2 = enumConstantElementValue.getTypeName(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, enumConstantElementValue.referencedClasses))) {
            enumConstantElementValue.u2typeNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        String string;
        String string2 = classElementValue.getClassName(clazz);
        if (!string2.equals(string = ClassReferenceFixer.newDescriptor(string2, classElementValue.referencedClasses))) {
            classElementValue.u2classInfoIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private static String newDescriptor(String string, Clazz clazz) {
        if (clazz == null) {
            return string;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(descriptorClassEnumeration.nextFluff());
        if (descriptorClassEnumeration.hasMoreClassNames()) {
            String string2 = descriptorClassEnumeration.nextClassName();
            String string3 = descriptorClassEnumeration.nextFluff();
            String string4 = ClassReferenceFixer.newClassName(string2, clazz);
            stringBuffer.append(string4);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String newDescriptor(String string, Clazz[] clazzArray) {
        if (clazzArray == null || clazzArray.length == 0) {
            return string;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(descriptorClassEnumeration.nextFluff());
        int n = 0;
        while (descriptorClassEnumeration.hasMoreClassNames()) {
            String string2 = descriptorClassEnumeration.nextClassName();
            boolean bl = descriptorClassEnumeration.isInnerClassName();
            String string3 = descriptorClassEnumeration.nextFluff();
            String string4 = ClassReferenceFixer.newClassName(string2, clazzArray[n++]);
            if (bl) {
                string4 = string4.substring(string4.lastIndexOf(36) + 1);
            }
            stringBuffer.append(string4);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private String newUniqueMemberName(String string, String string2) {
        return string.equals("<init>") ? "<init>" : string + '$' + Long.toHexString(Math.abs(string2.hashCode()));
    }

    private static String newClassName(String string, Clazz clazz) {
        if (clazz == null) {
            return string;
        }
        String string2 = clazz.getName();
        if (string.charAt(0) == '[') {
            string2 = string.substring(0, string.indexOf(76) + 1) + string2 + ';';
        }
        return string2;
    }
}

