/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassPool {
    private final Map classes = new TreeMap();

    public void clear() {
        this.classes.clear();
    }

    public void addClass(Clazz clazz) {
        this.classes.put(clazz.getName(), clazz);
    }

    public void removeClass(Clazz clazz) {
        this.removeClass(clazz.getName());
    }

    public void removeClass(String string) {
        this.classes.remove(string);
    }

    public Clazz getClass(String string) {
        return (Clazz)this.classes.get(string);
    }

    public Iterator classNames() {
        return this.classes.keySet().iterator();
    }

    public int size() {
        return this.classes.size();
    }

    public void accept(ClassPoolVisitor classPoolVisitor) {
        classPoolVisitor.visitClassPool(this);
    }

    public void classesAccept(ClassVisitor classVisitor) {
        for (Clazz clazz : this.classes.values()) {
            clazz.accept(classVisitor);
        }
    }

    public void classesAcceptAlphabetically(ClassVisitor classVisitor) {
        for (Clazz clazz : this.classes.values()) {
            clazz.accept(classVisitor);
        }
    }

    public void classesAccept(String string, ClassVisitor classVisitor) {
        this.classesAccept(new ListParser(new ClassNameParser()).parse(string), classVisitor);
    }

    public void classesAccept(List list, ClassVisitor classVisitor) {
        this.classesAccept(new ListParser(new ClassNameParser()).parse(list), classVisitor);
    }

    public void classesAccept(StringMatcher stringMatcher, ClassVisitor classVisitor) {
        for (Map.Entry entry : this.classes.entrySet()) {
            String string = (String)entry.getKey();
            if (!stringMatcher.matches(string)) continue;
            Clazz clazz = (Clazz)entry.getValue();
            clazz.accept(classVisitor);
        }
    }

    public void classAccept(String string, ClassVisitor classVisitor) {
        Clazz clazz = this.getClass(string);
        if (clazz != null) {
            clazz.accept(classVisitor);
        }
    }
}

