/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MemberFinder;

public class LambdaExpression {
    public ProgramClass referencedClass;
    public int bootstrapMethodIndex;
    public BootstrapMethodInfo bootstrapMethodInfo;
    public String factoryMethodDescriptor;
    public String[] interfaces;
    public String[] bridgeMethodDescriptors;
    public String interfaceMethod;
    public String interfaceMethodDescriptor;
    public int invokedReferenceKind;
    public String invokedClassName;
    public String invokedMethodName;
    public String invokedMethodDesc;
    public Clazz referencedInvokedClass;
    public Method referencedInvokedMethod;
    public ProgramClass lambdaClass;
    private static final String LAMBDA_METHOD_PREFIX = "lambda$";

    public LambdaExpression(ProgramClass programClass, int n, BootstrapMethodInfo bootstrapMethodInfo, String string, String[] stringArray, String[] stringArray2, String string2, String string3, int n2, String string4, String string5, String string6, Clazz clazz, Method method) {
        this.referencedClass = programClass;
        this.bootstrapMethodIndex = n;
        this.bootstrapMethodInfo = bootstrapMethodInfo;
        this.factoryMethodDescriptor = string;
        this.interfaces = stringArray;
        this.bridgeMethodDescriptors = stringArray2;
        this.interfaceMethod = string2;
        this.interfaceMethodDescriptor = string3;
        this.invokedReferenceKind = n2;
        this.invokedClassName = string4;
        this.invokedMethodName = string5;
        this.invokedMethodDesc = string6;
        this.referencedInvokedClass = clazz;
        this.referencedInvokedMethod = method;
    }

    public String getLambdaClassName() {
        return String.format("%s$$Lambda$%d", this.referencedClass.getName(), this.bootstrapMethodIndex);
    }

    public String getConstructorDescriptor() {
        if (this.isStateless()) {
            return "()V";
        }
        int n = this.factoryMethodDescriptor.indexOf(41);
        return this.factoryMethodDescriptor.substring(0, n + 1) + 'V';
    }

    public boolean isSerializable() {
        for (String string : this.interfaces) {
            if (!"java/io/Serializable".equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isMethodReference() {
        return !LambdaExpression.isLambdaMethod(this.invokedMethodName);
    }

    public boolean isStateless() {
        return ClassUtil.internalMethodParameterCount(this.factoryMethodDescriptor) == 0;
    }

    public boolean invokesStaticInterfaceMethod() {
        return this.invokedReferenceKind == 6 && this.referencedInvokedClass != null && (this.referencedInvokedClass.getAccessFlags() & 0x200) != 0;
    }

    boolean referencesPrivateSyntheticInterfaceMethod() {
        return (this.referencedInvokedClass.getAccessFlags() & 0x200) != 0 && (this.referencedInvokedMethod.getAccessFlags() & 0x1002) != 0;
    }

    public boolean needsAccessorMethod() {
        return this.referencedInvokedClass != null && new MemberFinder().findMethod(this.lambdaClass, this.referencedInvokedClass, this.invokedMethodName, this.invokedMethodDesc) == null;
    }

    public boolean referencesPrivateConstructor() {
        return this.invokedReferenceKind == 8 && "<init>".equals(this.invokedMethodName) && (this.referencedInvokedMethod.getAccessFlags() & 2) != 0;
    }

    private static boolean isLambdaMethod(String string) {
        return string.startsWith(LAMBDA_METHOD_PREFIX);
    }
}

