/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.DuplicateClassPrinter;
import proguard.classfile.ClassPool;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.io.ClassFilter;
import proguard.io.ClassReader;
import proguard.io.DataEntryReader;
import proguard.io.DirectoryPump;

public class InputReader {
    private static final boolean FAVOR_LIBRARY_CLASSES = System.getProperty("favor.library.classes") != null;
    private final Configuration configuration;

    public InputReader(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        int n2;
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = new PrintWriter(System.err, true);
        WarningPrinter warningPrinter = new WarningPrinter(printWriter, this.configuration.note);
        WarningPrinter warningPrinter2 = new WarningPrinter(printWriter2, this.configuration.warn);
        DuplicateClassPrinter duplicateClassPrinter = new DuplicateClassPrinter(warningPrinter);
        if (FAVOR_LIBRARY_CLASSES && this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, (DataEntryReader)new ClassFilter(new ClassReader(true, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter2, new ClassPresenceFilter(classPool2, duplicateClassPrinter, new ClassPoolFiller(classPool2)))));
        }
        this.readInput("Reading program ", this.configuration.programJars, (DataEntryReader)new ClassFilter(new ClassReader(false, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter2, new ClassPresenceFilter(classPool, duplicateClassPrinter, new ClassPresenceFilter(classPool2, duplicateClassPrinter, new ClassPoolFiller(classPool))))));
        if (classPool.size() == 0) {
            throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
        }
        if (!FAVOR_LIBRARY_CLASSES && this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, (DataEntryReader)new ClassFilter(new ClassReader(true, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter2, new ClassPresenceFilter(classPool, duplicateClassPrinter, new ClassPresenceFilter(classPool2, duplicateClassPrinter, new ClassPoolFiller(classPool2))))));
        }
        if ((n2 = warningPrinter.getWarningCount()) > 0) {
            printWriter2.println("Note: there were " + n2 + " duplicate class definitions.");
            printWriter2.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#duplicateclass)");
        }
        if ((n = warningPrinter2.getWarningCount()) > 0) {
            printWriter2.println("Warning: there were " + n + " classes in incorrectly named files.");
            printWriter2.println("         You should make sure all file names correspond to their class names.");
            printWriter2.println("         The directory hierarchies must correspond to the package hierarchies.");
            printWriter2.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unexpectedclass)");
            if (!this.configuration.ignoreWarnings) {
                printWriter2.println("         If you don't mind the mentioned classes not being written out,");
                printWriter2.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }

    private void readInput(String string, ClassPath classPath, DataEntryReader dataEntryReader) throws IOException {
        this.readInput(string, classPath, 0, classPath.size(), dataEntryReader);
    }

    public void readInput(String string, ClassPath classPath, int n, int n2, DataEntryReader dataEntryReader) throws IOException {
        for (int i = n; i < n2; ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (classPathEntry.isOutput()) continue;
            this.readInput(string, classPathEntry, dataEntryReader);
        }
    }

    private void readInput(String string, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader dataEntryReader2 = DataEntryReaderFactory.createDataEntryReader(string, classPathEntry, dataEntryReader);
            DirectoryPump directoryPump = new DirectoryPump(classPathEntry.getFile());
            directoryPump.pumpDataEntries(dataEntryReader2);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Can't read [" + classPathEntry + "] (" + iOException.getMessage() + ")").initCause(iOException);
        }
    }
}

